/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxMaracasSurfaceRenderingProp3D.h"
#include "wxMaracasDialog_NViewers.h"

#include <wx/colordlg.h>
#include "wxMaracasSurfaceRendering.h"
#include "wxMaracasRendererView.h"

#include "vtkImageData.h"

#include <OpenImage.xpm>
#include <Add.xpm>
#include "Color.xpm"

/**
**	Implementation of viewProp3D
**/
wxMaracasSurfaceRenderingProp3D::wxMaracasSurfaceRenderingProp3D(wxWindow* parent, int propid, bool _isComplexBox, int _panID)
:wxMaracasSurfaceRenderingPanel(parent, propid, _isComplexBox, _panID){
	createControls();	
}

/**
** Panel Destructor
**/ 
wxMaracasSurfaceRenderingProp3D::~wxMaracasSurfaceRenderingProp3D(){	
	//wxMaracasSurfaceRendering::getInstance()->addRemoveActor(_propid, false);
	if(this->isComplex())
	{	
		//if(this->getPanId() == 1)
		//	((wxMaracasRenderTabbedPanel*)(wxMaracasRendererView::getInstance())->getTabbedPanel())->addRemoveActorSA(_propid, false);
		//if(this->getPanId() == 2)
		//	((wxMaracasRenderTabbedPanel*)(wxMaracasRendererView::getInstance())->getTabbedPanel())->addRemoveActorSB(_propid, false);
		//if(this->getPanId() == 3)
		//	((wxMaracasRenderTabbedPanel*)(wxMaracasRendererView::getInstance())->getTabbedPanel())->addRemoveActorSC(_propid, false);
	}
	//else
		//wxMaracasSurfaceRendering::getInstance()->deleteActor(_propid);
}

/**
** Constructs the panel. Elements inside may change depending on which tipe of panel construction if being requested
**/
void wxMaracasSurfaceRenderingProp3D::createControls(){

	wxFlexGridSizer* sizersurfprop = new wxFlexGridSizer(1);
	
	if(!isComplexBox) 
	{
		//wxString choices[2];
		//choices[0] = wxString(_T("On"));
		//choices[1] = wxString(_T("Off"));
		wxFlexGridSizer* checkboxsizer = new wxFlexGridSizer(2);

		checkbox = new  wxCheckBox(this,-1,wxString(_T("Show Actor")));
		Connect(checkbox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasSurfaceRenderingProp3D::onCheckBoxChange);	
		checkbox->SetValue(true);	
		checkboxsizer->Add(checkbox,1, wxGROW);


		if(wxMaracasSurfaceRendering::getInstance()->interactorSet()){
			checkboxsurface = new  wxCheckBox(this,-1,wxString(_T("Surface Box")));
			Connect(checkboxsurface->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction)&wxMaracasSurfaceRenderingProp3D::onCheckBoxSurfaceChange);	
			checkboxsurface->SetValue(true);
			checkboxsizer->Add(checkboxsurface,1, wxGROW);
		}	


		sizersurfprop->Add(checkboxsizer,1, wxGROW);
	}

	//this->addControl(checkbox);	
	wxFlexGridSizer* sizerbut = new wxFlexGridSizer(3);

	wxBitmap bitmap(Color_xpm);
	_colorchoose = new wxBitmapButton(this, -1, bitmap,wxDefaultPosition,wxSize(30,30));	
	Connect(_colorchoose->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasSurfaceRenderingProp3D::onColorChange);			
	sizerbut->Add(_colorchoose,1, wxGROW);

	/*
	wxBitmap bitmap1(Add_xpm);
	_viewimage = new wxBitmapButton(this, -1, bitmap1, wxDefaultPosition, wxSize(30,30));	
	Connect(_viewimage->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&wxMaracasSurfaceRenderingProp3D::onViewImage);			
	sizerbut->Add(_viewimage,wxFIXED_MINSIZE);
	*/
	sizersurfprop->Add(sizerbut,1, wxGROW);
	//sizercolor->Add(checkbox,wxFIXED_MINSIZE);
	//sizercolor->Add(_colorchoose,wxFIXED_MINSIZE);
	//this->addControl(sizercolor);

	wxStaticText* label = new wxStaticText(this, -1, wxString(_T("Opacity")));		
	opacity = new wxSlider(this, -1,100,0,100,wxDefaultPosition,wxDefaultSize,wxSL_HORIZONTAL|wxSL_LABELS);	
	Connect(opacity->GetId(), wxEVT_SCROLL_CHANGED, (wxObjectEventFunction)&wxMaracasSurfaceRenderingProp3D::onOpacityRelease);	
	wxFlexGridSizer* sizeropacity = new wxFlexGridSizer(1,1,1);	
	sizeropacity->Add(label,1, wxGROW);
	sizeropacity->Add(opacity,1, wxGROW);

	sizersurfprop->Add(sizeropacity,1, wxGROW);

	this->addControl(sizersurfprop);
	
}

/**
** Method called by setting on or off the actor
**/
void wxMaracasSurfaceRenderingProp3D::onCheckBoxChange(wxCommandEvent& event){	
	//if(!isComplexBox)
	wxMaracasSurfaceRendering::getInstance()->addRemoveActor(this->getPropId(), checkbox->GetValue());	
}
void wxMaracasSurfaceRenderingProp3D::onCheckBoxSurfaceChange(wxCommandEvent& event){	
	//if(!isComplexBox)
	wxMaracasSurfaceRendering::getInstance()->addRemoveSurfaceBox(this->getPropId(), checkboxsurface->GetValue());	
}

/**
** 
**/
void wxMaracasSurfaceRenderingProp3D::onColorChange(wxCommandEvent& event){
	wxColourDialog* colourdiag = new wxColourDialog(this);
	if(colourdiag->ShowModal()==wxID_OK){
		wxColour colour = colourdiag->GetColourData().GetColour();
		_colorchoose->SetBackgroundColour(colour);

		double r = (double)(colour.Red())/255.0;
		double g = (double)(colour.Green())/255.0;
		double b = (double)(colour.Blue())/255.0;
		
		if(this->isComplex()){
			if(this->getPanId() == 1)
				( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeColorA(this->getPropId(), r, g, b);
			if(this->getPanId() == 2)
				( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeColorB(this->getPropId(), r, g, b);
			if(this->getPanId() == 3)
				( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeColorC(this->getPropId(), r, g, b);
		}
		else
			wxMaracasSurfaceRendering::getInstance()->changeColor(this->getPropId(),r,g,b);
	}
	delete colourdiag;
}
/*void wxMaracasSurfaceRenderingProp3D::onActionButtonPressedEliminate( wxCommandEvent& event ){	

}*/

/**
** Changes the opacity of an actor
**/
void wxMaracasSurfaceRenderingProp3D::onOpacityRelease(wxScrollEvent& event ){

	if(this->isComplex()){
		if(this->getPanId() == 1)
			( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeOpacityA(this->getPropId(),opacity->GetValue());
		if(this->getPanId() == 2)
			( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeOpacityB(this->getPropId(),opacity->GetValue());
		if(this->getPanId() == 3)
			( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeOpacityC(this->getPropId(),opacity->GetValue());
	}
	else
		wxMaracasSurfaceRendering::getInstance()->changeOpacity(this->getPropId(),opacity->GetValue());

}

/**Carolina Perez: Method recently added. Not functionalit yet
** Loads the volume in a separate window
**/
void wxMaracasSurfaceRenderingProp3D::onViewImage(wxCommandEvent& event){	
	vtkImageData* img;
	if(this->isComplexBox){
		if(this->getPanId() == 1)
			img = (wxMaracasRendererView::getInstance())->getTabbedPanel(_propid)->getSurfAImage();
		if(this->getPanId() == 2)
			img = (wxMaracasRendererView::getInstance())->getTabbedPanel(_propid)->getSurfBImage();
		if(this->getPanId() == 3)
			img = (wxMaracasRendererView::getInstance())->getTabbedPanel(_propid)->getSurfCImage();
		
		std::vector<int> type;
		type.push_back(6);

		wxMaracasDialog_NViewers* dialog1 = new wxMaracasDialog_NViewers(this, img, &type, wxString(_T("Volume Visualization") ));
		dialog1->SetSize(730, 700);
		dialog1->Show();
	}
	else{	
		//vtkImageData* img = wxMaracasMultipleVolumeRendererView::getInstance()->getVolImage();
	}
}
