/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxMaracasSurfaceRenderingProp3DMHD.h"

#include "wxMaracasSurfaceRendering.h"
#include "wxMaracasRendererView.h"
#include <OpenImage.xpm>
/**
**	SurfaceRenderingProp3DMHD implementation
**/
wxMaracasSurfaceRenderingProp3DMHD::wxMaracasSurfaceRenderingProp3DMHD(wxWindow* parent, int propid, bool _isComplexBox, int _panID)
: wxMaracasSurfaceRenderingProp3D(parent, propid, _isComplexBox, _panID){
	
}
wxMaracasSurfaceRenderingProp3DMHD::~wxMaracasSurfaceRenderingProp3DMHD(){
	//this->Show(false);
	if(this->isComplex())
	{
		//if(this->getPanId() == 1)
		//	((wxMaracasRenderTabbedPanel*)(wxMaracasRendererView::getInstance())->getTabbedPanel())->addRemoveActorSA(_propid, false);
		//if(this->getPanId() == 2)
		//	((wxMaracasRenderTabbedPanel*)(wxMaracasRendererView::getInstance())->getTabbedPanel())->addRemoveActorSB(_propid, false);
		//if(this->getPanId() == 3)
		//	((wxMaracasRenderTabbedPanel*)(wxMaracasRendererView::getInstance())->getTabbedPanel())->addRemoveActorSC(_propid, false);
	}
	//else
		//wxMaracasSurfaceRendering::getInstance()->addRemoveActor(_propid, false);
}
void wxMaracasSurfaceRenderingProp3DMHD::createControls(int maxisovalue){
	
	wxFlexGridSizer* sizer = new wxFlexGridSizer(1,1,1);

	wxStaticText* label = new wxStaticText(this, -1, wxString(_T("IsoValue")));
	sizer->Add(label, 1, wxGROW);
	//this->addControl(label);
	isovalue = new wxSlider(this, -1,maxisovalue,0,maxisovalue,wxDefaultPosition,wxDefaultSize,wxSL_HORIZONTAL|wxSL_LABELS);
	sizer->Add(isovalue, 1, wxGROW);
	//this->addControl(isovalue);

	this->addControl(sizer);	
	Connect(isovalue->GetId(), wxEVT_SCROLL_CHANGED, (wxObjectEventFunction)&wxMaracasSurfaceRenderingProp3DMHD::onIsoValueRelease);	

}

void wxMaracasSurfaceRenderingProp3DMHD::onIsoValueRelease(wxScrollEvent& event )
{
	if(this->isComplex())
	{
		if(this->getPanId() == 1)
			( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeIsoValueA(this->getPropId(),isovalue->GetValue()/1.0);
		if(this->getPanId() == 2)
			( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeIsoValueB(this->getPropId(),isovalue->GetValue()/1.0);
		if(this->getPanId() == 3)
			( (wxMaracasRendererView::getInstance())->getTabbedPanel(getPropId()) )->changeIsoValueC(this->getPropId(),isovalue->GetValue()/1.0);
	}
	else
		wxMaracasSurfaceRendering::getInstance()->changeIsoValue(this->getPropId(), isovalue->GetValue()/1.0);
	
}

void wxMaracasSurfaceRenderingProp3DMHD::onViewImage(wxCommandEvent& event){	

	//if(mwxwidget->ShowModal()==wxID_OK){
    
	//	mwxwidget->Show(false);
	//}	
}

