/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef wxMaracasMultipleVolumeRendererPanel_H_
#define wxMaracasMultipleVolumeRendererPanel_H_

#include <wx/wx.h>
#include "HistogramDialogComboBox.h"

class wxMaracasMultipleVolumeRendererPanel : public wxPanel{
	
public:
	wxMaracasMultipleVolumeRendererPanel(wxWindow* parent, int propid, vtkImageData* img, bool _isComplexBox);
	~wxMaracasMultipleVolumeRendererPanel();
	void createControls(vtkImageData* img);	
	void onCheckBoxChange(wxCommandEvent& event);
	void onColorChange(wxCommandEvent& event);
	void onOK(wxCommandEvent& event);
	void onCancel(wxCommandEvent& event);
	void onUpdate(wxCommandEvent& event);
	void onViewImage(wxCommandEvent& event);
	void onRadioBoxSelectFunction(wxCommandEvent& event);

	void updateVolume();
	int getPropId();
	HistogramDialogComboBox* getMwxwidget();

private:
	wxCheckBox* checkbox;
	wxRadioBox* _radiobox;
	wxBitmapButton* _viewimage;
	
	int _propid;

	bool first;

	HistogramDialogComboBox* mwxwidget;
	//wxFrame* _frame;

	//-- added for complex box --//
	bool isComplexBox;
};

#endif /*wxMaracasMultipleVolumeRendererPanel_H_*/
