/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxMaracasMultipleVolumeRendererView.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:43 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/



// EOF - wxMaracasMPR.cxx

#include "wxMaracasMultipleVolumeRendererView.h"


#include <wx/colordlg.h>
#include <wx/bmpbuttn.h> 

#include <OpenImage.xpm>
#include <Color.xpm>

wxMaracasMultipleVolumeRendererView* wxMaracasMultipleVolumeRendererView::instance=NULL;

wxMaracasMultipleVolumeRendererView::wxMaracasMultipleVolumeRendererView( wxWindow* parent,std::string path)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize){

	wxauimanager = new wxAuiManager(this);

	_path = path;

        volmanager = new VolumeRendererManager();
	std::string iconsdir = path;
	iconsdir+="/data/Icons";
	this->_toolb = new ToolBarMultipleVolumeRenderer(this,iconsdir);
	wxStaticText* txt = new wxStaticText(this, -1, wxString(_T("  Volume Rendering  ")));
	wxAuiPaneInfo paneinfo;
	wxauimanager->AddPane(txt,paneinfo.ToolbarPane().Top());
	wxauimanager->AddPane(_toolb,paneinfo.ToolbarPane().Top());

	wxauimanager->Update();	

}
wxMaracasMultipleVolumeRendererView::~wxMaracasMultipleVolumeRendererView( ){

	delete _toolb;
}

std::string wxMaracasMultipleVolumeRendererView::getPath(){
	return _path;
}

wxMaracasMultipleVolumeRendererView* wxMaracasMultipleVolumeRendererView::getInstance(wxWindow* parent,std::string path){
	if(instance==NULL)
{
		instance = new wxMaracasMultipleVolumeRendererView(parent,path);
	}
	return instance;
}

wxMaracasMultipleVolumeRendererView* wxMaracasMultipleVolumeRendererView::getInstance(){
	return instance;
}

void wxMaracasMultipleVolumeRendererView::changeCompositeMIPFunction(int id, int function){
	try{
		volmanager->changeCompositeMIPFunction(id, function);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString( str,wxConvUTF8 ), wxString( str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
	}
}

void wxMaracasMultipleVolumeRendererView::setRenderer(vtkRenderer*  renderer){
	volmanager->setRenderer(renderer);
}

void wxMaracasMultipleVolumeRendererView::addRemoveActor(int id, bool addremove){
	try{
		volmanager->addRemoveActor(id, addremove);
	}
	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString( str,wxConvUTF8 ), wxString( str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
	}
	
}

void wxMaracasMultipleVolumeRendererView::onLoadImageFile(){

	wxString mhd(_T("mhd"));	

	wxFileDialog* fildial = new wxFileDialog(this, wxString(_T("Select a MHD file")),wxString(_T("")),
		wxString(_T("")),wxString(_T("MHD files (*.mhd)|*.mhd")) );

	if(fildial->ShowModal()==wxID_OK){
        wxString filename = fildial->GetFilename();
		wxString pathfile(fildial->GetDirectory() + _T("/") + filename);
		if(filename.EndsWith(mhd)){
			loadVolume(pathfile,filename);
		}
	}
	delete fildial;

}

void wxMaracasMultipleVolumeRendererView::addVolumeViewPanel(wxMaracasMultipleVolumeRendererPanel* irmview, std::string dataname){

	wxString s(dataname.c_str(),wxConvUTF8 );
	wxAuiPaneInfo paneinfo;
	wxauimanager->AddPane(irmview, paneinfo.DefaultPane().Centre().DestroyOnClose().Caption(s));
	wxauimanager->Update();
}
	
void wxMaracasMultipleVolumeRendererView::addVolume(vtkImageData* img, std::string dataname){

	try{
		int id = volmanager->addVolume(-1, img,dataname);		
		if(id!=-1){
			wxMaracasMultipleVolumeRendererPanel* controlpan = new wxMaracasMultipleVolumeRendererPanel(this, id,img, false);
			addVolumeViewPanel(controlpan, dataname);
			controlpan->updateVolume();
		}
	}catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
	}
}

void wxMaracasMultipleVolumeRendererView::loadVolume(wxString filename, wxString dataname){

	std::string s = std::string(filename.mb_str());
	vtkImageData* img = volmanager->getImageData(s);
	imgVect.push_back(img);

	if(img!=NULL){
		s = std::string(dataname.mb_str());
		addVolume(img, s);
	}
}

void wxMaracasMultipleVolumeRendererView::deleteVolume(int volid)
{
	try{
		volmanager->deleteActor(volid);
	}

	catch(char* str){
		std::cout << "Exception : " << str << '\n';
		wxMessageDialog* diag = new wxMessageDialog(this, wxString(str,wxConvUTF8 ), wxString(str,wxConvUTF8 ), wxICON_ERROR);
		diag->ShowModal();
	}
}

void wxMaracasMultipleVolumeRendererView::SetValuesColorPointsFunction(int volid, std::vector<double> greylevelcolors,std::vector<double> red,std::vector<double> green,std::vector<double> blue)
{
	volmanager->setVolumeColor(volid, greylevelcolors, red, green, blue);
}
void wxMaracasMultipleVolumeRendererView::SetValuesPointsFunction(int volid, std::vector<double> greylevel, std::vector<double> values)
{
	volmanager->setVolumeOpacity(volid, greylevel, values);
}

vtkPiecewiseFunction* wxMaracasMultipleVolumeRendererView::GetTransferFunction(int volumeid)
{
	return volmanager->GetTransferFunction(volumeid);
}
vtkColorTransferFunction* wxMaracasMultipleVolumeRendererView::GetColorFunction(int volumeid)
{
    return volmanager->GetColorFunction(volumeid);
}

std::vector<vtkImageData*> wxMaracasMultipleVolumeRendererView::GetOutputImages(){
	return imgVect;
}

VolumeRendererManager* wxMaracasMultipleVolumeRendererView::getVolumeRenderManager()
{
	return volmanager;
}

/**
**
**/

ToolBarMultipleVolumeRenderer::ToolBarMultipleVolumeRenderer(wxWindow * parent,std::string iconsdir)
: wxToolBar(parent, -1, wxDefaultPosition, wxDefaultSize)
{


	std::string iconfil = iconsdir;

	//iconfil+= "/OpenImage.png";
	//wxBitmap* bitmap0 = new wxBitmap(wxString(iconfil.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);
	wxBitmap bitmap0(OpenImage_xpm);


//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	this->AddTool(1, wxString(_T("test")),bitmap0, NULL, wxITEM_NORMAL, wxString(_T("Open File")));
#else
	this->AddTool(1, wxString(_T("test")),bitmap0 , wxString(_T("Open File")), wxITEM_NORMAL );
#endif


	/*iconfil+= "/Open.png";
	wxBitmap* bitmap2 = new wxBitmap(wxString(iconfil.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);
	this->AddTool(2, wxString(_T("test")),*bitmap2);	*/

	/*iconfil = iconsdir;
	iconfil+= "/Open.png";
	wxBitmap* bitmap30 = new wxBitmap(wxString(iconfil.c_str(),wxConvUTF8), wxBITMAP_TYPE_PNG);
	this->AddTool(30, wxString(_T("test")),*bitmap30);*/

	this->Realize();

	_evthand = new ToolBarEventHandlerMultipleVolumeRenderer();
	this->SetEventHandler(_evthand);

}

ToolBarMultipleVolumeRenderer::~ToolBarMultipleVolumeRenderer(void){
}

ToolBarEventHandlerMultipleVolumeRenderer::ToolBarEventHandlerMultipleVolumeRenderer()
: wxEvtHandler(){
}
ToolBarEventHandlerMultipleVolumeRenderer::~ToolBarEventHandlerMultipleVolumeRenderer(){
}

void ToolBarEventHandlerMultipleVolumeRenderer::onLoadImageFile(wxCommandEvent& event){
	wxMaracasMultipleVolumeRendererView::getInstance()->onLoadImageFile();
}



BEGIN_EVENT_TABLE(ToolBarEventHandlerMultipleVolumeRenderer, wxEvtHandler)
	EVT_MENU(1, ToolBarEventHandlerMultipleVolumeRenderer::onLoadImageFile)
END_EVENT_TABLE()


