/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */ 

#ifndef __ITKToVTKImageImport_TXX
#define __ITKToVTKImageImport_TXX


namespace itk{

/**
** Default constructor, allocates the vtkImageExport and itkImageImport
**	Connects the pipelines and set them ready to be use
**/
template<typename TypeImage>
ITKToVTKImageImport<TypeImage>::ITKToVTKImageImport(){

        vtkimageexport  = vtkImageExport::New();
        imageimportpointer = ImageImportType::New();

        imageimportpointer->SetUpdateInformationCallback(vtkimageexport->GetUpdateInformationCallback());
        imageimportpointer->SetPipelineModifiedCallback(vtkimageexport->GetPipelineModifiedCallback());
        imageimportpointer->SetWholeExtentCallback(vtkimageexport->GetWholeExtentCallback());
        imageimportpointer->SetSpacingCallback(vtkimageexport->GetSpacingCallback());
        imageimportpointer->SetOriginCallback(vtkimageexport->GetOriginCallback());
        imageimportpointer->SetScalarTypeCallback(vtkimageexport->GetScalarTypeCallback());
        imageimportpointer->SetNumberOfComponentsCallback(vtkimageexport->GetNumberOfComponentsCallback());
        imageimportpointer->SetPropagateUpdateExtentCallback(vtkimageexport->GetPropagateUpdateExtentCallback());
        imageimportpointer->SetUpdateDataCallback(vtkimageexport->GetUpdateDataCallback());
        imageimportpointer->SetDataExtentCallback(vtkimageexport->GetDataExtentCallback());
        imageimportpointer->SetBufferPointerCallback(vtkimageexport->GetBufferPointerCallback());
        imageimportpointer->SetCallbackUserData(vtkimageexport->GetCallbackUserData());


        imageexportpointer = ImageExportType::New();
        vtkimageimport = vtkImageImport::New();

        vtkimageimport->SetUpdateInformationCallback(imageexportpointer->GetUpdateInformationCallback());
        vtkimageimport->SetPipelineModifiedCallback(imageexportpointer->GetPipelineModifiedCallback());
        vtkimageimport->SetWholeExtentCallback(imageexportpointer->GetWholeExtentCallback());
        vtkimageimport->SetSpacingCallback(imageexportpointer->GetSpacingCallback());
        vtkimageimport->SetOriginCallback(imageexportpointer->GetOriginCallback());
        vtkimageimport->SetScalarTypeCallback(imageexportpointer->GetScalarTypeCallback());
        vtkimageimport->SetNumberOfComponentsCallback(imageexportpointer->GetNumberOfComponentsCallback());
        vtkimageimport->SetPropagateUpdateExtentCallback(imageexportpointer->GetPropagateUpdateExtentCallback());
        vtkimageimport->SetUpdateDataCallback(imageexportpointer->GetUpdateDataCallback());
        vtkimageimport->SetDataExtentCallback(imageexportpointer->GetDataExtentCallback());
        vtkimageimport->SetBufferPointerCallback(imageexportpointer->GetBufferPointerCallback());
        vtkimageimport->SetCallbackUserData(imageexportpointer->GetCallbackUserData());

}


template<typename TypeImage >
ITKToVTKImageImport<TypeImage>::~ITKToVTKImageImport(){
        /*std::cout<<"delete ~ITKToVTKImageImport(){"<<std::endl;*/
        vtkimageimport->Delete();
        vtkimageexport->Delete();
}
/*
*	set the vtkImage data to connect to itk pipeline
*/
template<typename TypeImage>
void ITKToVTKImageImport<TypeImage>::SetVTKImage(vtkImageData* img) {
        vtkimageexport->SetInput( img );
        vtkimageexport->Update();
        imageimportpointer->Update();
}

/*
*
*/
template<typename TypeImage>
typename ITKToVTKImageImport<TypeImage>::InputImagePointerType ITKToVTKImageImport<TypeImage>::GetOutputITKImage() {
        if(vtkimageexport->GetInput()==0){
                throw "Image not set to get the ItkImage, set the VtkImage before.\0";
        }
        return  imageimportpointer->GetOutput();
}

/*
*	Get the vtkImageData from the itk image
*/
template<typename TypeImage >
vtkImageData* ITKToVTKImageImport<TypeImage >::GetOutputVTKImage() {
        return vtkimageimport->GetOutput();
}
/*
*	set the vtkImage data to connect to itk pipeline
*/
template<typename TypeImage>
void ITKToVTKImageImport<TypeImage >::SetITKImage(InputImagePointerType itkimage){
        //std::cout<<"image pointer setITKImage"<<img<<std::endl;

    m_ITKImage = itkimage;
    imageexportpointer->SetInput(itkimage);
    imageexportpointer->Update();
    vtkimageimport->Update();

}

}
#endif
