/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef ITKVTKCOLORTRANSFERFUNCTION_H
#define ITKVTKCOLORTRANSFERFUNCTION_H


#include <itkProcessObject.h>

#include <vtkColorTransferFunction.h>

#include <itkRGBToLuminanceImageFilter.h>
#include <itkImageRegionConstIterator.h>

namespace itk{

template< class TypeImage>
class VTKColorTransferFunction :
public ProcessObject
{

    public:

        /** Standard class typedefs. */
        typedef VTKColorTransferFunction           Self;

        /** Standard "Superclass" typedef */
        typedef ProcessObject Superclass;

        /** Smart pointer typedef support. */
        typedef SmartPointer<Self>            Pointer;
        typedef SmartPointer<const Self>      ConstPointer;

        /** Method for creation through the object factory. */
        itkNewMacro(Self);

        /** Run-time type information (and related methods). */
        itkTypeMacro( VTKColorTransferFunction, ProcessObject );

        /** InputImageType typedef support. */
        typedef TypeImage                                   InputImageType;
        typedef typename InputImageType::Pointer            InputImagePointerType;
        typedef typename InputImageType::PixelType          PixelType;
        typedef typename InputImageType::IndexType          IndexType;


        /**
          * set the rgb image to create the transfer function
         */
        itkSetMacro(Input, InputImagePointerType)
        /**
          * set the rgb image to create the transfer function
         */
        itkGetConstMacro(Input, InputImagePointerType)

        /**
          get the color transfer created from the image
         */
        itkGetMacro(Output, vtkColorTransferFunction*)

        virtual void Update();

protected:
    VTKColorTransferFunction();
    ~VTKColorTransferFunction();

    virtual void GenerateData ();

    virtual void GenerateOutputInformation();

private:
    vtkColorTransferFunction* m_Output;
    InputImagePointerType m_Input;
};

}

#ifndef ITK_MANUAL_INSTANTIATION
#include "itkvtkcolortransferfunction.txx"
#endif

#endif // ITKVTKCOLORTRANSFERFUNCTION_H
