/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "surfacerenderingimagestencilexport.h"

#include "vtkMetaImageWriter.h"

#include "math.h"


vtkStandardNewMacro(SurfaceRenderingImageStencilExport)

SurfaceRenderingImageStencilExport::SurfaceRenderingImageStencilExport()
{    
    ImageOutput = 0;
}

SurfaceRenderingImageStencilExport::~SurfaceRenderingImageStencilExport()
{

    if(ImageOutput)
	{
        ImageOutput->Delete();
    }
}



//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5

	void SurfaceRenderingImageStencilExport::Update(){
	    this->Execute(0);
	}


	// This method is much too long, and has to be broken up!
	// Furthermore we are loosing the normals !!!
	void SurfaceRenderingImageStencilExport::Execute(vtkImageData *data){
	{

    vtkSmartPointer<vtkPolyDataToImageStencil> polytostencil = vtkSmartPointer<vtkPolyDataToImageStencil>::New();

    vtkPolyData* polydata = (vtkPolyData*)this->GetInput();
    polytostencil->SetInput(polydata);
    polytostencil->Update();

    double *bounds = polydata->GetBounds();
    vtkSmartPointer<vtkImageData> imagein = vtkSmartPointer<vtkImageData>::New();

    imagein->SetExtent(bounds[0] - 1, bounds[1] + 1, bounds[2] - 1, bounds[3] + 1, bounds[4] - 1, bounds[5] + 1);
    imagein->SetScalarTypeToUnsignedShort();    
    imagein->AllocateScalars();

    int* extent = imagein->GetExtent();

	int x, y, z;
    for (x = extent[0]; x <= extent[1]; x++){
        for (y = extent[2]; y <= extent[3]; y++){
            for (z  =extent[4]; z <= extent[5]; z++){
                unsigned short* pixel = static_cast<unsigned short*>(imagein->GetScalarPointer(x,y,z));
                *pixel = 0;
            }  // for x
        } // for y 
    } // for z

    vtkSmartPointer<vtkImageStencil> stencil = vtkSmartPointer<vtkImageStencil>::New();

    stencil->SetInput(imagein);
    stencil->SetStencil(polytostencil->GetOutput());

    stencil->ReverseStencilOn();
    stencil->SetBackgroundValue(128);
    stencil->Update();

    if(ImageOutput)
	{
        ImageOutput->Delete();
    }
    ImageOutput = vtkImageData::New();
    ImageOutput->DeepCopy(stencil->GetOutput());

	}

#else

int SurfaceRenderingImageStencilExport::RequestData(  vtkInformation *vtkNotUsed(request),  vtkInformationVector **inputVector,  vtkInformationVector *outputVector)
{

	// get the info objects
	vtkInformation *inInfo = inputVector[0]->GetInformationObject(0);
	vtkInformation *outInfo = outputVector->GetInformationObject(0);

	// get the input and output
	vtkPolyData *input = vtkPolyData::SafeDownCast(    inInfo->Get(vtkDataObject::DATA_OBJECT()));
	vtkPolyData *output = vtkPolyData::SafeDownCast(    outInfo->Get(vtkDataObject::DATA_OBJECT()));


    vtkSmartPointer<vtkPolyDataToImageStencil> polytostencil = vtkSmartPointer<vtkPolyDataToImageStencil>::New();

//    vtkPolyData* polydata = (vtkPolyData*)this->GetInput();
    vtkPolyData* polydata = input;
    polytostencil->SetInputData(polydata);
    polytostencil->Update();

    double *bounds = polydata->GetBounds();
    vtkSmartPointer<vtkImageData> imagein = vtkSmartPointer<vtkImageData>::New();

    imagein->SetExtent(bounds[0] - 1, bounds[1] + 1, bounds[2] - 1, bounds[3] + 1, bounds[4] - 1, bounds[5] + 1);
    imagein->AllocateScalars(VTK_UNSIGNED_SHORT,1);


    int* extent = imagein->GetExtent();

	int x,y,z;
    for (x = extent[0]; x <= extent[1]; x++){
        for (y = extent[2]; y <= extent[3]; y++){
            for (z  =extent[4]; z <= extent[5]; z++){
                unsigned short* pixel = static_cast<unsigned short*>(imagein->GetScalarPointer(x,y,z));
                *pixel = 0;
            } // for z
        }  // for y
    }  // for z

    vtkSmartPointer<vtkImageStencil> stencil = vtkSmartPointer<vtkImageStencil>::New();

    stencil->SetInputData(imagein);
    stencil->SetStencilData(polytostencil->GetOutput());

    stencil->ReverseStencilOn();
    stencil->SetBackgroundValue(128);
    stencil->Update();

//    if(ImageOutput)
//	{
//       ImageOutput->Delete();
//    }
//    ImageOutput = vtkImageData::New();
//    ImageOutput->DeepCopy(stencil->GetOutput());

	output->ShallowCopy( stencil->GetOutput() );
	stencil->Delete();


	return 1;
}

#endif







//-------------------------------------------------------------------------------------------

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
 vtkImageData* SurfaceRenderingImageStencilExport::GetOutputData()
  {
     return ImageOutput;
  }
#else
  // ..
#endif

