/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxMaracasSurfaceRenderingManagerData.h"

#include <vtkSmartPointer.h>
#include "vtkSTLWriter.h"
#include "vtkPLYWriter.h"
#include "vtkPolyDataWriter.h"
#include "surfacerenderingimagestencilexport.h"
#include "vtkMetaImageWriter.h"
#include "vtkPolyDataReader.h"
#include "vtkPLYReader.h"
#include "vtkSmartPointer.h"

/********************************************************************************************
** Start of data viewmanagerData
*********************************************************************************************/

wxMaracasSurfaceRenderingManagerData::wxMaracasSurfaceRenderingManagerData(vtkProp3D* prop3Dvect, std::string dataname, vtkRenderWindowInteractor*  interactor){

        _dataMapper = 0;
	_prop3D = prop3Dvect;	
	_dataname = dataname;	
	_boxWidgetS1=NULL;
	
	initializeBoxWidget(interactor);
	

	

	/*_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(0) );
	_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(1) );
	_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(2) );
	_boxWidgetS1->GetPlanes( this->GetVtkClipping3DDataViewer()->GetTissuePlanes(3) );*/
}

wxMaracasSurfaceRenderingManagerData::wxMaracasSurfaceRenderingManagerData(string filename, vtkRenderWindowInteractor*  interactor){

    _prop3D = getProp3D(filename);
    _dataname = filename;
    _boxWidgetS1=NULL;

    initializeBoxWidget(interactor);
}

vtkProp3D* wxMaracasSurfaceRenderingManagerData::getProp3D(std::string filename){

    if(filename.compare("")!= 0){

        vtkSmartPointer<vtkPolyData> polydata = vtkSmartPointer<vtkPolyData>::New();
        std::string ext = filename.substr(filename.find_last_of("."), 4);
        if(ext.compare(STL)==0){
            vtkSmartPointer<vtkSTLReader> STLReader=vtkSmartPointer<vtkSTLReader>::New();
            STLReader->SetFileName(filename.c_str());
            STLReader->Update();
            polydata->DeepCopy(STLReader->GetOutput());

        }else if(ext.compare(PLY)==0){
            vtkSmartPointer<vtkPLYReader> plyreader =vtkSmartPointer<vtkPLYReader>::New();
            plyreader->SetFileName(filename.c_str());
            plyreader->Update();
            polydata->DeepCopy(plyreader->GetOutput());
        }else if(ext.compare(VTK)==0){
            vtkSmartPointer<vtkPolyDataReader> polyreader =vtkSmartPointer<vtkPolyDataReader>::New();
            polyreader->SetFileName(filename.c_str());
            polyreader->Update();
            polydata->DeepCopy(polyreader->GetOutput());
        }

        _dataMapper = vtkPolyDataMapper::New();

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        _dataMapper->SetInput(polydata);
#else
        _dataMapper->SetInputData(polydata);
#endif

        vtkActor* dataActor = vtkActor::New();
        dataActor->SetMapper(_dataMapper);
        dataActor->GetProperty()->SetOpacity(1);
        return dataActor;
    }
    return NULL;
}

wxMaracasSurfaceRenderingManagerData::~wxMaracasSurfaceRenderingManagerData(){
	
	_prop3D->Delete();	
	if (_boxWidgetS1!=NULL)					 { _boxWidgetS1		-> Delete();					}
}

void wxMaracasSurfaceRenderingManagerData::initializeBoxWidget(vtkRenderWindowInteractor*  interactor){
	if(interactor!= NULL){
	
	}
}

/**
**	Adds a prop3D to the world of the application
**/
void wxMaracasSurfaceRenderingManagerData::setProp3D(vtkProp3D* prop3D){
	_prop3D = prop3D;
}

void wxMaracasSurfaceRenderingManagerData::addRemoveSurfaceBox(bool visible)
{
	if(_boxWidgetS1){
		if (visible==true){
			_boxWidgetS1->On();
		} else {
			_boxWidgetS1->Off();
		}
	}
}
/**
**	Changes the opacity in a prop3D
**/
void wxMaracasSurfaceRenderingManagerData::changeOpacity(int value){
	std::cout<<"chage op"<<value<<std::endl;
	vtkActor* actor = (vtkActor*)this->_prop3D;	
	actor->GetProperty()->SetOpacity((double)value/100.0);

	

}
void wxMaracasSurfaceRenderingManagerData::changeColor(double red, double green, double blue){
	std::cout<<"chage col"<<red<<green<<blue<<std::endl;
    vtkActor* actor = (vtkActor*)this->_prop3D;	
	actor->GetProperty()->SetColor(red,green,blue);	
}
/**
**	Check if the variables are setted correctly
**/
void wxMaracasSurfaceRenderingManagerData::checkInvariant(){

}
/**
**	get the prop3D 
**/
vtkProp3D* wxMaracasSurfaceRenderingManagerData::getProp3D(){
	return this->_prop3D;
}
/**
**	return the id from the daat
**/
int wxMaracasSurfaceRenderingManagerData::getId(){
	return _id;
}
/**
**	set data id
**/
void wxMaracasSurfaceRenderingManagerData::setId(int propid){
	_id = propid;
}

/**
**	Get the filanme
**/
std::string wxMaracasSurfaceRenderingManagerData::getDataname(){
	return _dataname;
}
/**
** Set the filanme
**/
void wxMaracasSurfaceRenderingManagerData::setDataname(std::string dataname){
	_dataname = dataname;
}



void wxMaracasSurfaceRenderingManagerData::saveProp3DSTL(const char* filename){
    if(_dataMapper){

        std::string filena(filename);
        std::string ext = filena.substr(filena.find_last_of("."), 4);
        if(ext.compare(PLY) == 0){
            vtkSmartPointer<vtkPLYWriter> plywriter =
            vtkSmartPointer<vtkPLYWriter>::New();
              plywriter->SetFileName(filename);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
              plywriter->SetInput(_dataMapper->GetInput());
#else
              plywriter->SetInputData(_dataMapper->GetInput());
#endif
              plywriter->Write();
        }else if(ext.compare(STL) == 0){
            vtkSmartPointer<vtkSTLWriter> stlWriter =
            vtkSmartPointer<vtkSTLWriter>::New();
              stlWriter->SetFileName(filename);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
              stlWriter->SetInput(_dataMapper->GetInput());
#else
              stlWriter->SetInputData(_dataMapper->GetInput());
#endif
              stlWriter->SetFileTypeToBinary();
              stlWriter->Write();
        }else if(ext.compare(VTK) == 0){
            vtkSmartPointer<vtkPolyDataWriter> polydataWriter =
            vtkSmartPointer<vtkPolyDataWriter>::New();
              polydataWriter->SetFileName(filename);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
              polydataWriter->SetInput(_dataMapper->GetInput());
#else
              polydataWriter->SetInputData(_dataMapper->GetInput());
#endif
              polydataWriter->SetFileTypeToBinary();
              polydataWriter->Write();
        }else{
            cout<<"unsupported format"<<endl;
        }
    }
}

void wxMaracasSurfaceRenderingManagerData::enableBoxWidget(bool enable){

}

void wxMaracasSurfaceRenderingManagerData::exportImageStencil(const char* filename){
    if(_dataMapper){
        vtkSmartPointer< SurfaceRenderingImageStencilExport> stencilexport = vtkSmartPointer< SurfaceRenderingImageStencilExport >::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        stencilexport->SetInput( _dataMapper->GetInput());
#else
        stencilexport->SetInputData( _dataMapper->GetInput());
#endif
        stencilexport->Update();
        vtkImageData* imgstencil = stencilexport->GetOutput();

        vtkSmartPointer<vtkMetaImageWriter> metawriter = vtkSmartPointer<vtkMetaImageWriter>::New();
        metawriter->SetFileName(filename);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
        metawriter->SetInput(imgstencil);
#else
        metawriter->SetInputData(imgstencil);
#endif
        metawriter->Write();
    }else{
        cout<<"No poly data set to data mapper."<<endl;
    }

}




