# - Find a GDCM installation or build tree.
# The following variables are set if GDCM is found.  If GDCM is not
# found, GDCM_FOUND is set to false.
#  GDCM_FOUND         - Set to true when GDCM is found.
#  GDCM_USE_FILE      - CMake file to use GDCM.
#  GDCM_MAJOR_VERSION - The GDCM major version number.
#  GDCM_MINOR_VERSION - The GDCM minor version number 
#                       (odd non-release).
#  GDCM_BUILD_VERSION - The GDCM patch level 
#                       (meaningless for odd minor).
#  GDCM_INCLUDE_DIRS  - Include directories for GDCM
#  GDCM_LIBRARY_DIRS  - Link directories for GDCM libraries
#  GDCM_KITS          - List of GDCM kits, in CAPS 
#                      (COMMON,IO,) etc.
#  GDCM_LANGUAGES     - List of wrapped languages, in CAPS
#                      (TCL, PYHTON,) etc.
# The following cache entries must be set by the user to locate GDCM:
#  GDCM_DIR  - The directory containing GDCMConfig.cmake.  
#             This is either the root of the build tree,
#             or the lib/vtk directory.  This is the 
#             only cache entry.


# Construct consitent error messages for use below.
SET(GDCM_DIR_DESCRIPTION "directory containing GDCMConfig.cmake.  This is either the root of the build tree, or PREFIX/lib/GDCM for an installation.")
SET(GDCM_DIR_MESSAGE "GDCM not found.  Set the GDCM_DIR cmake cache entry to the ${GDCM_DIR_DESCRIPTION}")

# Search only if the location is not already known.
IF(NOT GDCM_DIR)
  # Get the system search path as a list.
  IF(UNIX)
    STRING(REGEX MATCHALL "[^:]+" GDCM_DIR_SEARCH1 "$ENV{PATH}")
  ELSE(UNIX)
    STRING(REGEX REPLACE "\\\\" "/" GDCM_DIR_SEARCH1 "$ENV{PATH}")
  ENDIF(UNIX)
  STRING(REGEX REPLACE "/;" ";" GDCM_DIR_SEARCH2 "${GDCM_DIR_SEARCH1}")

  # Construct a set of paths relative to the system search path.
  SET(GDCM_DIR_SEARCH "")
  FOREACH(dir ${GDCM_DIR_SEARCH2})
    SET(GDCM_DIR_SEARCH ${GDCM_DIR_SEARCH}
      ${dir}/../lib/GDCM
      )
  ENDFOREACH(dir)

  #
  # Look for an installation or build tree.
  #
  FIND_PATH(GDCM_DIR GDCMConfig.cmake
    # Look for an environment variable GDCM_DIR.
    $ENV{GDCM_DIR}

    # Look in places relative to the system executable search path.
    ${GDCM_DIR_SEARCH}

    # Look in standard UNIX install locations.
    /usr/local/lib/GDCM
    /usr/lib/GDCM

    # Read from the CMakeSetup registry entries.  It is likely that
    # GDCM will have been recently built.
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild1]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild2]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild3]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild4]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild5]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild6]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild7]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild8]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild9]
    [HKEY_CURRENT_USER\\Software\\Kitware\\CMakeSetup\\Settings\\StartPath;WhereBuild10]

    # Help the user find it if we cannot.
    DOC "The ${GDCM_DIR_DESCRIPTION}"
  )
ENDIF(NOT GDCM_DIR)

# If GDCM was found, load the configuration file to get the rest of the
# settings.
IF(GDCM_DIR)
  # Make sure the GDCMConfig.cmake file exists in the directory provided.
  IF(EXISTS ${GDCM_DIR}/GDCMConfig.cmake)

    # We found GDCM.  Load the settings.
    SET(GDCM_FOUND 1)
    INCLUDE(${GDCM_DIR}/GDCMConfig.cmake)

  ENDIF(EXISTS ${GDCM_DIR}/GDCMConfig.cmake)
ELSE(GDCM_DIR)
  # We did not find GDCM.
  SET(GDCM_FOUND 0)
ENDIF(GDCM_DIR)

#-----------------------------------------------------------------------------
IF(NOT GDCM_FOUND)
  # GDCM not found, explain to the user how to specify its location.
  IF(NOT GDCM_FIND_QUIETLY)
    MESSAGE(FATAL_ERROR ${GDCM_DIR_MESSAGE})
  ELSE(NOT GDCM_FIND_QUIETLY)
    IF(GDCM_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR ${GDCM_DIR_MESSAGE})
    ENDIF(GDCM_FIND_REQUIRED)
  ENDIF(NOT GDCM_FIND_QUIETLY)
ENDIF(NOT GDCM_FOUND)
