#
# This module finds if GLIB is installed and determines where the
# include files and libraries are. It also determines what the name of
# the library is. This code sets the following variables:
#
#  GLIB_FOUND           = system has GLIB and it should be used
#  GLIB_LIBRARIES       = full path to the GLIB library and linker flags on unix
#  CMAKE_GLIB_CXX_FLAGS = compiler flags for building GLIB 
#  GLIB_INCLUDE_DIR     = include path of GLIB

IF(WIN32)
  IF(CYGWIN)

    FIND_PROGRAM(CMAKE_GLIB_CONFIG glib-config ../glib/bin ../../glib/bin)
    SET(CMAKE_GLIB_CXX_FLAGS "`${CMAKE_GLIB_CONFIG} --cflags`")
    SET(GLIB_LIBRARIES "`${CMAKE_GLIB_CONFIG} --libs`")

  ELSE(CYGWIN)

    SET (GLIB_POSSIBLE_PATHS
      $ENV{GLIB}/src/glib
      $ENV{CREATIS}/glib-1.3/src/glib
      "C:/glib-1.3/src/glib"
    )
    FIND_LIBRARY(GLIB_SHARED_LIBRARY
      NAMES glib-1.3
      PATHS ${GLIB_POSSIBLE_PATHS} 
    )

    FIND_PATH(GLIB_INCLUDE_DIR
      glib.h
      ${GLIB_POSSIBLE_PATHS} 
    )

  ENDIF(CYGWIN)
ELSE(WIN32)

  FIND_PROGRAM(CMAKE_GLIB_CONFIG glib-config ../glib/bin ../../glib/bin)
  SET(CMAKE_GLIB_CXX_FLAGS "`${CMAKE_GLIB_CONFIG} --cflags`")
  SET(GLIB_LIBRARIES "`${CMAKE_GLIB_CONFIG} --libs`")

ENDIF(WIN32)

MARK_AS_ADVANCED(
  GLIB_SHARED_LIBRARY
  CMAKE_GLIB_CONFIG
  CMAKE_GLIB_CXX_FLAGS
  GLIB_INCLUDE_DIR
)

IF(GLIB_LIBRARIES)
  IF(GLIB_INCLUDE_DIR OR CMAKE_GLIB_CXX_FLAGS)
    SET(CMAKE_GLIB_CAN_COMPILE 1)
    SET(GLIB_FOUND 1)
  ENDIF(GLIB_INCLUDE_DIR OR CMAKE_GLIB_CXX_FLAGS)
ENDIF(GLIB_LIBRARIES)

