#
# This module finds if GSL is installed and determines where the
# include files and libraries are. It also determines what the name of
# the library is. This code sets the following variables:
#
#  GSL_FOUND        = system has GSL and it should be used
#  GSL_LIBRARIES         = full path to the GSL library and linker flags on unix
#  CMAKE_GSL_CXX_FLAGS        = compiler flags for building GSL 
#  GSL_INCLUDE_DIR    = include path of GSL

IF(WIN32)
  IF(CYGWIN)

    FIND_PROGRAM(CMAKE_GSL_CONFIG gsl-config ../GSL/bin ../../GSL/bin)
    SET(CMAKE_GSL_CXX_FLAGS "`${CMAKE_GSL_CONFIG} --cflags`")
    SET(GSL_LIBRARIES "`${CMAKE_GSL_CONFIG} --libs`")

  ELSE(CYGWIN)

    SET (GSL_POSSIBLE_LIB_PATHS
      $ENV{GSL}/lib
      "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\GNU Scientific Library_is1;Inno Setup: App Path]/lib"
    )

    FIND_LIBRARY(GSL_STATIC_LIBRARY
      NAMES gsl
      PATHS ${GSL_POSSIBLE_LIB_PATHS} 
    )

    FIND_LIBRARY(GSL_SHARED_LIBRARY
      NAMES gsl
      PATHS ${GSL_POSSIBLE_LIB_PATHS} 
    )

    SET (GSL_POSSIBLE_INCLUDE_PATHS
      $ENV{GSL}/include
      "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\GNU Scientific Library_is1;Inno Setup: App Path]/include"
    )

    FIND_PATH(GSL_INCLUDE_DIR
      gsl/gsl_version.h
      ${GSL_POSSIBLE_INCLUDE_PATHS} 
    )

    IF(GSL_SHARED_LIBRARY)
      OPTION(GSL_USE_SHARED_LIBS 
             "Use shared versions of GSL libraries" ON)
      MARK_AS_ADVANCED(GSL_USE_SHARED_LIBS)
    ENDIF(GSL_SHARED_LIBRARY)

    SET(CMAKE_GSL_LIBRARIES ${CMAKE_GSL_LIBRARIES}) # comctl32 ctl3d32 wsock32 rpcrt4)

    IF(GSL_USE_SHARED_LIBS)
      SET(GSL_LIBRARIES ${GSL_SHARED_LIBRARY} ${CMAKE_GSL_LIBRARIES})
    ELSE(GSL_USE_SHARED_LIBS)
      SET(GSL_LIBRARIES ${GSL_STATIC_LIBRARY} ${CMAKE_GSL_LIBRARIES})
    ENDIF(GSL_USE_SHARED_LIBS)

    MARK_AS_ADVANCED(
      GSL_STATIC_LIBRARY
      GSL_SHARED_LIBRARY
      GSL_INCLUDE_DIR
    )
  ENDIF(CYGWIN)
ELSE(WIN32)

  FIND_PROGRAM(CMAKE_GSL_CONFIG gsl-config ../GSL/bin ../../GSL/bin)
  SET(CMAKE_GSL_CXX_FLAGS "`${CMAKE_GSL_CONFIG} --cflags`")
  SET(GSL_LIBRARIES "`${CMAKE_GSL_CONFIG} --libs`")

ENDIF(WIN32)  

MARK_AS_ADVANCED(
  CMAKE_GSL_CONFIG 
  CMAKE_GSL_CXX_FLAGS
  GSL_INCLUDE_DIR
)

IF(GSL_LIBRARIES)
  IF(GSL_INCLUDE_DIR OR CMAKE_GSL_CXX_FLAGS)
    SET(CMAKE_GSL_CAN_COMPILE 1)
    SET(GSL_FOUND 1)
  ENDIF(GSL_INCLUDE_DIR OR CMAKE_GSL_CXX_FLAGS)
ENDIF(GSL_LIBRARIES)

