#
# This module finds if GSLOBJ is installed and determines where the
# include files and libraries are. It also determines what the name of
# the library is. This code sets the following variables:
#
#  GSLOBJ_FOUND        = system has GSLOBJ and it should be used
#  GSLOBJ_LIBRARIES         = full path to the GSLOBJ library and linker flags on unix
#  CMAKE_GSLOBJ_CXX_FLAGS        = compiler flags for building GSLOBJ 
#  GSLOBJ_INCLUDE_DIR    = include path of GSLOBJ

IF(WIN32)
IF(NOT UNIX)
  SET (GSLOBJ_POSSIBLE_LIB_PATHS
    $ENV{GSLOBJ}/lib
    $ENV{CREATIS}/gslobj/win32inst/lib
    "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\GSLobj_is1;Inno Setup: App Path]/lib"
  )

  FIND_LIBRARY(GSLOBJ_STATIC_LIBRARY
    NAMES gslobj
    PATHS ${GSLOBJ_POSSIBLE_LIB_PATHS} 
  )

  SET (GSLOBJ_POSSIBLE_INCLUDE_PATHS
    $ENV{GSLOBJ}/include
    $ENV{CREATIS}/gslobj/win32inst/include
    "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\GSLobj_is1;Inno Setup: App Path]/include"
  )

  FIND_PATH(GSLOBJ_INCLUDE_DIR
    gslobj/gslobj.hxx
    ${GSLOBJ_POSSIBLE_INCLUDE_PATHS} 
  )

  SET(GSLOBJ_LIBRARIES ${GSLOBJ_STATIC_LIBRARY} ${CMAKE_GSLOBJ_LIBRARIES})

  MARK_AS_ADVANCED(
    GSLOBJ_STATIC_LIBRARY
    GSLOBJ_INCLUDE_DIR
  )
ENDIF(NOT UNIX)
ENDIF(WIN32)

IF(UNIX)

  FIND_PROGRAM(CMAKE_GSLOBJ_CONFIG gslobj-config ../gslobj/bin ../../gslobj/bin)
  SET(CMAKE_GSLOBJ_CXX_FLAGS "`${CMAKE_GSLOBJ_CONFIG} --cflags`")
  SET(GSLOBJ_LIBRARIES "`${CMAKE_GSLOBJ_CONFIG} --libs`")

ENDIF(UNIX)  

MARK_AS_ADVANCED(
  CMAKE_GSLOBJ_CXX_FLAGS
  GSLOBJ_INCLUDE_DIR
)

IF(GSLOBJ_LIBRARIES)
  IF(GSLOBJ_INCLUDE_DIR OR CMAKE_GSLOBJ_CXX_FLAGS)
    SET(CMAKE_GSLOBJ_CAN_COMPILE 1)
    SET(GSLOBJ_FOUND 1)
  ENDIF(GSLOBJ_INCLUDE_DIR OR CMAKE_GSLOBJ_CXX_FLAGS)
ENDIF(GSLOBJ_LIBRARIES)
