#
# This module finds if kgfo is installed and determines where the
# include files and libraries are. It also determines what the name of
# the library is. This code sets the following variables:
#
#  KGFO_FOUND        = system has kgfo and it should be used
#  KGFO_LIBRARIES         = full path to the kgfo library and linker flags on unix
#  CMAKE_KGFO_CXX_FLAGS        = compiler flags for building kgfo 
#  KGFO_INCLUDE_DIR    = include path of kgfo

IF(WIN32)
  IF(NOT UNIX)

    SET (KGFO_POSSIBLE_LIB_PATHS
      $ENV{KGFO}/lib
      $ENV{CREATIS}/kgfo/win32inst/lib
      "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\kgfo_is1;Inno Setup: App Path]/lib"
    )

    FIND_LIBRARY(KGFO_STATIC_LIBRARY
      NAMES kgfo
      PATHS ${KGFO_POSSIBLE_LIB_PATHS} 
    )

    FIND_LIBRARY(KGFO_SHARED_LIBRARY
      NAMES kgfo
      PATHS ${KGFO_POSSIBLE_LIB_PATHS} 
    )

    SET (KGFO_POSSIBLE_INCLUDE_PATHS
      $ENV{KGFO}/include
      $ENV{CREATIS}/kgfo/win32inst/include
      "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\kgfo_is1;Inno Setup: App Path]/include"
    )

    FIND_PATH(KGFO_INCLUDE_DIR
      kgfo/kgfo-setup.hxx
      ${KGFO_POSSIBLE_INCLUDE_PATHS} 
    )

    IF(KGFO_SHARED_LIBRARY)
      OPTION(KGFO_USE_SHARED_LIBS 
             "Use shared versions of kgfo libraries" ON)
      MARK_AS_ADVANCED(KGFO_USE_SHARED_LIBS)
    ENDIF(KGFO_SHARED_LIBRARY)

    SET(CMAKE_KGFO_LIBRARIES ${CMAKE_KGFO_LIBRARIES}) # comctl32 ctl3d32 wsock32 rpcrt4)

    IF(KGFO_USE_SHARED_LIBS)
      SET(KGFO_LIBRARIES ${KGFO_SHARED_LIBRARY} ${CMAKE_KGFO_LIBRARIES})
      ADD_DEFINITIONS(-DKGFO_USING_DLL)
    ELSE(KGFO_USE_SHARED_LIBS)
      SET(KGFO_LIBRARIES ${KGFO_STATIC_LIBRARY} ${CMAKE_KGFO_LIBRARIES})
    ENDIF(KGFO_USE_SHARED_LIBS)

    MARK_AS_ADVANCED(
      KGFO_STATIC_LIBRARY
      KGFO_SHARED_LIBRARY
      KGFO_INCLUDE_DIR
    )

  ENDIF(NOT UNIX)
ENDIF(WIN32)

IF(UNIX)

  FIND_PROGRAM(CMAKE_KGFO_CONFIG kgfo-config ../kgfo/bin ../../kgfo/bin)
  SET(CMAKE_KGFO_CXX_FLAGS "`${CMAKE_KGFO_CONFIG} --cflags`")
  SET(KGFO_LIBRARIES "`${CMAKE_KGFO_CONFIG} --libs`")

ENDIF(UNIX)  

MARK_AS_ADVANCED(
  CMAKE_KGFO_CONFIG
  CMAKE_KGFO_CXX_FLAGS
  KGFO_INCLUDE_DIR
)

IF(KGFO_LIBRARIES)
  IF(KGFO_INCLUDE_DIR OR CMAKE_KGFO_CXX_FLAGS)
    SET(CMAKE_KGFO_CAN_COMPILE 1)
    SET(KGFO_FOUND 1)
  ENDIF(KGFO_INCLUDE_DIR OR CMAKE_KGFO_CXX_FLAGS)
ENDIF(KGFO_LIBRARIES)

