#
# This module finds if Python is installed and determines where the
# include files and libraries are. It also determines what the name of
# the library is. This code sets the following variables:
#
#  LIBIDO_SOURCE_DIR      = the full path containing the sources
#  LIBIDO_BINARY_DIR      = the full path containing the binaries
#  LIBIDO_INCLUDE_PATHS   = the paths to where .h files can be found
#  LIBIDO_LIBRARIES       = the full path to the library found
#  LIBIDO_DEBUG_LIBRARIES = the full path to the debug library found
#

#-----------------------------------------------------------------------------
INCLUDE(${CMAKE_ROOT}/Modules/CMakeFindFrameworks.cmake)

#-----------------------------------------------------------------------------
IF(${libIdo_DIR})
   SET(LIBIDO_SOURCE_DIR ${libIdo_DIR} CACHE PATH "libIdo source directory")
   SET(LIBIDO_BINARY_DIR ${libIdo_DIR} CACHE PATH "libIdo binary directory")
ENDIF(${libIdo_DIR})

IF(NOT LIBIDO_SOURCE_DIR)
   FIND_PATH( LIBIDO_SOURCE_DIR  libido.spec.in  $ENV{LIBIDO_SRC} )
   SET(LIBIDO_SOURCE_DIR  ${LIBIDO_SOURCE_DIR}  CACHE PATH "libIdo source directory")
ELSE(NOT LIBIDO_SOURCE_DIR)
	INCLUDE_DIRECTORIES(${LIBIDO_SOURCE_DIR})
ENDIF(NOT LIBIDO_SOURCE_DIR)



IF(NOT LIBIDO_BINARY_DIR)
   FIND_PATH( LIBIDO_BINARY_DIR  libIdoConfig.cmake paths  $ENV{LIBIDO_PATH} )
   SET(LIBIDO_BINARY_DIR ${LIBIDO_BINARY_DIR}  CACHE PATH "libIdo binary directory")
ENDIF(NOT LIBIDO_BINARY_DIR)


#-----------------------------------------------------------------------------
# Set libIdo compilation variables
FIND_PATH(LIBIDO_INCLUDE_PATH NAME idima.h
   PATHS ${LIBIDO_SOURCE_DIR}/src
   DOC "libIdo include path"
)
FIND_LIBRARY(LIBIDO_LIBRARY name Ido libIdo
   PATHS ${LIBIDO_BINARY_DIR}/lib/release
   ${LIBIDO_BINARY_DIR}/lib
   DOC "libIdo library"
)
FIND_LIBRARY(LIBIDO_DEBUG_LIBRARY name Ido libIdo
   PATHS ${LIBIDO_BINARY_DIR}/lib/debug
   ${LIBIDO_BINARY_DIR}/lib
   DOC "libIdo debug library"
)

IF(WIN32)
   MARK_AS_ADVANCED(FORCE
      GLIB_INCLUDE_PATH
      GLIB_LIBRARY
   )
ENDIF(WIN32)
MARK_AS_ADVANCED(FORCE
   LIBIDO_SOURCE_DIR
   LIBIDO_BINARY_DIR
   LIBIDO_INCLUDE_PATH
   LIBIDO_LIBRARY
   LIBIDO_DEBUG_LIBRARY
)

SET(LIBIDO_INCLUDE_PATHS   "${LIBIDO_INCLUDE_PATH}")
SET(LIBIDO_LIBRARIES       "${LIBIDO_LIBRARY}")
SET(LIBIDO_DEBUG_LIBRARIES "${LIBIDO_DEBUG_LIBRARY}")

