#
# This module finds if WXGLADE is installed and determines where the
# include files and libraries are. It also determines what the name of
# the library is. This code sets the following variables:
#
#  WXGLADE_FOUND        = system has WXGLADE and it should be used
#  WXGLADE_EXECUTABLE  =  path to the program itself

IF(WIN32)
IF(NOT UNIX)
  SET (WXGLADE_POSSIBLE_LIB_PATHS
    $ENV{WXGLADE}
    "[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\wxGlade_is1;Inno Setup: App Path]"
  )

  FIND_PROGRAM(WXGLADE_EXECUTABLE 
    wxglade
    ${WXGLADE_POSSIBLE_LIB_PATHS}
  )

ENDIF(NOT UNIX)
ENDIF(WIN32)

IF(UNIX)

  #rpm put a /usr/bin/wxglade which link to:
  #/usr/lib/wxGlade/wxglade.py

#  FIND_PROGRAM(WXGLADE_EXECUTABLE 
#    wxglade
#    /usr/bin
#  )

  FIND_PROGRAM(WXGLADE_EXECUTABLE 
    wxglade.py
    /usr/lib/wxGlade
    /usr/local/lib/wxGlade
  )

  FIND_PROGRAM(XRC2WXG_EXECUTABLE 
    xrc2wxg.py
    /usr/lib/wxGlade
    /usr/local/lib/wxGlade
  )

ENDIF(UNIX)  

MARK_AS_ADVANCED(
  WXGLADE_EXECUTABLE 
)

IF(WXGLADE_EXECUTABLE)
    SET(WXGLADE_FOUND 1)
ENDIF(WXGLADE_EXECUTABLE)
