#-----------------------------------------------------------------------------
OPTION(USE_ITK "Build ITK-based " ON)
IF(USE_ITK)
  # Search ITK
  FIND_PACKAGE(ITK)
  # If itk found
  IF(ITK_FOUND)
    INCLUDE(${ITK_USE_FILE})
#    ADD_DEF( _USE_ITK_ )
    SET(MARACAS_ITK_LIBRARIES
      ${MARACAS_ITK_LIBRARIES}
      ITKCommon 
      ITKBasicFilters
      ITKIO
      ITKNumerics
      ITKAlgorithms
      #      itkvnl
      )  
    MARK_AS_ADVANCED(ITK_DIR)

    # images compilation option 
    OPTION ( itk_IMAGE_DIM_2 "itk : Compile 2D images" ON)
    OPTION ( itk_IMAGE_DIM_3 "itk : Compile 3D images" ON)
    OPTION ( itk_IMAGE_TYPE_UCHAR "itk : Compile unsigned char images" ON)
    OPTION ( itk_IMAGE_TYPE_SHORT "itk : Compile short images" ON)
    OPTION ( itk_IMAGE_TYPE_USHORT "itk : Compile unsigned short images" ON)
    OPTION ( itk_IMAGE_TYPE_INT "itk : Compile int images" ON)
    OPTION ( itk_IMAGE_TYPE_FLOAT "itk : Compile float images" ON)
    
#    IF ( itk_IMAGE_DIM_2 ) 
#      ADD_DEF( BBTK_ITK_IMAGE_DIM_2 )
#    ENDIF ( itk_IMAGE_DIM_2 )
    
#    IF ( itk_IMAGE_DIM_3 ) 
#      ADD_DEF( BBTK_ITK_IMAGE_DIM_3 )
#    ENDIF ( itk_IMAGE_DIM_3 )
    
#    IF ( itk_IMAGE_TYPE_UCHAR ) 
#      ADD_DEF( BBTK_ITK_IMAGE_TYPE_UCHAR )
#    ENDIF ( itk_IMAGE_TYPE_UCHAR )
    
#    IF ( itk_IMAGE_TYPE_SHORT ) 
#      ADD_DEF( BBTK_ITK_IMAGE_TYPE_SHORT )
#    ENDIF ( itk_IMAGE_TYPE_SHORT )
    
#    IF ( itk_IMAGE_TYPE_USHORT ) 
#      ADD_DEF( BBTK_ITK_IMAGE_TYPE_USHORT )
#    ENDIF ( itk_IMAGE_TYPE_USHORT )
    
#    IF ( itk_IMAGE_TYPE_INT ) 
#      ADD_DEF( BBTK_ITK_IMAGE_TYPE_INT )
#    ENDIF ( itk_IMAGE_TYPE_INT )
    
#    IF ( itk_IMAGE_TYPE_FLOAT ) 
#      ADD_DEF( BBTK_ITK_IMAGE_TYPE_FLOAT )
#    ENDIF ( itk_IMAGE_TYPE_FLOAT )
    

  ELSE(ITK_FOUND)
    MESSAGE(FATAL_ERROR
           "Cannot build MARACAS without ITK.  Please set ITK_DIR.")
  ENDIF(ITK_FOUND)






ENDIF(USE_ITK)
MARK_AS_ADVANCED(USE_ITK)
#-----------------------------------------------------------------------------
