/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

Program:   wxMaracas
Module:    $RCSfile: CutModelMainPanel.cxx,v $
Language:  C++
Date:      $Date: 2012/11/15 14:16:20 $
Version:   $Revision: 1.14 $

Copyright: (c) 2002, 2003
License:

This software is distributed WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the above copyright notice for more information.

=========================================================================*/



// EOF - wxMaracasMPR.cxx

#include "CutModelMainPanel.h"
#include "HistogramDialog.h"
#include "creaSystem.h"

#include <wx/colordlg.h>
#include <wx/bmpbuttn.h>

#include "Add.xpm"
#include "Undo.xpm"
#include "Redo.xpm"
#include "OkAll.xpm"



CutModelMainPanel* CutModelMainPanel::instance=NULL;

CutModelMainPanel::CutModelMainPanel( wxWindow* parent, std::string path)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize){

	cutmanager=NULL;
	_isCheck=false;
	_isFirstTime=true;
	initialize(path);

}
CutModelMainPanel::~CutModelMainPanel( ){
	viewpanels.clear();
	delete cutmanager;
}

void CutModelMainPanel::initialize(std::string path){
	cutmanager = new CutModelManager(path);
	_panelid = 0;
	_wxauimanager = new wxAuiManager(this);

	wxAuiPaneInfo paneinfo;

	//RaC 5-02-2010 Add tabs
	_notebook = new wxAuiNotebook(this,wxID_ANY,wxDefaultPosition,wxDefaultSize,wxAUI_NB_TOP |wxAUI_NB_TAB_MOVE | wxAUI_NB_SCROLL_BUTTONS);

	_notebook->AddPage(new ToolBarCutModel(_notebook),_T("Cutter"),true);
	//_wxauimanager->AddPane(new ToolBarCutModel(this),paneinfo.ToolbarPane().Top());
	_wxauimanager->AddPane(_notebook,paneinfo.Center().CloseButton(false));
	addPolygonCutterTab();
	_notebook->Update();

	_wxauimanager->Update();
}

CutModelMainPanel* CutModelMainPanel::getInstance(wxWindow* parent, std::string path){
	if(instance==NULL){
		if(parent == NULL){
			parent = new wxFrame();
		}
		instance = new CutModelMainPanel(parent, path);
	}
	return instance;
}

/*CutModelMainPanel* CutModelMainPanel::getInstance(){
return instance;
}*/


void CutModelMainPanel::setImageData(vtkImageData* img){
	try{
		checkInvariant();
		cutmanager->setImageData(img);
	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::setInteractor(vtkRenderWindowInteractor* interactor){
	try{
		checkInvariant();
		cutmanager->setInteractor(interactor);
	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::setRenderer(vtkRenderer* renderer){
	try{
		checkInvariant();
		cutmanager->setRenderer(renderer);
	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

// EED 2022-08-04	throw
//void CutModelMainPanel::checkInvariant()throw (CutModelException)
void CutModelMainPanel::checkInvariant()
{
	try {
		if(cutmanager==NULL)
		{
			throw CutModelException("The manager is not initialize");
		}
	} catch (...) {
	  throw ;
	}
}

void CutModelMainPanel::showErrorDialog(std::string str)
{
	wxMessageDialog* diag = new wxMessageDialog(this, wxString(str.c_str(),wxConvUTF8 ), wxString(str.c_str(),wxConvUTF8 ), wxICON_ERROR);
	diag->ShowModal();
}

void CutModelMainPanel::RemoveActor(int id)
{
	try{
		checkInvariant();
		if(!this->IsBeingDeleted()){
			int i,j;
			for(i = 0; i < (int)viewpanels.size()-1;i++){
				CutModelView* view = viewpanels[i];
				if(view->getId()==id){
					for(j = i; j < (int)viewpanels.size()-1;j++){
						viewpanels[j]=viewpanels[j+1];
					}
					i = viewpanels.size();
				}
			}
			viewpanels.pop_back();
			cutmanager->RemoveActor(id);
		}
	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

//RaC
void CutModelMainPanel::onCheckChanged()
{
	if(_isFirstTime==true)
	{
		_isFirstTime=false;
		cutmanager->InitializePolygonInteractorStyle();
	}
	if(_isCheck==false)
	{
		_isCheck=true;
		//Draw Polygon
		cutmanager->ParallelProjectionOn();
		btnExecutePolygonCut->Enable(false);
		_notebook->GetPage(0)->Enable(false);
		_radioinsideout->Enable(false);
		lblMessagePolygon->SetLabel(_T("Drawing polygon..."));
	} else {
		_isCheck=false;
		//Finish Drawing
		cout<<"Finish Drawing"<<endl;
		cutmanager->ParallelProjectionOff();
		btnExecutePolygonCut->Enable(true);
		_notebook->GetPage(0)->Enable(true);
		_radioinsideout->Enable(true);
		lblMessagePolygon->SetLabel(_T("Contour saved! Click on Execute Cut"));
	}
	cutmanager->UpdatePolygon(_isCheck);
}

//RaC
void CutModelMainPanel::onExecuteCutPolygon()
{
	//Cuts Polygon
	cutmanager->ExecuteCutPolygon(_radioinsideout->GetSelection());
	lblMessagePolygon->SetLabel(_T("No contour drawed"));
}

void CutModelMainPanel::onAddCutModel()
{
	try{
		checkInvariant();
		int id = addNewViewPanel();
		cutmanager->onAddCutModel(id, getModelView(id));
		_panelid++;
		ShowCurrentPanel(id);
	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::ShowCurrentPanel(int id)
{
        int i;
	for(i = 0; i < (int) viewpanels.size();i++){
		if(viewpanels[i]->getId()==id){
			_wxauimanager->GetPane(viewpanels[i]).Show(true);
			cutmanager->RefreshActor(id);
		}else{
			_wxauimanager->GetPane(viewpanels[i]).Show(false);
		}
	}
	_wxauimanager->Update();
}

// EED 2022-08-04	throw
//int CutModelMainPanel::addNewViewPanel()throw( CutModelException)
int CutModelMainPanel::addNewViewPanel()
{
	try {
		CutModelView* viewpanel = new CutModelView(this,cutmanager->getImageRange());
		wxAuiPaneInfo paneinfo0;
		_wxauimanager->AddPane(viewpanel, paneinfo0.DefaultPane().DestroyOnClose().Centre().Bottom());
		viewpanel->setId(_panelid);
		viewpanels.push_back(viewpanel);
		return viewpanel->getId();
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//CutModelView* CutModelMainPanel::getModelView(int id)throw( CutModelException)
CutModelView* CutModelMainPanel::getModelView(int id)
{
	try {
		CutModelView* current = NULL;
		int i;
		for(i = 0; i < (int)viewpanels.size();i++)
		{
			if(viewpanels[i]->getId()==id)
			{
				current = viewpanels[i];
			}
		}
		if(current == NULL)
		{
			std::string s = "Id not found";
			throw CutModelException(s);
		}
		return current;
	} catch (...) {
	  throw ;
	}
}

void CutModelMainPanel::onUndo()
{
	try{
		checkInvariant();
		/*int result = */ cutmanager->Undo(); // result unused// JPR

	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::onRedo(){
	try{
		checkInvariant();
		/*int result = */ cutmanager->Redo();

	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::changeOpacity(int id,int opacity){
	try{
		checkInvariant();
		cutmanager->changeOpacity(id, opacity);

	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::ShowViewBox(int id,bool check){
	try{
		checkInvariant();
		cutmanager->ShowViewBox(id, check);

	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::ShowPopUpMenu(int id)
{
	showErrorDialog("test");
}

void CutModelMainPanel::changeColor(int id,double r,double g,double b)
{
	try{
		checkInvariant();
		cutmanager->changeColor(id, r, g, b);

	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::ChangeShape(int id,int selection)
{
	try{
		checkInvariant();

		cutmanager->ChangeShape(id, selection);

	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::updateActorDirection(int id)
{
	try{
		checkInvariant();

		cutmanager->updateActorDirection(id);

	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::ExecuteCut(int id, double* range, bool isinside)
{
	try{
		checkInvariant();

		cutmanager->ExecuteCut(id, range, isinside);
	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
}

void CutModelMainPanel::ExecuteAll()
{
	int i;
	for(i = 0; i < (int)viewpanels.size(); i++){
		viewpanels[i]->ExecuteCut();
	}
}

vtkImageData* CutModelMainPanel::GetResultImage()
{
	try{
		checkInvariant();
		return cutmanager->GetResultImage();
	}catch(CutModelException e){
		showErrorDialog(e.getCause());
	}
	return NULL;
}

void CutModelMainPanel::ShowStatistics(int id)
{
	checkInvariant();
	HistogramDialog *histo = new HistogramDialog(this, _T("Statistics"));
	histo->initializeHistogram(cutmanager->GetResultImage());
	histo->ShowModal();
	delete histo;
}

void CutModelMainPanel::SaveCutModelData(std::string filename)
{
	cutmanager->SaveCutModelData(filename);
}

void CutModelMainPanel::LoadCutModelData(std::string filename)
{
	cutmanager->LoadCutModelData(filename);
}

void CutModelMainPanel::SetType(int type)
{
	_type = type;
}

int CutModelMainPanel::GetType()
{
	return _type;
}

void CutModelMainPanel::addPolygonCutterTab()
{
	wxPanel *panel = new wxPanel(_notebook);
	panel->SetAutoLayout(true);
	wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
	panel->SetSizer(sizer);
	sizer->AddSpacer(20);
	wxCheckBox *item = new wxCheckBox(panel,10,_T("Draw Polygon"),wxDefaultPosition,wxDefaultSize,0,wxDefaultValidator,_T("") );
	item->SetValue(false);
	Connect(item->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)(&PolygonCutterEventHandlerCutModel::onCheckChanged));
	sizer->Add(item, 0, wxALIGN_LEFT);
	lblMessagePolygon = new wxStaticText(panel,30,_T("No contour drawed"),wxDefaultPosition,wxDefaultSize,0,_T("") );
	sizer->Add(lblMessagePolygon, 0, wxALIGN_LEFT);
	wxString choices0[2];
	choices0[0] = _T("inside");
	choices0[1] = _T("outside");
	_radioinsideout = new  wxRadioBox(panel,-1,_T(""), wxDefaultPosition, wxDefaultSize,2,choices0);
	sizer->Add(_radioinsideout, wxALIGN_LEFT);
	btnExecutePolygonCut = new wxButton(panel,20,_T("Execute Cut"),wxDefaultPosition,wxDefaultSize,0,wxDefaultValidator,_T("") );
	Connect(btnExecutePolygonCut->GetId(), wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)(&PolygonCutterEventHandlerCutModel::onExecuteCutPolygon));
	sizer->Add(btnExecutePolygonCut, 0, wxALIGN_LEFT);
	_notebook->AddPage(panel, _T("Polygon Cutter"), false);
}

void PolygonCutterEventHandlerCutModel::onCheckChanged(wxCommandEvent& event)
{
	CutModelMainPanel::getInstance()->onCheckChanged();
}

void PolygonCutterEventHandlerCutModel::onExecuteCutPolygon(wxCommandEvent& event)
{
	CutModelMainPanel::getInstance()->onExecuteCutPolygon();
}

/**
**
**/
ToolBarCutModel::ToolBarCutModel(wxWindow * parent)
: wxToolBar(parent, -1, wxDefaultPosition, wxDefaultSize)
{
	wxBitmap bitmap10(Add_xpm);
	this->AddTool(10, wxString(_T("Add")),bitmap10);
	this->AddSeparator();
	wxBitmap bitmap20(Undo_xpm);
	this->AddTool(20, wxString(_T("Undo")),bitmap20);
	wxBitmap bitmap30(Redo_xpm);
	this->AddTool(30, wxString(_T("Redo")),bitmap30);
	this->AddSeparator();
	wxBitmap bitmap40(OkAll_xpm);
	this->AddTool(40, wxString(_T("Ok All")),bitmap40);
	this->Realize();
	_evthand = new ToolBarEventHandlerCutModel();
	this->SetEventHandler(_evthand);
}

ToolBarCutModel::~ToolBarCutModel(void)
{
}

ToolBarEventHandlerCutModel::ToolBarEventHandlerCutModel()
: wxEvtHandler()
{
}

ToolBarEventHandlerCutModel::~ToolBarEventHandlerCutModel()
{
}

void ToolBarEventHandlerCutModel::onAdd(wxCommandEvent& event)
{
	CutModelMainPanel::getInstance()->onAddCutModel();
}

void ToolBarEventHandlerCutModel::onUndo(wxCommandEvent& event)
{
	CutModelMainPanel::getInstance()->onUndo();
}

void ToolBarEventHandlerCutModel::onRedo(wxCommandEvent& event)
{
	CutModelMainPanel::getInstance()->onRedo();
}

void ToolBarEventHandlerCutModel::onExecuteAll(wxCommandEvent& event)
{
	CutModelMainPanel::getInstance()->ExecuteAll();
}

BEGIN_EVENT_TABLE(ToolBarEventHandlerCutModel, wxEvtHandler)
	EVT_MENU(10, ToolBarEventHandlerCutModel::onAdd)
	EVT_MENU(20, ToolBarEventHandlerCutModel::onUndo)
	EVT_MENU(30, ToolBarEventHandlerCutModel::onRedo)
	EVT_MENU(40, ToolBarEventHandlerCutModel::onExecuteAll)
END_EVENT_TABLE()
