/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: CutModelView.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:16:20 $
  Version:   $Revision: 1.4 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/



// EOF - wxMaracasMPR.cxx

#include "CutModelView.h"


#include <wx/colordlg.h>
#include <wx/bmpbuttn.h>

#include <OpenImage.xpm>
#include <Color.xpm>
#include <Ok1.xpm>
#include <Statistics.xpm>

#include "vtkBoxWidget.h"

#include "CutModelMainPanel.h"

CutModelView::CutModelView( wxWindow* parent, double* range)
: wxPanel(parent, -1, wxDefaultPosition, wxDefaultSize){

	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	this->SetSizer(sizer);	
	
	sizer->Add(getBoxControls(this, range),wxSizerFlags().FixedMinSize());	

	sizer->AddSpacer(5);

	sizer->Add(getActorProperties(this),wxSizerFlags().FixedMinSize());	


	wxBitmap bitmapok(Ok1_xpm);
	wxBitmapButton* okbutton = new wxBitmapButton(this, -1, bitmapok,wxDefaultPosition,wxSize(30,30));		 	
	Connect(okbutton->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)(&CutModelViewEventHandler::onExecute));	
	
	sizer->AddSpacer(5);
	sizer->Add(okbutton,wxSizerFlags().FixedMinSize());


	


}
CutModelView::~CutModelView( ){
	CutModelMainPanel::getInstance()->RemoveActor(this->getId());
}

wxSizer* CutModelView::getBoxControls(wxWindow* parent,double* range){

	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
	wxCheckBox* checkbox = new wxCheckBox(parent,-1,_T("View Box"));
	sizer->Add(checkbox,wxSizerFlags().FixedMinSize());
	checkbox->SetValue(true);
	Connect(checkbox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)(&CutModelViewEventHandler::onViewBoxChecked));

	wxString choices1[3];
	//choices1[0] = _T("Select a shape...");
	choices1[0] = _T("Sphere");
	choices1[1] = _T("Cylinder");
	choices1[2] = _T("Cube");
	wxComboBox* combo = new wxComboBox(parent, -1,_T(""),wxDefaultPosition,wxDefaultSize,3,choices1);
	combo->SetValue(_T("Sphere"));
	sizer->Add(combo,wxSizerFlags().FixedMinSize());
	Connect(combo->GetId(), wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)(&CutModelViewEventHandler::onShapeChange));

	wxStaticText* labelgreyv = new wxStaticText(parent, -1, wxString(_T("Grey value range")));	
	_sliderrange = new wxSlider(parent, -1, range[0],range[0],range[1],wxDefaultPosition,wxDefaultSize,wxSL_LABELS|wxSL_SELRANGE);
	wxBoxSizer* sizergreyv = new wxBoxSizer(wxVERTICAL);
	sizergreyv->Add(labelgreyv,wxSizerFlags().FixedMinSize());
	sizergreyv->Add(_sliderrange,1, wxGROW);
	sizer->Add(sizergreyv, 1, wxGROW);
	
	wxString choices0[2];
	choices0[0] = _T("inside");
	choices0[1] = _T("outside");
	_radioinsideout = new  wxRadioBox(parent,-1,_T(""), wxDefaultPosition, wxDefaultSize,2,choices0);
	sizer->Add(_radioinsideout,wxSizerFlags().FixedMinSize());

	/*wxString choices[2];
	choices[0] = _T("Cut");
	choices[1] = _T("Statistics");
	_radiocutstat = new  wxRadioBox(parent,-1,_T(""), wxDefaultPosition, wxDefaultSize,2,choices);
	sizer->Add(_radiocutstat,wxSizerFlags().FixedMinSize());*/

	wxBitmap bitmap(Statistics_xpm);
	wxBitmapButton* statbut = new wxBitmapButton(parent, -1, bitmap,wxDefaultPosition,wxSize(30,30));		 	
	Connect(statbut->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)(&CutModelViewEventHandler::onStatistics));	
    sizer->Add(statbut,wxSizerFlags().FixedMinSize());

	

	return sizer;
}
wxSizer* CutModelView::getActorProperties(wxWindow* parent){

	wxBoxSizer* sizeractorproperties = new wxBoxSizer(wxVERTICAL);	

	wxStaticText* labelshapeactor = new wxStaticText(parent, -1, wxString(_T("Actor's properties")));

	sizeractorproperties->Add(labelshapeactor,wxSizerFlags().FixedMinSize());

	sizeractorproperties->Add(getColorChooseActor(parent),wxSizerFlags().FixedMinSize());

	sizeractorproperties->Add(getOpacityActor(parent),wxSizerFlags().FixedMinSize());

	return sizeractorproperties;
	
}

wxSizer* CutModelView::getOpacityActor(wxWindow* parent){
	wxBoxSizer* sizeropacity = new wxBoxSizer(wxVERTICAL);	

	wxStaticText* labelopacity = new wxStaticText(parent, -1, wxString(_T("Opacity")));
	wxSlider* slider0 = new wxSlider(parent, -1, 60,0,100,wxDefaultPosition,wxDefaultSize,wxSL_LABELS);
	Connect(slider0->GetId(), wxEVT_SCROLL_THUMBRELEASE,(wxObjectEventFunction)(&CutModelViewEventHandler::onOpacityChange));	
	
	//sizeropacity->Add(labelopacity,1, wxGROWwxSizerFlags().FixedMinSize());
        sizeropacity->Add(labelopacity,1, wxGROW);
	//sizeropacity->Add(slider0,wxSizerFlags().FixedMinSize());
        sizeropacity->Add(slider0, 1, wxGROW);

	return sizeropacity;
}

wxSizer* CutModelView::getColorChooseActor(wxWindow* parent){
    wxBoxSizer* sizercolor = new wxBoxSizer(wxHORIZONTAL);
	wxBitmap bitmap(Color_xpm);
	wxBitmapButton* colorchoose = new wxBitmapButton(parent, -1, bitmap,wxDefaultPosition,wxSize(30,30));		 
	wxObjectEventFunction f = (wxObjectEventFunction)(&CutModelViewEventHandler::onColorChange);	
	Connect(colorchoose->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, f);	

	_currentcolor = new wxStaticText(parent,-1,_T(""),wxDefaultPosition,wxSize(20,20));
	this->SetCurrentColor(wxColour(255.0,0.0,0.0));

	sizercolor->Add(colorchoose,wxSizerFlags().FixedMinSize());
	sizercolor->AddSpacer(5);
	sizercolor->Add(_currentcolor,wxSizerFlags().FixedMinSize().Centre());
	return sizercolor;
}

// EED 2022-08-04	throw
//void CutModelView::checkInvariant()throw (CutModelException)
void CutModelView::checkInvariant()
{	
	try {
	} catch (...) {
	  throw ;
	}
}

void CutModelView::Execute(vtkObject *wdg, unsigned long eventId, void* calldata) {  // virtual
	//vtkBoxWidget *boxwidget = reinterpret_cast<vtkBoxWidget*>(wdg);

	if(eventId==vtkCommand::StartInteractionEvent){
        CutModelMainPanel::getInstance()->ShowCurrentPanel(this->getId());
	}else if(eventId==vtkCommand::InteractionEvent){
		CutModelMainPanel::getInstance()->updateActorDirection(this->getId());
	}else if(eventId==vtkCommand::RightButtonReleaseEvent){
		//  =(
        CutModelMainPanel::getInstance()->ShowPopUpMenu(this->getId());
	}
}

void CutModelView::ExecuteCut(){	
	if(this->isCut()){
		CutModelMainPanel::getInstance()->ExecuteCut(this->getId(),this->getRange(),this->isInside());
	}else{
	}
	
}

double* CutModelView::getRange(){
	double* x = new double[3];
	x[0] = 0;
	x[1] = _sliderrange->GetValue();
	x[2] = 100000;

	return x;
}
bool CutModelView::isCut(){
	return true;
	//return _radiocutstat->GetSelection()==0;
}
bool CutModelView::isInside(){
	return _radioinsideout->GetSelection()==0;
}
void CutModelView::SetCurrentColor(wxColour colour){
	_currentcolor->SetBackgroundColour(colour);

	this->Refresh();
	this->Layout();
}

void CutModelViewEventHandler::onColorChange(wxCommandEvent& event){
	CutModelView* parent = (CutModelView*)((wxWindow*)event.GetEventObject())->GetParent();
	wxColourDialog* colourdiag = new wxColourDialog(parent);
	if(colourdiag->ShowModal()==wxID_OK){
		wxColour colour = colourdiag->GetColourData().GetColour();
		
		parent->SetCurrentColor(colour);

		double r = (double)(colour.Red())/255.0;
		double g = (double)(colour.Green())/255.0;
		double b = (double)(colour.Blue())/255.0;		
		CutModelMainPanel::getInstance()->changeColor(parent->getId(),r,g,b);


	}
	delete colourdiag;
}

void CutModelViewEventHandler::onOpacityChange(wxScrollEvent& event){
	CutModelView* parent = (CutModelView*)((wxWindow*)event.GetEventObject())->GetParent();

	CutModelMainPanel::getInstance()->changeOpacity(parent->getId(),event.GetInt());
}
void CutModelViewEventHandler::onViewBoxChecked(wxCommandEvent& event){
    CutModelView* parent = (CutModelView*)((wxWindow*)event.GetEventObject())->GetParent();

	CutModelMainPanel::getInstance()->ShowViewBox(parent->getId(),event.IsChecked());
}
void CutModelViewEventHandler::onShapeChange(wxCommandEvent& event){
	CutModelView* parent = (CutModelView*)((wxWindow*)event.GetEventObject())->GetParent();

	//if(event.GetSelection()>0){
		//std::cout<<"id in CutModelViewEventHandler:: "<<parent->getId()<<std::endl;
	CutModelMainPanel::getInstance()->ChangeShape(parent->getId(),event.GetSelection());
	//}
}
void CutModelViewEventHandler::onStatistics(wxCommandEvent& event){
	CutModelView* parent = (CutModelView*)((wxWindow*)event.GetEventObject())->GetParent();
	CutModelMainPanel::getInstance()->ShowStatistics(parent->getId());
}
void CutModelViewEventHandler::onExecute(wxCommandEvent& event){
     CutModelView* parent = (CutModelView*)((wxWindow*)event.GetEventObject())->GetParent();

	 parent->ExecuteCut();
	 
}
