/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: CutModelData.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:48 $
  Version:   $Revision: 1.4 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/




#ifndef __CutModelDataH__
#define __CutModelDataH__

#include <iostream>
#include <vector>

#include "vtkImageData.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkCommand.h"
#include "vtkBoxWidget.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkProperty.h"
#include "CutModelException.h"
#include "CutModelFigure.h"
#include "CutModelFigureCube.h"
#include "CutModelFigureSphere.h"
#include "CutModelFigureCylinder.h"

#include <wx/utils.h>

class CutModelData  {

public:
	CutModelData();
	CutModelData(int id, vtkRenderWindowInteractor* interactor, vtkCommand* observer, vtkImageData* img);
	~CutModelData();
	void initializeData(int id, vtkRenderWindowInteractor* interactor, vtkCommand* observer, vtkImageData* img);
	int getId(){
		return _id;
	}
// EED 2022-08-04	
/*
	void changeOpacity(int opacity)throw( CutModelException);
	void ShowViewBox(bool check)throw( CutModelException);
	void ChangeShape(int selection)throw( CutModelException);
	vtkActor* getActor()throw( CutModelException);
	vtkPolyData* getPolyData()throw( CutModelException);
	void changeColor(double r,double g,double b)throw( CutModelException);
	void udapteActorDirection()throw( CutModelException);
	void ExecuteCut( double* range, bool isinside, vtkImageData* copyimage)throw( CutModelException);
	void ExecuteUnCut(  bool isinside, vtkImageData* image, vtkImageData* copyimage)throw( CutModelException);
	void setTransform(vtkTransform* transform,vtkImageData* img)throw( CutModelException);
*/
	void changeOpacity(int opacity);
	void ShowViewBox(bool check);
	void ChangeShape(int selection);
	vtkActor* getActor();
	vtkPolyData* getPolyData();
	void changeColor(double r,double g,double b);
	void udapteActorDirection();
	void ExecuteCut( double* range, bool isinside, vtkImageData* copyimage);
	void ExecuteUnCut(  bool isinside, vtkImageData* image, vtkImageData* copyimage);
	void setTransform(vtkTransform* transform,vtkImageData* img);
	
	void RefreshViewBox();
	vtkTransform* getCurrentMatrix(){
		return currentmatrix;
	}
	int getCurrentShape(){
		return _currentshape;
	}
	void setCurrentShape(int currentshape){
		_currentshape = currentshape;
	}
private:	
// EED 2022-08-04	
//	void checkInvariant()throw( CutModelException);
//	void setTransform(vtkImageData* img)throw( CutModelException);
	void checkInvariant();
	void setTransform(vtkImageData* img);
	
	void createBoxWidget(vtkRenderWindowInteractor* interactor, vtkCommand* observer);
	void createActor();
	void createShapes();	
	vtkBoxWidget			*_boxWidgetVolume;
	vtkPolyDataMapper		*_Mapper;	
	vtkActor				*_Actor;	
	int 					_id;
	int 					_currentshape;
	CutModelFigureCube		*_cubefigure;
	CutModelFigureCylinder	*_cylinderfigure;
	CutModelFigureSphere	*_spherefigure;
	vtkTransform			*currentmatrix;
	vtkTransform			*modeltransform;
	vtkTransform			*inversModel;
	CutModelFigure*	getCurentCuttingModel();
	vtkTransform*	getModelTransform(vtkImageData* copyimage);
	vtkTransform* 	getModelTransformInvers();
};

#endif 
