/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

Program:   wxMaracas
Module:    $RCSfile: CutModelManager.cxx,v $
Language:  C++
Date:      $Date: 2012/11/15 14:15:48 $
Version:   $Revision: 1.11 $

Copyright: (c) 2002, 2003
License:

This software is distributed WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "CutModelManager.h"

//Machete
#include "CutModelMainPanel.h"

/**
**	Start of the manager class
**/
CutModelManager::CutModelManager(std::string path){
	_path = path;
	_img = NULL;
	_img2 = NULL;
	_interactor = NULL;	
	_render = NULL;
	_currentaction=0;

}
CutModelManager::~CutModelManager(){
	std::string files = _path;
	files+="/infounrd_0_fig_0.info";	
	remove(files.c_str());	
	_vectordata.clear();
	_img = NULL;
	_img2 = NULL;
	_interactor = NULL;	
	_render = NULL;
}


vtkImageData* CutModelManager::getImageData(){
	return _img2;
}

void CutModelManager::setImageData(vtkImageData* img){
	int type = CutModelMainPanel::getInstance()->GetType();
	if( type == 0)
	{
		_img = img;

		if(_img2!=NULL){
			_img2->Delete();
		}
		_img2 = vtkImageData::New();
		_img2->SetExtent(_img->GetExtent());
		_img2->SetSpacing(_img->GetSpacing());
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_img2->AllocateScalars();
#else
  //...
#endif
		_img2->DeepCopy(_img);
	}
	else
	{
		_img2 = img;

		if(_img!=NULL){
			_img->Delete();
		}
		_img = vtkImageData::New();
		_img->SetExtent(_img2->GetExtent());
		_img->SetSpacing(_img2->GetSpacing());
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_img->AllocateScalars();
#else
  //...
#endif

		_img->DeepCopy(_img2);
	}
}

void CutModelManager::setInteractor(vtkRenderWindowInteractor* interactor){
	_interactor = interactor;
}

void CutModelManager::setRenderer(vtkRenderer* renderer){
	_render = renderer;
}

// EED 2022-08-04	throw
//void CutModelManager::onAddCutModel(int id, vtkCommand* observer) throw( CutModelException)
void CutModelManager::onAddCutModel(int id, vtkCommand* observer) 
{
	try {
		checkInvariant();
		CutModelData* data = new CutModelData(id,_interactor, observer, _img);
		_vectordata.push_back(data);
		_render->AddActor(data->getActor());
		//_render->UpdateCamera();
		_render->Render();
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::checkInvariant() throw( CutModelException)
void CutModelManager::checkInvariant() 
{
	try {
		if(_img==NULL){
			throw CutModelException("The image is not set");
		}
		if(_img2==NULL){
			throw CutModelException("The image is not set");
		}
		if(_interactor==NULL){
			throw CutModelException("Interactor not set");
		}
		if(_render==NULL){
			throw CutModelException("Render not set");
		}
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//double* CutModelManager::getImageRange()throw( CutModelException)
double* CutModelManager::getImageRange()
{
	try {
		checkInvariant();
		return _img->GetScalarRange();
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::changeOpacity(int id,int opacity)throw( CutModelException)
void CutModelManager::changeOpacity(int id,int opacity)
{
	try {
		checkInvariant();
		CutModelData* current = getCutModelData(id);
		current->changeOpacity(opacity);
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::ShowViewBox(int id,bool check)throw( CutModelException)
void CutModelManager::ShowViewBox(int id,bool check)
{
	try {
		checkInvariant();
		CutModelData* current = getCutModelData(id);
		current->ShowViewBox(check);
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::ChangeShape(int id,int selection)throw( CutModelException)
void CutModelManager::ChangeShape(int id,int selection)
{
	try {
		checkInvariant();
		CutModelData* current = getCutModelData(id);
		current->ChangeShape(selection);			
		_render->Render();
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//CutModelData* CutModelManager::getCutModelData(int id)throw( CutModelException)
CutModelData* CutModelManager::getCutModelData(int id)
{
	try {
		CutModelData* current = NULL;
		int i;
		for(i= 0; i < (int)_vectordata.size();i++)
		{
			CutModelData* temp = _vectordata[i];
			std::cout<<"id in CutModelManager:: "<<id<<std::endl;
			std::cout<<"vectordataid in CutModelManager:: "<<temp->getId()<<std::endl;
			if(temp->getId() == id)
			{
				current =  temp;
			}
		}
		if(current ==NULL)
		{
			throw CutModelException("Data not found");
		}
		return current;
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::updateActorDirection(int id)throw( CutModelException)
void CutModelManager::updateActorDirection(int id)
{
	try {
		checkInvariant();
		CutModelData* current = getCutModelData(id);
		current->udapteActorDirection();
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::changeColor(int id,double r,double g,double b)throw( CutModelException)
void CutModelManager::changeColor(int id,double r,double g,double b)
{
	try {
		checkInvariant();
		CutModelData* current = getCutModelData(id);
		current->changeColor(r,g,b);
		_render->Render();
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::RemoveActor(int id)throw( CutModelException)
void CutModelManager::RemoveActor(int id)
{
	try {
		checkInvariant();
		CutModelData* current = getCutModelData(id);
		int i,j;
		for(i = 0; i < (int)_vectordata.size()-1;i++)
		{
			if(_vectordata[i]->getId()==id){				
				for(j = i; j < (int)_vectordata.size()-1;j++){
					_vectordata[j]=_vectordata[j+1];
				}
				i = _vectordata.size();
			}
		}
		_render->RemoveViewProp(current->getActor());		
		//_render->RemoveViewProp(current->get
		delete current;
		_vectordata.pop_back();
		_render->Render();
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::ExecuteCut(int id, double* range, bool isinside)throw( CutModelException)
void CutModelManager::ExecuteCut(int id, double* range, bool isinside)
{
	try {
		checkInvariant();
		CutModelData* current = getCutModelData(id);
		current->ExecuteCut(range, isinside,_img2);
		/*
		Setting extra information for the undo
		*/
		CutModelSaveBinInfo* undoaction = this->AddActionUndo(id, CUTMODEL_CUT);
		undoaction->setRange(range);
		undoaction->setIsInside(isinside);
	} catch (...) {
	  throw ;
	}
}

vtkImageData* CutModelManager::GetResultImage()
{
	checkInvariant();
	return _img2;
}

void CutModelManager::RefreshActor(int id)
{
	checkInvariant();
	CutModelData* current = getCutModelData(id);	
	_render->RemoveActor(current->getActor());
	_render->AddActor(current->getActor());	
	current->RefreshViewBox();
	_render->Render();
}

// EED 2022-08-04	throw
//void CutModelManager::SaveCutModelData(std::string filename)throw( CutModelException)
void CutModelManager::SaveCutModelData(std::string filename)
{
	try {
		throw CutModelException("not implemented");
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//void CutModelManager::LoadCutModelData(std::string filename)throw( CutModelException)
void CutModelManager::LoadCutModelData(std::string filename)
{
	try {
		throw CutModelException("not implemented");
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//CutModelSaveBinInfo* CutModelManager::AddActionUndo(int idc, UNDOTYPE type)throw( CutModelException)
CutModelSaveBinInfo* CutModelManager::AddActionUndo(int idc, UNDOTYPE type)
{
	try {
		for(int i = _undoredo.size()-1; i > _currentaction;i--)
		{
			delete _undoredo[i];
			_undoredo.pop_back();		
		}
		CutModelSaveBinInfo* cutmodel = new CutModelSaveBinInfo(idc, _currentaction, type, _path);
		if(type == CUTMODEL_CUT){
			cutmodel->saveMatrix4x4(this->getCutModelData(idc)->getCurrentMatrix()->GetMatrix());
			cutmodel->setCurrentShape(this->getCutModelData(idc)->getCurrentShape());
		}
		_undoredo.push_back(cutmodel);
		_currentaction++;// = _undoredo.size();
		//std::cout<<"current index "<<_currentaction;
		return cutmodel;
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//int CutModelManager::Undo()	throw( CutModelException)
int CutModelManager::Undo()	
{
	try {
		//&& _currentaction < _undoredo.size()
		if(_currentaction > 0)
		{
			int tempaction = _currentaction-1;
			CutModelSaveBinInfo* currentundo = _undoredo[tempaction];
			CutModelData* currentmodel;
			if(currentundo->getActionType()==CUTMODEL_CUT){
				//Undo the cut
				vtkTransform* transform = currentundo->getTransformFromMatrixFile();
				currentmodel = getCutModelData(currentundo->getId());
				currentmodel->setTransform(transform, _img2);
				currentmodel->setCurrentShape(currentundo->getCurrentShape());
				currentmodel->ExecuteUnCut(currentundo->getIsInside(), _img, _img2);
			}
			//Every thing ok
			_currentaction--;
			return 0;
		}
		return -1;
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//int CutModelManager::Redo()	throw( CutModelException)
int CutModelManager::Redo()	
{
	try {
		if(_currentaction >= 0 && _currentaction < (int)_undoredo.size())
		{
			CutModelSaveBinInfo* currentundo = _undoredo[_currentaction];
			CutModelData* currentmodel;
			if(currentundo->getActionType()==CUTMODEL_CUT){
				//Redo the cut
				vtkTransform* transform = currentundo->getTransformFromMatrixFile();
				currentmodel = getCutModelData(currentundo->getId());
				currentmodel->setTransform(transform, _img2);
				currentmodel->setCurrentShape(currentundo->getCurrentShape());
				currentmodel->ExecuteCut(currentundo->getRange(), currentundo->getIsInside(), _img2);
			}
			_currentaction++;
			return 0;
		}
		return -1;
	} catch (...) {
	  throw ;
	}
}

void CutModelManager::ParallelProjectionOn()
{
	_render->GetActiveCamera()->ParallelProjectionOn();
}

void CutModelManager::ParallelProjectionOff()
{
	_render->GetActiveCamera()->ParallelProjectionOff();
}

//RaC
void CutModelManager::UpdatePolygon(bool mode)
{
	if(mode)
	{
		cutterstyle->Delete();
		cutterstyle = vtkInteractorStyleCutter::New();
		cutterstyle->SetInteractor ( _interactor );
		_interactor ->SetInteractorStyle( cutterstyle );
	} else {
		cutterstyle->VisibilityOff();
		loop = vtkImplicitSelectionLoop::New();
		mapper = vtkPolyDataMapper::New();
		if(cutterstyle->Finished())
		{
			if(actor3D != NULL)
			{
				_render->RemoveActor(actor3D);
			}
			loop->SetLoop( cutterstyle->GetLoopPoints() );
			loop->SetNormal( cutterstyle->GetDirection());
			/// Printing Points
			int numPoints = cutterstyle->GetLoopPoints()->GetNumberOfPoints();
			contourDirection = cutterstyle->GetDirection();

			contourPoints = cutterstyle->GetLoopPoints();

			_polygonCutter = new CutModelPolygon();

			cout<<"RaC Printing points......"<<endl;
			for(int t=0;t<numPoints;t++)
			{
				double point[3];
				cutterstyle->GetLoopPoints()->GetPoint(t,point);
				cout<<"Initial Point:"<<t<<" XX:"<<point[0]<<" YY:"<<point[1]<<" ZZ:"<<point[2]<<endl;
			}
			cout<<endl;
			sample = vtkSampleFunction::New();
			sample->SetImplicitFunction(loop);
			sample->CappingOn();			
			contour = vtkContourFilter::New();
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			contour->SetInput((vtkDataObject *)sample->GetOutput());
#else
			contour->SetInputData((vtkDataObject *)sample->GetOutput());
#endif
			contour->SetValue(0,1);
			actor = contour->GetOutput();
			actor3D = vtkActor::New();			
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
			mapper->SetInput(actor);			 
#else
			mapper->SetInputData(actor);			 
#endif
			mapper->SetScalarModeToUseCellData();
			actor3D->SetMapper( mapper);
			_render->AddActor(actor3D);			
		}		
		interactorstyle->SetInteractor (  _interactor );
		_interactor->SetInteractorStyle( interactorstyle );
	} 
	_interactor->Render();
	_render->ResetCameraClippingRange();
}

void CutModelManager::ExecuteCutPolygon(bool inOutCut)
{
	_polygonCutter->setInImage(_img2);
	_polygonCutter->setPoints(contourPoints);
	_polygonCutter->setDirection(contourDirection);
	_polygonCutter->processOutImage(inOutCut);
}

void CutModelManager::InitializePolygonInteractorStyle()
{
	cutterstyle = vtkInteractorStyleCutter::New();		
	interactorstyle = vtkInteractorStyleTrackballCamera ::New();
	interactorstyle->SetInteractor (  _interactor );
	_interactor->SetInteractorStyle( interactorstyle );
}
