/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __CutModelPolygonH__
#define __CutModelPolygonH__

#include "vtkImageData.h"
#include "vtkPoints.h"
#include "vtkTransform.h"
#include "manualBaseModel.h"
#include "manualContourModelPolygon.h"
#include "ContourExtractData.h"
#include <vector>

class CutModelPolygon{
public:
	//Constructor method
	CutModelPolygon();
    ~CutModelPolygon();

	// Principal method wich process the input imageData
	void processOutImage(int cutInsideOutside);

	//Initialize the characteristics of the output ImageData with dimensions 
	//and type of the input one.
	void initializeOutputImage();

	//Calculate three orthogonal and normalized vectors which are saved in parameters
	//v1 and v2. v1 is the resultant vector between point 0 and point 1 of the contour.
	//v2 is an orthogonal vector to v1 and the direction vector.
	//@param double v1 - Vector 1
	//@param double v2 - Vector 2, perpendicular to v1 and direction vector
	void calculateOrthogonalVectors(double* v1, double* v2);

	//Constructs the matrix transformation with the vectors given.
	//@param double v1 - Vector 1
	//@param double v2 - Vector 2
	//@param double v3 - Vector 3
	void updateTransform(double* v1, double* v2, double* v3);

	//Transforms all contour points with the transformation created with the correspondent vectors.
	//The transformed points are saved in the vectors given by parameter.
	//@param std::vector<double> *vectorOutX
	//@param std::vector<double> *vectorOutY
	//@param std::vector<double> *vectorOutZ
	void transformContourPoints(std::vector<double> *vectorOutX,std::vector<double> *vectorOutY,std::vector<double> *vectorOutZ);

	//Creates a Polygonal contour and put all the points which are included into it in the "direction vector" direction in value zero, 
	//and all the rest remains as they are in the original input image. It is the final step of the process.
	//This algorithm creates a hole in the whole image.
	//@param std::vector<double> *vectorOutX - X-coordinate of all contour points
	//@param std::vector<double> *vectorOutY - Y-coordinate of all contour points
	//@param std::vector<double> *vectorOutZ - Z-coordinate of all contour points
	void cutInputImage(std::vector<double> vectorOutX,std::vector<double> vectorOutY,std::vector<double> vectorOutZ);

	//Creates a Polygonal contour with the points given by parameter. This parameter exists in creaMaracasVisu
	//@param std::vector<double> *pointsX - X-coordinate of all contour points
	//@param std::vector<double> *pointsY - Y-coordinate of all contour points
	//@param std::vector<double> *pointsZ - Z-coordinate of all contour points
	manualBaseModel* InitializeContourModel(std::vector<double> pointsX, std::vector<double> pointsY,  std::vector<double> pointsZ);

	//////////////////////
	// Getters and setters
	//////////////////////

	vtkImageData* getInImage();
	vtkImageData* getOutImage();
	vtkPoints* getPoints();
	double* getDirection();

	void setInImage(vtkImageData* pImage);
	void setOutImage(vtkImageData* pImage);
	void setPoints(vtkPoints *pPoints);
	void setDirection(double *pDirection);
	
private:
	//Input image
	vtkImageData *_inImage;

	//Output image
	//vtkImageData *_outImage;

	//Contour points
	vtkPoints *_points;

	//Direction vector
	double *_direction;
	
	//Transform
	vtkTransform *_transform;

	//If cuts inside:0, else 1
	int _cutInsideOutside;
};

#endif
