/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: CutModelSaveBinInfo.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:48 $
  Version:   $Revision: 1.3 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "CutModelSaveBinInfo.h"

/**
**	Start of the manager class
**/
CutModelSaveBinInfo::CutModelSaveBinInfo(int id, int currentaction, UNDOTYPE actiontype, std::string path)
{
	_id = id;
	char c[100];
	sprintf(c,"/infounrd_%d_fig_%d.info",currentaction,id);
	_stdFilename = path;	
    _stdFilename+=c;
	_stdFilename+=".poly";
	_matrixFilename = path;	
	_matrixFilename+=c;
	_actiontype = actiontype;	
}

CutModelSaveBinInfo::~CutModelSaveBinInfo()
{	
}

void CutModelSaveBinInfo::savePolyData(vtkPolyData* polydata)
{
	vtkPolyDataWriter * writer = vtkPolyDataWriter ::New();
	writer->SetFileName(_stdFilename.c_str());	
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	writer->SetInput(polydata);
#else
	writer->SetInputData(polydata);
#endif

	writer->SetFileTypeToBinary();
	writer->Write();
	writer->Delete();
}

// EED 2022-08-04	throw
//vtkTransform* CutModelSaveBinInfo::getPolyDataTransform()throw( CutModelException)
vtkTransform* CutModelSaveBinInfo::getPolyDataTransform()
{
	try {
			vtkPolyDataReader* reader = vtkPolyDataReader::New();
			//std::cout<<"filename vtkTransform* CutModelSaveBinInfo::getPolyDataTransform()"<<this->getSTDFileName()<<std::endl;
			reader->SetFileName(this->getSTDFileName().c_str());
			vtkPolyData* poly = reader->GetOutput();

			vtkPolyDataMapper* mapper	= vtkPolyDataMapper::New();	
		//EED 2017-01-01 Migration VTK7
		#if VTK_MAJOR_VERSION <= 5
			mapper->SetInput(poly);
		#else
			mapper->SetInputData(poly);
		#endif
			vtkActor* actor	= vtkActor::New();
			actor->SetMapper(mapper);
			vtkMatrix4x4* actmatrix = actor->GetMatrix();

			std::cout<<"tkTransform* CutModelSaveBinInfo::getPolyDataTransform() Actor "<<actor<<std::endl;
			std::cout<<"tkTransform* CutModelSaveBinInfo::getPolyDataTransform() Actor Matrix "<<actmatrix<<std::endl;

			mapper->Update();

			vtkTransform* transform = vtkTransform::New();

			transform->Identity();

			transform->GetMatrix()->SetElement(0,0,actmatrix->GetElement(0,0));
			transform->GetMatrix()->SetElement(1,0,actmatrix->GetElement(1,0));
			transform->GetMatrix()->SetElement(2,0,actmatrix->GetElement(2,0));
			transform->GetMatrix()->SetElement(0,1,actmatrix->GetElement(0,1));
			transform->GetMatrix()->SetElement(1,1,actmatrix->GetElement(1,1));
			transform->GetMatrix()->SetElement(2,1,actmatrix->GetElement(2,1));
			transform->GetMatrix()->SetElement(0,2,actmatrix->GetElement(0,2));
			transform->GetMatrix()->SetElement(1,2,actmatrix->GetElement(1,2));
			transform->GetMatrix()->SetElement(2,2,actmatrix->GetElement(2,2));		
			transform->GetMatrix()->SetElement(0,3,actmatrix->GetElement(0,3));
			transform->GetMatrix()->SetElement(1,3,actmatrix->GetElement(1,3));
			transform->GetMatrix()->SetElement(2,3,actmatrix->GetElement(2,3));

			actor->Delete();
			mapper->Delete();
			reader->Delete();
			//poly->Delete();
			return transform;
	} catch (...) {
	  throw ;
	}
}

void CutModelSaveBinInfo::saveMatrix4x4(vtkMatrix4x4* matrix)
{
	fstream binary_file(_matrixFilename.c_str(),ios::out|ios::binary);
	binary_file.write(reinterpret_cast<char *>(matrix),sizeof(vtkMatrix4x4));
	binary_file.close();
}

// EED 2022-08-04	throw
//vtkTransform* CutModelSaveBinInfo::getTransformFromMatrixFile()throw( CutModelException)
vtkTransform* CutModelSaveBinInfo::getTransformFromMatrixFile()
{
	try {
		vtkMatrix4x4* matrix = vtkMatrix4x4::New();
		fstream binary_file(_matrixFilename.c_str(),ios::binary|ios::in);
		binary_file.read(reinterpret_cast<char *>(matrix),sizeof(vtkMatrix4x4));
		binary_file.close();
		vtkTransform* transform = vtkTransform::New();
		transform->SetMatrix(matrix);
		return transform;
	} catch (...) {
	  throw ;
	}
}

// EED 2022-08-04	throw
//std::string CutModelSaveBinInfo::getSTDFileName()throw( CutModelException)
std::string CutModelSaveBinInfo::getSTDFileName()
{
	try {
		if(_stdFilename=="")
		{
			throw new CutModelException("Filename undoredo does not exists");
		}
		return _stdFilename;
	} catch (...) {
	  throw ;
	}
}


