/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: CutModelSaveBinInfo.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:49 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/




#ifndef __CutModelSaveBinInfoH__
#define __CutModelSaveBinInfoH__

#include <iostream>
#include <vector>
#include "CutModelException.h"

#include <vtkPolyData.h>
#include <vtkPolyDataWriter.h>
#include <vtkPolyDataReader.h>
#include <vtkPolyDataMapper.h>
#include <vtkTransform.h>
#include <vtkMatrix4x4.h>
#include <vtkActor.h>

enum UNDOTYPE
{
    CUTMODEL_ADD = 0,	
	CUTMODEL_REMOVE = 10,
	CUTMODEL_CUT= 20,
	
};

class CutModelSaveBinInfo  {

public:
	
	CutModelSaveBinInfo(int id, int currentaction,UNDOTYPE actiontype, std::string path);
	~CutModelSaveBinInfo();

	int getId(){
		return _id;
	}	

	UNDOTYPE getActionType(){
		return _actiontype;
	}

// EED 2022-08-04	
//	std::string getSTDFileName()throw( CutModelException);
//	std::string getSTDFileName()throw( CutModelException){
//		if(_stdFilename==""){
//			throw new CutModelException("Filename undoredo does not exists");
//		}
//		return _stdFilename;
//	}
	std::string getSTDFileName();


	/*void setSTDFileName(std::string filename){
		_stdFilename = filename;
	}*/

	int getCurrentShape(){
		return _currentshape;
	}

	void setCurrentShape(int currentshape){
		_currentshape=currentshape;
	}

	void savePolyData(vtkPolyData* polydata);


// EED 2022-08-04	
//	vtkTransform* getPolyDataTransform()throw( CutModelException);	
//	vtkTransform* getTransformFromMatrixFile()throw( CutModelException);
	vtkTransform* getPolyDataTransform();	
	vtkTransform* getTransformFromMatrixFile();
	
	void saveMatrix4x4(vtkMatrix4x4* matrix);

	void setRange(double* range){
		_range = range;
	}
	void setIsInside(bool isinside){
		_isinside = isinside;
	}

	double* getRange(){
		return _range;
	}
	bool getIsInside(){
		return _isinside;
	}
	
private:		
	
	int _id;
	UNDOTYPE _actiontype;
	int _currentshape;
	double* _range;
	bool _isinside;
	std::string _stdFilename;		
	std::string _matrixFilename;	
};



#endif 
