proc swig_cast { pointer newType } {

    set pt [ split $pointer "_"]
    return "_[ lindex $pt 1 ]_$newType"

}

proc DistPoints { x1 y1 z1 x2 y2 z2 } {
  
  set carre [ expr ( ( $x2 - $x1 ) * ( $x2 - $x1 ) ) + ( ( $y2 - $y1 ) * ( $y2 - $y1 ) ) + ( ( $z2 - $z1 ) * ( $z2 - $z1 ) ) ]
  set carre [ expr sqrt( $carre ) ]
  return $carre

}

proc VoxelCoord { xPto yPto zPto xOrig yOrig zOrig dimXVoxel dimYVoxel dimZVoxel } {

  set d [ expr $xPto - $xOrig ]
  set d [ expr $d + 0.0 ]
  set floatLoc [ expr $d / $dimXVoxel ]
  set xVoxel [ expr round( $floatLoc ) ]

  set d [ expr $yPto - $yOrig ]
  set d [ expr $d + 0.0 ]
  set floatLoc [ expr $d / $dimYVoxel ]
  set yVoxel [ expr round( $floatLoc ) ]

  set d [ expr $zPto - $zOrig ]
  set d [ expr $d + 0.0 ]
  set floatLoc [ expr $d / $dimZVoxel ]
  set zVoxel [ expr round( $floatLoc ) ]
  return "$xVoxel $yVoxel $zVoxel"

}

proc PointCoord { xVoxel yVoxel zVoxel xOrig yOrig zOrig dimXVoxel dimYVoxel dimZVoxel } {


  set floatLoc [ expr $xVoxel * $dimXVoxel ]
  set xPto [ expr $floatLoc + $xOrig ]

  set floatLoc [ expr $yVoxel * $dimYVoxel ]
  set yPto [ expr $floatLoc + $yOrig ]

  set floatLoc [ expr $zVoxel * $dimZVoxel ]
  set zPto [ expr $floatLoc + $zOrig ]

  return "$xPto $yPto $zPto"
}

proc DrawSphere { name radius xc yc zc r g b } {

    vtkSphereSource $name
        $name SetRadius $radius
        $name SetCenter $xc $yc $zc
    vtkPolyDataMapper mapper_sphere_$name
        mapper_sphere_$name SetInput [ $name GetOutput ]
        mapper_sphere_$name ImmediateModeRenderingOn
    vtkActor actor_sphere_$name
        actor_sphere_$name SetMapper mapper_sphere_$name
        [ actor_sphere_$name GetProperty ] SetColor  $r $g $b

    return "actor_sphere_$name"

}

proc GetSphereActorName { name } {

    return "actor_sphere_$name"

}

proc DeleteSphere { name } {

    catch { actor_sphere_$name  Delete }
    catch { mapper_sphere_$name Delete }
    catch { $name               Delete }

}

proc pick_point_local_actor { x y renderer actor { tol 0.025 } } {

#    catch { pick_point_local_cell_picker Delete }
#
#    vtkWorldPointPicker pick_point_local_cell_picker
#        pick_point_local_cell_picker Pick $x $y 0 $renderer
#        set pickWPPos [ pick_point_local_cell_picker GetPickPosition ]
#
#    catch { pick_point_local_cell_picker Delete }
#    return $pickWPPos
#
    catch { pick_point_local_cell_picker Delete }

    set actors [ $renderer GetActors ]
    vtkCellPicker pick_point_local_cell_picker
        pick_point_local_cell_picker SetTolerance $tol
        pick_point_local_cell_picker Pick $x $y 0 $renderer
        set positions [ pick_point_local_cell_picker GetPickedPositions ]

    set ret {}
    for { set i 0 } { $i < [ $actors GetNumberOfItems ] } { incr i } {

        set act [ $actors GetItemAsObject $i ]
        if { [ string compare $act $actor ] == 0 } {

            set ret [ $positions GetPoint $i ]
            break

        }

    }
    catch { pick_point_local_cell_picker Delete }
    return $ret

}

proc change_float_precision { number decimals } {

    set l [ split $number . ]
    set ret $number
    if { [ llength $l ] == 2 } {

        set ret "[ lindex $l 0 ]."
        for { set i 0 } { $i < $decimals } { incr i } {

            set ret "$ret[ string index [ lindex $l 1 ] $i ]"

        }

    }
    return $ret

}

# EOF - general.tcl
