/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef MAR__INTERFACE__TCL__HXX
#define MAR__INTERFACE__TCL__HXX

#include "../kernel/marInterface.h"
#include <kgfo/volstat.hxx>
#include <tcl.h>
#include <tk.h>
#include <wx/list.h>
#include <wx/string.h>
#include <vtkCellArray.h>
#include <vtkCellLocator.h>
#include <vtkImageData.h>
#include <vtkMath.h>
#include <vtkPoints.h>
#include <vtkPolyData.h>
#include <vtkTclUtil.h>

// ----------------------------------------------------------------------------
static marInterface MyMaracasData;
static kVolume* _ucharVol = NULL;

// ----------------------------------------------------------------------------
void freeAllMaracasInterfaces_dll( )
{
	MyMaracasData.reset( );
	if( _ucharVol ) delete _ucharVol;
	_ucharVol = NULL;
}

// ----------------------------------------------------------------------------
wxStringList params_dll( )
{
    return( MyMaracasData._parameters->getRelationalArray( ) );

}

// ----------------------------------------------------------------------------
void setParams_dll( wxStringList& raParams )
{
    MyMaracasData._parameters->setRelationalArray( raParams );

}

// ----------------------------------------------------------------------------
bool saveParams_dll( std::string& fName )
{
    return( MyMaracasData.saveParameters( std::string( fName ) ) );

}

// ----------------------------------------------------------------------------
bool loadParams_dll( std::string& fName )
{
    return( MyMaracasData.loadParameters( std::string( fName ) ) );

}

// ----------------------------------------------------------------------------
void SetROIStep_dll( double vWidth )
{
    MyMaracasData._parameters->setROIStep( vWidth );

}

// ----------------------------------------------------------------------------
double GetActualVoxelSize_dll( ) {

    return( MyMaracasData._parameters->getVoxelSize( ) );

}

// ----------------------------------------------------------------------------
wxStringList studies_dll( )
{
    return( MyMaracasData._dicom->getStudies( ) );
}

// ----------------------------------------------------------------------------
wxStringList studyData_dll( std::string& study )
{
    MyMaracasData._dicom->setActualStudy( study );
    return( MyMaracasData._dicom->getRelationalArrayStudyData( ) );

}

// ----------------------------------------------------------------------------
wxStringList series_dll( std::string& study )
{
    MyMaracasData._dicom->setActualStudy( study );
    return( MyMaracasData._dicom->getSeries( ) );

}

// ----------------------------------------------------------------------------
wxStringList serieData_dll( std::string& study, std::string& serie )
{
    MyMaracasData._dicom->setActualStudy( study );
    MyMaracasData._dicom->setActualSerie( serie );
    return( MyMaracasData._dicom->getRelationalArraySerieData( ) );

}

// ----------------------------------------------------------------------------
void SubtractSeries_dll( std::string& sl, std::string& sr, std::string& ss, std::string& description )
{/*
   marDicom::SubtractSeries(
   MyMaracasData._parameters,
   MyMaracasData._dicom->getActualStudy( ),
   sl, sr,
   ss, description
   );
 */
}

// ----------------------------------------------------------------------------
bool LoadImages_dll( )
{
    MyMaracasData._dicom->loadActualSerie( );
    return( true );

}

// ----------------------------------------------------------------------------
void CastVolume_dummy( )
{
	if( _ucharVol ) delete _ucharVol;
	_ucharVol = new kVolume( *( MyMaracasData._dicom->getVolume( ) ) );

	_ucharVol->convertScale( kVolume::UCHAR, 0, 255 );

}

// ----------------------------------------------------------------------------
void LoadTkImage_dummy( uchar** image, int w, int h,
						std::string& tkName, Tcl_Interp* interp )
{
    Tk_PhotoHandle hnd;
    Tk_PhotoImageBlock bl;

    hnd = Tk_FindPhoto( interp, ( char* )tkName.c_str( ) );
    if( hnd != NULL ) {

        // Image size
        bl.width  = w;
        bl.height = h;

        // One pixel is represented with one unsigned short value
        bl.pixelSize = sizeof( uchar );

        // We're working on intensity images i.e. no RGB
        bl.offset[ 0 ] = 0;
        bl.offset[ 1 ] = 0;
        bl.offset[ 2 ] = 0;
        bl.offset[ 3 ] = 0;

        // To go to next in vertical value
        bl.pitch = bl.pixelSize * bl.width;

        // Menory block
        bl.pixelPtr = ( uchar* )image[ 0 ];

        // Ok, lets do it!
        Tk_PhotoPutBlock( hnd, &bl, 0, 0, bl.width, bl.height );

    } // fi

}

// ----------------------------------------------------------------------------
void LoadTkImages_dll( wxStringList& tkNames, Tcl_Interp* interp )
{
    int k, w, h, d;
	std::string tmp;

    w = MyMaracasData._dicom->getVolume( )->getXdim( );
    h = MyMaracasData._dicom->getVolume( )->getYdim( );
    d = MyMaracasData._dicom->getVolume( )->getZdim( );

    CastVolume_dummy( );
	uchar*** vol = ( uchar*** )( _ucharVol->getData3D( ) );
    for( k = 0; k < d; k++ ) {

		tmp = tkNames[ k ];
        LoadTkImage_dummy( vol[ k ],
						   w, h, tmp, interp );

    } // rof

}

// ----------------------------------------------------------------------------
int GetNumberOfImages_dll( )
{
    return( MyMaracasData._dicom->getVolume( )->getZdim( ) );

}

// ----------------------------------------------------------------------------
wxStringList GetImagesNumbers_dll( )
{
    return( MyMaracasData._dicom->getImageNumbers( ) );

}

// ----------------------------------------------------------------------------
double GetImageIntensity_dll( int x, int y, int z )
{
    return( MyMaracasData._dicom->getVolume( )->getPixel( x, y, z ) );

}

// ----------------------------------------------------------------------------
ushort* GetProfilFromTotalVolume_dll( int xO, int yO, int zO,
										 int xF, int yF, int zF )
{
    int i;
	kVolumeStat* stats = new kVolumeStat( MyMaracasData._dicom->
										  getVolume( ) );

	stats->profile( xO, yO, zO, xF, yF, zF );

    ushort* r = new ushort[ stats->getSize( ) + 6 ];

    r[ 0 ] = stats->getSize( ) + 6;
    r[ 1 ] = ( ushort )stats->getMin( );
    r[ 2 ] = ( ushort )stats->getMax( );
    r[ 3 ] = ( ushort )stats->getAvg( );
    r[ 4 ] = ( ushort )stats->getSD( );
    r[ 5 ] = ( ushort )stats->getSize( );
    for( i = 0; i < stats->getSize( ); i++ )
		r[ i + 6 ] = ( ushort )( stats->getValues( ) )[ i ];
    return( r );

}

// ----------------------------------------------------------------------------
void GetAreaValuesFromTotalVolume_dll( int xO, int yO, int zO,
									   int xF, int yF, int zF,
									   int* min, int* max, int* avg,
									   int* sd, int* size )
{
	kVolumeStat* stats = new kVolumeStat( MyMaracasData._dicom->getVolume( ) );

	stats->stats( xO, yO, zO, xF, yF, zF );

    *min = ( int )stats->getMin( );
    *max = ( int )stats->getMax( );
    *avg = ( int )stats->getAvg( );
    *sd = ( int )stats->getSD( );
    *size = stats->getSize( );

}

// ----------------------------------------------------------------------------
bool SaveExperiment_dll ( std::string& fName )
{
    return( MyMaracasData.saveExperiment( fName ) );

}

// ----------------------------------------------------------------------------
bool LoadExperiment_dll ( std::string& fName )
{
    return( MyMaracasData.loadExperiment( fName ) );

}

// ----------------------------------------------------------------------------
void InitExperiment_dll ( int* voi )
{
    MyMaracasData._experiment->setVOI( voi );
    MyMaracasData._experiment->initExperiment( MyMaracasData._dicom->
											   getVolume( ) );
	//if( _ucharVol ) delete _ucharVol;
	//_ucharVol = NULL;
	MyMaracasData._dicom->freeVolume( );
}

// ----------------------------------------------------------------------------
void SetStartPoint_dll( int x, int y, int z )
{
    MyMaracasData._experiment->setStartPoint( x, y, z );
}

// ----------------------------------------------------------------------------
void ExtractAxes_dll( )
{
    MyMaracasData._experiment->extractVascularTree( );
}

// ----------------------------------------------------------------------------
int GetNumberOfAxes_dll( )
{
    return( MyMaracasData._experiment->getNumberOfAxes( ) );
}

// ----------------------------------------------------------------------------
vtkPolyData* GetAllAxes_dll( )
{
    int i, n, j;
    double p[ marAxis::INDX_count ];
    marAxis* tmp;

    vtkPoints* allPoints = vtkPoints::New( );
    vtkCellArray* allTopology = vtkCellArray::New( );

    j = 0;
    for( n = 0; n < MyMaracasData._experiment->getNumberOfAxes( ); n++ ) {

        tmp = MyMaracasData._experiment->getAxis( );
        allTopology->InsertNextCell( tmp->getNumberOfControlPoints( ) );
        for( i = 0; i < tmp->getNumberOfControlPoints( ); i++ ) {

            tmp->getControlPoint( i, p, p + 3 );
            allPoints->InsertNextPoint( p[ 0 ], p[ 1 ], p[ 2 ] );
            allTopology->InsertCellPoint( j );
			j++;

        } // rof

    } // rof

    vtkPolyData* allData = vtkPolyData::New( );
    allData->SetPoints( allPoints );
    allData->SetLines( allTopology );
    
    allPoints->Delete();
    allTopology->Delete();

    return( allData );

}

// ----------------------------------------------------------------------------
vtkPolyData* GetActualAxis_dll( )
{
    int i, j, h;
    double p[ marAxis::INDX_count ];
    marAxis* tmp;

    vtkPoints* points = vtkPoints::New( );
    vtkCellArray* topology = vtkCellArray::New( );

    j = 0;
    h = MyMaracasData._experiment->getDynData( )->getVolume( )->getYdim( );
    tmp = MyMaracasData._experiment->getAxis( );
    topology->InsertNextCell( tmp->getNumberOfControlPoints( ) );
    for( i = 0; i < tmp->getNumberOfControlPoints( ); i++ ) {

		tmp->getControlPoint( i, p, p + 3 );
		topology->InsertCellPoint( j++ );
		points->InsertNextPoint( p[ 0 ], h - 1 - p[ 1 ], p[ 2 ] );

    } // rof

    vtkPolyData* data = vtkPolyData::New( );
    data->SetPoints( points );
    data->SetLines( topology );
    
    points->Delete();
    topology->Delete();

    return( data );
}

// ----------------------------------------------------------------------------
int GetActualAxisNumberOfPoints_dll( )
{
    return( MyMaracasData._experiment->getAxis( )->getNumberOfControlPoints( ) );

}

// ----------------------------------------------------------------------------
double* GetActualAxisPoint_dll( int i )
{
    double* ret = new double[ marAxis::INDX_count + 1 ];

    ret[ 0 ] = marAxis::INDX_count;
    MyMaracasData._experiment->getAxis( )->getControlPoint( i, ret + 1, ret + 4 );
    return( ret );
}

// ----------------------------------------------------------------------------
vtkImageData* GetActualAxisSlice_dll( int i )
{
	//    return( MyMaracasData._experiment->GetSliceImage( i ) );
	return( NULL );

}

// ----------------------------------------------------------------------------
void PrepareQuantification_dll( int i )
{
	/*
	  MyMaracasData._experiment->SetAxis( i );
	  MyMaracasData._experiment->PrepareQuantification( );
	*/
}

// ----------------------------------------------------------------------------
double GetAxisLength_dll( )
{
    return( MyMaracasData._experiment->getAxis( )->length( ) );

}

// ----------------------------------------------------------------------------
void GetImageRange_dll( int* min, int* max )
{
    double m, M;

    MyMaracasData._experiment->getDynData( )->getVolume( )->getMinMax( m, M );
    *min = ( int )m;
    *max = ( int )M;

}

// ----------------------------------------------------------------------------
vtkImageData* GetVTKVolume_dll( )
{
    return( MyMaracasData._experiment->getDynData( )->getVolume( )->castVtk( ) );

}

// ----------------------------------------------------------------------------
int IntersectWithLine_dll(
						  vtkCellLocator* iCellLocator,
						  double x1, double y1, double z1, 
						  double x2, double y2, double z2,
						  double tol, double *xI, double *yI, double *zI
						  )
{
    float a0[ 3 ], a1[ 3 ], x[ 3 ], t, pcoords[ 3 ];
    int subId; 

    int returnVal;
 
    iCellLocator->Update( );

    a0[ 0 ] = x1; a0[ 1 ] = y1; a0[ 2 ] = z1;
    a1[ 0 ] = x2; a1[ 1 ] = y2; a1[ 2 ] = z2;

    returnVal = iCellLocator->IntersectWithLine( a0, a1, tol, t, x, pcoords, subId );
    ( *xI ) = x[ 0 ]; ( *yI ) = x[ 1 ]; ( *zI ) = x[ 2 ];

    return( returnVal );
}

// ----------------------------------------------------------------------------
void TclPerpendiculars_dll(
						   double xN, double yN, double zN, double angle,
						   double *xP1, double *yP1, double *zP1,
						   double *xP2, double *yP2, double *zP2
						   )
{
    double x[ 3 ], y[ 3 ], z[ 3 ];
    vtkMath* math;

    x[ 0 ] = xN; x[ 1 ] = yN; x[ 2 ] = zN;
    math = vtkMath::New( );
    math->Perpendiculars( x, y, z,angle );
    ( *xP1 ) = y[ 0 ]; ( *yP1 ) = y[ 1 ]; ( *zP1 ) = y[ 2 ];
    ( *xP2 ) = z[ 0 ]; ( *yP2 ) = z[ 1 ]; ( *zP2 ) = z[ 2 ];
    math->Delete( );
}

#endif // MAR__INTERFACE__TCL__HXX

// EOF - interfaceTCL.hxx
