
proc BindTkRenderWidget {widget} {
    bind $widget <Any-ButtonPress> {StartMotionOrWindowLevelInteraction %W %x %y}
    bind $widget <Any-ButtonRelease> {EndMotionOrWindowLevelInteraction %W %x %y}
    bind $widget <B1-Motion> {PanOrRotate %W %x %y}
    bind $widget <B2-Motion> {ZoomOrWinLevel %W %x %y}
    bind $widget <B3-Motion> {ZoomOrWinLevel %W %x %y}
    bind $widget <KeyPress-r> {Reset %W %x %y}
    bind $widget <KeyPress-u> {wm deiconify .vtkInteract}
#    bind $widget <Enter> {Enter %W %x %y}
#    bind $widget <Leave> {focus $oldFocus}
    bind $widget <Expose> {Expose %W}
}

proc BindTkRenderWidget2D {widget} {
    bind $widget <Any-ButtonPress> {StartMotionOrWindowLevelInteraction %W %x %y}
    bind $widget <Any-ButtonRelease> {EndMotionOrWindowLevelInteraction %W %x %y}
    bind $widget <B1-Motion> {PanOrRedim %W %x %y}
    bind $widget <B2-Motion> {ZoomOrWinLevel %W %x %y}
    bind $widget <B3-Motion> {ZoomOrWinLevel %W %x %y}
    bind $widget <KeyPress-r> {Reset %W %x %y}
    bind $widget <KeyPress-u> {wm deiconify .vtkInteract}
#    bind $widget <Enter> {Enter %W %x %y}
#    bind $widget <Leave> {focus $oldFocus}
    bind $widget <Expose> {Expose %W}
}

# Global variable keeps track of whether active renderer was found
set RendererFound 0

# a litle more complex than just "bind $widget <Expose> {%W Render}"
# we have to handle all pending expose events otherwise they que up.
proc Expose {widget} {
   if {[GetWidgetVariableValue $widget InExpose] == 1} {
      return
   }
   SetWidgetVariableValue $widget InExpose 1
   update
   [$widget GetRenderWindow] Render
   SetWidgetVariableValue $widget InExpose 0
}

# Create event bindings
#
proc Render {} {
    global CurrentCamera CurrentLight CurrentRenderWindow

    eval $CurrentLight SetPosition [$CurrentCamera GetPosition]
    eval $CurrentLight SetFocalPoint [$CurrentCamera GetFocalPoint]

    $CurrentRenderWindow Render
}

proc UpdateRenderer {widget x y} {
    global CurrentCamera CurrentLight 
    global CurrentRenderWindow CurrentRenderer
    global RendererFound LastX LastY
    global WindowCenterX WindowCenterY

    # Get the renderer window dimensions
    set WindowX [lindex [$widget configure -width] 4]
    set WindowY [lindex [$widget configure -height] 4]

    # Find which renderer event has occurred in
    set CurrentRenderWindow [$widget GetRenderWindow]
    set renderers [$CurrentRenderWindow GetRenderers]
    set numRenderers [$renderers GetNumberOfItems]

    $renderers InitTraversal; set RendererFound 0
    for {set i 0} {$i < $numRenderers} {incr i} {
	set CurrentRenderer [$renderers GetNextItem]
	set vx [expr double($x) / $WindowX]
	set vy [expr ($WindowY - double($y)) / $WindowY]
	set viewport [$CurrentRenderer GetViewport]
	set vpxmin [lindex $viewport 0]
	set vpymin [lindex $viewport 1]
	set vpxmax [lindex $viewport 2]
	set vpymax [lindex $viewport 3]
	if { $vx >= $vpxmin && $vx <= $vpxmax && \
	$vy >= $vpymin && $vy <= $vpymax} {
	    set RendererFound 1
	    set WindowCenterX [expr double($WindowX)*(($vpxmax - $vpxmin)/2.0\
				+ $vpxmin)]
	    set WindowCenterY [expr double($WindowY)*(($vpymax - $vpymin)/2.0\
				+ $vpymin)]
	    break
	}
    }
    
    set CurrentCamera [$CurrentRenderer GetActiveCamera]
    set lights [$CurrentRenderer GetLights]
    $lights InitTraversal; set CurrentLight [$lights GetNextItem]

    set LastX $x
    set LastY $y
}

proc Enter {widget x y} {
    global oldFocus

    set oldFocus [focus]
    focus $widget
    UpdateRenderer $widget $x $y
}

proc StartMotionOrWindowLevelInteraction {widget x y} {
    global CurrentCamera CurrentLight 
    global CurrentRenderWindow CurrentRenderer
    global LastX LastY
    global RendererFound
    global vFnMPR

  UpdateRenderer $widget $x $y
  if { ! $RendererFound } { return }

  if { 1 == 1} {

    $CurrentRenderWindow SetDesiredUpdateRate 3.0
  } elseif {$vFnMPR(winlevel) == 1} {
    puts "Modificar WindowLevel"
    # save the starting mouse position and the corresponding window/level
    SetWidgetVariableValue $widget X $x
    SetWidgetVariableValue $widget Y $y
    SetWidgetVariableValue $widget Window [vtkFnMPR(ColorLookupTable) GetWindow]
    SetWidgetVariableValue $widget Level  [vtkFnMPR(ColorLookupTable) GetLevel]
    UpdateWindowLevelInteraction $widget $x $y
  }
}

proc EndMotionOrWindowLevelInteraction {widget x y} {
    global CurrentRenderWindow
    global RendererFound
    global vFnMPR

    if { ! $RendererFound } {return}

    if {$vFnMPR(zoom) == 1} {
      $CurrentRenderWindow SetDesiredUpdateRate 0.01
      Render
  } elseif {$vFnMPR(winlevel) == 1} {
      $CurrentRenderWindow SetDesiredUpdateRate 0.01
      Render
  }
}

proc PanOrRotate {widget x y} {
    global LastX LastY
    global RendererFound
    global CurrentRenderer CurrentCamera
    global WindowCenterX WindowCenterY LastX LastY
    global vFnMPR

  if { ! $RendererFound } { return }

  if {$vFnMPR(rotate) == 1} {
    $CurrentCamera Azimuth [expr (($LastX - $x)/3.0)]
    $CurrentCamera Elevation [expr (($y - $LastY)/3.0)]
    $CurrentCamera OrthogonalizeViewUp

    set LastX $x
    set LastY $y

    Render
  } elseif {$vFnMPR(pan) == 1} {

    if { ! $RendererFound } { return }

    set FPoint [$CurrentCamera GetFocalPoint]
	set FPoint0 [lindex $FPoint 0]
	set FPoint1 [lindex $FPoint 1]
	set FPoint2 [lindex $FPoint 2]

    set PPoint [$CurrentCamera GetPosition]
	set PPoint0 [lindex $PPoint 0]
	set PPoint1 [lindex $PPoint 1]
	set PPoint2 [lindex $PPoint 2]

    $CurrentRenderer SetWorldPoint $FPoint0 $FPoint1 $FPoint2 1.0
    $CurrentRenderer WorldToDisplay
    set DPoint [$CurrentRenderer GetDisplayPoint]
    set focalDepth [lindex $DPoint 2]

    set APoint0 [expr $WindowCenterX + ($x - $LastX)]
    set APoint1 [expr $WindowCenterY - ($y - $LastY)]

    $CurrentRenderer SetDisplayPoint $APoint0 $APoint1 $focalDepth
    $CurrentRenderer DisplayToWorld
    set RPoint [$CurrentRenderer GetWorldPoint]
	set RPoint0 [lindex $RPoint 0]
	set RPoint1 [lindex $RPoint 1]
	set RPoint2 [lindex $RPoint 2]
	set RPoint3 [lindex $RPoint 3]
    if { $RPoint3 != 0.0 } {
	set RPoint0 [expr $RPoint0 / $RPoint3]
	set RPoint1 [expr $RPoint1 / $RPoint3]
	set RPoint2 [expr $RPoint2 / $RPoint3]
    }

    $CurrentCamera SetFocalPoint \
      [expr ($FPoint0 - $RPoint0)/2.0 + $FPoint0] \
      [expr ($FPoint1 - $RPoint1)/2.0 + $FPoint1] \
      [expr ($FPoint2 - $RPoint2)/2.0 + $FPoint2]

    $CurrentCamera SetPosition \
      [expr ($FPoint0 - $RPoint0)/2.0 + $PPoint0] \
      [expr ($FPoint1 - $RPoint1)/2.0 + $PPoint1] \
      [expr ($FPoint2 - $RPoint2)/2.0 + $PPoint2]

    set LastX $x
    set LastY $y

    Render
  }
}

proc PanOrRedim {widget x y} {
    global LastX LastY
    global RendererFound
    global CurrentRenderer CurrentCamera
    global WindowCenterX WindowCenterY LastX LastY
    global vFnMPR

    if { ! $RendererFound } { return }

    set FPoint [$CurrentCamera GetFocalPoint]
	set FPoint0 [lindex $FPoint 0]
	set FPoint1 [lindex $FPoint 1]
	set FPoint2 [lindex $FPoint 2]

    set PPoint [$CurrentCamera GetPosition]
	set PPoint0 [lindex $PPoint 0]
	set PPoint1 [lindex $PPoint 1]
	set PPoint2 [lindex $PPoint 2]

    $CurrentRenderer SetWorldPoint $FPoint0 $FPoint1 $FPoint2 1.0
    $CurrentRenderer WorldToDisplay
    set DPoint [$CurrentRenderer GetDisplayPoint]
    set focalDepth [lindex $DPoint 2]

    set APoint0 [expr $WindowCenterX + ($x - $LastX)]
    set APoint1 [expr $WindowCenterY - ($y - $LastY)]

    $CurrentRenderer SetDisplayPoint $APoint0 $APoint1 $focalDepth
    $CurrentRenderer DisplayToWorld
    set RPoint [$CurrentRenderer GetWorldPoint]
	set RPoint0 [lindex $RPoint 0]
	set RPoint1 [lindex $RPoint 1]
	set RPoint2 [lindex $RPoint 2]
	set RPoint3 [lindex $RPoint 3]
    if { $RPoint3 != 0.0 } {
	set RPoint0 [expr $RPoint0 / $RPoint3]
	set RPoint1 [expr $RPoint1 / $RPoint3]
	set RPoint2 [expr $RPoint2 / $RPoint3]
    }

    $CurrentCamera SetFocalPoint \
      [expr ($FPoint0 - $RPoint0)/2.0 + $FPoint0] \
      [expr ($FPoint1 - $RPoint1)/2.0 + $FPoint1] \
      [expr ($FPoint2 - $RPoint2)/2.0 + $FPoint2]

    $CurrentCamera SetPosition \
      [expr ($FPoint0 - $RPoint0)/2.0 + $PPoint0] \
      [expr ($FPoint1 - $RPoint1)/2.0 + $PPoint1] \
      [expr ($FPoint2 - $RPoint2)/2.0 + $PPoint2]

    set LastX $x
    set LastY $y

    Render
}


proc ZoomOrWinLevel {widget x y} {
    global CurrentCamera
    global LastX LastY
    global RendererFound
    global vFnMPR

  if { ! $RendererFound } { return }

  if {$vFnMPR(zoom) == 1} {
    set zoomFactor [expr pow(1.01,($y - $LastY))]
    set clippingRange [$CurrentCamera GetClippingRange]
    set minRange [lindex $clippingRange 0]
    set maxRange [lindex $clippingRange 1]
    $CurrentCamera SetClippingRange [expr $minRange / $zoomFactor] \
				    [expr $maxRange / $zoomFactor]
    $CurrentCamera Dolly $zoomFactor

    set LastX $x
    set LastY $y

    Render
  } elseif {$vFnMPR(winlevel) == 1} {
      UpdateWindowLevelInteraction $widget $x $y
  }
}

proc Reset {widget x y} {
    global CurrentRenderWindow
    global RendererFound
    global CurrentRenderer
    global vFnMPR

    # Get the renderer window dimensions
    set WindowX [lindex [$widget configure -width] 4]
    set WindowY [lindex [$widget configure -height] 4]

    # Find which renderer event has occurred in
    set CurrentRenderWindow [$widget GetRenderWindow]
    set renderers [$CurrentRenderWindow GetRenderers]
    set numRenderers [$renderers GetNumberOfItems]

    $renderers InitTraversal; set RendererFound 0
    for {set i 0} {$i < $numRenderers} {incr i} {
	set CurrentRenderer [$renderers GetNextItem]
	set vx [expr double($x) / $WindowX]
	set vy [expr ($WindowY - double($y)) / $WindowY]

	set viewport [$CurrentRenderer GetViewport]
	set vpxmin [lindex $viewport 0]
	set vpymin [lindex $viewport 1]
	set vpxmax [lindex $viewport 2]
	set vpymax [lindex $viewport 3]
	if { $vx >= $vpxmin && $vx <= $vpxmax && \
	$vy >= $vpymin && $vy <= $vpymax} {
	    set RendererFound 1
	    break
	}
    }

    if { $RendererFound } {
	[$CurrentRenderer GetActiveCamera] SetPosition 32.5 32.5 1000
	[$CurrentRenderer GetActiveCamera] SetViewUp 0 1 0
	[$CurrentRenderer GetActiveCamera] ComputeViewPlaneNormal
	$CurrentRenderer ResetCamera
    }

    #vtkFnMPR(ColorLookupTable) SetWindow 255
    #vtkFnMPR(ColorLookupTable) SetLevel 128

    vtkFnMPR(ColorLookupTable) SetWindow $vFnMPR(intmax)
    vtkFnMPR(ColorLookupTable) SetLevel [expr $vFnMPR(intmax) / 4]

    Render
}

proc Wireframe {} {
    global CurrentRenderer

    set actors [$CurrentRenderer GetActors]

    $actors InitTraversal
    set actor [$actors GetNextItem]
    while { $actor != "" } {
	[$actor GetProperty] SetRepresentationToWireframe
	set actor [$actors GetNextItem]
    }

    Render
}

proc Surface {} {
    global CurrentRenderer

    set actors [$CurrentRenderer GetActors]

    $actors InitTraversal
    set actor [$actors GetNextItem]
    while { $actor != "" } {
	[$actor GetProperty] SetRepresentationToSurface
	set actor [$actors GetNextItem]
    }

    Render
}


# clicking on the window sets up sliders with current value at mouse,
# and scaled so that the whole window represents x4 change.
proc UpdateWindowLevelInteraction {widget x y} {
   global vFnMPR

   # get the widgets dimensions
   set width [lindex [$widget configure -width] 4]
   set height [lindex [$widget configure -height] 4]

   # get the old window level values
   set window [GetWidgetVariableValue $widget Window]
   set level [GetWidgetVariableValue $widget Level]

   # get starting x, y and window/level values to compute delta
   set start_x [GetWidgetVariableValue $widget X]
   set start_y [GetWidgetVariableValue $widget Y]

   # compute normalized delta
   set dx [expr 4.0 * ($x - $start_x) / $width]
   set dy [expr 4.0 * ($start_y - $y) / $height]

   # scale by current values 
   set dx [expr $dx * $window]
   set dy [expr $dy * $level]

   #puts "   update: ($x, $y), dx = $dx, dy = $dy"

   # abs so that direction does not flip
   if {$window < 0.0} {set dx [expr -$dx]}
   if {$level < 0.0} {set dy [expr -$dy]}

   # compute new window level
   set new_window [expr $dx + $window]
   if {$new_window < 0.0} {
      set new_level [expr $dy + $level]
   } else {
      set new_level [expr $level - $dy]
   }

   # zero window or level can trap the value.
   # put a limit of 1 / 100 value


   # if window is negative, then delta level should flip (down is dark).
   if {$new_window < 0.0} {set dy [expr -$dy]}

   vtkFnMPR(ColorLookupTable) SetWindow $new_window
   vtkFnMPR(ColorLookupTable) SetLevel $new_level

   .frText.t insert end "Window : $new_window  -  Level : $new_level\n"

   Render
}
