
namespace eval choose_direction {

    namespace export \
        show

    # variables
    variable base ""

    variable frButtons   .frButtons
    variable frBlueGreen .frBlueGreen

    variable btnCancel .frButtons.btnCancel
    variable btnOK     .frButtons.btnOk

    variable question .frBlueGreen.question

    variable btnGreenRed .frBlueGreen.btnGreenRed
    variable btnRedBlue  .frBlueGreen.btnRedBlue

    variable direction -1

    variable im1 ""
    variable im2 ""

}

proc choose_direction::reset_values { } {

    # For programming facilities
    upvar choose_direction::base        base
    upvar choose_direction::frButtons   frButtons
    upvar choose_direction::frBlueGreen frBlueGreen
    upvar choose_direction::btnCancel   btnCancel
    upvar choose_direction::btnOK       btnOk
    upvar choose_direction::question    question
    upvar choose_direction::btnGreenRed btnGreenRed
    upvar choose_direction::btnRedBlue  btnRedBlue
    upvar choose_direction::direction   direction
    upvar choose_direction::im1         im1
    upvar choose_direction::im2         im2

    set base        ""
    set frButtons   ".frButtons"
    set frBlueGreen ".frBlueGreen"
    set btnCancel   ".frButtons.btnCancel"
    set btnOK       ".frButtons.btnOk"
    set question    ".frBlueGreen.question"
    set btnGreenRed ".frBlueGreen.btnGreenRed"
    set btnRedBlue  ".frBlueGreen.btnRedBlue"
    set direction   0

    set im1 $global_window::im1
    set im2 $global_window::im2

}

proc choose_direction::show { parent } {

    # For programming facilities
    upvar choose_direction::base        base
    upvar choose_direction::frButtons   frButtons
    upvar choose_direction::frBlueGreen frBlueGreen
    upvar choose_direction::btnCancel   btnCancel
    upvar choose_direction::btnOK       btnOk
    upvar choose_direction::question    question
    upvar choose_direction::btnGreenRed btnGreenRed
    upvar choose_direction::btnRedBlue  btnRedBlue
    upvar choose_direction::direction   direction
    upvar choose_direction::im1         im1
    upvar choose_direction::im2         im2

    choose_direction::reset_values
    set base        "$parent.choose_direction"
    set frButtons   "$base$frButtons"
    set frBlueGreen "$base$frBlueGreen"
    set btnCancel   "$base$btnCancel"
    set btnOK       "$base$btnOk"
    set question    "$base$question"
    set btnGreenRed "$base$btnGreenRed"
    set btnRedBlue  "$base$btnRedBlue"

    toplevel $base
    wm title $base "$string_table::str_partial_axis_delete"

    frame $frButtons
    frame $frBlueGreen -relief sunken -borderwidth 2 

    button $btnCancel -text $string_table::str_cancel -command "set choose_direction::direction 2; destroy $base"
    button $btnOK     -text $string_table::str_ok     -command "destroy $base"

    label $question -text "$string_table::str_select_the_segment_to_delete"

    radiobutton $btnGreenRed -relief flat -image $im1 -text "$string_table::str_green_red" -variable cut_type -value 1 -command "set choose_direction::direction -1"
    radiobutton $btnRedBlue  -relief flat -image $im2 -text "$string_table::str_red_blue"  -variable cut_type -value 2 -command "set choose_direction::direction 1"

    pack $frButtons        -side bottom -fill x -pady 2m
    pack $btnOK $btnCancel -side left -expand 1 -padx 1c
    pack $frBlueGreen      -side top -pady 1m -padx 2m 
    pack $question         -side top -anchor w
    pack $btnGreenRed      -side top -anchor w
    pack $btnRedBlue       -side top -anchor w

    $btnGreenRed deselect
    $btnRedBlue  deselect
    $btnRedBlue  invoke

    # set global focus input to dialog
    grab set $base

    # waits for dialog destruction, i.e. waits for user interaction with dialog
    tkwait window $base

    return $direction

}

# EOF - choose_direction.tcl
