package require BLT
package require mclistbox
catch { namespace import blt::* }
catch { namespace import mclistbox::* }

namespace eval data_browser {

    # public interface
    namespace export \
        sel_study    \
        sel_serie    \
        create       \
        positionate  \
        set_studies  \
        forget
    
    # variables
    variable widgets

    variable sel_study ""
    variable sel_serie ""
    variable local_id

}

proc data_browser::reset { parent } {

    # For programming facilities
    upvar data_browser::widgets widgets

    set widgets(base)      "$parent"
    set widgets(data_brw)  "$parent\.data_browser"
    set widgets(up_brw)    "$parent\.data_browser.01"
    set widgets(down_brw)  "$parent\.data_browser.02"
    set widgets(split)     "$parent\.data_browser.03"
    set widgets(up_view)   "$parent\.data_browser.01.lst"
    set widgets(down_view) "$parent\.data_browser.02.lst"
    set widgets(up_hs)     "$parent\.data_browser.01.hs"
    set widgets(up_vs)     "$parent\.data_browser.01.vs"
    set widgets(down_hs)   "$parent\.data_browser.02.hs"
    set widgets(down_vs)   "$parent\.data_browser.02.vs"

}

proc data_browser::create { parent id } {

    # For programming facilities
    upvar data_browser::widgets widgets
    upvar data_browser::sel_study sel_study
    upvar data_browser::sel_serie sel_serie
    upvar data_browser::local_id  local_id

    set local_id $id
    data_browser::reset $parent

    # frames
    frame $widgets(data_brw) -borderwidth 1 -height 100 -relief groove -width 200 
    frame $widgets(up_brw)   -borderwidth 1 -height 100 -relief groove -width 200 
    frame $widgets(down_brw) -borderwidth 1 -height 100 -relief groove -width 200 
    frame $widgets(split)    -borderwidth 2 -relief raised 

    # multi-column listboxes
    mclistbox $widgets(up_view)                       \
        -borderwidth        1                         \
        -highlightthickness 0                         \
        -relief             groove                    \
        -selectborderwidth  0                         \
        -columnrelief       flat                      \
        -labelanchor        w                         \
        -columnborderwidth  0                         \
        -selectmode         single                    \
        -labelborderwidth   2                         \
        -labelrelief        raised                    \
        -selectcommand      "data_browser::cb_select"
    scrollbar $widgets(up_vs) -command "$widgets(up_view) yview"
    scrollbar $widgets(up_hs) -command "$widgets(up_view) xview" -orient horizontal
    $widgets(up_view) configure -xscrollcommand "$widgets(up_hs) set"
    $widgets(up_view) configure -yscrollcommand "$widgets(up_vs) set"

    mclistbox $widgets(down_view)                           \
        -borderwidth        1                               \
        -highlightthickness 0                               \
        -relief             groove                          \
        -selectborderwidth  0                               \
        -columnrelief       flat                            \
        -labelanchor        w                               \
        -columnborderwidth  0                               \
        -selectmode         extended                        \
        -labelborderwidth   2                               \
        -labelrelief        raised                          \
        -selectcommand      "data_browser::cb_select_serie"
    scrollbar $widgets(down_vs) -command "$widgets(down_view) yview"
    scrollbar $widgets(down_hs) -command "$widgets(down_view) xview" -orient horizontal
    $widgets(down_view) configure -xscrollcommand "$widgets(down_hs) set"
    $widgets(down_view) configure -yscrollcommand "$widgets(down_vs) set"

    bind $widgets(down_view) <Double-Button-1> "global_window::cb_image_browse"

    # split binds
    bind $widgets(split) <B1-Motion> {
        set root [ split %W . ]
        set nb [ llength $root ]
        incr nb -1
        set root [ lreplace $root $nb $nb ]
        set root [ join $root . ]
        set height [ winfo height $root ].0
        set val [ expr (%Y - [winfo rooty $root]) /$height ]
        if { $val >= 0 && $val <= 1.0 } {
            place $root.01 -relheight $val
            place $root.03 -rely $val
            place $root.02 -relheight [ expr 1.0 - $val ]
        }
    }

}

proc data_browser::positionate { } {

    # For programming facilities
    upvar data_browser::widgets  widgets
    upvar data_browser::local_id local_id

    set global_window::window_shown $local_id

    pack  $widgets(data_brw)  -anchor center -expand 1 -fill both -side top 
    place $widgets(up_brw)    -x 0 -y 0 -relwidth 1 -height -1 -relheight 0.5 -anchor nw -bordermode ignore 
    place $widgets(down_brw)  -x 0 -y 0 -rely 1 -relwidth 1 -height -1 -relheight 0.5 -anchor sw -bordermode ignore 
    pack  $widgets(up_view)   -anchor center -expand 1 -fill both -side top 
    pack  $widgets(down_view) -anchor center -expand 1 -fill both -side top 
    place $widgets(split)     -x 0 -relx 0.9 -y 0 -rely 0.5 -width 10 -height 10 -anchor e -bordermode ignore 

    grid  $widgets(up_view)   -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid  $widgets(up_vs)     -row 0 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid  $widgets(up_hs)     -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news

    grid  rowconfig    $widgets(up_brw) 0 -weight 1 -minsize 0
    grid  columnconfig $widgets(up_brw) 0 -weight 1 -minsize 0

    grid  $widgets(down_view) -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news
    grid  $widgets(down_vs)   -row 0 -column 1 -rowspan 1 -columnspan 1 -sticky news
    grid  $widgets(down_hs)   -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky news

    grid  rowconfig    $widgets(down_brw) 0 -weight 1 -minsize 0
    grid  columnconfig $widgets(down_brw) 0 -weight 1 -minsize 0

    data_browser::controls 0

}

proc data_browser::forget { } {

    # For programming facilities
    upvar data_browser::widgets  widgets

    grid  forget $widgets(down_hs)
    grid  forget $widgets(down_vs)
    grid  forget $widgets(down_view)
    grid  forget $widgets(up_hs)
    grid  forget $widgets(up_vs)
    grid  forget $widgets(up_view)
    place forget $widgets(split)
    pack  forget $widgets(down_view)
    pack  forget $widgets(up_view)
    place forget $widgets(down_brw)
    place forget $widgets(up_brw)
    pack  forget $widgets(data_brw)

}

proc data_browser::clean_list { } {

    # For programming facilities
    upvar data_browser::widgets   widgets
    upvar data_browser::sel_study sel_study
    upvar data_browser::sel_serie sel_serie

    catch { $widgets(up_view) column delete c08 }
    catch { $widgets(up_view) column delete c07 }
    catch { $widgets(up_view) column delete c06 }
    catch { $widgets(up_view) column delete c05 }
    catch { $widgets(up_view) column delete c04 }
    catch { $widgets(up_view) column delete c03 }
    catch { $widgets(up_view) column delete c02 }
    catch { $widgets(up_view) column delete c01 }
    catch { $widgets(up_view) column delete c00 }

    catch { $widgets(down_view) column delete c08 }
    catch { $widgets(down_view) column delete c07 }
    catch { $widgets(down_view) column delete c06 }
    catch { $widgets(down_view) column delete c05 }
    catch { $widgets(down_view) column delete c04 }
    catch { $widgets(down_view) column delete c03 }
    catch { $widgets(down_view) column delete c02 }
    catch { $widgets(down_view) column delete c01 }
    catch { $widgets(down_view) column delete c00 }

}

proc data_browser::set_data { } {

    # For programming facilities
    upvar data_browser::widgets   widgets
    upvar data_browser::sel_study sel_study
    upvar data_browser::sel_serie sel_serie
    upvar data_browser::local_id  local_id

    data_browser::clean_list
    $widgets(down_view) column add c00 -label "$string_table::str_serie_name"        -width 20
    $widgets(down_view) column add c01 -label "$string_table::str_serie_number"      -width 10
    $widgets(down_view) column add c02 -label "$string_table::str_serie_date"        -width 15
    $widgets(down_view) column add c03 -label "$string_table::str_serie_time"        -width 10
    $widgets(down_view) column add c04 -label "$string_table::str_serie_modality"    -width 10
    $widgets(down_view) column add c05 -label "$string_table::str_serie_bodypart"    -width 10
    $widgets(down_view) column add c06 -label "$string_table::str_serie_description" -width 100
    $widgets(down_view) column add c07 -label "$string_table::str_serie_diagnostic"  -width 100
    $widgets(up_view)   column add c00 -label "$string_table::str_patient_name"      -width 20
    $widgets(up_view)   column add c01 -label "$string_table::str_patient_id"        -width 10
    $widgets(up_view)   column add c02 -label "$string_table::str_study_name"        -width 15
    $widgets(up_view)   column add c03 -label "$string_table::str_study_id"          -width 10
    $widgets(up_view)   column add c04 -label "$string_table::str_study_date"        -width 10
    $widgets(up_view)   column add c05 -label "$string_table::str_study_time"        -width 10
    $widgets(up_view)   column add c06 -label "$string_table::str_institution"       -width 20
    $widgets(up_view)   column add c07 -label "$string_table::str_description"       -width 200

    $widgets(up_view) label bind c00 <ButtonPress-1> "data_browser::sort_mclst $widgets(up_view) c00"
    $widgets(up_view) label bind c01 <ButtonPress-1> "data_browser::sort_mclst $widgets(up_view) c01"
    $widgets(up_view) label bind c02 <ButtonPress-1> "data_browser::sort_mclst $widgets(up_view) c02"
    $widgets(up_view) label bind c03 <ButtonPress-1> "data_browser::sort_mclst $widgets(up_view) c03"
    $widgets(up_view) label bind c04 <ButtonPress-1> "data_browser::sort_mclst $widgets(up_view) c04"
    $widgets(up_view) label bind c05 <ButtonPress-1> "data_browser::sort_mclst $widgets(up_view) c05"
    $widgets(up_view) label bind c06 <ButtonPress-1> "data_browser::sort_mclst $widgets(up_view) c06"
    $widgets(up_view) label bind c07 <ButtonPress-1> "data_browser::sort_mclst $widgets(up_view) c07"

    $widgets(down_view) label bind c00 <ButtonPress-1> "data_browser::sort_mclst $widgets(down_view) c00"
    $widgets(down_view) label bind c01 <ButtonPress-1> "data_browser::sort_mclst $widgets(down_view) c01"
    $widgets(down_view) label bind c02 <ButtonPress-1> "data_browser::sort_mclst $widgets(down_view) c02"
    $widgets(down_view) label bind c03 <ButtonPress-1> "data_browser::sort_mclst $widgets(down_view) c03"
    $widgets(down_view) label bind c04 <ButtonPress-1> "data_browser::sort_mclst $widgets(down_view) c04"
    $widgets(down_view) label bind c05 <ButtonPress-1> "data_browser::sort_mclst $widgets(down_view) c05"
    $widgets(down_view) label bind c06 <ButtonPress-1> "data_browser::sort_mclst $widgets(down_view) c06"
    $widgets(down_view) label bind c07 <ButtonPress-1> "data_browser::sort_mclst $widgets(down_view) c07"

    $widgets(up_view) delete 0 end
    set studies [ studies_dll ]
    foreach study $studies { 
    
        array set arr [ studyData_dll $study ]
        $widgets(up_view) insert end [ list  \
            $arr(ID_Patient_Name)            \
            $arr(ID_Patient_ID)              \
            $arr(ID_File_Name)               \
            $arr(ID_Study_ID)                \
            $arr(ID_Study_Date)              \
            $arr(ID_Study_Time)              \
            $arr(ID_Institution_Name)        \
            $arr(ID_Study_Description)       \
        ]

    }

    data_browser::sort_mclst $widgets(up_view) c00
    data_browser::controls 0

}

proc data_browser::cb_select { args } {

    # For programming facilities
    upvar data_browser::widgets   widgets
    upvar data_browser::sel_study sel_study
    upvar data_browser::sel_serie sel_serie

    if { [ string compare $args "" ] != 0 } {

        set sel [ $widgets(up_view) get [ $widgets(up_view) curselection ] ]
        set sel_study [ lindex $sel 2 ]
        set series [ series_dll $sel_study ]
        $widgets(down_view) delete 0 end
        foreach serie $series {
        
            array set arr [ serieData_dll $sel_study $serie ]
            $widgets(down_view) insert end [ list        \
                $arr(ID_File_Name)                       \
                $arr(ID_Series_Number)                   \
                $arr(ID_Series_Date)                     \
                $arr(ID_Series_Time)                     \
                $arr(ID_Modality)                        \
                $arr(ID_Body_Part_Examined)              \
                $arr(ID_Series_Description)              \
                $arr(ID_Admitting_Diagnoses_Description) \
            ]

        }

        data_browser::controls 0
    
    }


}

proc data_browser::sort_mclst { lst id } {

    # For programming facilities
    upvar data_browser::widgets   widgets
    upvar data_browser::sel_study sel_study
    upvar data_browser::sel_serie sel_serie

    set data   [ $lst get 0 end ]
    set index  [ lsearch -exact [ $lst column names ] $id ]
    set result [ lsort -index $index $data ]
    $lst delete 0 end
    eval $lst insert end $result

}


proc data_browser::cb_select_serie { args } {

    # For programming facilities
    upvar data_browser::widgets   widgets
    upvar data_browser::sel_study sel_study
    upvar data_browser::sel_serie sel_serie

    if { [ string compare $args "" ] != 0 } {

        set sel [ $widgets(down_view) curselection ]
        if { [ llength $sel ] == 1 } {

            set sel_serie [ lindex [ $widgets(down_view) get $sel ] 0 ]
            set data [ serieData_dll $sel_study $sel_serie ]
            data_browser::controls 1

        } elseif { [ llength $sel ] == 2 } {

            data_browser::controls 2

        } else {

            data_browser::controls 0

        }

    }

}

proc data_browser::get_subdata { } {

    # For programming facilities
    upvar data_browser::widgets   widgets
    upvar data_browser::sel_study sel_study
    upvar data_browser::sel_serie sel_serie

    set sel [ $widgets(down_view) curselection ]
    set sel_data [ $widgets(down_view) get $sel ]
    if { [ llength $sel ] == 2 } {

        return [ list [ lindex [ lindex $sel_data 0 ] 0 ] [ lindex [ lindex $sel_data 1 ] 0 ] ]

    }
    return ""


}

proc data_browser::controls { { id -1 } } {
        
    if { $id == -1 } {

        global_window::active_controls 0

    } else {
    
        if { $id == 0 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_params    | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                0
            ]

        } elseif { $id == 1 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_ibrw      | \
                $global_window::en_params    | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                0
            ]

        } elseif { $id == 2 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_subtract  | \
                $global_window::en_params    | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                0
            ]

        }

    }

}

# EOF - data_browser.tcl
