
namespace eval dlg_name_axis {

    # public interface
    namespace export \
        show

    # variables
    variable widgets

    variable name

}

proc dlg_name_axis::reset { parent } {

    # For programming facilities
    upvar dlg_name_axis::widgets widgets

    set widgets(base)      "$parent\.dlg_name_axis"
    set widgets(lbl001)    "$parent\.dlg_name_axis.lbl001"
    set widgets(frame)     "$parent\.dlg_name_axis.frame"
    set widgets(lbl002)    "$parent\.dlg_name_axis.frame.lbl002"
    set widgets(edtName)   "$parent\.dlg_name_axis.frame.name"
    set widgets(btnOk)     "$parent\.dlg_name_axis.btnOk"
    set widgets(btnCancel) "$parent\.dlg_name_axis.btnCancel"

}

proc dlg_name_axis::show { parent } {

    # For programming facilities
    upvar dlg_name_axis::widgets widgets
    upvar dlg_name_axis::name    name

    dlg_name_axis::reset $parent
    set name "<no name>"

    toplevel            $widgets(base) -class Toplevel
    wm focusmodel       $widgets(base) passive
    wm geometry         $widgets(base) 321x151+95+255
    wm maxsize          $widgets(base) 1030 755
    wm minsize          $widgets(base) 106 2
    wm overrideredirect $widgets(base) 0
    wm resizable        $widgets(base) 0 0
    wm title            $widgets(base) "$string_table::str_choose_a_name"

    frame $widgets(frame) -height 30 -width 30 

    label $widgets(lbl001) -borderwidth 0           -text $string_table::str_no_name_choose_yet 
    label $widgets(lbl002) -anchor w -borderwidth 0 -text $string_table::str_new_axis_name 

    entry $widgets(edtName) -textvariable dlg_name_axis::name

    button $widgets(btnOk)     -default active -text $string_table::str_ok     -command "destroy $widgets(base)"
    button $widgets(btnCancel)                 -text $string_table::str_cancel -command "set dlg_name_axis::name \"\"; destroy $widgets(base)"

    bind $widgets(btnOk) <Key-Return> "$widgets(btnOk) invoke"
    bind $widgets(edtName) <Key-Return> "$widgets(btnOk) invoke"

    place $widgets(lbl001)    -x 30 -y 30 -anchor nw -bordermode ignore 
    place $widgets(frame)     -x 30 -y 60 -width 245 -height 25 -anchor nw -bordermode ignore 
    pack  $widgets(lbl002)    -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgets(edtName)   -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgets(btnOk)     -x 75 -y 100 -anchor nw -bordermode ignore 
    place $widgets(btnCancel) -x 160 -y 100 -anchor nw -bordermode ignore 

    focus $widgets(edtName)
    $widgets(edtName) selection range 0 end

    $widgets(btnOk) flash

    # set global focus input to dialog
    grab set $widgets(base)

    # waits for dialog destruction, i.e. waits for user interaction with dialog
    tkwait window $widgets(base)

    return $dlg_name_axis::name

}

# EOF - dlg_name_axis.tcl
