namespace eval dlg_params {

    # public interface
    namespace export \
        show

    # variables
    variable widgets
    variable widgetsGeneral
    variable widgetsAxes
    variable widgetsContours
    variable widgetsQuantification

    # values to load
    variable gen_debug      0
    variable con_debug      0
    variable quant_type     0
    variable stenosis_type  0
    variable alg_type       0
    variable voxel_typ      0
    variable params_to_save {}

}

proc dlg_params::reset { parent } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set widgets(base)           "$parent\.dlg_params"
    set widgets(tabs)           "$parent\.dlg_params.tabs"
    set widgets(buttons)        "$parent\.dlg_params.buttons"
    set widgets(general)        "$parent\.dlg_params.general"
    set widgets(axis)           "$parent\.dlg_params.axis"
    set widgets(contour)        "$parent\.dlg_params.contour"
    set widgets(quantification) "$parent\.dlg_params.quantification"
    set widgets(btnGeneral)     "$parent\.dlg_params.tabs.btnGeneral"
    set widgets(btnAxis)        "$parent\.dlg_params.tabs.btnAxis"
    set widgets(btnContour)     "$parent\.dlg_params.tabs.btnContour"
    set widgets(btnQuant)       "$parent\.dlg_params.tabs.btnQuant"
    set widgets(btnOk)          "$parent\.dlg_params.buttons.btnOk"
    set widgets(btnCancel)      "$parent\.dlg_params.buttons.btnCancel"

    set widgetsGeneral(genDataPaths)    "$parent\.dlg_params.general.dataPaths"
    set widgetsGeneral(genWork)         "$parent\.dlg_params.general.dataPaths.cpd24"
    set widgetsGeneral(genWork01)       "$parent\.dlg_params.general.dataPaths.cpd24.01"
    set widgetsGeneral(genWork02)       "$parent\.dlg_params.general.dataPaths.cpd24.02"
    set widgetsGeneral(genImages)       "$parent\.dlg_params.general.dataPaths.cpd25"
    set widgetsGeneral(genImages01)     "$parent\.dlg_params.general.dataPaths.cpd25.01"
    set widgetsGeneral(genImages02)     "$parent\.dlg_params.general.dataPaths.cpd25.02"
    set widgetsGeneral(genBtnBrwWork)   "$parent\.dlg_params.general.dataPaths.btnBrwWork"
    set widgetsGeneral(genBtnBrwImages) "$parent\.dlg_params.general.dataPaths.btnBrwImages"
    set widgetsGeneral(genDebug)        "$parent\.dlg_params.general.debug"
    set widgetsGeneral(genBtnWndVis)    "$parent\.dlg_params.general.debug.btnWndVis"
    set widgetsGeneral(genBtnConVis)    "$parent\.dlg_params.general.debug.btnConVis"
    set widgetsGeneral(genBtnMIPDef)    "$parent\.dlg_params.general.debug.btnMIPDef"
    set widgetsGeneral(genBtnAllSlc)    "$parent\.dlg_params.general.debug.btnAllSlc"
    set widgetsGeneral(genBtnColor)     "$parent\.dlg_params.general.debug.btnColor"
    set widgetsGeneral(genlbl009)       "$parent\.dlg_params.general.debug.lbl009"
    set widgetsGeneral(genlbl001)       "$parent\.dlg_params.general.lbl001"
    set widgetsGeneral(genlbl078)       "$parent\.dlg_params.general.lbl078"

    set widgetsAxes(axVoxelX)        "$parent\.dlg_params.axis.cpd26"
    set widgetsAxes(axVoxelX01)      "$parent\.dlg_params.axis.cpd26.01"
    set widgetsAxes(axVoxelX02)      "$parent\.dlg_params.axis.cpd26.02"
    set widgetsAxes(axVoxelY)        "$parent\.dlg_params.axis.cpd28"
    set widgetsAxes(axVoxelY01)      "$parent\.dlg_params.axis.cpd28.01"
    set widgetsAxes(axVoxelY02)      "$parent\.dlg_params.axis.cpd28.02"
    set widgetsAxes(axVoxelZ)        "$parent\.dlg_params.axis.cpd29"
    set widgetsAxes(axVoxelZ01)      "$parent\.dlg_params.axis.cpd29.01"
    set widgetsAxes(axVoxelZ02)      "$parent\.dlg_params.axis.cpd29.02"
    set widgetsAxes(axStep)          "$parent\.dlg_params.axis.cpd30"
    set widgetsAxes(axStep01)        "$parent\.dlg_params.axis.cpd30.01"
    set widgetsAxes(axStep02)        "$parent\.dlg_params.axis.cpd30.02"
    set widgetsAxes(axAxisStep)      "$parent\.dlg_params.axis.cpd31"
    set widgetsAxes(axAxisStep01)    "$parent\.dlg_params.axis.cpd31.01"
    set widgetsAxes(axAxisStep02)    "$parent\.dlg_params.axis.cpd31.02"
    set widgetsAxes(axROIDim)        "$parent\.dlg_params.axis.cpd32"
    set widgetsAxes(axROIDim01)      "$parent\.dlg_params.axis.cpd32.01"
    set widgetsAxes(axROIDim02)      "$parent\.dlg_params.axis.cpd32.02"
    set widgetsAxes(axMassPower)     "$parent\.dlg_params.axis.cpd33"
    set widgetsAxes(axMassPower01)   "$parent\.dlg_params.axis.cpd33.01"
    set widgetsAxes(axMassPower02)   "$parent\.dlg_params.axis.cpd33.02"
    set widgetsAxes(axTension)       "$parent\.dlg_params.axis.cpd34"
    set widgetsAxes(axTension01)     "$parent\.dlg_params.axis.cpd34.01"
    set widgetsAxes(axTension02)     "$parent\.dlg_params.axis.cpd34.02"
    set widgetsAxes(axPas)           "$parent\.dlg_params.axis.cpd35"
    set widgetsAxes(axPas01)         "$parent\.dlg_params.axis.cpd35.01"
    set widgetsAxes(axPas02)         "$parent\.dlg_params.axis.cpd35.02"
    set widgetsAxes(axDistCDG)       "$parent\.dlg_params.axis.cpd36"
    set widgetsAxes(axDistCDG01)     "$parent\.dlg_params.axis.cpd36.01"
    set widgetsAxes(axDistCDG02)     "$parent\.dlg_params.axis.cpd36.02"
    set widgetsAxes(axCell)          "$parent\.dlg_params.axis.cpd37"
    set widgetsAxes(axCell01)        "$parent\.dlg_params.axis.cpd37.01"
    set widgetsAxes(axCell02)        "$parent\.dlg_params.axis.cpd37.02"
    set widgetsAxes(axFlex)          "$parent\.dlg_params.axis.cpd38"
    set widgetsAxes(axFlex01)        "$parent\.dlg_params.axis.cpd38.01"
    set widgetsAxes(axFlex02)        "$parent\.dlg_params.axis.cpd38.02"
    set widgetsAxes(axMaskSize)      "$parent\.dlg_params.axis.cpd39"
    set widgetsAxes(axMaskSize01)    "$parent\.dlg_params.axis.cpd39.01"
    set widgetsAxes(axMaskSize02)    "$parent\.dlg_params.axis.cpd39.02"
    set widgetsAxes(axDistInt)       "$parent\.dlg_params.axis.cpd40"
    set widgetsAxes(axDistInt01)     "$parent\.dlg_params.axis.cpd40.01"
    set widgetsAxes(axDistInt02)     "$parent\.dlg_params.axis.cpd40.02"
    set widgetsAxes(axCoefCellMax)   "$parent\.dlg_params.axis.axCoefCellMax"
    set widgetsAxes(axCoefCellMax01) "$parent\.dlg_params.axis.axCoefCellMax.01"
    set widgetsAxes(axCoefCellMax02) "$parent\.dlg_params.axis.axCoefCellMax.02"
    set widgetsAxes(axBtnMinVoxel)   "$parent\.dlg_params.axis.btnMinVoxel"
    set widgetsAxes(axBtnNorVoxel)   "$parent\.dlg_params.axis.btnNorVoxel"
    set widgetsAxes(axlblColor)      "$parent\.dlg_params.axis.lblColor"
    set widgetsAxes(axBtnColor)      "$parent\.dlg_params.axis.btnColor"
    set widgetsAxes(axLblDebug)      "$parent\.dlg_params.axis.lblDebug"
    set widgetsAxes(axFrDebug)       "$parent\.dlg_params.axis.frDebug"
    set widgetsAxes(axBtnShowCell)   "$parent\.dlg_params.axis.frDebug.btnShowCell"
    set widgetsAxes(axBtnShowICell)  "$parent\.dlg_params.axis.frDebug.btnShowICell"

    set widgetsContours(conFrSlice)               "$parent\.dlg_params.contour.frSlice"
    set widgetsContours(conFrScale)               "$parent\.dlg_params.contour.frSlice.frScale"
    set widgetsContours(conLblScale)              "$parent\.dlg_params.contour.frSlice.frScale.lblScale"
    set widgetsContours(conEdtScale)              "$parent\.dlg_params.contour.frSlice.frScale.edtScale"
    set widgetsContours(conFrSample)              "$parent\.dlg_params.contour.frSlice.frSample"
    set widgetsContours(conLblSample)             "$parent\.dlg_params.contour.frSlice.frSample.lblSample"
    set widgetsContours(conEdtSample)             "$parent\.dlg_params.contour.frSlice.frSample.edtSample"
    set widgetsContours(conFrDebug)               "$parent\.dlg_params.contour.frDebug"
    set widgetsContours(conBtnIsoconturs)         "$parent\.dlg_params.contour.frDebug.btnIsoconturs"
    set widgetsContours(conBtnDiameters)          "$parent\.dlg_params.contour.frDebug.btnDiameters"
    set widgetsContours(conBtnFillContours)       "$parent\.dlg_params.contour.frDebug.btnFillContours"
    set widgetsContours(conFrIso)                 "$parent\.dlg_params.contour.frIso"
    set widgetsContours(conFrThrIso)              "$parent\.dlg_params.contour.frIso.frThrIso"
    set widgetsContours(conLblThrIso)             "$parent\.dlg_params.contour.frIso.frThrIso.lblThrIso"
    set widgetsContours(conEdtThrIso)             "$parent\.dlg_params.contour.frIso.frThrIso.edtThrIso"
    set widgetsContours(conFrSnakeIso)            "$parent\.dlg_params.contour.frSnakeIso"
    set widgetsContours(conFrThrSnakeIso)         "$parent\.dlg_params.contour.frSnakeIso.frThrSnakeIso"
    set widgetsContours(conLblThrSnakeIso)        "$parent\.dlg_params.contour.frSnakeIso.frThrSnakeIso.lblThrSnakeIso"
    set widgetsContours(conEdtThrSnakeIso)        "$parent\.dlg_params.contour.frSnakeIso.frThrSnakeIso.edtThrSnakeIso"
    set widgetsContours(conFrIterSnakeIso)        "$parent\.dlg_params.contour.frSnakeIso.frIterSnakeIso"
    set widgetsContours(conLblIterSnakeIso)       "$parent\.dlg_params.contour.frSnakeIso.frIterSnakeIso.lblIterSnakeIso"
    set widgetsContours(conEdtIterSnakeIso)       "$parent\.dlg_params.contour.frSnakeIso.frIterSnakeIso.edtIterSnakeIso"
    set widgetsContours(conFrCoefExternSnakeIso)  "$parent\.dlg_params.contour.frSnakeIso.frCoefExternSnakeIso"
    set widgetsContours(conLblCoefExternSnakeIso) "$parent\.dlg_params.contour.frSnakeIso.frCoefExternSnakeIso.lblCoefExternSnakeIso"
    set widgetsContours(conEdtCoefExternSnakeIso) "$parent\.dlg_params.contour.frSnakeIso.frCoefExternSnakeIso.edtCoefExternSnakeIso"
    set widgetsContours(conFrSnakeDer)            "$parent\.dlg_params.contour.frSnakeDer"
    set widgetsContours(conFrIterSnakeDer)        "$parent\.dlg_params.contour.frSnakeDer.frIterSnakeDer"
    set widgetsContours(conLblIterSnakeDer)       "$parent\.dlg_params.contour.frSnakeDer.frIterSnakeDer.lblIterSnakeDer"
    set widgetsContours(conEdtIterSnakeDer)       "$parent\.dlg_params.contour.frSnakeDer.frIterSnakeDer.edtIterSnakeDer"
    set widgetsContours(conFrCoefGradSnakeDer)    "$parent\.dlg_params.contour.frSnakeDer.frCoefGradSnakeDer"
    set widgetsContours(conLblCoefGradSnakeDer)   "$parent\.dlg_params.contour.frSnakeDer.frCoefGradSnakeDer.lblCoefGradSnakeDer"
    set widgetsContours(conEdtCoefGradSnakeDer)   "$parent\.dlg_params.contour.frSnakeDer.frCoefGradSnakeDer.edtCoefGradSnakeDer"
    set widgetsContours(conFrCoefBallonSnakeDer)  "$parent\.dlg_params.contour.frSnakeDer.frBallonCoefSnakeDer"
    set widgetsContours(conLblCoefBallonSnakeDer) "$parent\.dlg_params.contour.frSnakeDer.frBallonCoefSnakeDer.lblCoefBallonSnakeDer"
    set widgetsContours(conEdtCoefBallonSnakeDer) "$parent\.dlg_params.contour.frSnakeDer.frBallonCoefSnakeDer.edtCoefBallonSnakeDer"
    set widgetsContours(conFrSigmaSnakeDer)       "$parent\.dlg_params.contour.frSnakeDer.frSigmaSnakeDer"
    set widgetsContours(conLblSigmaSnakeDer)      "$parent\.dlg_params.contour.frSnakeDer.frSigmaSnakeDer.lblSigmaSnakeDer"
    set widgetsContours(conEdtSigmaSnakeDer)      "$parent\.dlg_params.contour.frSnakeDer.frSigmaSnakeDer.edtSigmaSnakeDer"
    set widgetsContours(conLbl001)                "$parent\.dlg_params.contour.lbl001"
    set widgetsContours(conLbl002)                "$parent\.dlg_params.contour.lbl002"
    set widgetsContours(conBtnIso)                "$parent\.dlg_params.contour.btnIso"
    set widgetsContours(conBtnSnakeIso)           "$parent\.dlg_params.contour.btnSnakeIso"
    set widgetsContours(conBtnSnakeDer)           "$parent\.dlg_params.contour.btnSnakeDer"

    set widgetsQuantification(quantMeasures)    "$parent\.dlg_params.quantification.measures"
    set widgetsQuantification(quantBtnAreaM)    "$parent\.dlg_params.quantification.measures.btnAreaM"
    set widgetsQuantification(quantBtnPeriM)    "$parent\.dlg_params.quantification.measures.btnPeriM"
    set widgetsQuantification(quantBtnDiaAreaM) "$parent\.dlg_params.quantification.measures.btnDiaAreaM"
    set widgetsQuantification(quantBtnDiaPeriM) "$parent\.dlg_params.quantification.measures.btnDiaPeriM"
    set widgetsQuantification(quantBtnDiaMinM)  "$parent\.dlg_params.quantification.measures.btnDiaMinM"
    set widgetsQuantification(quantBtnDiaMaxM)  "$parent\.dlg_params.quantification.measures.btnDiaMaxM"
    set widgetsQuantification(quantBtnDiaAvgM)  "$parent\.dlg_params.quantification.measures.btnDiaAvgM"
    set widgetsQuantification(quantStenosis)    "$parent\.dlg_params.quantification.stenosis"
    set widgetsQuantification(quantBtnAreaS)    "$parent\.dlg_params.quantification.stenosis.btnAreaS"
    set widgetsQuantification(quantBtnPeriS)    "$parent\.dlg_params.quantification.stenosis.btnPeriS"
    set widgetsQuantification(quantBtnDiaAreaS) "$parent\.dlg_params.quantification.stenosis.btnDiaAreaS"
    set widgetsQuantification(quantBtnDiaPeriS) "$parent\.dlg_params.quantification.stenosis.btnDiaPeriS"
    set widgetsQuantification(quantBtnDiaMinS)  "$parent\.dlg_params.quantification.stenosis.btnDiaMinS"
    set widgetsQuantification(quantBtnDiaMaxS)  "$parent\.dlg_params.quantification.stenosis.btnDiaMaxS"
    set widgetsQuantification(quantBtnDiaAvgS)  "$parent\.dlg_params.quantification.stenosis.btnDiaAvgS"
    set widgetsQuantification(quantlbl22)       "$parent\.dlg_params.quantification.lbl22"
    set widgetsQuantification(quantlbl23)       "$parent\.dlg_params.quantification.lbl23"

    set gen_debug      0
    set con_debug      0
    set quant_type     0
    set stenosis_type  0
    set alg_type       0
    set params_to_save {}

}

proc dlg_params::show { parent params } {       

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    dlg_params::reset $parent

    # toplevel
    toplevel            $widgets(base) -class Toplevel
    wm focusmodel       $widgets(base) passive
    wm geometry         $widgets(base) 519x384+357+190
    wm maxsize          $widgets(base) 1030 755
    wm minsize          $widgets(base) 106 2
    wm overrideredirect $widgets(base) 0
    wm resizable        $widgets(base) 0 0
    wm deiconify        $widgets(base)
    wm title            $widgets(base) "$string_table::str_title_params"

    # frames
    frame $widgets(tabs)           -height 75 -width 125 
    frame $widgets(buttons)        -height 47 -width 125 
    frame $widgets(general)        -borderwidth 2 -height 75 -relief groove -width 125 
    frame $widgets(axis)           -borderwidth 2 -height 75 -relief groove -width 125 
    frame $widgets(contour)        -borderwidth 2 -height 75 -relief groove -width 125 
    frame $widgets(quantification) -borderwidth 2 -height 75 -relief groove -width 125 

    frame $widgetsGeneral(genDataPaths) -borderwidth 2 -height 75 -relief groove -width 125 
    frame $widgetsGeneral(genWork)      -borderwidth 1 -height 30 -width 30 
    frame $widgetsGeneral(genImages)    -borderwidth 1 -height 30 -width 30 
    frame $widgetsGeneral(genDebug)     -borderwidth 2 -height 75 -relief groove -width 125 

    frame $widgetsAxes(axVoxelX)      -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axVoxelY)      -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axVoxelZ)      -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axStep)        -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axAxisStep)    -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axROIDim)      -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axMassPower)   -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axTension)     -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axPas)         -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axDistCDG)     -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axCell)        -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axFlex)        -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axMaskSize)    -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axDistInt)     -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axCoefCellMax) -borderwidth 1 -height 30 -width 30 
    frame $widgetsAxes(axFrDebug)     -borderwidth 2 -height 30 -width 30 -relief groove

    frame $widgetsContours(conFrSlice)               -borderwidth 2 -height 30 -width 30 -relief groove
    frame $widgetsContours(conFrScale)               -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrSample)              -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrDebug)               -borderwidth 2 -height 30 -width 30 -relief groove
    frame $widgetsContours(conFrIso)                 -borderwidth 2 -height 30 -width 30 -relief groove
    frame $widgetsContours(conFrThrIso)              -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrSnakeIso)            -borderwidth 2 -height 30 -width 30 -relief groove
    frame $widgetsContours(conFrThrSnakeIso)         -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrIterSnakeIso)        -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrCoefExternSnakeIso)  -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrSnakeDer)            -borderwidth 2 -height 30 -width 30 -relief groove
    frame $widgetsContours(conFrIterSnakeDer)        -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrCoefGradSnakeDer)    -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrCoefBallonSnakeDer)  -borderwidth 1 -height 30 -width 30
    frame $widgetsContours(conFrSigmaSnakeDer)       -borderwidth 1 -height 30 -width 30

    frame $widgetsQuantification(quantMeasures) -borderwidth 2 -height 75 -relief groove -width 125 
    frame $widgetsQuantification(quantStenosis) -borderwidth 2 -height 75 -relief groove -width 125 

    # tabs
    radiobutton $widgets(btnGeneral) -indicatoron 0 -text $string_table::str_general        -variable tab_value -value 1 -command "dlg_params::cb_show_general"
    radiobutton $widgets(btnAxis)    -indicatoron 0 -text $string_table::str_axis           -variable tab_value -value 2 -command "dlg_params::cb_show_axis"
    radiobutton $widgets(btnContour) -indicatoron 0 -text $string_table::str_contour        -variable tab_value -value 3 -command "dlg_params::cb_show_contour"
    radiobutton $widgets(btnQuant)   -indicatoron 0 -text $string_table::str_quantification -variable tab_value -value 4 -command "dlg_params::cb_show_quant"

    # entries
    entry $widgetsGeneral(genWork02)
    entry $widgetsGeneral(genImages02)
    
    entry $widgetsAxes(axVoxelX02)
    entry $widgetsAxes(axVoxelY02)
    entry $widgetsAxes(axVoxelZ02)
    label $widgetsAxes(axStep02)
    entry $widgetsAxes(axAxisStep02)
    label $widgetsAxes(axROIDim02)
    label $widgetsAxes(axMassPower02)
    entry $widgetsAxes(axTension02)
    label $widgetsAxes(axPas02)
    entry $widgetsAxes(axDistCDG02)
    label $widgetsAxes(axCell02)
    entry $widgetsAxes(axFlex02)
    entry $widgetsAxes(axMaskSize02)
    label $widgetsAxes(axDistInt02)
    label $widgetsAxes(axCoefCellMax02)

    entry $widgetsContours(conEdtScale)
    entry $widgetsContours(conEdtSample)
    entry $widgetsContours(conEdtThrIso)
    entry $widgetsContours(conEdtThrSnakeIso)
    entry $widgetsContours(conEdtIterSnakeIso)
    entry $widgetsContours(conEdtCoefExternSnakeIso)
    entry $widgetsContours(conEdtIterSnakeDer)
    entry $widgetsContours(conEdtCoefGradSnakeDer)
    entry $widgetsContours(conEdtCoefBallonSnakeDer)
    entry $widgetsContours(conEdtSigmaSnakeDer)

    # checkbuttons
    checkbutton $widgetsGeneral(genBtnWndVis) -text $string_table::str_debug_window_visible   -variable btnWndVis  -command { dlg_params::cb_gen_debug $btnWndVis  0x01 }
    checkbutton $widgetsGeneral(genBtnConVis) -text $string_table::str_console_window_visible -variable btnConsole -command { dlg_params::cb_gen_debug $btnConsole 0x02 }
    checkbutton $widgetsGeneral(genBtnMIPDef) -text $string_table::str_calculate_mip_default  -variable btnMIP     -command { dlg_params::cb_gen_debug $btnMIP     0x04 }
    checkbutton $widgetsGeneral(genBtnAllSlc) -text $string_table::str_all_slices_selected    -variable btnSlices  -command { dlg_params::cb_gen_debug $btnSlices  0x08 }

    checkbutton $widgetsAxes(axBtnShowCell)  -text $string_table::str_show_cell    -variable btnDebug01 
    checkbutton $widgetsAxes(axBtnShowICell) -text $string_table::str_show_i_cell  -variable btnDebug02 

    checkbutton $widgetsContours(conBtnIsoconturs)   -text $string_table::str_isocontours    -variable btn001 -command { dlg_params::cb_con_debug $btn001 0x01 }
    checkbutton $widgetsContours(conBtnDiameters)    -text $string_table::str_diameters      -variable btn002 -command { dlg_params::cb_con_debug $btn001 0x02 }
    checkbutton $widgetsContours(conBtnFillContours) -text $string_table::str_filled_contour -variable btn003 -command { dlg_params::cb_con_debug $btn001 0x04 }

    checkbutton $widgetsQuantification(quantBtnAreaM)    -text $string_table::str_area      -variable btnArea    -command { dlg_params::cb_quant_type $btnArea    0x01 quantBtnAreaS }
    checkbutton $widgetsQuantification(quantBtnPeriM)    -text $string_table::str_peri      -variable btnPeri    -command { dlg_params::cb_quant_type $btnPeri    0x02 quantBtnPeriS }
    checkbutton $widgetsQuantification(quantBtnDiaAreaM) -text $string_table::str_diam_area -variable btnDiaArea -command { dlg_params::cb_quant_type $btnDiaArea 0x04 quantBtnDiaAreaS }
    checkbutton $widgetsQuantification(quantBtnDiaPeriM) -text $string_table::str_diam_peri -variable btnDiaPeri -command { dlg_params::cb_quant_type $btnDiaPeri 0x08 quantBtnDiaPeriS }
    checkbutton $widgetsQuantification(quantBtnDiaMinM)  -text $string_table::str_diam_min  -variable btnDiaMin  -command { dlg_params::cb_quant_type $btnDiaMin  0x10 quantBtnDiaMinS }
    checkbutton $widgetsQuantification(quantBtnDiaMaxM)  -text $string_table::str_diam_max  -variable btnDiaMax  -command { dlg_params::cb_quant_type $btnDiaMax  0x20 quantBtnDiaMaxS }
    checkbutton $widgetsQuantification(quantBtnDiaAvgM)  -text $string_table::str_diam_avg  -variable btnDiaAvg  -command { dlg_params::cb_quant_type $btnDiaAvg  0x40 quantBtnDiaAvgS }

    # radiobuttons
    radiobutton $widgetsAxes(axBtnMinVoxel)  -borderwidth 0 -text $string_table::str_minimum_voxel -variable dlg_params::voxel_typ -value 1 
    radiobutton $widgetsAxes(axBtnNorVoxel)  -borderwidth 0 -text $string_table::str_normal_voxel  -variable dlg_params::voxel_typ -value 2

    radiobutton $widgetsContours(conBtnIso)      -text $string_table::str_isocontour -variable dlg_params::alg_type -value 1 -borderwidth 0 -relief flat
    radiobutton $widgetsContours(conBtnSnakeIso) -text $string_table::str_snake_iso  -variable dlg_params::alg_type -value 2 -borderwidth 0 -relief flat
    radiobutton $widgetsContours(conBtnSnakeDer) -text $string_table::str_snake_der  -variable dlg_params::alg_type -value 3 -borderwidth 0 -relief flat

    radiobutton $widgetsQuantification(quantBtnAreaS)    -text $string_table::str_area      -variable v_stenosis_type -value 1 -command { dlg_params::set_stenosis_type $v_stenosis_type }
    radiobutton $widgetsQuantification(quantBtnPeriS)    -text $string_table::str_peri      -variable v_stenosis_type -value 2 -command { dlg_params::set_stenosis_type $v_stenosis_type }
    radiobutton $widgetsQuantification(quantBtnDiaAreaS) -text $string_table::str_diam_area -variable v_stenosis_type -value 3 -command { dlg_params::set_stenosis_type $v_stenosis_type }
    radiobutton $widgetsQuantification(quantBtnDiaPeriS) -text $string_table::str_diam_peri -variable v_stenosis_type -value 4 -command { dlg_params::set_stenosis_type $v_stenosis_type }
    radiobutton $widgetsQuantification(quantBtnDiaMaxS)  -text $string_table::str_diam_max  -variable v_stenosis_type -value 5 -command { dlg_params::set_stenosis_type $v_stenosis_type }
    radiobutton $widgetsQuantification(quantBtnDiaMinS)  -text $string_table::str_diam_min  -variable v_stenosis_type -value 6 -command { dlg_params::set_stenosis_type $v_stenosis_type }
    radiobutton $widgetsQuantification(quantBtnDiaAvgS)  -text $string_table::str_diam_avg  -variable v_stenosis_type -value 7 -command { dlg_params::set_stenosis_type $v_stenosis_type }

    # labels
    label $widgetsGeneral(genWork01)   -anchor w      -text $string_table::str_work_directory
    label $widgetsGeneral(genImages01) -anchor w      -text $string_table::str_images_directory
    label $widgetsGeneral(genlbl009)   -borderwidth 0 -text $string_table::str_3D_back_color 
    label $widgetsGeneral(genlbl001)   -borderwidth 0 -text $string_table::str_directories 
    label $widgetsGeneral(genlbl078)   -borderwidth 0 -text $string_table::str_user_defined 

    label $widgetsAxes(axVoxelX01)      -anchor w      -text $string_table::str_dim_voxel_x
    label $widgetsAxes(axVoxelY01)      -anchor w      -text $string_table::str_dim_voxel_y
    label $widgetsAxes(axVoxelZ01)      -anchor w      -text $string_table::str_dim_voxel_z
    label $widgetsAxes(axStep01)        -anchor w      -text $string_table::str_step -state disabled
    label $widgetsAxes(axAxisStep01)    -anchor w      -text $string_table::str_axis_step
    label $widgetsAxes(axROIDim01)      -anchor w      -text $string_table::str_roi_dim -state disabled
    label $widgetsAxes(axMassPower01)   -anchor w      -text $string_table::str_mass_power -state disabled
    label $widgetsAxes(axTension01)     -anchor w      -text $string_table::str_coef_tension
    label $widgetsAxes(axPas01)         -anchor w      -text $string_table::str_coef_pas -state disabled
    label $widgetsAxes(axDistCDG01)     -anchor w      -text $string_table::str_distance_cdg -state disabled
    label $widgetsAxes(axCell01)        -anchor w      -text $string_table::str_coef_cell -state disabled
    label $widgetsAxes(axFlex01)        -anchor w      -text $string_table::str_coef_flex
    label $widgetsAxes(axMaskSize01)    -anchor w      -text $string_table::str_mask_size
    label $widgetsAxes(axDistInt01)     -anchor w      -text $string_table::str_dist_int -state disabled
    label $widgetsAxes(axlblColor)      -borderwidth 0 -text $string_table::str_axis_color 
    label $widgetsAxes(axCoefCellMax01) -anchor w      -text $string_table::str_coef_cell_max_int -state disabled
    label $widgetsAxes(axLblDebug)      -anchor w -text $string_table::str_debug


    label $widgetsContours(conLblScale)              -anchor w -text $string_table::str_scale
    label $widgetsContours(conLblSample)             -anchor w -text $string_table::str_sample
    label $widgetsContours(conLblThrIso)             -anchor w -text $string_table::str_threshold
    label $widgetsContours(conLblThrSnakeIso)        -anchor w -text $string_table::str_threshold
    label $widgetsContours(conLblIterSnakeIso)       -anchor w -text $string_table::str_iter
    label $widgetsContours(conLblCoefExternSnakeIso) -anchor w -text $string_table::str_coef_extern
    label $widgetsContours(conLblIterSnakeDer)       -anchor w -text $string_table::str_iter
    label $widgetsContours(conLblCoefGradSnakeDer)   -anchor w -text $string_table::str_coef_grad
    label $widgetsContours(conLblCoefBallonSnakeDer) -anchor w -text $string_table::str_coef_ballon
    label $widgetsContours(conLblSigmaSnakeDer)      -anchor w -text $string_table::str_sigma
    label $widgetsContours(conLbl001)                -anchor w -text $string_table::str_slice
    label $widgetsContours(conLbl002)                -anchor w -text $string_table::str_debug
   
    label $widgetsQuantification(quantlbl22) -borderwidth 0 -text $string_table::str_data_types 
    label $widgetsQuantification(quantlbl23) -borderwidth 0 -text $string_table::str_stenosis_type 

    # buttons
    button $widgets(btnOk)     -text $string_table::str_ok          -command "dlg_params::save_params"
    button $widgets(btnCancel) -text $string_table::str_cancel      -command "dlg_params::cancel_params"
    
    button $widgetsGeneral(genBtnBrwWork)   -text $string_table::str_browse -command "dlg_params::cb_browse_path $widgetsGeneral(genWork02)"
    button $widgetsGeneral(genBtnBrwImages) -text $string_table::str_browse -command "dlg_params::cb_browse_path $widgetsGeneral(genImages02)"
    button $widgetsGeneral(genBtnColor)                                     -command "dlg_params::cb_choose_color $widgetsGeneral(genBtnColor)"

    button $widgetsAxes(axBtnColor) -command "dlg_params::cb_choose_color $widgetsAxes(axBtnColor)"

    # packing
    dlg_params::positionate

    # init
    dlg_params::init_params $params

    # set global focus input to dialog
    grab set $widgets(base)

    # waits for dialog destruction, i.e. waits for user interaction with dialog
    tkwait window $widgets(base)

    return $params_to_save

}

proc dlg_params::positionate { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    pack  $widgets(tabs)       -expand 0 -fill x -side top 
    pack  $widgets(btnGeneral) -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnAxis)    -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnContour) -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnQuant)   -anchor nw -expand 0 -fill none -side left 

    $widgets(btnGeneral) deselect
    $widgets(btnAxis)    deselect
    $widgets(btnContour) deselect
    $widgets(btnQuant)   deselect
    $widgets(btnGeneral) invoke

}

proc dlg_params::init_params { params } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set params_to_save $params
    array set arr $params

    $widgetsGeneral(genWork02)   delete 0 end
    $widgetsGeneral(genImages02) delete 0 end

    $widgetsAxes(axVoxelX02) delete 0 end
    $widgetsAxes(axVoxelY02) delete 0 end
    $widgetsAxes(axVoxelZ02) delete 0 end
    $widgetsAxes(axAxisStep02) delete 0 end
    $widgetsAxes(axTension02) delete 0 end
    $widgetsAxes(axDistCDG02) delete 0 end
    $widgetsAxes(axFlex02) delete 0 end
    $widgetsAxes(axMaskSize02) delete 0 end

    $widgetsContours(conEdtScale)              delete 0 end
    $widgetsContours(conEdtSample)             delete 0 end
    $widgetsContours(conEdtThrIso)             delete 0 end
    $widgetsContours(conEdtThrSnakeIso)        delete 0 end
    $widgetsContours(conEdtIterSnakeIso)       delete 0 end
    $widgetsContours(conEdtCoefExternSnakeIso) delete 0 end
    $widgetsContours(conEdtIterSnakeDer)       delete 0 end
    $widgetsContours(conEdtCoefGradSnakeDer)   delete 0 end
    $widgetsContours(conEdtCoefBallonSnakeDer) delete 0 end
    $widgetsContours(conEdtSigmaSnakeDer)      delete 0 end

    $widgetsGeneral(genWork02)   insert 0 $arr(e_installation_directory)
    $widgetsGeneral(genImages02) insert 0 $arr(e_dicom_images_directory)

    $widgetsAxes(axVoxelX02)      insert 0 $arr(e_voxel_x_dimension)
    $widgetsAxes(axVoxelY02)      insert 0 $arr(e_voxel_y_dimension)
    $widgetsAxes(axVoxelZ02)      insert 0 $arr(e_voxel_z_dimension)
    $widgetsAxes(axAxisStep02)    insert 0 [ change_float_precision $arr(e_axis_discret_step) 2 ]
    $widgetsAxes(axTension02)     insert 0 [ change_float_precision $arr(e_tension_coeficient) 2 ]
    $widgetsAxes(axDistCDG02)     insert 0 [ change_float_precision $arr(e_gravity_distance) 2 ]
    $widgetsAxes(axFlex02)        insert 0 [ change_float_precision $arr(e_flexion_coeficient) 2 ]
    $widgetsAxes(axMaskSize02)    insert 0 [ change_float_precision $arr(e_mask_size) 2 ]

    $widgetsAxes(axStep02) configure -text [ change_float_precision $arr(e_step) 2 ]
    $widgetsAxes(axROIDim02) configure -text [ change_float_precision $arr(e_roi_dimension) 2 ]
    $widgetsAxes(axMassPower02) configure -text [ change_float_precision $arr(e_mass_power) 2 ]
    $widgetsAxes(axPas02) configure -text [ change_float_precision $arr(e_step_coeficient) 2 ]
    $widgetsAxes(axCell02) configure -text [ change_float_precision $arr(e_cell_coeficient) 2 ]
    $widgetsAxes(axDistInt02) configure -text [ change_float_precision $arr(e_distance_to_maximum_intensity) 2 ]
    $widgetsAxes(axCoefCellMax02) configure -text $arr(e_coef_cell_max_int)

    $widgetsContours(conEdtScale)              insert 0 [ change_float_precision $arr(e_scale) 2 ]
    $widgetsContours(conEdtSample)             insert 0 [ change_float_precision $arr(e_sampling) 2 ]
    $widgetsContours(conEdtThrIso)             insert 0 [ change_float_precision $arr(e_threshold_isocontour) 2 ]
    $widgetsContours(conEdtThrSnakeIso)        insert 0 [ change_float_precision $arr(e_threshold_snake_isocontour) 2 ]
    $widgetsContours(conEdtIterSnakeIso)       insert 0 [ change_float_precision $arr(e_number_of_iterations_snake_isocontour) 2 ]
    $widgetsContours(conEdtCoefExternSnakeIso) insert 0 [ change_float_precision $arr(e_extern_coeficient) 2 ]
    $widgetsContours(conEdtIterSnakeDer)       insert 0 [ change_float_precision $arr(e_number_of_iterations_snake_deriche) 2 ]
    $widgetsContours(conEdtCoefGradSnakeDer)   insert 0 [ change_float_precision $arr(e_gradient_coeficient) 2 ]
    $widgetsContours(conEdtCoefBallonSnakeDer) insert 0 [ change_float_precision $arr(e_ballon_coeficient) 2 ]
    $widgetsContours(conEdtSigmaSnakeDer)      insert 0 [ change_float_precision $arr(e_sigma) 2 ]
    
    $widgetsAxes(axBtnMinVoxel) deselect
    $widgetsAxes(axBtnNorVoxel) deselect
    if { $arr(e_voxel_type) == 1 } { $widgetsAxes(axBtnMinVoxel) invoke }
    if { $arr(e_voxel_type) == 2 } { $widgetsAxes(axBtnNorVoxel) invoke }

    $widgetsGeneral(genBtnWndVis) deselect
    $widgetsGeneral(genBtnConVis) deselect
    $widgetsGeneral(genBtnMIPDef) deselect
    $widgetsGeneral(genBtnAllSlc) deselect
    set gen_debug 0
    if { $arr(e_calculate_mip_default)     == 1 } { $widgetsGeneral(genBtnMIPDef) invoke }
    if { $arr(e_choose_all_slices_default) == 1 } { $widgetsGeneral(genBtnAllSlc) invoke }
    if { $arr(e_debug_window_visible)      == 1 } { $widgetsGeneral(genBtnWndVis) invoke }
    if { $arr(e_debug_console_visible)     == 1 } { $widgetsGeneral(genBtnConVis) invoke }

    set alg_type $arr(e_algorithm_type)
    if { $alg_type == 1 } { $widgetsContours(conBtnIso)      invoke }
    if { $alg_type == 2 } { $widgetsContours(conBtnSnakeIso) invoke }
    if { $alg_type == 3 } { $widgetsContours(conBtnSnakeDer) invoke }

    $widgetsContours(conBtnIsoconturs)   deselect
    $widgetsContours(conBtnDiameters)    deselect
    $widgetsContours(conBtnFillContours) deselect
    set con_debug 0
    if { $arr(e_debug_isocontour) == 1 } { $widgetsContours(conBtnIsoconturs)   invoke }
    if { $arr(e_debug_diameters)  == 1 } { $widgetsContours(conBtnDiameters)    invoke }
    if { $arr(e_debug_fill_area)  == 1 } { $widgetsContours(conBtnFillContours) invoke }

#    $widgetsGeneral(genBtnColor) configure -background $arr(e_back_color_3D)

#    $widgetsAxes(axBtnColor) configure -background $arr(e_axis_color)
    
    $widgetsQuantification(quantBtnAreaM)    deselect; $widgetsQuantification(quantBtnAreaS)    configure -state disabled
    $widgetsQuantification(quantBtnPeriM)    deselect; $widgetsQuantification(quantBtnPeriS)    configure -state disabled
    $widgetsQuantification(quantBtnDiaAreaM) deselect; $widgetsQuantification(quantBtnDiaAreaS) configure -state disabled
    $widgetsQuantification(quantBtnDiaPeriM) deselect; $widgetsQuantification(quantBtnDiaPeriS) configure -state disabled
    $widgetsQuantification(quantBtnDiaMinM)  deselect; $widgetsQuantification(quantBtnDiaMinS)  configure -state disabled
    $widgetsQuantification(quantBtnDiaMaxM)  deselect; $widgetsQuantification(quantBtnDiaMaxS)  configure -state disabled
    $widgetsQuantification(quantBtnDiaAvgM)  deselect; $widgetsQuantification(quantBtnDiaAvgS)  configure -state disabled
    set quant_type 0
    if { ( $arr(e_quantification_type) & 0x01 ) == 0x01 } { $widgetsQuantification(quantBtnAreaM)    invoke }
    if { ( $arr(e_quantification_type) & 0x02 ) == 0x02 } { $widgetsQuantification(quantBtnPeriM)    invoke }
    if { ( $arr(e_quantification_type) & 0x04 ) == 0x04 } { $widgetsQuantification(quantBtnDiaAreaM) invoke }
    if { ( $arr(e_quantification_type) & 0x08 ) == 0x08 } { $widgetsQuantification(quantBtnDiaPeriM) invoke }
    if { ( $arr(e_quantification_type) & 0x10 ) == 0x10 } { $widgetsQuantification(quantBtnDiaMinM)  invoke }
    if { ( $arr(e_quantification_type) & 0x20 ) == 0x20 } { $widgetsQuantification(quantBtnDiaMaxM)  invoke }
    if { ( $arr(e_quantification_type) & 0x40 ) == 0x40 } { $widgetsQuantification(quantBtnDiaAvgM)  invoke }

    $widgetsQuantification(quantBtnAreaS)    deselect
    $widgetsQuantification(quantBtnPeriS)    deselect
    $widgetsQuantification(quantBtnDiaAreaS) deselect
    $widgetsQuantification(quantBtnDiaPeriS) deselect
    $widgetsQuantification(quantBtnDiaMinS)  deselect
    $widgetsQuantification(quantBtnDiaMaxS)  deselect
    $widgetsQuantification(quantBtnDiaAvgS)  deselect
    set stenosis_type 0
    if { $arr(e_stenosis_type) == 1 } { $widgetsQuantification(quantBtnAreaS)    invoke }
    if { $arr(e_stenosis_type) == 2 } { $widgetsQuantification(quantBtnPeriS)    invoke }
    if { $arr(e_stenosis_type) == 3 } { $widgetsQuantification(quantBtnDiaAreaS) invoke }
    if { $arr(e_stenosis_type) == 4 } { $widgetsQuantification(quantBtnDiaPeriS) invoke }
    if { $arr(e_stenosis_type) == 5 } { $widgetsQuantification(quantBtnDiaMaxS)  invoke }
    if { $arr(e_stenosis_type) == 6 } { $widgetsQuantification(quantBtnDiaMinS)  invoke }
    if { $arr(e_stenosis_type) == 7 } { $widgetsQuantification(quantBtnDiaAvgS)  invoke }

}

proc dlg_params::cb_show_general { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    dlg_params::p_hide_general
    dlg_params::p_hide_axis
    dlg_params::p_hide_contour
    dlg_params::p_hide_quant

    pack  $widgets(general)                -anchor center -expand 1 -fill both -side top 
    place $widgetsGeneral(genDataPaths)    -x 10 -y 25 -width 415 -height 110 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genWork)         -x 15 -y 20 -width 320 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsGeneral(genWork01)       -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsGeneral(genWork02)       -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsGeneral(genImages)       -x 15 -y 60 -width 320 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsGeneral(genImages01)     -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsGeneral(genImages02)     -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsGeneral(genBtnBrwWork)   -x 340 -y 20 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genBtnBrwImages) -x 340 -y 60 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genDebug)        -x 10 -y 145 -width 415 -height 130 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genBtnWndVis)    -x 5 -y 5 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genBtnConVis)    -x 5 -y 35 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genBtnMIPDef)    -x 5 -y 65 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genBtnAllSlc)    -x 5 -y 95 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genBtnColor)     -x 215 -y 50 -width 185 -height 28 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genlbl009)       -x 215 -y 30 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genlbl001)       -x 15 -y 15 -anchor nw -bordermode ignore 
    place $widgetsGeneral(genlbl078)       -x 15 -y 135 -anchor nw -bordermode ignore 
    pack  $widgets(buttons)                -anchor center -expand 0 -fill x -side top 
    place $widgets(btnOk)                  -x 155 -y 10 -anchor nw -bordermode ignore 
    place $widgets(btnCancel)              -x 235 -y 10 -anchor nw -bordermode ignore 

}

proc dlg_params::cb_show_axis { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    dlg_params::p_hide_general
    dlg_params::p_hide_axis
    dlg_params::p_hide_contour
    dlg_params::p_hide_quant

    pack  $widgets(axis)                -anchor center -expand 1 -fill both -side top 
    place $widgetsAxes(axDistCDG)       -x 25 -y 35 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axDistCDG01)     -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axDistCDG02)     -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axCell)          -x 25 -y 65 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axCell01)        -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axCell02)        -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axFlex)          -x 25 -y 95 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axFlex01)        -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axFlex02)        -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axMaskSize)      -x 25 -y 125 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axMaskSize01)    -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axMaskSize02)    -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axDistInt)       -x 195 -y 35 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axDistInt01)     -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axDistInt02)     -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axMassPower)     -x 195 -y 125 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axMassPower01)   -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axMassPower02)   -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axTension)       -x 195 -y 95 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axTension01)     -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axTension02)     -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axPas)           -x 195 -y 65 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axPas01)         -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axPas02)         -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axROIDim)        -x 25 -y 160 -width 115 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axROIDim01)      -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axROIDim02)      -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axStep)          -x 165 -y 160 -width 115 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axStep01)        -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axStep02)        -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axAxisStep)      -x 305 -y 160 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axAxisStep01)    -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axAxisStep02)    -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axVoxelX)        -x 25 -y 190 -width 115 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axVoxelX01)      -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axVoxelX02)      -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axVoxelY)        -x 165 -y 190 -width 115 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axVoxelY01)      -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axVoxelY02)      -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axVoxelZ)        -x 305 -y 190 -width 115 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axVoxelZ01)      -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axVoxelZ02)      -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axBtnColor)      -x 180 -y 245 -width 180 -height 28 -anchor nw -bordermode ignore 
    place $widgetsAxes(axlblColor)      -x 175 -y 225 -anchor nw -bordermode ignore 
    place $widgetsAxes(axBtnMinVoxel)   -x 30 -y 220 -anchor nw -bordermode ignore 
    place $widgetsAxes(axBtnNorVoxel)   -x 30 -y 240 -anchor nw -bordermode ignore 
    place $widgetsAxes(axCoefCellMax)   -x 350 -y 35 -width 145 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsAxes(axCoefCellMax01) -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsAxes(axCoefCellMax02) -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsAxes(axFrDebug)       -x 375 -y 230 -width 135 -height 55 -anchor nw -bordermode ignore 
    place $widgetsAxes(axBtnShowCell)   -x 5 -y 5 -anchor nw -bordermode ignore 
    place $widgetsAxes(axBtnShowICell)  -x 5 -y 25 -anchor nw -bordermode ignore 
    place $widgetsAxes(axLblDebug)      -x 380 -y 220 -anchor nw -bordermode ignore 
    pack  $widgets(buttons)             -anchor center -expand 0 -fill x -side top 
    place $widgets(btnOk)               -x 155 -y 10 -anchor nw -bordermode ignore 
    place $widgets(btnCancel)           -x 235 -y 10 -anchor nw -bordermode ignore 

}

proc dlg_params::cb_show_contour { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    dlg_params::p_hide_general
    dlg_params::p_hide_axis
    dlg_params::p_hide_contour
    dlg_params::p_hide_quant

    pack  $widgets(contour)                           -anchor center -expand 1 -fill both -side top 
    place $widgetsContours(conFrSlice)               -x 10 -y 20 -width 160 -height 80 -anchor nw -bordermode ignore 
    place $widgetsContours(conFrDebug)               -x 10 -y 110 -width 160 -height 80 -anchor nw -bordermode ignore 
    place $widgetsContours(conFrIso)                 -x 175 -y 40 -width 250 -height 35 -anchor nw -bordermode ignore 
    place $widgetsContours(conFrSnakeIso)            -x 175 -y 105 -width 250 -height 85 -anchor nw -bordermode ignore 
    place $widgetsContours(conFrSnakeDer)            -x 10 -y 220 -width 415 -height 60 -anchor nw -bordermode ignore 
    place $widgetsContours(conBtnIso)                -x 170 -y 15 -anchor nw -bordermode ignore 
    place $widgetsContours(conBtnSnakeIso)           -x 170 -y 80 -anchor nw -bordermode ignore 
    place $widgetsContours(conBtnSnakeDer)           -x 170 -y 195 -anchor nw -bordermode ignore 
    place $widgetsContours(conLbl001)                -x 15 -y 10 -anchor nw -bordermode ignore 
    place $widgetsContours(conLbl002)                -x 15 -y 100 -anchor nw -bordermode ignore 
    place $widgetsContours(conFrScale)               -x 10 -y 15 -width 135 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblScale)              -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtScale)              -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conFrSample)              -x 10 -y 45 -width 135 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblSample)             -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtSample)             -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conBtnIsoconturs)         -x 20 -y 10 -anchor nw -bordermode ignore 
    place $widgetsContours(conBtnDiameters)          -x 20 -y 30 -anchor nw -bordermode ignore 
    place $widgetsContours(conBtnFillContours)       -x 20 -y 50 -anchor nw -bordermode ignore 
    place $widgetsContours(conFrThrIso)              -x 5 -y 5 -width 240 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblThrIso)             -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtThrIso)             -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conFrThrSnakeIso)         -x 5 -y 5 -width 240 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblThrSnakeIso)        -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtThrSnakeIso)        -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conFrIterSnakeIso)        -x 5 -y 30 -width 240 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblIterSnakeIso)       -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtIterSnakeIso)       -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conFrCoefExternSnakeIso)  -x 5 -y 55 -width 240 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblCoefExternSnakeIso) -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtCoefExternSnakeIso) -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conFrIterSnakeDer)        -x 5 -y 5 -width 240 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblIterSnakeDer)       -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtIterSnakeDer)       -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conFrCoefGradSnakeDer)    -x 5 -y 30 -width 240 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblCoefGradSnakeDer)   -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtCoefGradSnakeDer)   -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conFrCoefBallonSnakeDer)  -x 245 -y 5 -width 165 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblCoefBallonSnakeDer) -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtCoefBallonSnakeDer) -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $widgetsContours(conFrSigmaSnakeDer)       -x 245 -y 30 -width 165 -height 25 -anchor nw -bordermode ignore 
    pack  $widgetsContours(conLblSigmaSnakeDer)      -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgetsContours(conEdtSigmaSnakeDer)      -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    pack  $widgets(buttons)                           -anchor center -expand 0 -fill x -side top 
    place $widgets(btnOk)                             -x 155 -y 10 -anchor nw -bordermode ignore 
    place $widgets(btnCancel)                         -x 235 -y 10 -anchor nw -bordermode ignore 

}

proc dlg_params::cb_show_quant { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    dlg_params::p_hide_general
    dlg_params::p_hide_axis
    dlg_params::p_hide_contour
    dlg_params::p_hide_quant

    pack  $widgets(quantification)                 -anchor center -expand 1 -fill both -side top 
    place $widgetsQuantification(quantMeasures)    -x 15 -y 60 -width 185 -height 170 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnAreaM)    -x 5 -y 10 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnPeriM)    -x 5 -y 30 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaAreaM) -x 5 -y 50 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaPeriM) -x 5 -y 70 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaMinM)  -x 5 -y 90 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaMaxM)  -x 5 -y 110 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaAvgM)  -x 5 -y 130 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantStenosis)    -x 220 -y 60 -width 190 -height 170 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnAreaS)    -x 5 -y 10 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnPeriS)    -x 5 -y 30 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaAreaS) -x 5 -y 50 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaPeriS) -x 5 -y 70 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaMinS)  -x 5 -y 90 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaMaxS)  -x 5 -y 110 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantBtnDiaAvgS)  -x 5 -y 130 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantlbl22)       -x 20 -y 50 -anchor nw -bordermode ignore 
    place $widgetsQuantification(quantlbl23)       -x 225 -y 50 -anchor nw -bordermode ignore 
    pack  $widgets(buttons)                        -anchor center -expand 0 -fill x -side top 
    place $widgets(btnOk)                          -x 155 -y 10 -anchor nw -bordermode ignore 
    place $widgets(btnCancel)                      -x 235 -y 10 -anchor nw -bordermode ignore 

}

proc dlg_params::p_hide_general { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    place forget $widgets(btnCancel)
    place forget $widgets(btnOk)
    pack  forget $widgets(buttons)
    place forget $widgetsGeneral(genlbl078)
    place forget $widgetsGeneral(genlbl001)
    place forget $widgetsGeneral(genlbl009)
    place forget $widgetsGeneral(genBtnColor)
    place forget $widgetsGeneral(genBtnAllSlc)
    place forget $widgetsGeneral(genBtnMIPDef)
    place forget $widgetsGeneral(genBtnConVis)
    place forget $widgetsGeneral(genBtnWndVis)
    place forget $widgetsGeneral(genDebug)
    place forget $widgetsGeneral(genBtnBrwImages)
    place forget $widgetsGeneral(genBtnBrwWork)
    pack  forget $widgetsGeneral(genImages02)
    pack  forget $widgetsGeneral(genImages01)
    place forget $widgetsGeneral(genImages)
    pack  forget $widgetsGeneral(genWork02)
    pack  forget $widgetsGeneral(genWork01)
    place forget $widgetsGeneral(genWork)
    place forget $widgetsGeneral(genDataPaths)
    pack  forget $widgets(general)

}

proc dlg_params::p_hide_axis { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    place forget $widgets(btnCancel)
    place forget $widgets(btnOk)
    pack  forget $widgets(buttons)
    place forget $widgetsAxes(axBtnNorVoxel)
    place forget $widgetsAxes(axBtnMinVoxel)
    place forget $widgetsAxes(axlblColor)
    place forget $widgetsAxes(axBtnColor)
    pack  forget $widgetsAxes(axVoxelZ02)
    pack  forget $widgetsAxes(axVoxelZ01)
    place forget $widgetsAxes(axVoxelZ)
    pack  forget $widgetsAxes(axVoxelY02)
    pack  forget $widgetsAxes(axVoxelY01)
    place forget $widgetsAxes(axVoxelY)
    pack  forget $widgetsAxes(axVoxelX02)
    pack  forget $widgetsAxes(axVoxelX01)
    place forget $widgetsAxes(axVoxelX)
    pack  forget $widgetsAxes(axAxisStep02)
    pack  forget $widgetsAxes(axAxisStep01)
    place forget $widgetsAxes(axAxisStep)
    pack  forget $widgetsAxes(axStep02)
    pack  forget $widgetsAxes(axStep01)
    place forget $widgetsAxes(axStep)
    pack  forget $widgetsAxes(axROIDim02)
    pack  forget $widgetsAxes(axROIDim01)
    place forget $widgetsAxes(axROIDim)
    pack  forget $widgetsAxes(axPas02)
    pack  forget $widgetsAxes(axPas01)
    place forget $widgetsAxes(axPas)
    pack  forget $widgetsAxes(axTension02)
    pack  forget $widgetsAxes(axTension01)
    place forget $widgetsAxes(axTension)
    pack  forget $widgetsAxes(axMassPower02)
    pack  forget $widgetsAxes(axMassPower01)
    place forget $widgetsAxes(axMassPower)
    pack  forget $widgetsAxes(axDistInt02)
    pack  forget $widgetsAxes(axDistInt01)
    place forget $widgetsAxes(axDistInt)
    pack  forget $widgetsAxes(axMaskSize02)
    pack  forget $widgetsAxes(axMaskSize01)
    place forget $widgetsAxes(axMaskSize)
    pack  forget $widgetsAxes(axFlex02)
    pack  forget $widgetsAxes(axFlex01)
    place forget $widgetsAxes(axFlex)
    pack  forget $widgetsAxes(axCell02)
    pack  forget $widgetsAxes(axCell01)
    place forget $widgetsAxes(axCell)
    pack  forget $widgetsAxes(axDistCDG02)
    pack  forget $widgetsAxes(axDistCDG01)
    place forget $widgetsAxes(axDistCDG)
    pack  forget $widgets(axis)

}

proc dlg_params::p_hide_contour { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    place forget $widgets(btnCancel)
    place forget $widgets(btnOk)
    pack  forget $widgets(buttons)
    pack  forget $widgetsContours(conEdtSigmaSnakeDer)
    pack  forget $widgetsContours(conLblSigmaSnakeDer)
    place forget $widgetsContours(conFrSigmaSnakeDer)
    pack  forget $widgetsContours(conEdtCoefBallonSnakeDer)
    pack  forget $widgetsContours(conLblCoefBallonSnakeDer)
    place forget $widgetsContours(conFrCoefBallonSnakeDer)
    pack  forget $widgetsContours(conEdtCoefGradSnakeDer)
    pack  forget $widgetsContours(conLblCoefGradSnakeDer)
    place forget $widgetsContours(conFrCoefGradSnakeDer)
    pack  forget $widgetsContours(conEdtIterSnakeDer)
    pack  forget $widgetsContours(conLblIterSnakeDer)
    place forget $widgetsContours(conFrIterSnakeDer)
    pack  forget $widgetsContours(conEdtCoefExternSnakeIso)
    pack  forget $widgetsContours(conLblCoefExternSnakeIso)
    place forget $widgetsContours(conFrCoefExternSnakeIso)
    pack  forget $widgetsContours(conEdtIterSnakeIso)
    pack  forget $widgetsContours(conLblIterSnakeIso)
    place forget $widgetsContours(conFrIterSnakeIso)
    pack  forget $widgetsContours(conEdtThrSnakeIso)
    pack  forget $widgetsContours(conLblThrSnakeIso)
    place forget $widgetsContours(conFrThrSnakeIso)
    pack  forget $widgetsContours(conEdtThrIso)
    pack  forget $widgetsContours(conLblThrIso)
    place forget $widgetsContours(conFrThrIso)
    place forget $widgetsContours(conBtnFillContours)
    place forget $widgetsContours(conBtnDiameters)
    place forget $widgetsContours(conBtnIsoconturs)
    pack  forget $widgetsContours(conEdtSample)
    pack  forget $widgetsContours(conLblSample)
    place forget $widgetsContours(conFrSample)
    pack  forget $widgetsContours(conEdtScale)
    pack  forget $widgetsContours(conLblScale)
    place forget $widgetsContours(conFrScale)
    place forget $widgetsContours(conLbl002)
    place forget $widgetsContours(conLbl001)
    place forget $widgetsContours(conBtnSnakeDer)
    place forget $widgetsContours(conBtnSnakeIso)
    place forget $widgetsContours(conBtnIso)
    place forget $widgetsContours(conFrSnakeDer)
    place forget $widgetsContours(conFrSnakeIso)
    place forget $widgetsContours(conFrIso)
    place forget $widgetsContours(conFrDebug)
    place forget $widgetsContours(conFrSlice)
    pack  forget $widgets(contour)

}

proc dlg_params::p_hide_quant { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    place forget $widgets(btnCancel)
    place forget $widgets(btnOk)
    pack  forget $widgets(buttons)
    place forget $widgetsQuantification(quantlbl23)
    place forget $widgetsQuantification(quantlbl22)
    place forget $widgetsQuantification(quantBtnDiaAvgS)
    place forget $widgetsQuantification(quantBtnDiaMaxS)
    place forget $widgetsQuantification(quantBtnDiaMinS)
    place forget $widgetsQuantification(quantBtnDiaPeriS)
    place forget $widgetsQuantification(quantBtnDiaAreaS)
    place forget $widgetsQuantification(quantBtnPeriS)
    place forget $widgetsQuantification(quantBtnAreaS)
    place forget $widgetsQuantification(quantStenosis)
    place forget $widgetsQuantification(quantBtnDiaAvgM)
    place forget $widgetsQuantification(quantBtnDiaMaxM)
    place forget $widgetsQuantification(quantBtnDiaMinM)
    place forget $widgetsQuantification(quantBtnDiaPeriM)
    place forget $widgetsQuantification(quantBtnDiaAreaM)
    place forget $widgetsQuantification(quantBtnPeriM)
    place forget $widgetsQuantification(quantBtnAreaM)
    place forget $widgetsQuantification(quantMeasures)
    pack  forget $widgets(quantification)

}

proc dlg_params::cancel_params { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set params_to_save [ array get arr ]
    destroy $widgets(base)

}

proc dlg_params::save_params { } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save
    upvar dlg_params::voxel_typ             voxel_typ

    array set arr $params_to_save

    set arr(e_installation_directory)         [ $widgetsGeneral(genWork02)   get ]
    set arr(e_dicom_images_directory)        [ $widgetsGeneral(genImages02) get ]

    set arr(e_voxel_x_dimension)             [ $widgetsAxes(axVoxelX02)    get ]
    set arr(e_voxel_y_dimension)             [ $widgetsAxes(axVoxelY02)    get ]
    set arr(e_voxel_z_dimension)             [ $widgetsAxes(axVoxelZ02)    get ]
    #set arr(e_step)                          [ $widgetsAxes(axStep02)      get ]
    set arr(e_axis_discret_step)             [ $widgetsAxes(axAxisStep02)  get ]
    #set arr(e_roi_dimension)                 [ $widgetsAxes(axROIDim02)    get ]
    #set arr(e_mass_power)                    [ $widgetsAxes(axMassPower02) get ]
    set arr(e_tension_coeficient)            [ $widgetsAxes(axTension02)   get ]
    #set arr(e_step_coeficient)               [ $widgetsAxes(axPas02)       get ]
    set arr(e_gravity_distance)              [ $widgetsAxes(axDistCDG02)   get ]
    #set arr(e_cell_coeficient)               [ $widgetsAxes(axCell02)      get ]
    set arr(e_flexion_coeficient)            [ $widgetsAxes(axFlex02)      get ]
    set arr(e_mask_size)                     [ $widgetsAxes(axMaskSize02)  get ]
    #set arr(e_distance_to_maximum_intensity) [ $widgetsAxes(axDistInt02)   get ]
    #set arr(e_coef_cell_max_int)             [ $widgetsAxes(axCoefCellMax02) get ]

    set arr(e_scale)                                 [ $widgetsContours(conEdtScale)              get ]
    set arr(e_sampling)                              [ $widgetsContours(conEdtSample)             get ]
    set arr(e_threshold_isocontour)                  [ $widgetsContours(conEdtThrIso)             get ]
    set arr(e_threshold_snake_isocontour)            [ $widgetsContours(conEdtThrSnakeIso)        get ]
    set arr(e_number_of_iterations_snake_isocontour) [ $widgetsContours(conEdtIterSnakeIso)       get ]
    set arr(e_extern_coeficient)                     [ $widgetsContours(conEdtCoefExternSnakeIso) get ]
    set arr(e_number_of_iterations_snake_deriche)    [ $widgetsContours(conEdtIterSnakeDer)       get ]
    set arr(e_gradient_coeficient)                   [ $widgetsContours(conEdtCoefGradSnakeDer)   get ]
    set arr(e_ballon_coeficient)                     [ $widgetsContours(conEdtCoefBallonSnakeDer) get ]
    set arr(e_sigma)                                 [ $widgetsContours(conEdtSigmaSnakeDer)      get ]

    set arr(e_voxel_type) $voxel_typ

    set arr(e_debug_window_visible)      [ expr ( ( $gen_debug & 0x01 ) == 0x01 ) ]
    set arr(e_debug_console_visible)     [ expr ( ( $gen_debug & 0x02 ) == 0x02 ) ]
    set arr(e_calculate_mip_default)     [ expr ( ( $gen_debug & 0x04 ) == 0x04 ) ]
    set arr(e_choose_all_slices_default) [ expr ( ( $gen_debug & 0x08 ) == 0x08 ) ]

    set arr(e_algorithm_type)    $alg_type
    set arr(e_debug_isocontour) [ expr ( ( $con_debug & 0x01 ) == 0x01 ) ]
    set arr(e_debug_diameters)  [ expr ( ( $con_debug & 0x02 ) == 0x02 ) ]
    set arr(e_debug_fill_area)  [ expr ( ( $con_debug & 0x04 ) == 0x04 ) ]

#    set arr(e_back_color_3D) [ $widgetsGeneral(genBtnColor) cget -background ]

#    set arr(e_axis_color)    [ $widgetsAxes(axBtnColor)  cget -background ]

    set arr(e_quantification_type) $quant_type
    set arr(e_stenosis_type)       $stenosis_type

    set params_to_save [ array get arr ]
    destroy $widgets(base)

}

proc dlg_params::cb_browse_path { entry_widget } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set nDir [ tk_chooseDirectory \
                    -initialdir [ $entry_widget get ] \
                    -parent $widgets(base) \
                    -title "$string_table::str_chooseadirectory" \
                    -mustexist true \
    ]
    if { $nDir != "" } {

        $entry_widget delete 0 end
        $entry_widget insert 0 $nDir

    }

}

proc dlg_params::cb_gen_debug { value mask } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set gen_debug [ expr ( $value == 1 )? \
                         ( $gen_debug | $mask ): \
                         ( $gen_debug & ( ~$mask ) ) \
    ]

}

proc dlg_params::cb_con_debug { value mask } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set con_debug [ expr ( $value == 1 )? \
                         ( $con_debug | $mask ): \
                         ( $con_debug & ( ~$mask ) ) \
    ]

}

proc dlg_params::cb_quant_type { value mask partner } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set quant_type [ expr ( $value == 1 )? \
                          ( $quant_type | $mask ): \
                          ( $quant_type & ( ~$mask ) ) \
    ]
    set partner2 ""
    if { [ string compare $partner "quantBtnAreaS"    ] == 0 } { set partner2 $widgetsQuantification(quantBtnAreaS) }
    if { [ string compare $partner "quantBtnPeriS"    ] == 0 } { set partner2 $widgetsQuantification(quantBtnPeriS) }
    if { [ string compare $partner "quantBtnDiaAreaS" ] == 0 } { set partner2 $widgetsQuantification(quantBtnDiaAreaS) }
    if { [ string compare $partner "quantBtnDiaPeriS" ] == 0 } { set partner2 $widgetsQuantification(quantBtnDiaPeriS) }
    if { [ string compare $partner "quantBtnDiaMinS"  ] == 0 } { set partner2 $widgetsQuantification(quantBtnDiaMinS) }
    if { [ string compare $partner "quantBtnDiaMaxS"  ] == 0 } { set partner2 $widgetsQuantification(quantBtnDiaMaxS) }
    if { [ string compare $partner "quantBtnDiaAvgS"  ] == 0 } { set partner2 $widgetsQuantification(quantBtnDiaAvgS) }

    if { $value == 1 } { $partner2 configure -state normal }
    if { $value == 0 } { $partner2 configure -state disabled }

}

proc dlg_params::cb_choose_color { button_chooser } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set col [ $button_chooser cget -background ]
    set col [ \
        tk_chooseColor \
            -initialcolor $col \
            -parent $button_chooser \
            -title "Choose a color..."
    ]
    if { $col != "" } { $button_chooser configure -background $col }

}

proc dlg_params::set_alg_type { v_alg_type } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set alg_type $v_alg_type

}

proc dlg_params::set_stenosis_type { v_stenosis_type } {

    # For programming facilities
    upvar dlg_params::widgets               widgets
    upvar dlg_params::widgetsGeneral        widgetsGeneral
    upvar dlg_params::widgetsAxes           widgetsAxes
    upvar dlg_params::widgetsContours       widgetsContours
    upvar dlg_params::widgetsQuantification widgetsQuantification
    upvar dlg_params::gen_debug             gen_debug
    upvar dlg_params::con_debug             con_debug
    upvar dlg_params::quant_type            quant_type
    upvar dlg_params::alg_type              alg_type
    upvar dlg_params::stenosis_type         stenosis_type
    upvar dlg_params::params_to_save        params_to_save

    set stenosis_type $v_stenosis_type

}

# EOF -- dlg_params.tcl
