namespace eval global_window {

    # public interface
    namespace export \
        show \
        active_controls \
        show_params  \
        en_quant     \
        en_planes    \
        en_3D        \
        en_subtract  \
        en_ibrw      \
        en_params    \
        en_save      \
        en_load      \
        en_open      \
        en_help      \
        en_rotate    \
        en_bright    \
        en_pan       \
        en_zoom      \
        en_clear     \
        en_intensity \
        en_linear    \
        en_area      \
        en_back      \
        en_excel     \
        en_wizard    \
        im1         \
        im2
    
    # variables
    variable widgets

    # Loaded button images
    variable images

	# Parameters dialog visible?
    variable show_params -1

	# Button enable/disable values
    variable en_quant     0x000001
    variable en_planes    0x000002
    variable en_3D        0x000004
    variable en_subtract  0x000008
    variable en_ibrw      0x000010
    variable en_params    0x000020
    variable en_save      0x000040
    variable en_load      0x000080
    variable en_open      0x000100
    variable en_help      0x000200
    variable en_rotate    0x000400
    variable en_bright    0x000800
    variable en_pan       0x001000
    variable en_zoom      0x002000
    variable en_clear     0x004000
    variable en_intensity 0x008000
    variable en_linear    0x010000
    variable en_area      0x020000
    variable en_back      0x040000
    variable en_excel     0x080000
    variable en_wizard    0x100000

	# Windows id values
    variable sh_none    0x01
    variable sh_data    0x02
    variable sh_ibrw    0x04
    variable sh_3D_mpr  0x08
    variable sh_3D_mip  0x10
    variable sh_3D_sur  0x20
    variable sh_3D_qua  0x40

    variable window_shown

}

proc global_window::reset { } {

    # For programming facilities
    upvar global_window::widgets widgets

    set widgets(base)              "."
    set widgets(toolBar)           ".frToolBar"
    set widgets(toolsAllData)      ".frToolBar.frTAllData"
    set widgets(toolsData)         ".frToolBar.frTData"
    set widgets(toolsState)        ".frToolBar.frState"
    set widgets(toolsMouse)        ".frToolBar.frMouse"
    set widgets(toolsProfil)       ".frToolBar.frProfil"
    set widgets(toolsHelp)         ".frToolBar.frHelp"
    set widgets(work)              ".frWork"
    set widgets(btnChooseDataPath) ".frToolBar.frTAllData.btnChooseDataPath"
    set widgets(btnLoadExperiment) ".frToolBar.frTAllData.btnLoadExperiment"
    set widgets(btnSaveExperiment) ".frToolBar.frTAllData.btnSaveExperiment"
    set widgets(btnSaveExcel)      ".frToolBar.frTAllData.btnSaveExcel"
    set widgets(btnParam)          ".frToolBar.frTAllData.btnParam"
    set widgets(btnWizard)         ".frToolBar.frTAllData.btnWizard"
    set widgets(btnIbrw)           ".frToolBar.frTData.btnIbrw"
    set widgets(btnSubtract)       ".frToolBar.frTData.btnSubtract"
    set widgets(btnBack)           ".frToolBar.frState.btnBack"
    set widgets(btn3D)             ".frToolBar.frState.btn3D"
    set widgets(btnPlanes)         ".frToolBar.frState.btnPlanes"
    set widgets(btnQuant)          ".frToolBar.frState.btnQuant"
    set widgets(btnRotate)         ".frToolBar.frMouse.btnRotate"
    set widgets(btnBright)         ".frToolBar.frMouse.btnBright"
    set widgets(btnPan)            ".frToolBar.frMouse.btnPan"
    set widgets(btnZoom)           ".frToolBar.frMouse.btnZoom"
    set widgets(btnClear)          ".frToolBar.frProfil.btnClear"
    set widgets(btnIntensity)      ".frToolBar.frProfil.btnIntensity"
    set widgets(btnLinear)         ".frToolBar.frProfil.btnLinear"
    set widgets(btnArea)           ".frToolBar.frProfil.btnArea"
    set widgets(btnHelp)           ".frToolBar.frHelp.btnHelp"

}

proc global_window::show { imgpath } {

    # For programming facilities
    upvar global_window::widgets widgets
    upvar global_window::images            images
    upvar global_window::im1               im1
    upvar global_window::im2               im2
    upvar global_window::data_loaded       data_loaded
    upvar global_window::window_shown      window_shown

    set data_loaded 0
    set window_shown 0

    # Images
    set images(connect)      [ image create photo -file "$imgpath/connect.gif" ]
    set images(loadexp)      [ image create photo -file "$imgpath/loadexp.gif" ]
    set images(save)         [ image create photo -file "$imgpath/save.gif" ]
    set images(excel)        [ image create photo -file "$imgpath/excel.gif" ]
    set images(params)       [ image create photo -file "$imgpath/params.gif" ]
    set images(wizard)       [ image create photo -file "$imgpath/wizard.gif" ]
    set images(back)         [ image create photo -file "$imgpath/back.gif" ]
    set images(imagebrowser) [ image create photo -file "$imgpath/imagebrowser.gif" ]
    set images(subtract)     [ image create photo -file "$imgpath/subtract.gif" ]
    set images(triD)         [ image create photo -file "$imgpath/3D.gif" ]
    set images(plans)        [ image create photo -file "$imgpath/plans.gif" ]
    set images(quant)        [ image create photo -file "$imgpath/quant.gif" ]
    set images(rotate)       [ image create photo -file "$imgpath/rotate.gif" ]
    set images(bright)       [ image create photo -file "$imgpath/bright.gif" ]
    set images(pan)          [ image create photo -file "$imgpath/pan.gif" ]
    set images(zoom)         [ image create photo -file "$imgpath/zoom.gif" ]
    set images(clear)        [ image create photo -file "$imgpath/clear.gif" ]
    set images(intensity)    [ image create photo -file "$imgpath/intensity.gif" ]
    set images(linear)       [ image create photo -file "$imgpath/linear.gif" ]
    set images(area)         [ image create photo -file "$imgpath/area.gif" ]
    set images(help)         [ image create photo -file "$imgpath/help.gif" ]
    set images(extract)      [ image create photo -file "$imgpath/extract.gif" ]
    set images(del_axis)     [ image create photo -file "$imgpath/del_axis.gif" ]
    set images(add)          [ image create photo -file "$imgpath/add.gif" ]
    set images(continue)     [ image create photo -file "$imgpath/continue.gif" ]
    set im1                  [ image create photo -file "$imgpath/redgreen.gif" ]
    set im2                  [ image create photo -file "$imgpath/redblue.gif" ]

    loadParams_dll "params.dat"
    
    global_window::create $imgpath
     data_browser::create $widgets(work) 0x1
    image_browser::create $widgets(work) 0x2
             u_3D::create $widgets(work) 0x4
    planes_window::create $widgets(work) 0x8

    global_window::positionate

}

proc global_window::create { imgpath } {

    # For programming facilities
    upvar global_window::widgets     widgets
    upvar global_window::images      images
    upvar global_window::en_help     en_help
    upvar global_window::en_quant    en_quant
    upvar global_window::en_planes   en_planes
    upvar global_window::en_3D       en_3D
    upvar global_window::en_subtract en_subtract
    upvar global_window::en_ibrw     en_ibrw
    upvar global_window::en_params   en_params
    upvar global_window::en_save     en_save
    upvar global_window::en_load     en_load
    upvar global_window::en_open     en_open
    upvar global_window::en_excel    en_excel
    upvar global_window::en_wizard   en_wizard
 
    global_window::reset

    # toplevel...
    wm focusmodel       $widgets(base) passive
    wm geometry         $widgets(base) 912x564+16+108
    wm minsize          $widgets(base) 50 50
    wm overrideredirect $widgets(base) 0
    wm resizable        $widgets(base) 1 1
    wm deiconify        $widgets(base)
    wm title            $widgets(base) "$string_table::str_maracas_title"

    # frames
    frame $widgets(toolBar)      -borderwidth 1 -height 1 -relief flat -width 1
    frame $widgets(toolsAllData) -borderwidth 2 -height 1 -relief groove -width 1
    frame $widgets(toolsData)    -borderwidth 2 -height 1 -relief groove -width 1
    frame $widgets(toolsState)   -borderwidth 2 -height 1 -relief groove -width 1
    frame $widgets(toolsMouse)   -borderwidth 2 -height 1 -relief groove -width 1
    frame $widgets(toolsProfil)  -borderwidth 2 -height 1 -relief groove -width 1
    frame $widgets(toolsHelp)    -borderwidth 2 -height 1 -relief groove -width 1
    frame $widgets(work)         -borderwidth 1 -height 1 -relief flat -width 1

    # buttons
    button $widgets(btnChooseDataPath) -relief flat -image $images(connect)      -command "global_window::cb_open_data"
    button $widgets(btnLoadExperiment) -relief flat -image $images(loadexp)      -command "global_window::open_data"
    button $widgets(btnSaveExperiment) -relief flat -image $images(save)         -command "global_window::save_data"
    button $widgets(btnSaveExcel)      -relief flat -image $images(excel)        -command "global_window::save_data_as_excel"
    button $widgets(btnParam)          -relief flat -image $images(params)       -command "global_window::cb_load_params"
    button $widgets(btnWizard)         -relief flat -image $images(wizard)       -command "global_window::show_wizard"
    button $widgets(btnBack)           -relief flat -image $images(back)         -command "global_window::back"
    button $widgets(btnIbrw)           -relief flat -image $images(imagebrowser) -command "global_window::cb_image_browse"
    button $widgets(btnSubtract)       -relief flat -image $images(subtract)     -command "global_window::subtract"
    button $widgets(btn3D)             -relief flat -image $images(triD)         -command "global_window::start_3D"
    button $widgets(btnPlanes)         -relief flat -image $images(plans)        -command "global_window::show_planes"
    button $widgets(btnQuant)          -relief flat -image $images(quant)        -command "global_window::do_quant"
    button $widgets(btnClear)                       -image $images(clear)        -command "global_window::clear"
    button $widgets(btnHelp)           -relief flat -image $images(help)         -command "help_wnd::show_about $imgpath"
                
    radiobutton $widgets(btnRotate)    -indicatoron 0 -variable left_button -value 1 -relief flat -image $images(rotate)    -command "global_window::set_mouse_left_events 0x4"
    radiobutton $widgets(btnPan)       -indicatoron 0 -variable left_button -value 2 -relief flat -image $images(pan)       -command "global_window::set_mouse_left_events 0x2"
    radiobutton $widgets(btnIntensity) -indicatoron 0 -variable left_button -value 3 -relief flat -image $images(intensity) -command "global_window::set_mouse_left_events 0x1"

    radiobutton $widgets(btnBright) -indicatoron 0 -variable right_button -value 1 -relief flat -image $images(bright)    -command "global_window::set_mouse_right_events 0x8"
    radiobutton $widgets(btnZoom)   -indicatoron 0 -variable right_button -value 2 -relief flat -image $images(zoom)      -command "global_window::set_mouse_right_events 0x4"
    radiobutton $widgets(btnLinear) -indicatoron 0 -variable right_button -value 3 -relief flat -image $images(linear)    -command "global_window::set_mouse_right_events 0x2"
    radiobutton $widgets(btnArea)   -indicatoron 0 -variable right_button -value 4 -relief flat -image $images(area)      -command "global_window::set_mouse_right_events 0x1"

    bind $widgets(btnChooseDataPath) <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnLoadExperiment) <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnSaveExperiment) <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnSaveExcel)      <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnParam)          <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnWizard)         <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnBack)           <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnIbrw)           <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnSubtract)       <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btn3D)             <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnPlanes)         <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnQuant)          <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnRotate)         <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }
    bind $widgets(btnHelp)           <Enter> { if { [ string compare [ %W cget -state ] "normal" ] == 0 } { %W configure -relief raised } }

    bind $widgets(btnChooseDataPath) <Leave> { %W configure -relief flat }
    bind $widgets(btnLoadExperiment) <Leave> { %W configure -relief flat }
    bind $widgets(btnSaveExperiment) <Leave> { %W configure -relief flat }
    bind $widgets(btnSaveExcel)      <Leave> { %W configure -relief flat }
    bind $widgets(btnParam)          <Leave> { %W configure -relief flat }
    bind $widgets(btnWizard)         <Leave> { %W configure -relief flat }
    bind $widgets(btnBack)           <Leave> { %W configure -relief flat }
    bind $widgets(btnIbrw)           <Leave> { %W configure -relief flat }
    bind $widgets(btnSubtract)       <Leave> { %W configure -relief flat }
    bind $widgets(btn3D)             <Leave> { %W configure -relief flat }
    bind $widgets(btnPlanes)         <Leave> { %W configure -relief flat }
    bind $widgets(btnQuant)          <Leave> { %W configure -relief flat }
    bind $widgets(btnRotate)         <Leave> { %W configure -relief flat }
    bind $widgets(btnHelp)           <Leave> { %W configure -relief flat }

	bind $widgets(base) <Destroy> "global_window::DestroyWindow %W"

    global_window::controls 0

}

proc global_window::DestroyWindow { widget } {

    # For programming facilities
    upvar global_window::widgets widgets

	if { [ string compare $widget $widgets(base) ] == 0 } {

		freeAllMaracasInterfaces_dll

	}

}

proc global_window::positionate { } {

    # For programming facilities
    upvar global_window::widgets     widgets
    upvar global_window::show_params show_params

    set show_params -1

    pack $widgets(toolBar)           -anchor n  -expand 0 -fill both -side top
    pack $widgets(toolsAllData)      -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnChooseDataPath) -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnLoadExperiment) -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnSaveExperiment) -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnSaveExcel)      -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnParam)          -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnWizard)         -anchor nw -expand 0 -fill none -side left
    pack $widgets(toolsData)         -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnIbrw)           -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnSubtract)       -anchor nw -expand 0 -fill none -side left
    pack $widgets(toolsState)        -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnBack)           -anchor nw -expand 0 -fill none -side left
    pack $widgets(btn3D)             -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnPlanes)         -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnQuant)          -anchor nw -expand 0 -fill none -side left
    pack $widgets(toolsMouse)        -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnRotate)         -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnBright)         -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnPan)            -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnZoom)           -anchor nw -expand 0 -fill none -side left
    pack $widgets(toolsProfil)       -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnClear)          -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnIntensity)      -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnLinear)         -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnArea)           -anchor nw -expand 0 -fill none -side left
    pack $widgets(toolsHelp)         -anchor nw -expand 0 -fill none -side left
    pack $widgets(btnHelp)           -anchor nw -expand 0 -fill none -side left
    pack $widgets(work)              -anchor n  -expand 1 -fill both -side top

}

proc global_window::forget { } {

    # For programming facilities
    upvar global_window::widgets widgets

    pack forget $widgets(work)
    pack forget $widgets(btnHelp)
    pack forget $widgets(toolsHelp)
    pack forget $widgets(btnArea)
    pack forget $widgets(btnLinear)
    pack forget $widgets(btnIntensity)
    pack forget $widgets(btnClear)
    pack forget $widgets(toolsProfil)
    pack forget $widgets(btnZoom)
    pack forget $widgets(btnPan)
    pack forget $widgets(btnBright)
    pack forget $widgets(btnRotate)
    pack forget $widgets(toolsMouse)
    pack forget $widgets(btnQuant)
    pack forget $widgets(btnPlanes)
    pack forget $widgets(btn3D)
    pack forget $widgets(btnBack)
    pack forget $widgets(toolsState)
    pack forget $widgets(btnSubtract)
    pack forget $widgets(btnIbrw)
    pack forget $widgets(toolsData)
    pack forget $widgets(btnWizard)
    pack forget $widgets(btnParam)
    pack forget $widgets(btnLoadExperiment)
    pack forget $widgets(btnSaveExcel)
    pack forget $widgets(btnSaveExperiment)
    pack forget $widgets(btnChooseDataPath)
    pack forget $widgets(toolsAllData)
    pack forget $widgets(toolBar)

}

proc global_window::get_active_controls { } {

    # For programming facilities
    upvar global_window::widgets      widgets
    upvar global_window::en_quant     en_quant    
    upvar global_window::en_planes    en_planes   
    upvar global_window::en_3D        en_3D       
    upvar global_window::en_subtract  en_subtract 
    upvar global_window::en_ibrw      en_ibrw     
    upvar global_window::en_params    en_params   
    upvar global_window::en_save      en_save     
    upvar global_window::en_load      en_load     
    upvar global_window::en_open      en_open     
    upvar global_window::en_help      en_help     
    upvar global_window::en_rotate    en_rotate   
    upvar global_window::en_bright    en_bright   
    upvar global_window::en_pan       en_pan      
    upvar global_window::en_zoom      en_zoom     
    upvar global_window::en_clear     en_clear    
    upvar global_window::en_intensity en_intensity
    upvar global_window::en_linear    en_linear   
    upvar global_window::en_area      en_area     
    upvar global_window::en_back      en_back
    upvar global_window::en_excel     en_excel
    upvar global_window::en_wizard    en_wizard

	set ret 0
    if { [ string compare [ $widgets(btnQuant)          cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_quant     ] }
    if { [ string compare [ $widgets(btnPlanes)         cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_planes    ] }
    if { [ string compare [ $widgets(btn3D)             cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_3D        ] }
    if { [ string compare [ $widgets(btnSubtract)       cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_subtract  ] }
    if { [ string compare [ $widgets(btnIbrw)           cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_ibrw      ] }
    if { [ string compare [ $widgets(btnParam)          cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_params    ] }
    if { [ string compare [ $widgets(btnSaveExperiment) cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_save      ] }
    if { [ string compare [ $widgets(btnLoadExperiment) cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_load      ] }
    if { [ string compare [ $widgets(btnChooseDataPath) cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_open      ] }
    if { [ string compare [ $widgets(btnHelp)           cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_help      ] }
    if { [ string compare [ $widgets(btnRotate)         cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_rotate    ] }
    if { [ string compare [ $widgets(btnBright)         cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_bright    ] }
    if { [ string compare [ $widgets(btnPan)            cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_pan       ] }
    if { [ string compare [ $widgets(btnZoom)           cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_zoom      ] }
    if { [ string compare [ $widgets(btnClear)          cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_clear     ] }
    if { [ string compare [ $widgets(btnIntensity)      cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_intensity ] }
    if { [ string compare [ $widgets(btnLinear)         cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_linear    ] }
    if { [ string compare [ $widgets(btnArea)           cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_area      ] }
    if { [ string compare [ $widgets(btnBack)           cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_back      ] }
    if { [ string compare [ $widgets(btnSaveExcel)      cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_excel     ] }
    if { [ string compare [ $widgets(btnWizard)         cget -state ] "normal" ] == 0 } { set ret [ expr $ret | $en_wizard    ] }

	return $ret

}

proc global_window::active_controls { mask } {

    # For programming facilities
    upvar global_window::widgets      widgets
    upvar global_window::en_quant     en_quant    
    upvar global_window::en_planes    en_planes   
    upvar global_window::en_3D        en_3D       
    upvar global_window::en_subtract  en_subtract 
    upvar global_window::en_ibrw      en_ibrw     
    upvar global_window::en_params    en_params   
    upvar global_window::en_save      en_save     
    upvar global_window::en_load      en_load     
    upvar global_window::en_open      en_open     
    upvar global_window::en_help      en_help     
    upvar global_window::en_rotate    en_rotate   
    upvar global_window::en_bright    en_bright   
    upvar global_window::en_pan       en_pan      
    upvar global_window::en_zoom      en_zoom     
    upvar global_window::en_clear     en_clear    
    upvar global_window::en_intensity en_intensity
    upvar global_window::en_linear    en_linear   
    upvar global_window::en_area      en_area     
    upvar global_window::en_back      en_back
    upvar global_window::en_excel     en_excel
    upvar global_window::en_wizard    en_wizard

    if { ( $mask & $en_quant     ) == $en_quant     } { $widgets(btnQuant)          configure -state normal } else { $widgets(btnQuant)          configure -state disabled -relief flat }
    if { ( $mask & $en_planes    ) == $en_planes    } { $widgets(btnPlanes)         configure -state normal } else { $widgets(btnPlanes)         configure -state disabled -relief flat }
    if { ( $mask & $en_3D        ) == $en_3D        } { $widgets(btn3D)             configure -state normal } else { $widgets(btn3D)             configure -state disabled -relief flat }
    if { ( $mask & $en_subtract  ) == $en_subtract  } { $widgets(btnSubtract)       configure -state normal } else { $widgets(btnSubtract)       configure -state disabled -relief flat }
    if { ( $mask & $en_ibrw      ) == $en_ibrw      } { $widgets(btnIbrw)           configure -state normal } else { $widgets(btnIbrw)           configure -state disabled -relief flat }
    if { ( $mask & $en_params    ) == $en_params    } { $widgets(btnParam)          configure -state normal } else { $widgets(btnParam)          configure -state disabled -relief flat }
    if { ( $mask & $en_save      ) == $en_save      } { $widgets(btnSaveExperiment) configure -state normal } else { $widgets(btnSaveExperiment) configure -state disabled -relief flat }
    if { ( $mask & $en_load      ) == $en_load      } { $widgets(btnLoadExperiment) configure -state normal } else { $widgets(btnLoadExperiment) configure -state disabled -relief flat }
    if { ( $mask & $en_open      ) == $en_open      } { $widgets(btnChooseDataPath) configure -state normal } else { $widgets(btnChooseDataPath) configure -state disabled -relief flat }
    if { ( $mask & $en_help      ) == $en_help      } { $widgets(btnHelp)           configure -state normal } else { $widgets(btnHelp)           configure -state disabled -relief flat }
    if { ( $mask & $en_rotate    ) == $en_rotate    } { $widgets(btnRotate)         configure -state normal } else { $widgets(btnRotate)         configure -state disabled -relief flat }
    if { ( $mask & $en_bright    ) == $en_bright    } { $widgets(btnBright)         configure -state normal } else { $widgets(btnBright)         configure -state disabled -relief flat }
    if { ( $mask & $en_pan       ) == $en_pan       } { $widgets(btnPan)            configure -state normal } else { $widgets(btnPan)            configure -state disabled -relief flat }
    if { ( $mask & $en_zoom      ) == $en_zoom      } { $widgets(btnZoom)           configure -state normal } else { $widgets(btnZoom)           configure -state disabled -relief flat }
    if { ( $mask & $en_clear     ) == $en_clear     } { $widgets(btnClear)          configure -state normal } else { $widgets(btnClear)          configure -state disabled -relief flat }
    if { ( $mask & $en_intensity ) == $en_intensity } { $widgets(btnIntensity)      configure -state normal } else { $widgets(btnIntensity)      configure -state disabled -relief flat }
    if { ( $mask & $en_linear    ) == $en_linear    } { $widgets(btnLinear)         configure -state normal } else { $widgets(btnLinear)         configure -state disabled -relief flat }
    if { ( $mask & $en_area      ) == $en_area      } { $widgets(btnArea)           configure -state normal } else { $widgets(btnArea)           configure -state disabled -relief flat }
    if { ( $mask & $en_back      ) == $en_back      } { $widgets(btnBack)           configure -state normal } else { $widgets(btnBack)           configure -state disabled -relief flat }
    if { ( $mask & $en_excel     ) == $en_excel     } { $widgets(btnSaveExcel)      configure -state normal } else { $widgets(btnSaveExcel)      configure -state disabled -relief flat }
    if { ( $mask & $en_wizard    ) == $en_wizard    } { $widgets(btnWizard)         configure -state normal } else { $widgets(btnWizard)         configure -state disabled -relief flat }

}

proc global_window::cb_load_params { } {

    # For programming facilities
    upvar global_window::widgets      widgets
    upvar global_window::sh_none      sh_none
    upvar global_window::sh_data      sh_data
    upvar global_window::sh_ibrw      sh_ibrw
    upvar global_window::sh_3D_mpr    sh_3D_mpr
    upvar global_window::sh_3D_mip    sh_3D_mip
    upvar global_window::sh_3D_sur    sh_3D_sur
    upvar global_window::sh_3D_qua    sh_3D_qua
    upvar global_window::window_shown window_shown
    upvar global_window::show_params  show_params

    set ac_ctrls [ global_window::get_active_controls ]

    set p [ params_dll ]
    array set arrB $p
    set p [ dlg_params::show $widgets(work) $p ]
    array set arrP $p
    if { $p != "" } {

        setParams_dll $p
        saveParams_dll "params.dat"

        # Recalculate axes, if an
        u_surf::reload_axis [ expr ( $arrB(e_mask_size) != $arrP(e_mask_size) ) || ( $arrB(e_coef_cell_max_int) != $arrP(e_coef_cell_max_int) ) ] [ expr ( $arrB(e_axis_discret_step) != $arrP(e_axis_discret_step) ) ]
        planes_window::reload_axis [ expr ( $arrB(e_mask_size) != $arrP(e_mask_size) ) || ( $arrB(e_coef_cell_max_int) != $arrP(e_coef_cell_max_int) ) ] [ expr ( $arrB(e_axis_discret_step) != $arrP(e_axis_discret_step) ) ]

    }
    global_window::active_controls $ac_ctrls

}

proc global_window::cb_open_data { } {

    # For programming facilities
    upvar global_window::data_loaded_from_disk data_loaded_from_disk

    busy hold .
    update

    planes_window::forget
    u_3D::forget
    image_browser::forget
    data_browser::forget
    data_browser::set_data
    set data_loaded_from_disk 0
    data_browser::positionate

    busy release .
    update

}

proc global_window::cb_image_browse { } {

    busy hold .
    update

    planes_window::forget
    u_3D::forget
    image_browser::forget
    data_browser::forget
    image_browser::set_data
    image_browser::positionate

    busy release .
    update

}

proc global_window::start_3D { } {

    busy hold .
    update

    planes_window::forget
    u_3D::forget
    image_browser::forget
    data_browser::forget
    u_3D::set_data
    u_3D::positionate

    busy release .
    update

}

proc global_window::show_planes { } {

    busy hold .
    update

    planes_window::forget
    u_3D::forget
    image_browser::forget
    data_browser::forget
    planes_window::set_data
    planes_window::positionate

    busy release .
    update

}

proc global_window::do_quant { } {

    planes_window::do_quant

}

proc global_window::subtract { } {

    # For programming facilities
    upvar global_window::widgets widgets

    set sub_data [ data_browser::get_subdata ]
    
    if { [ llength $sub_data ] == 2 } {
    
        set sub_info [ subtract::show $widgets(work) [ lindex $sub_data 0 ] [ lindex $sub_data 1 ] ]
        busy hold .
        update

        if { [ lindex $sub_info 0 ] == 12 } {

            subtractSeries_dll [ lindex $sub_data 0 ] [ lindex $sub_data 1 ] [ lindex $sub_info 2 ] [ lindex $sub_info 1 ]

        } elseif { [ lindex $sub_info 0 ] == 21 } {

            subtractSeries_dll [ lindex $sub_data 1 ] [ lindex $sub_data 2 ] [ lindex $sub_info 2 ] [ lindex $sub_info 1 ]

        }
        busy release .
        update
    
    }

}

proc global_window::save_data_as_excel { } {

    # For programming facilities
    upvar global_window::widgets widgets

    set fileName "exp_$data_browser::sel_study\_$data_browser::sel_serie\.xls"

    array set arr [ params_dll -1 ]
    set fileName [                                                \
        tk_getSaveFile                                            \
        -initialdir $arr(e_installation_directory)                 \
        -initialfile $fileName                                    \
        -parent $widgets(work)                                    \
        -filetypes { { {Excel Files} {.xls} } { {All files} * } } \
        -defaultextension dat                                     \
        -title $string_table::str_choose_a_file                   \
    ]

    if { $fileName != "" } {

        busy hold .
        update
        set res [ saveAsExcel_dll $fileName ]
        busy release .
        update

    }

}

proc global_window::save_data { } {

    # For programming facilities
    upvar global_window::widgets widgets

    set fileName "exp_$data_browser::sel_study\_$data_browser::sel_serie\.dat"
    set filetext "axis.txt"
    set fileraw "vol.raw"

    array set arr [ params_dll ]
    set fileName [                                               \
        tk_getSaveFile                                           \
        -initialdir $arr(e_installation_directory)                \
        -initialfile $fileName                                   \
        -parent $widgets(work)                                   \
        -filetypes { { {Data Files} {.dat} } { {All files} * } } \
        -defaultextension dat                                    \
        -title $string_table::str_choose_a_file                  \
    ]

#    set fileraw [                                               \
#        tk_getSaveFile                                           \
#        -initialdir $arr(e_installation_directory)                \
#        -initialfile $fileraw                                   \
#        -parent $widgets(work)                                   \
#        -filetypes { { {Raw volumes} {.raw} } } \
#        -defaultextension raw                                    \
#        -title $string_table::str_choose_a_file                  \
#    ]

    set filetext "iamnotforyouruse.txt"
#    set filetext [                                               \
#        tk_getSaveFile                                           \
#        -initialdir $arr(e_installation_directory)                \
#        -initialfile $filetext                                   \
#        -parent $widgets(work)                                   \
#        -filetypes { { {Text Files} {.txt} } } \
#        -defaultextension txt                                    \
#        -title $string_table::str_choose_a_file                  \
#    ]

    if { $fileName != "" } {

        busy hold .
        update
        set res [ SaveExperiment_dll $fileName ]
#        saveVolumeAsRaw_dll $fileraw
        busy release .
        update


    }

}

proc global_window::open_data { } {

    # For programming facilities
    upvar global_window::widgets widgets
    upvar global_window::data_loaded_from_disk data_loaded_from_disk

    array set arr [ params_dll -1 ]
    set fileName [                                               \
        tk_getOpenFile                                           \
        -initialdir $arr(e_installation_directory)                \
        -parent $widgets(work)                                   \
        -filetypes { { {Data Files} {.dat} } { {All files} * } } \
        -defaultextension dat                                    \
        -title $string_table::str_choose_a_file                  \
    ]

    if { $fileName != "" } {

        busy hold .
        update
        set res [ loadExperiment_dll $fileName ]
        set data_loaded_from_disk 1
        busy release .
        update
        array set ser_data [ seriedata_dll [ getStudy_dll ] [ getSerie_dll ] ]
        global_window::set_window_title "$ser_data(ID_Patient_Name) - [ getStudy_dll ]/[ getSerie_dll ]"
        global_window::show_planes

    }

}

proc global_window::set_mouse_left_events { mask } {

    image_browser::set_mouse_left_events $mask
    u_mpr::set_mouse_left_events $mask
    u_mip::set_mouse_left_events $mask
    u_surf::set_mouse_left_events $mask
    planes_window::set_mouse_left_events $mask

}

proc global_window::set_mouse_right_events { mask } {

    image_browser::set_mouse_right_events $mask
    u_mpr::set_mouse_right_events $mask
    u_mip::set_mouse_right_events $mask
    u_surf::set_mouse_right_events $mask
    planes_window::set_mouse_right_events $mask

}

proc global_window::clear { } {

    image_browser::clear
#    planes_window::clear

}

proc global_window::show_wizard { } {

    # For programming facilities
    upvar global_window::widgets widgets

    wizardpostaxis::show $widgets(work)
    wizardpostcontour::show $widgets(work)

}

proc global_window::invoke_buttons { mask } {

    # For programming facilities
    upvar global_window::widgets widgets
    upvar global_window::en_quant          en_quant    
    upvar global_window::en_planes         en_planes   
    upvar global_window::en_3D             en_3D       
    upvar global_window::en_subtract       en_subtract 
    upvar global_window::en_ibrw           en_ibrw     
    upvar global_window::en_params         en_params   
    upvar global_window::en_save           en_save     
    upvar global_window::en_load           en_load     
    upvar global_window::en_open           en_open     
    upvar global_window::en_help           en_help     
    upvar global_window::en_rotate         en_rotate   
    upvar global_window::en_bright         en_bright   
    upvar global_window::en_pan            en_pan      
    upvar global_window::en_zoom           en_zoom     
    upvar global_window::en_clear          en_clear    
    upvar global_window::en_intensity      en_intensity
    upvar global_window::en_linear         en_linear   
    upvar global_window::en_area           en_area     

    if { ( $mask & $en_quant     ) == $en_quant     } { $widgets(btnQuant)          invoke }
    if { ( $mask & $en_planes    ) == $en_planes    } { $widgets(btnPlanes)         invoke }
    if { ( $mask & $en_3D        ) == $en_3D        } { $widgets(btn3D)             invoke }
    if { ( $mask & $en_subtract  ) == $en_subtract  } { $widgets(btnSubtract)       invoke }
    if { ( $mask & $en_ibrw      ) == $en_ibrw      } { $widgets(btnIbrw)           invoke }
    if { ( $mask & $en_params    ) == $en_params    } { $widgets(btnParam)          invoke }
    if { ( $mask & $en_save      ) == $en_save      } { $widgets(btnSaveExperiment) invoke }
    if { ( $mask & $en_load      ) == $en_load      } { $widgets(btnLoadExperiment) invoke }
    if { ( $mask & $en_open      ) == $en_open      } { $widgets(btnChooseDataPath) invoke }
    if { ( $mask & $en_help      ) == $en_help      } { $widgets(btnHelp)           invoke }
    if { ( $mask & $en_rotate    ) == $en_rotate    } { $widgets(btnRotate)         invoke }
    if { ( $mask & $en_bright    ) == $en_bright    } { $widgets(btnBright)         invoke }
    if { ( $mask & $en_pan       ) == $en_pan       } { $widgets(btnPan)            invoke }
    if { ( $mask & $en_zoom      ) == $en_zoom      } { $widgets(btnZoom)           invoke }
    if { ( $mask & $en_clear     ) == $en_clear     } { $widgets(btnClear)          invoke }
    if { ( $mask & $en_intensity ) == $en_intensity } { $widgets(btnIntensity)      invoke }
    if { ( $mask & $en_linear    ) == $en_linear    } { $widgets(btnLinear)         invoke }
    if { ( $mask & $en_area      ) == $en_area      } { $widgets(btnArea)           invoke }

}

proc global_window::deselect_buttons { } {

    # For programming facilities
    upvar global_window::widgets widgets

    $widgets(btnRotate)    deselect
    $widgets(btnBright)    deselect
    $widgets(btnPan)       deselect
    $widgets(btnZoom)      deselect
    $widgets(btnIntensity) deselect
    $widgets(btnLinear)    deselect
    $widgets(btnArea)      deselect

}

proc global_window::set_window_title { title } {

    # For programming facilities
    upvar global_window::widgets widgets

    wm title $widgets(base) "$string_table::str_maracas_title - $title"

}

proc global_window::back { } {

    # For programming facilities
    upvar global_window::data_loaded_from_disk data_loaded_from_disk

    if { [ image_browser::back ] == 1 } {

        global_window::cb_open_data

    } elseif { [ u_3D::back ] == 1 } {

        busy hold .
        update

        if { $data_loaded_from_disk == 1 } {

            set data_browser::sel_study [ getStudy_dll ]
            set data_browser::sel_serie [ getSerie_dll ]
            image_browser::set_data
        
        }
        
        planes_window::forget
        u_3D::forget
        image_browser::forget
        data_browser::forget
        image_browser::positionate

        busy release .
        update

    } elseif { [ planes_window::back ] == 1 } {

        busy hold .
        update

        if { $data_loaded_from_disk == 1 } {
        
            image_browser::set_data2
            u_3D::set_data
            
        }
        planes_window::forget
        u_3D::forget
        image_browser::forget
        data_browser::forget
        u_3D::positionate
        u_3D::controls 2

        busy release .
        update

    }

}

proc global_window::controls { { id -1 } } {
        
    if { $id == -1 } {
        global_window::active_controls 0
    } else {

        global_window::active_controls [  \
            expr                          \
            $global_window::en_params   | \
            $global_window::en_load     | \
            $global_window::en_open     | \
            $global_window::en_help     | \
            0
        ]

    }

}

# EOF - global_window.tcl
