
namespace eval help_wnd {

    namespace export \
        show_logo    \
        show_about

}

proc help_wnd::show_logo { imgpath } {

    catch { destroy .fnLogo }
    toplevel .fnLogo 
    wm title .fnLogo "MARACAS - MAgnetic Resonance Angiography Computer ASsisted analysis"

    frame .fnLogo.buttons
    pack .fnLogo.buttons -side bottom -anchor n -expand 0

    frame .fnLogo.frLogo
    pack .fnLogo.frLogo -side top -anchor n -expand 1 -fill both

    button .fnLogo.buttons.ok -text Ok \
        -command {\
	        destroy .fnLogo
	    }

    pack .fnLogo.buttons.ok

    image create photo imaLogo -file "$imgpath/logocreatis.gif" -format "gif"

    set cLogo .fnLogo.frLogo.cLogo

    canvas $cLogo -width 598 -height 249 -relief sunken -borderwidth 2
    pack $cLogo

    $cLogo create image 0 0 -image imaLogo -anchor nw

}

proc help_wnd::show_about { imgpath } {

    catch { destroy .fnLogo }
    toplevel .fnLogo 
    wm title .fnLogo "MARACAS - MAgnetic Resonance Angiography Computer ASsisted analysis"

    frame .fnLogo.buttons
    pack .fnLogo.buttons -side bottom -anchor n -expand 0

    frame .fnLogo.frLogo
    pack .fnLogo.frLogo -side top -anchor n -expand 1 -fill both

    button .fnLogo.buttons.ok -text Ok \
        -command {\
		    destroy .fnLogo
        }

    pack .fnLogo.buttons.ok

    image create photo imaLogo -file "$imgpath/authors.gif" -format "gif"

    set cLogo .fnLogo.frLogo.cLogo

    canvas $cLogo -width 1000 -height 600 -relief sunken -borderwidth 2
    pack $cLogo

    $cLogo create image 0 0 -image imaLogo -anchor nw

}
