package require ibrowser
package require imagepp
package require BLT
catch { namespace import ibrowser::* }
catch { namespace import imagepp::* }
catch { namespace import blt::* }

namespace eval image_browser {

    # public interface
    namespace export        \
        create              \
        positionate         \
        forget              \
        get_images          \
        get_real_images

    # variables
    variable widgets

    variable first_image -1
    variable last_image -1
    variable image_width  -1
    variable image_height -1
    variable mip_raised    0
    variable actual_image
    variable local_id
    variable shown
    variable return_nothing 0

}

proc image_browser::reset { parent } {

    # For programming facilities
    upvar image_browser::widgets widgets

    set widgets(base)       "$parent"
    set widgets(image_brw)  "$parent\.images"
    set widgets(bottom_brw) "$parent\.images.02"
    set widgets(vert_split) "$parent\.images.03"
    set widgets(right_brw)  "$parent\.images.02.02"
    set widgets(horz_split) "$parent\.images.02.03"
    set widgets(type)       "$parent\.images.02.02.type"
    set widgets(ibrw)       "$parent\.images.01"
    set widgets(impp)       "$parent\.images.02.01"
    set widgets(btnSerie)   "$parent\.images.02.02.type.btnSerie"
    set widgets(btnMIP)     "$parent\.images.02.02.type.btnMIP"
    set widgets(lbl001)     "$parent\.images.02.02.lbl001"
    set widgets(sclSerie)   "$parent\.images.02.02.sclSerie"

}

proc image_browser::create { parent id } {

    # For programming facilities
    upvar image_browser::widgets widgets
    upvar image_browser::image_width  image_width
    upvar image_browser::image_height image_height
    upvar image_browser::mip_raised   mip_raised
    upvar image_browser::local_id  local_id
    upvar image_browser::shown     shown

    set local_id $id
    image_browser::reset $parent
    set shown 0

    # frames
    frame $widgets(image_brw)  -height 1 -width 1
    frame $widgets(bottom_brw) -borderwidth 1 -relief groove 
    frame $widgets(right_brw)  -borderwidth 1 -relief groove 
    frame $widgets(type)       -borderwidth 2 -height 75 -relief groove -width 125 
    frame $widgets(horz_split) -borderwidth 2 -relief raised 
    frame $widgets(vert_split) -borderwidth 2 -relief raised 

    # radio buttons
    set mip_raised 0
    radiobutton $widgets(btnSerie) -text $string_table::str_serie -variable var_type -value 1 -command "image_browser::cb_load_serie"
    radiobutton $widgets(btnMIP)   -text $string_table::str_mip   -variable var_type -value 2 -command "image_browser::cb_load_mip"

    # labels
    label $widgets(lbl001) -borderwidth 0 -text $string_table::str_showtype 

    # scales
    scale $widgets(sclSerie) -label $string_table::str_series -orient horizontal 

    # split bindings
    bind $widgets(horz_split) <B1-Motion> {
        set root [ split %W . ]
        set nb [ llength $root ]
        incr nb -1
        set root [ lreplace $root $nb $nb ]
        set root [ join $root . ]
        set width [ winfo width $root ].0
        set val [ expr (%X - [winfo rootx $root]) /$width ]
        if { $val >= 0 && $val <= 1.0 } {
            place $root.01 -relwidth $val
            place $root.03 -relx $val
            place $root.02 -relwidth [ expr 1.0 - $val ]
        }
    }
    bind $widgets(vert_split) <B1-Motion> {
        set root [ split %W . ]
        set nb [ llength $root ]
        incr nb -1
        set root [ lreplace $root $nb $nb ]
        set root [ join $root . ]
        set height [ winfo height $root ].0
        set val [ expr (%Y - [winfo rooty $root]) /$height ]
        if { $val >= 0 && $val <= 1.0 } {
            place $root.01 -relheight $val
            place $root.03 -rely $val
            place $root.02 -relheight [ expr 1.0 - $val ]
        }
    }

}

proc image_browser::positionate { } {

    # For programming facilities
    upvar image_browser::widgets      widgets
    upvar image_browser::image_width  image_width
    upvar image_browser::image_height image_height
    upvar image_browser::mip_raised   mip_raised
    upvar image_browser::local_id     local_id
    upvar image_browser::shown     shown
    upvar image_browser::return_nothing return_nothing

    set return_nothing 0
    set shown 1
    set global_window::window_shown $local_id

    pack  $widgets(image_brw)  -anchor n -expand 1 -fill both -side top
    place $widgets(ibrw)       -x 0 -y 0 -relwidth 1 -height -1 -relheight 0.25 -anchor nw -bordermode ignore
    place $widgets(bottom_brw) -x 0 -y 0 -rely 1 -relwidth 1 -height -1 -relheight 0.75 -anchor sw -bordermode ignore
    place $widgets(impp)       -x 0 -y 0 -width -1 -relwidth 0.75 -relheight 1 -anchor nw -bordermode ignore
    place $widgets(right_brw)  -x 0 -relx 1 -y 0 -width -1 -relwidth 0.25 -relheight 1 -anchor ne -bordermode ignore
    place $widgets(type)       -x 15 -y 60 -width 110 -height 65 -anchor nw -bordermode ignore
    place $widgets(btnSerie)   -x 20 -y 10 -anchor nw -bordermode ignore
    place $widgets(btnMIP)     -x 20 -y 35 -anchor nw -bordermode ignore
    place $widgets(lbl001)     -x 20 -y 50 -anchor nw -bordermode ignore
    place $widgets(sclSerie)   -x 15 -y 130 -width 200 -anchor nw -bordermode ignore
    place $widgets(horz_split) -x 0 -relx 0.75 -y 0 -rely 0.9 -width 10 -height 10 -anchor s -bordermode ignore
    place $widgets(vert_split) -x 0 -relx 0.9 -y 0 -rely 0.25 -width 10 -height 10 -anchor e -bordermode ignore

    image_browser::controls 0

}

proc image_browser::forget { } {

    # For programming facilities
    upvar image_browser::widgets      widgets
    upvar image_browser::image_width  image_width
    upvar image_browser::image_height image_height
    upvar image_browser::mip_raised   mip_raised
    upvar image_browser::shown     shown

    set shown 0

    place forget $widgets(vert_split)
    place forget $widgets(horz_split)
    place forget $widgets(sclSerie)
    place forget $widgets(lbl001)
    place forget $widgets(btnMIP)
    place forget $widgets(btnSerie)
    place forget $widgets(type)
    place forget $widgets(right_brw)
    catch { place forget $widgets(impp) }
    place forget $widgets(bottom_brw)
    catch { place forget $widgets(ibrw) }
    pack  forget $widgets(image_brw)

}

proc image_browser::set_data { } {

    # For programming facilities
    upvar image_browser::widgets  widgets
    upvar image_browser::local_id local_id

    set global_window::data_loaded [ expr $global_window::data_loaded | $local_id ]

    catch {

        set data [ $widgets(ibrw) curselection ]
        $widgets(ibrw) delete -tags "delete"

    }

    # image browser
    destroy $widgets(ibrw)
    ibrowser $widgets(ibrw)     \
        -borderwidth    1       \
        -cache          1       \
        -fontcolor      #ffff00 \
        -gap            5       \
        -height         1       \
        -multisel       1       \
        -primarycolor   #ff0000 \
        -relief         groove  \
        -secondarycolor #00ff00 \
        -thumbheight    100     \
        -thumbwidth     100     \
        -width          1
    bind $widgets(ibrw) <<AfterSelectFirstImage>> "image_browser::select_image 0"
    bind $widgets(ibrw) <<AfterSelectLastImage>> "image_browser::select_image 1"

    # image pp
    destroy $widgets(impp)
    imagepp $widgets(impp)           \
        -borderwidth 1               \
        -height      10              \
        -initialroi  "10 10 100 100" \
        -relief      groove          \
        -takefocus   0               \
        -width       10
    bind $widgets(impp) <<AfterProfil>> "image_browser::do_profil"

    array set ser_data [ serieData_dll $data_browser::sel_study $data_browser::sel_serie ]
    global_window::set_window_title "$ser_data(ID_Patient_Name) - $data_browser::sel_study/$data_browser::sel_serie"
    LoadImages_dll
    set n [ GetNumberOfImages_dll ]
    set tkNames {}
    for { set i 0 } { $i < $n } { incr i } { lappend tkNames [ image create photo ] }
    set numbers [ GetImagesNumbers_dll ]
    LoadTkImages_dll $tkNames
    set image_browser::first_image -1
    set image_browser::last_image -1

    set i 0
    set fN 0
    set lN 0
    foreach number $numbers {

        if { $i == 0 } { set fN $number }
        set lN $number
        set imgTK [ lindex $tkNames $i ]
        $widgets(ibrw) add                    \
            -image $imgTK                     \
            -tags "id_$i delete" \
            -title "$number"
        $widgets(impp) add -image $imgTK -id "id_$i"

        incr i

    }

    set image_width  [ image width $imgTK ]
    set image_height [ image height $imgTK ]

    $widgets(impp) configure -initialroi "[ expr $image_width * 0.3 ] [ expr $image_height * 0.3 ] [ expr $image_width * 0.7 ] [ expr $image_height * 0.7 ]"
    $widgets(impp) resetroi

    array set arr [ params_dll ]

    $widgets(ibrw) select -tags "id_0"
    set image_browser::first_image $fN
    if { $arr(e_choose_all_slices_default) == 1 } {

        $widgets(ibrw) select -tags "id_[ expr $i - 1 ]" -secondary
        set image_browser::last_image $lN

    }

    $widgets(btnSerie) deselect
    $widgets(btnMIP)   deselect

    if { $arr(e_calculate_mip_default) == 0 } { $widgets(btnSerie) invoke }
    if { $arr(e_calculate_mip_default) == 1 } { $widgets(btnMIP)   invoke }

    $widgets(sclSerie) configure                                         \
        -label "$string_table::str_series : $ser_data(ID_Series_Number)" \
        -from $fN                                                        \
        -to   $lN                                                        \
        -command "image_browser::select_first_image" \
        -resolution 1
    $widgets(sclSerie) set $fN

#    bind $widgets(sclSerie) <ButtonRelease-1> "image_browser::select_first_image"

    image_browser::controls 0

    global_window::deselect_buttons
    global_window::invoke_buttons [ expr \
        $global_window::en_clear     | \
        $global_window::en_intensity   \
    ]

}

proc image_browser::select_first_image { n } {

    # For programming facilities
    upvar image_browser::widgets widgets

#    set n [ $widgets(sclSerie) get ]
    set f [ $widgets(sclSerie) cget -from ]
    set i [ expr $n - $f ]
    set i [ lindex [ split $i . ] 0 ]
    $widgets(impp) show -id "id_$i"
#    $widgets(ibrw) select -tags "id_$i"

}

proc image_browser::cb_load_mip { } {

    # For programming facilities
    upvar image_browser::widgets widgets
    upvar image_browser::mip_raised mip_raised
    upvar image_browser::actual_image actual_image

    set mip_raised 1
    set datas [ $widgets(ibrw) curselection ]
    set images [ list ]
    foreach data $datas { lappend images [ lindex [ lindex $data 2 ] 2 ] }
    set mip [ loadMIPZ_dll $images ]
    set actual_image $mip
    set imgTK [ image create photo ]
    loadTKimage_dll $mip $imgTK
    $widgets(impp) add -image $imgTK -id mip

}

proc image_browser::cb_load_serie { } {

    # For programming facilities
    upvar image_browser::widgets widgets
    upvar image_browser::mip_raised mip_raised
    upvar image_browser::actual_image actual_image

    # $sclSerie configure -state normal
    set mip_raised 0
    set image [ $widgets(ibrw) lastimage ]
    set actual_image [ lindex [ lindex $image 2 ] 2 ]
    set id [ lindex $image 0 ]
    $widgets(impp) show -id $id

}

proc image_browser::select_image { i } {

    # For programming facilities
    upvar image_browser::widgets widgets
    upvar image_browser::mip_raised mip_raised

    if { $mip_raised == 0 } { cb_load_serie }
    if { $mip_raised == 1 } { cb_load_mip }
    set image [ $widgets(ibrw) lastimage ]
    set pos [ expr [ lindex [ split [ lindex [ lindex $image 2 ] 0 ] _ ] 1 ] + [ $widgets(sclSerie) cget -from ] ]
    $widgets(sclSerie) set $pos

    if { $i == 0 } { set image_browser::first_image $pos }
    if { $i == 1 } { set image_browser::last_image $pos }
    puts "$image_browser::first_image : $image_browser::last_image"

}

proc image_browser::set_data2 { } {

    # For programming facilities
    upvar image_browser::return_nothing return_nothing

    set return_nothing 1

}

proc image_browser::get_data { } {

    # For programming facilities
    upvar image_browser::widgets widgets
    upvar image_browser::mip_raised mip_raised
    upvar image_browser::return_nothing return_nothing

    if { $return_nothing == 0 } {

        set fr [ string trimleft [ $widgets(sclSerie) cget -from ] 0 ]
        set f  [ string trimleft $image_browser::first_image 0 ]
        set l  [ string trimleft $image_browser::last_image 0 ]

        set f [ expr $f - $fr ]
        set l [ expr $l - $fr ]

        set f [ expr ( $f < $l )? $f: $l ]
        set l [ expr ( $f > $l )? $f: $l ]

        set data [ $widgets(ibrw) curselection ]
        set roi  [ $widgets(impp) roi ]
        set roi  [ list \
            [ lindex [ split [ lindex $roi 0 ] . ] 0 ] \
            [ lindex [ split [ lindex $roi 2 ] . ] 0 ] \
            [ lindex [ split [ lindex $roi 1 ] . ] 0 ] \
            [ lindex [ split [ lindex $roi 3 ] . ] 0 ] \
            [ lindex [ split $f . ] 0 ] \
            [ lindex [ split $l . ] 0 ] \
        ]

        return $roi

    } else { return "" }

}

proc image_browser::set_mouse_left_events { mask } {

    # For programming facilities
    upvar image_browser::widgets widgets

    if { [ expr ( $mask & 0x1 ) ] == 0x1 }  { $widgets(impp) setnone }

}

proc image_browser::set_mouse_right_events { mask } {

    # For programming facilities
    upvar image_browser::widgets widgets

    if { [ expr ( $mask & 0x1 ) ] == 0x1 }  { catch { $widgets(impp) setarea } }
    if { [ expr ( $mask & 0x2 ) ] == 0x2 }  { catch { $widgets(impp) setlinear } }

}

proc image_browser::clear { } {

    # For programming facilities
    upvar image_browser::widgets widgets

    catch { $widgets(impp) clean }

}

proc image_browser::do_profil { } {

    # For programming facilities
    upvar image_browser::widgets widgets
    upvar image_browser::actual_image actual_image

    set data [ $widgets(impp) getprofildata ]

    if { [ lindex $data 0 ] == 1 } {

        busy hold .
        update

        set n [ $widgets(sclSerie) get ]
        set f [ $widgets(sclSerie) cget -from ]
        set i [ expr $n - $f ]
        set i [ lindex [ split $i . ] 0 ]
        set avals [ GetProfilFromTotalVolume_dll [ lindex $data 1 ] [ lindex $data 2 ] $i [ lindex $data 3 ] [ lindex $data 4 ] $i ]
        #avals[ 0 ] = min
        #avals[ 1 ] = max
        #avals[ 2 ] = avg
        #avals[ 3 ] = sd
        #avals[ 4 ] = size
        set xvals {}
        set yvals {}
        set size [ lindex $avals 4 ]
        for { set i 0 } { $i < $size } { incr i } {

            lappend xvals $i
            lappend yvals [ lindex $avals [ expr $i + 5 ] ]

        }

        catch { destroy "$widgets(impp)\.fnProfil" }
        toplevel "$widgets(impp)\.fnProfil" -width 640 -height 480

        graph $widgets(impp)\.fnProfil.gr \
            -background white \
            -barmode infront \
            -borderwidth 0 \
            -foreground black \
            -halo 8 \
            -height 480 \
            -plotpadx {8 8} \
            -plotpady {8 8} \
            -plotrelief groove \
            -width 640
        pack $widgets(impp)\.fnProfil.gr -anchor center -expand 1 -fill both -side top 
        $widgets(impp)\.fnProfil.gr axis configure y -min 0.00
        $widgets(impp)\.fnProfil.gr grid configure  -hide no
        $widgets(impp)\.fnProfil.gr legend configure -position bottom -font {Helvetica -14 bold}

        $widgets(impp)\.fnProfil.gr element create "Profile" \
            -color #0000ff \
            -symbol "" \
            -xdata $xvals \
            -ydata $yvals

        set x [ expr $size / 2 ]
        set y [ expr [ lindex $avals 1 ] * 0.75 ]
        set text "$string_table::str_min = [ lindex $avals 0 ]\n$string_table::str_max = [ lindex $avals 1 ]\n$string_table::str_avg = [ lindex $avals 2 ]\n$string_table::str_std = [ lindex $avals 3 ]\n$string_table::str_nro_pix = [ lindex $avals 4 ]"
        $widgets(impp)\.fnProfil.gr marker create text -text $text \
            -coords "$x $y" -font { Helvetica 20 }

        busy release .
        update

    } elseif { [ lindex $data 0 ] == 2 } {

        busy hold .
        update
        set n [ $widgets(sclSerie) get ]
        set f [ $widgets(sclSerie) cget -from ]
        set i [ expr $n - $f ]
        set i [ lindex [ split $i . ] 0 ]
        set avals [ GetAreaValuesFromTotalVolume_dll [ lindex $data 1 ] [ lindex $data 2 ] $i [ lindex $data 3 ] [ lindex $data 4 ] $i ]
        $widgets(impp) addtext "$string_table::str_min = [ lindex $avals 0 ]\n$string_table::str_max = [ lindex $avals 1 ]\n$string_table::str_avg = [ lindex $avals 2 ]\n$string_table::str_std = [ lindex $avals 3 ]\n$string_table::str_nro_pix = [ lindex $avals 4 ]" [ lindex $data 3 ] [ lindex $data 4 ]
        busy release .
        update

    } elseif { [ lindex $data 0 ] == 3 } {

        set n [ $widgets(sclSerie) get ]
        set f [ $widgets(sclSerie) cget -from ]
        set i [ expr $n - $f ]
        set i [ lindex [ split $i . ] 0 ]
        set val [ GetImageIntensity_dll [ lindex $data 3 ] [ lindex $data 4 ] $i ]
        $widgets(impp) addtext "$string_table::str_int = $val" [ lindex $data 3 ] [ lindex $data 4 ]

    } elseif { [ lindex $data 0 ] == 4 } {

        $widgets(impp) clean

    }

}

proc image_browser::back { } {

    # For programming facilities
    upvar image_browser::shown shown

    set ret $shown
    set shown 0

    return $ret

}

proc image_browser::controls { { id -1 } } {

    if { $id == -1 } {

        global_window::active_controls 0

    } else {

        if { $id == 0 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_3D        | \
                $global_window::en_params    | \
                $global_window::en_save      | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                $global_window::en_clear     | \
                $global_window::en_intensity | \
                $global_window::en_linear    | \
                $global_window::en_area      | \
                $global_window::en_back      | \
                0
            ]

        } elseif { $id == 1 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_params    | \
                $global_window::en_save      | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                $global_window::en_clear     | \
                $global_window::en_intensity | \
                $global_window::en_linear    | \
                $global_window::en_area      | \
                $global_window::en_back      | \
                0
            ]

        }

    }

}

# EOF - image_browser.tcl
