package require BLT
catch { namespace import blt::* }

namespace eval planes_window {

    # public interface
    namespace export        \
        create              \
        positionate         \
        forget
    
    # variables
    variable widgets

    variable reference_actor
    variable surf_data
    variable actual_actor
    variable quant_actor
    variable bounds
    variable intRange
    variable axis_index -1
    variable nClicks 0
    variable quantifing 0
    variable first_point_quant
    variable last_point_quant
    variable real_first_point_quant -1
    variable real_last_point_quant  -1
    variable actor_debug1
    variable actor_debug2
    variable initX
    variable initY
    variable initWindow
    variable initLevel
    variable man_points {}
    variable show_hs_var
    variable first_quant
    variable local_id
    variable show_rings
    variable rings_index {}
    variable quant_shown 0

    variable actual_area    0.00
    variable actual_peri    0.00
    variable actual_darea   0.00
    variable actual_dperi   0.00
    variable actual_dmax    0.00
    variable actual_dmin    0.00
    variable actual_davg    0.00
    variable actual_sten    0.00
    variable actual_partial 0.00
    variable actual_total   0.00

    variable actual_quant_x     {}
    variable actual_quant_area  {}
    variable actual_quant_peri  {}
    variable actual_quant_darea {}
    variable actual_quant_dperi {}
    variable actual_quant_dmax  {}
    variable actual_quant_dmin  {}
    variable actual_quant_davg  {}
    variable actual_quant_sten  {}
    variable shown 0
    variable given_points 0

}

proc planes_window::reset { parent } {

    # For programming facilities
    upvar planes_window::widgets widgets

    set widgets(base)              "$parent"
    set widgets(planes_wnd)        "$parent\.planes_wnd"
    set widgets(frTop)             "$parent\.planes_wnd.frTop"
    set widgets(frLeft)            "$parent\.planes_wnd.frTop.frLeft"
    set widgets(frRight)           "$parent\.planes_wnd.frTop.frRight"
    set widgets(work3D)            "$parent\.planes_wnd.frTop.frLeft.work3D"
    set widgets(frControls)        "$parent\.planes_wnd.frTop.frLeft.frControls"
    set widgets(frPlanes)          "$parent\.planes_wnd.frTop.frLeft.frControls.frPlanes"
    set widgets(btnSHealthySlice)  "$parent\.planes_wnd.frTop.frLeft.frControls.frPlanes.btnSHealthySlice"
    set widgets(btnPerpendicular)  "$parent\.planes_wnd.frTop.frLeft.frControls.frPlanes.btnPerpendicular"
    set widgets(frColor)           "$parent\.planes_wnd.frTop.frLeft.frControls.frColor"
    set widgets(btnGreyScale)      "$parent\.planes_wnd.frTop.frLeft.frControls.frColor.btnGreyScale"
    set widgets(btnColor)          "$parent\.planes_wnd.frTop.frLeft.frControls.frColor.btnColor"
    set widgets(frSurfaces)        "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces"
    set widgets(btnTransparent)    "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces.btnTransparent"
    set widgets(btnEdge)           "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces.btnEdge"
    set widgets(btnOpaque)         "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces.btnOpaque"
    set widgets(btnShowS)          "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces.btnShowS"
    set widgets(btnRings)          "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces.btnRings"
    set widgets(btnSurface)        "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces.btnSurface"
    set widgets(btnSColor)         "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces.btnSColor"
    set widgets(lbl001)            "$parent\.planes_wnd.frTop.frLeft.frControls.frSurfaces.lbl001"
    set widgets(frBrowsers)        "$parent\.planes_wnd.frTop.frLeft.frControls.frBrowsers"
    set widgets(sclSlice)          "$parent\.planes_wnd.frTop.frLeft.frControls.frBrowsers.sclSlice"
    set widgets(sclIsoVal)         "$parent\.planes_wnd.frTop.frLeft.frControls.frBrowsers.sclIsoVal"
    set widgets(sclOpacity)        "$parent\.planes_wnd.frTop.frLeft.frControls.frBrowsers.sclOpacity"
    set widgets(fr2D)              "$parent\.planes_wnd.frTop.frRight.fr2D"
    set widgets(image2D)           "$parent\.planes_wnd.frTop.frRight.fr2D.image2D"
    set widgets(frControls2D)      "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D"
    set widgets(fr001)             "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D.fr001"
    set widgets(btnContour)        "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D.fr001.btnContour"
    set widgets(btnClean)          "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D.fr001.btnClean"
    set widgets(btnHealthySlice)   "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D.fr001.btnHealthySlice"
    set widgets(btnCalculated)     "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D.fr001.btnCalculated"
    set widgets(btnPause)          "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D.fr001.btnPause"
    set widgets(btnEraseQuant)     "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D.fr001.btnEraseQuant"
    set widgets(btnSetPoint)       "$parent\.planes_wnd.frTop.frRight.fr2D.frControls2D.fr001.btnSetPoint"
    set widgets(frBLT)             "$parent\.planes_wnd.frTop.frRight.frBLT"
    set widgets(graph)             "$parent\.planes_wnd.frTop.frRight.frBLT.graph"
    set widgets(frData)            "$parent\.planes_wnd.frData"
    set widgets(frPartialAxis)     "$parent\.planes_wnd.frData.frPartialArea"
    set widgets(frTotalAxis)       "$parent\.planes_wnd.frData.frTotalArea"
    set widgets(frArea)            "$parent\.planes_wnd.frData.frArea"
    set widgets(frPerimeter)       "$parent\.planes_wnd.frData.frPerimeter"
    set widgets(frDiamArea)        "$parent\.planes_wnd.frData.frDiamArea"
    set widgets(frDiamPerimeter)   "$parent\.planes_wnd.frData.frDiamPerimeter"
    set widgets(frDiamMax)         "$parent\.planes_wnd.frData.frDiamMax"
    set widgets(frDiamMin)         "$parent\.planes_wnd.frData.frDiamMin"
    set widgets(frDiamAvg)         "$parent\.planes_wnd.frData.frDiamAvg"
    set widgets(frStenosis)        "$parent\.planes_wnd.frData.frStenosis"
    set widgets(lblArea)           "$parent\.planes_wnd.frData.frArea.lblArea"
    set widgets(lblPerimeter)      "$parent\.planes_wnd.frData.frPerimeter.lblPerimeter"
    set widgets(lblDiamArea)       "$parent\.planes_wnd.frData.frDiamArea.lblDiamArea"
    set widgets(lblDiamPerimeter)  "$parent\.planes_wnd.frData.frDiamPerimeter.lblDiamPerimeter"
    set widgets(lblDiamMax)        "$parent\.planes_wnd.frData.frDiamMax.lblDiamMax"
    set widgets(lblDiamMin)        "$parent\.planes_wnd.frData.frDiamMin.lblDiamMin"
    set widgets(lblDiamAvg)        "$parent\.planes_wnd.frData.frDiamAvg.lblDiamAvg"
    set widgets(lblStenosis)       "$parent\.planes_wnd.frData.frStenosis.lblStenosis"
    set widgets(lblPartialAxis)    "$parent\.planes_wnd.frData.frPartialArea.lblPartialArea"
    set widgets(lblTotalAxis)      "$parent\.planes_wnd.frData.frTotalArea.lblTotalArea"
    set widgets(vlblArea)          "$parent\.planes_wnd.frData.frArea.vlblArea"
    set widgets(vlblPerimeter)     "$parent\.planes_wnd.frData.frPerimeter.vlblPerimeter"
    set widgets(vlblDiamArea)      "$parent\.planes_wnd.frData.frDiamArea.vlblDiamArea"
    set widgets(vlblDiamPerimeter) "$parent\.planes_wnd.frData.frDiamPerimeter.vlblDiamPerimeter"
    set widgets(vlblDiamMax)       "$parent\.planes_wnd.frData.frDiamMax.vlblDiamMax"
    set widgets(vlblDiamMin)       "$parent\.planes_wnd.frData.frDiamMin.vlblDiamMin"
    set widgets(vlblDiamAvg)       "$parent\.planes_wnd.frData.frDiamAvg.vlblDiamAvg"
    set widgets(vlblStenosis)      "$parent\.planes_wnd.frData.frStenosis.vlblStenosis"
    set widgets(vlblPartialAxis)   "$parent\.planes_wnd.frData.frPartialArea.vlblPartialArea"
    set widgets(vlblTotalAxis)     "$parent\.planes_wnd.frData.frTotalArea.vlblTotalArea"

}

proc planes_window::create { parent id } {

    # For programming facilities
    upvar planes_window::widgets        widgets
    upvar planes_window::local_id       local_id
    upvar planes_window::actual_area    actual_area
    upvar planes_window::actual_peri    actual_peri
    upvar planes_window::actual_darea   actual_darea
    upvar planes_window::actual_dperi   actual_dperi
    upvar planes_window::actual_dmax    actual_dmax
    upvar planes_window::actual_dmin    actual_dmin
    upvar planes_window::actual_davg    actual_davg
    upvar planes_window::actual_sten    actual_sten
    upvar planes_window::actual_partial actual_partial
    upvar planes_window::actual_total   actual_total
    upvar planes_window::quant_shown    quant_shown
    upvar planes_window::shown          shown

    set shown 0

    set local_id $id
    set quant_shown 0

    planes_window::reset $parent

    # frames
    frame $widgets(planes_wnd)   -height 100 -width 125 
    frame $widgets(frTop)        -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frLeft)       -borderwidth 0 -height 1 -relief flat   -width 1
    frame $widgets(frControls)   -borderwidth 2 -height 112 -relief groove -width 100
    frame $widgets(frPlanes)     -borderwidth 0 -height 1 -relief groove -width 1
    frame $widgets(frColor)      -borderwidth 0 -height 1 -relief groove -width 1
    frame $widgets(frSurfaces)   -borderwidth 0 -height 1 -relief groove -width 1
    frame $widgets(frBrowsers)   -borderwidth 0 -height 1 -relief groove -width 1
    frame $widgets(frRight)      -borderwidth 0 -height 1 -relief flat   -width 1
    frame $widgets(fr2D)         -borderwidth 0 -height 1 -relief flat   -width 1
    frame $widgets(frControls2D) -borderwidth 0 -height 1 -relief flat   -width 1
    frame $widgets(fr001)        -borderwidth 2 -height 1 -relief groove -width 1
    frame $widgets(frBLT)        -borderwidth 0 -height 1 -relief flat   -width 1
    frame $widgets(frData)       -borderwidth 0 -height 1 -relief flat -width 1

    frame $widgets(frPartialAxis)   -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frTotalAxis)     -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frArea)          -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frPerimeter)     -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frDiamArea)      -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frDiamPerimeter) -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frDiamMax)       -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frDiamMin)       -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frDiamAvg)       -borderwidth 0 -height 1 -relief flat -width 1
    frame $widgets(frStenosis)      -borderwidth 0 -height 1 -relief flat -width 1
    
    # checkbuttons
    checkbutton $widgets(btnSHealthySlice)  -text $string_table::str_healthy_slice         -variable var_healthy -command { planes_window::show_hs_3D $var_healthy } 
    checkbutton $widgets(btnShowS)          -text $string_table::str_show_surf             -variable var_showS   -command { planes_window::set_IsoActor [ expr ( $var_showS == 0 )? 4: $planes_window::actual_actor ] }
    checkbutton $widgets(btnRings)          -text $string_table::str_rings_visible         -variable var_rings   -command { planes_window::show3D_rings_contour $var_rings }
    checkbutton $widgets(btnSurface)        -text $string_table::str_rec_surface           -variable var_rec     -command { planes_window::load_reconstructed_surface $var_rec }
    checkbutton $widgets(btnPerpendicular)  -text $string_table::str_perpendicular_section -variable var_perp    -command { planes_window::put_plane_3D $var_perp }

    # radiobuttons
    radiobutton $widgets(btnGreyScale)   -text $string_table::str_greyscale -variable color_type -value 1 -command { planes_window::set_color_table $color_type }
    radiobutton $widgets(btnColor)       -text $string_table::str_color     -variable color_type -value 2 -command { planes_window::set_color_table $color_type }

    radiobutton $widgets(btnOpaque)      -text $string_table::str_opaque      -variable surf_type -value 1 -command { planes_window::set_IsoActor $surf_type }
    radiobutton $widgets(btnTransparent) -text $string_table::str_transparent -variable surf_type -value 2 -command { planes_window::set_IsoActor $surf_type }
    radiobutton $widgets(btnEdge)        -text $string_table::str_edge_points -variable surf_type -value 3 -command { planes_window::set_IsoActor $surf_type }

    # buttons
    button $widgets(btnSColor)       -command "planes_window::change_color"

    button $widgets(btnContour)      -text $string_table::str_contour
    button $widgets(btnClean)        -text $string_table::str_clean         -command "planes_window::clean_contour"
    button $widgets(btnHealthySlice) -text $string_table::str_healthy_slice -command "planes_window::set_healthy_slice"
    button $widgets(btnCalculated)   -text $string_table::str_calculated    -command "planes_window::contour_calculated"
    button $widgets(btnPause)        -text $string_table::str_pause         -command "planes_window::pause"
    button $widgets(btnEraseQuant)   -text $string_table::str_erase_quant   -command "planes_window::erase_all_data"
    button $widgets(btnSetPoint)     -text "Point..." -command "planes_window::set_quant_point_from_scale"

    # scales
    scale $widgets(sclSlice)   -label $string_table::str_slice   -orient horizontal 
    scale $widgets(sclIsoVal)  -label $string_table::str_isoval  -orient horizontal 
    scale $widgets(sclOpacity) -label $string_table::str_opacity -orient horizontal 

    # labels
    label $widgets(lbl001)                                         -text $string_table::str_color 
    label $widgets(lblArea)          -borderwidth 1 -relief groove -text $string_table::str_area
    label $widgets(lblPerimeter)     -borderwidth 1 -relief groove -text $string_table::str_peri
    label $widgets(lblDiamArea)      -borderwidth 1 -relief groove -text $string_table::str_diam_area
    label $widgets(lblDiamPerimeter) -borderwidth 1 -relief groove -text $string_table::str_diam_peri
    label $widgets(lblDiamMax)       -borderwidth 1 -relief groove -text $string_table::str_diam_max
    label $widgets(lblDiamMin)       -borderwidth 1 -relief groove -text $string_table::str_diam_min
    label $widgets(lblDiamAvg)       -borderwidth 1 -relief groove -text $string_table::str_diam_avg
    label $widgets(lblStenosis)      -borderwidth 1 -relief groove -text Stenosis
    label $widgets(lblPartialAxis)   -borderwidth 1 -relief groove -text "Partial Axis Length"
    label $widgets(lblTotalAxis)     -borderwidth 1 -relief groove -text "Total Axis Length"

    label $widgets(vlblArea)          -borderwidth 1 -relief groove -textvariable planes_window::actual_area
    label $widgets(vlblPerimeter)     -borderwidth 1 -relief groove -textvariable planes_window::actual_peri
    label $widgets(vlblDiamArea)      -borderwidth 1 -relief groove -textvariable planes_window::actual_darea
    label $widgets(vlblDiamPerimeter) -borderwidth 1 -relief groove -textvariable planes_window::actual_dperi
    label $widgets(vlblDiamMax)       -borderwidth 1 -relief groove -textvariable planes_window::actual_dmax
    label $widgets(vlblDiamMin)       -borderwidth 1 -relief groove -textvariable planes_window::actual_dmin
    label $widgets(vlblDiamAvg)       -borderwidth 1 -relief groove -textvariable planes_window::actual_davg
    label $widgets(vlblStenosis)      -borderwidth 1 -relief groove -textvariable planes_window::actual_sten
    label $widgets(vlblPartialAxis)   -borderwidth 1 -relief groove -textvariable planes_window::actual_partial
    label $widgets(vlblTotalAxis)     -borderwidth 1 -relief groove -textvariable planes_window::actual_total

    # BLT graph
    graph $widgets(graph) \
        -background white \
        -barmode infront \
        -borderwidth 0 \
        -foreground black \
        -halo 8 \
        -height 75 \
        -plotpadx {8 8} \
        -plotpady {8 8} \
        -plotrelief groove \
        -width 480 

}

proc planes_window::positionate { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::local_id  local_id
    upvar planes_window::first_quant  first_quant
    upvar planes_window::local_id  local_id
    upvar planes_window::shown          shown
    upvar planes_window::given_points  given_points

    set given_points 0

    set shown 1

    set global_window::show_params 0

    set first_quant 1
    set global_window::window_shown $local_id

    pack  $widgets(planes_wnd)       -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frTop)            -anchor center -expand 1 -fill both -side top
    pack  $widgets(frLeft)           -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(work3D)           -anchor center -expand 1 -fill both -side top
    pack  $widgets(frControls)       -anchor center -expand 0 -fill both -side top
    place $widgets(frPlanes)         -x 10 -y 2 -width 300 -height 25 -anchor nw -bordermode ignore 
    place $widgets(btnSHealthySlice) -x 5 -y 0 -anchor nw -bordermode ignore 
    place $widgets(btnPerpendicular) -x 100 -y 0 -anchor nw -bordermode ignore 
    place $widgets(frColor)          -x 350 -y 2 -width 150 -height 25 -anchor nw -bordermode ignore 
    place $widgets(btnGreyScale)     -x 5 -y 0 -anchor nw -bordermode ignore 
    place $widgets(btnColor)         -x 80 -y 0 -anchor nw -bordermode ignore 
    place $widgets(frSurfaces)       -x 10 -y 27 -width 400 -height 25 -anchor nw -bordermode ignore 
    #place $widgets(btnSurface)       -x 5 -y 0 -anchor nw -bordermode ignore 
    place $widgets(btnRings)         -x 150 -y 0 -anchor nw -bordermode ignore 
    place $widgets(btnShowS)         -x 250 -y 0 -anchor nw -bordermode ignore 
    place $widgets(frBrowsers)       -x 10 -y 50 -width 515 -height 60 -anchor nw -bordermode ignore
    place $widgets(sclSlice)         -x 5 -y 0 -width 163 -height 60 -anchor nw -bordermode ignore 
    place $widgets(sclIsoVal)        -x 175 -y 0 -width 163 -height 60 -anchor nw -bordermode ignore 
    place $widgets(sclOpacity)       -x 350 -y 0 -width 158 -height 60 -anchor nw -bordermode ignore 
    pack  $widgets(frRight)          -anchor center -expand 0 -fill both -side left
    pack  $widgets(fr2D)             -anchor center -expand 1 -fill both -side top 
    pack  $widgets(image2D)          -anchor center -expand 1 -fill both -side top 
    pack  $widgets(frControls2D)     -anchor center -expand 0 -fill x -side top 
    pack  $widgets(fr001)            -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnContour)       -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnClean)         -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnHealthySlice)  -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnCalculated)    -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnPause)         -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnEraseQuant)    -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(btnSetPoint)      -anchor nw -expand 0 -fill none -side left 
    pack  $widgets(frBLT)            -anchor center -expand 1 -fill both -side top 
    pack  $widgets(graph)            -anchor center -expand 1 -fill both -side top 
    pack  $widgets(frData)           -anchor center -expand 0 -fill x -side top 
    pack  $widgets(frPartialAxis)    -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frTotalAxis)      -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frArea)           -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frPerimeter)      -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frDiamArea)       -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frDiamPerimeter)  -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frDiamMax)        -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frDiamMin)        -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frDiamAvg)        -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(frStenosis)       -anchor nw -expand 1 -fill both -side left 
    pack  $widgets(lblArea)           -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblPerimeter)      -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblDiamArea)       -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblDiamPerimeter)  -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblDiamMax)        -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblDiamMin)        -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblDiamAvg)        -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblStenosis)       -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblPartialAxis)   -anchor center -expand 1 -fill both -side top 
    pack  $widgets(lblTotalAxis)     -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblArea)          -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblPerimeter)     -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblDiamArea)      -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblDiamPerimeter) -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblDiamMax)       -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblDiamMin)       -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblDiamAvg)       -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblStenosis)      -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblPartialAxis)   -anchor center -expand 1 -fill both -side top 
    pack  $widgets(vlblTotalAxis)     -anchor center -expand 1 -fill both -side top 

}

proc planes_window::forget { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::shown   shown

    set shown 0

    pack  forget $widgets(vlblStenosis)
    pack  forget $widgets(vlblDiamAvg)
    pack  forget $widgets(vlblDiamMin)
    pack  forget $widgets(vlblDiamMax)
    pack  forget $widgets(vlblDiamPerimeter)
    pack  forget $widgets(vlblDiamArea)
    pack  forget $widgets(vlblPerimeter)
    pack  forget $widgets(vlblArea)
    pack  forget $widgets(lblStenosis)
    pack  forget $widgets(lblDiamAvg)
    pack  forget $widgets(lblDiamMin)
    pack  forget $widgets(lblDiamMax)
    pack  forget $widgets(lblDiamPerimeter)
    pack  forget $widgets(lblDiamArea)
    pack  forget $widgets(lblPerimeter)
    pack  forget $widgets(lblArea)
    pack  forget $widgets(frStenosis)
    pack  forget $widgets(frDiamAvg)
    pack  forget $widgets(frDiamMin)
    pack  forget $widgets(frDiamMax)
    pack  forget $widgets(frDiamPerimeter)
    pack  forget $widgets(frDiamArea)
    pack  forget $widgets(frPerimeter)
    pack  forget $widgets(frArea)
    pack  forget $widgets(frData)
    pack  forget $widgets(graph)
    pack  forget $widgets(frBLT)
    pack  forget $widgets(btnEraseQuant)
    pack  forget $widgets(btnPause)
    pack  forget $widgets(btnCalculated)
    pack  forget $widgets(btnHealthySlice)
    pack  forget $widgets(btnClean)
    pack  forget $widgets(btnContour)
    pack  forget $widgets(fr001)
    pack  forget $widgets(frControls2D)
    pack  forget $widgets(image2D)
    pack  forget $widgets(fr2D)
    pack  forget $widgets(frRight)
    place forget $widgets(sclOpacity)
    place forget $widgets(sclIsoVal)
    place forget $widgets(sclSlice)
    place forget $widgets(frBrowsers)
    place forget $widgets(lbl001)
    place forget $widgets(btnSColor)
    place forget $widgets(btnShowS)
    place forget $widgets(btnSurface)
    place forget $widgets(btnRings)
    place forget $widgets(btnOpaque)
    place forget $widgets(btnEdge)
    place forget $widgets(btnTransparent)
    place forget $widgets(frSurfaces)
    place forget $widgets(btnColor)
    place forget $widgets(btnGreyScale)
    place forget $widgets(frColor)
    place forget $widgets(btnPerpendicular)
    place forget $widgets(btnSHealthySlice)
    place forget $widgets(frPlanes)
    pack  forget $widgets(frControls)
    pack  forget $widgets(work3D)
    pack  forget $widgets(frLeft)
    pack  forget $widgets(frTop)
    pack  forget $widgets(planes_wnd)

}

proc planes_window::set_data { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index       axis_index
    upvar planes_window::first_point_quant first_point_quant
    upvar planes_window::last_point_quant last_point_quant
    upvar planes_window::first_quant       first_quant
    upvar planes_window::local_id  local_id
    upvar planes_window::actual_area  actual_area
    upvar planes_window::actual_peri  actual_peri
    upvar planes_window::actual_darea actual_darea
    upvar planes_window::actual_dperi actual_dperi
    upvar planes_window::actual_dmax  actual_dmax
    upvar planes_window::actual_dmin  actual_dmin
    upvar planes_window::actual_davg  actual_davg
    upvar planes_window::actual_sten  actual_sten
    upvar planes_window::rings_index  rings_index
    upvar planes_window::quant_shown  quant_shown
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant real_last_point_quant
    upvar planes_window::actual_partial  actual_partial
    upvar planes_window::actual_total    actual_total

    set real_first_point_quant -1
    set real_last_point_quant -1
    planes_window::controls 1

    catch { renderer_$widgets(work3D) RemoveActor hs_actor_$widgets(work3D) }
    catch { hs_actor_$widgets(work3D) Delete }
    catch { hs_mapper_$widgets(work3D) Delete }
    catch { hs_grid_$widgets(work3D) Delete }
    catch { hs_points_$widgets(work3D) Delete }
    catch { hs_poly_line_$widgets(work3D) Delete }
    foreach i $rings_index {

        catch { renderer_$widgets(work3D) RemoveActor cont3DActor_{$widgets(work3D)}_{$i} }
        catch { cont3DActor_{$widgets(work3D)}_{$i}    Delete }
        catch { cont3DMapper_{$widgets(work3D)}_{$i}   Delete }
        catch { cont3DGrid_{$widgets(work3D)}_{$i}     Delete }
        catch { cont3DPolyLine_{$widgets(work3D)}_{$i} Delete }
        catch { cont3DPoints_{$widgets(work3D)}_{$i}   Delete }

    }
    set rings_index [ list ]

    set actual_area  0.00
    set actual_peri  0.00
    set actual_darea 0.00
    set actual_dperi 0.00
    set actual_dmax  0.00
    set actual_dmin  0.00
    set actual_davg  0.00
    set actual_sten  0.00
    set quant_shown  0
    set global_window::data_loaded [ expr $global_window::data_loaded | $local_id ]

    set actual_quant_x     [ list ]
    set actual_quant_area  [ list ]
    set actual_quant_peri  [ list ]
    set actual_quant_darea [ list ]
    set actual_quant_dperi [ list ]
    set actual_quant_dmax  [ list ]
    set actual_quant_dmin  [ list ]
    set actual_quant_davg  [ list ]
    set actual_quant_sten  [ list ]

    planes_window::clean_BLT
    catch { $widgets(graph) marker delete line_healthy_slice }
    
    set first_quant 1

    # vtk controls
    destroy $widgets(work3D)
    destroy $widgets(image2D)
    vtkTkRenderWidget $widgets(work3D)  -width 30 -height 30
    vtkTkRenderWidget $widgets(image2D) -width 30 -height 30

    # TODO: change
    bindBasicEvents $widgets(work3D)
    bindBasicEvents $widgets(image2D)

    bind $widgets(work3D) <Double-Button-1> "planes_window::select_axis_point %x %y"
    bind $widgets(work3D) <Double-Button-2> "planes_window::set_plane_3D %x %y"
    bind $widgets(work3D) <Double-Button-3> "planes_window::set_plane_3D %x %y"

    bind $widgets(image2D) <Double-Button-1> "planes_window::extract_contour %x %y 1"
    bind $widgets(image2D) <Double-Button-3> "planes_window::add_point_contour_manual %x %y"

    catch { renderer_$widgets(work3D) Delete }
    catch { renderer_$widgets(image2D) Delete }
    vtkRenderer renderer_$widgets(work3D)
    vtkRenderer renderer_$widgets(image2D)

    set render [ $widgets(work3D) GetRenderWindow ]
#    renderer_$widgets(work3D) SetBackground 0.5 0.5 0.5
	renderer_$widgets(work3D) SetBackground 0.75 0.75 0.75
#    renderer_$widgets(work3D) SetBackground 0 0 0
    $render AddRenderer renderer_$widgets(work3D)
    $render SetSize 1 1

    set render [ $widgets(image2D) GetRenderWindow ]
#    renderer_$widgets(image2D) SetBackground 0.5 0.5 0.5
    renderer_$widgets(image2D) SetBackground 0 0 0
    $render AddRenderer renderer_$widgets(image2D)
    $render SetSize 1 1

    set range    [ GetImageRange_dll ]
    set resample [ GetVTKVolume_dll ]
    set bounds   [ $resample GetBounds ]
    $widgets(btnSColor) configure -background #faebd6
    set r 0.9803
    set g 0.9215
    set b 0.8392
    set actual_total [ change_float_precision [ getAxisLength_dll ] 2 ]
    set actual_partial 0.00

    catch { renderer_$widgets(work3D) RemoveActor outlineActor_$widgets(work3D) }
    catch { renderer_$widgets(work3D) RemoveActor isoActor_$widgets(work3D) }
    catch { renderer_$widgets(work3D) RemoveActor edgeActor_$widgets(work3D) }
    catch { renderer_$widgets(work3D) RemoveVolume opaqueVol_$widgets(work3D) }
    catch { outlineActor_$widgets(work3D)  Delete }
    catch { outlineMapper_$widgets(work3D) Delete }
    catch { outlineSource_$widgets(work3D) Delete }
    catch { opaqueVol_$widgets(work3D)     Delete }
    catch { isoCast_$widgets(work3D)       Delete }
    catch { isoFunc_$widgets(work3D)       Delete }
    catch { opaqueProp_$widgets(work3D)    Delete }
    catch { colorFunc_$widgets(work3D)     Delete }
    catch { constFunc_$widgets(work3D)     Delete }
    catch { edgeActor_$widgets(work3D)     Delete }
    catch { edgeMapper_$widgets(work3D)    Delete }
    catch { edgePoints_$widgets(work3D)    Delete }
    catch { isoActor_$widgets(work3D)      Delete }
    catch { isoMapper_$widgets(work3D)     Delete }
    catch { cubes_$widgets(work3D)         Delete }
    catch { struct_$widgets(work3D)        Delete }

    # 3D outline
    vtkCubeSource outlineSource_$widgets(work3D)
        outlineSource_$widgets(work3D) SetXLength [ expr [ lindex $bounds 1 ] - [ lindex $bounds 0 ] ]
        outlineSource_$widgets(work3D) SetYLength [ expr [ lindex $bounds 3 ] - [ lindex $bounds 2 ] ]
        outlineSource_$widgets(work3D) SetZLength [ expr [ lindex $bounds 5 ] - [ lindex $bounds 4 ] ]
        outlineSource_$widgets(work3D) SetCenter  \
            [ expr ( [ lindex $bounds 0 ] + [ lindex $bounds 1 ] ) / 2 ] \
            [ expr ( [ lindex $bounds 2 ] + [ lindex $bounds 3 ] ) / 2 ] \
            [ expr ( [ lindex $bounds 4 ] + [ lindex $bounds 5 ] ) / 2 ]

    vtkPolyDataMapper outlineMapper_$widgets(work3D)
        outlineMapper_$widgets(work3D) SetInput [ outlineSource_$widgets(work3D) GetOutput ]
        outlineMapper_$widgets(work3D) ImmediateModeRenderingOn

    vtkActor outlineActor_$widgets(work3D)
        outlineActor_$widgets(work3D) SetMapper outlineMapper_$widgets(work3D)
        [ outlineActor_$widgets(work3D) GetProperty ] SetRepresentationToWireframe
        [ outlineActor_$widgets(work3D) GetProperty ] SetColor    0.7 0.00 0.9
        [ outlineActor_$widgets(work3D) GetProperty ] SetAmbient  1
        [ outlineActor_$widgets(work3D) GetProperty ] SetDiffuse  0
        [ outlineActor_$widgets(work3D) GetProperty ] SetSpecular 0

    # Surface
    vtkImageToStructuredPoints struct_$widgets(work3D)
        struct_$widgets(work3D) SetInput $resample
        struct_$widgets(work3D) Update

    vtkMarchingCubes cubes_$widgets(work3D)
        cubes_$widgets(work3D) SetInput [ struct_$widgets(work3D) GetOutput ]
        cubes_$widgets(work3D) SetValue 0 [ expr [ lindex $range 1 ] / 4 ]

    vtkPolyDataMapper isoMapper_$widgets(work3D)
        isoMapper_$widgets(work3D) SetInput [ cubes_$widgets(work3D) GetOutput ]
        isoMapper_$widgets(work3D) ScalarVisibilityOff
        isoMapper_$widgets(work3D) ImmediateModeRenderingOn

    vtkActor isoActor_$widgets(work3D)
        isoActor_$widgets(work3D) SetMapper isoMapper_$widgets(work3D)
        eval [ isoActor_$widgets(work3D) GetProperty ] SetColor $r $g $b
        eval [ isoActor_$widgets(work3D) GetProperty ] SetOpacity 0.5

    # Edge points
    vtkEdgePoints edgePoints_$widgets(work3D)
        edgePoints_$widgets(work3D) SetInput $resample
        edgePoints_$widgets(work3D) SetValue [ expr [ lindex $range 1 ] / 4 ]

    vtkDataSetMapper edgeMapper_$widgets(work3D)
        edgeMapper_$widgets(work3D) SetInput [ edgePoints_$widgets(work3D) GetOutput ]
        edgeMapper_$widgets(work3D) ScalarVisibilityOff
        edgeMapper_$widgets(work3D) ImmediateModeRenderingOn
    
    vtkActor edgeActor_$widgets(work3D)
        edgeActor_$widgets(work3D) SetMapper edgeMapper_$widgets(work3D)
        eval [ edgeActor_$widgets(work3D) GetProperty ] SetColor $r $g $b

    # Opaque
    vtkPiecewiseFunction constFunc_$widgets(work3D)
        constFunc_$widgets(work3D) AddPoint  0                    1.0
        constFunc_$widgets(work3D) AddPoint  [ lindex $range 1 ]  1.0

    vtkColorTransferFunction colorFunc_$widgets(work3D)
        colorFunc_$widgets(work3D) AddRGBPoint 0.00                 1.0 1.0 1.0
        colorFunc_$widgets(work3D) AddRGBPoint [ lindex $range 1 ] 1.0 1.0 1.0

    vtkVolumeProperty opaqueProp_$widgets(work3D)
        opaqueProp_$widgets(work3D) SetColor colorFunc_$widgets(work3D)
        opaqueProp_$widgets(work3D) SetScalarOpacity constFunc_$widgets(work3D)
        opaqueProp_$widgets(work3D) ShadeOn
        opaqueProp_$widgets(work3D) SetInterpolationTypeToLinear

    vtkVolumeRayCastIsosurfaceFunction isoFunc_$widgets(work3D)
        isoFunc_$widgets(work3D) SetIsoValue [ expr [ lindex $range 1 ] / 4 ]

    vtkVolumeRayCastMapper isoCast_$widgets(work3D)
        isoCast_$widgets(work3D) SetInput $resample
        isoCast_$widgets(work3D) SetVolumeRayCastFunction isoFunc_$widgets(work3D)

    vtkVolume opaqueVol_$widgets(work3D)
        opaqueVol_$widgets(work3D) SetMapper isoCast_$widgets(work3D)
        opaqueVol_$widgets(work3D) SetProperty opaqueProp_$widgets(work3D)

    # Axis
    set points [ getAxis_dll ]
    set nP [ expr [ llength $points ] / 3 ]

    # Poly-line actor construction...
    catch { renderer_$widgets(work3D) RemoveActor axisActor_$widgets(work3D) }
    catch { axisActor_$widgets(work3D)    Delete }
    catch { axisMapper_$widgets(work3D)   Delete }
    catch { axisGrid_$widgets(work3D)     Delete }
    catch { axisPolyLine_$widgets(work3D) Delete }
    catch { axisPoints_$widgets(work3D)   Delete }

    vtkPoints axisPoints_$widgets(work3D)
    vtkPolyLine axisPolyLine_$widgets(work3D)
    [ axisPolyLine_$widgets(work3D) GetPointIds ] SetNumberOfIds $nP
    set vox_size [ getActualVoxelSize_dll ]
    for { set i 0 } { $i < $nP } { incr i } {

        [ axisPolyLine_$widgets(work3D) GetPointIds ] SetId $i $i
        set p [ \
            PointCoord \
            [ lindex $points [ expr $i * 3 + 0 ] ] \
            [ lindex $points [ expr $i * 3 + 1 ] ] \
            [ lindex $points [ expr $i * 3 + 2 ] ] \
            [ lindex $bounds 0 ] \
            [ lindex $bounds 2 ] \
            [ lindex $bounds 4 ] \
            $vox_size $vox_size $vox_size \
        ]
        axisPoints_$widgets(work3D) InsertNextPoint [ lindex $p 0 ] [ lindex $p 1 ] [ lindex $p 2 ]

    }

    vtkUnstructuredGrid axisGrid_$widgets(work3D)
        axisGrid_$widgets(work3D) Allocate 1 1
        axisGrid_$widgets(work3D) InsertNextCell \
            [ axisPolyLine_$widgets(work3D) GetCellType ] \
            [ axisPolyLine_$widgets(work3D) GetPointIds ]
            axisGrid_$widgets(work3D) SetPoints axisPoints_$widgets(work3D)

    vtkDataSetMapper axisMapper_$widgets(work3D)
        axisMapper_$widgets(work3D) SetInput axisGrid_$widgets(work3D)
        axisMapper_$widgets(work3D) ImmediateModeRenderingOn

    vtkActor axisActor_$widgets(work3D)
        axisActor_$widgets(work3D) SetMapper axisMapper_$widgets(work3D)
        [ axisActor_$widgets(work3D) GetProperty] BackfaceCullingOn
        [ axisActor_$widgets(work3D) GetProperty] SetDiffuseColor 1 0 0
#        [ axisActor_$widgets(work3D) GetProperty] SetLineWidth 3

    renderer_$widgets(work3D) AddActor axisActor_$widgets(work3D)

    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render

    $widgets(sclIsoVal) configure \
        -from [ lindex $range 0 ] \
        -to   [ lindex $range 1 ] \
        -resolution 1.0

    $widgets(sclOpacity) configure \
        -from 0.00 \
        -to   1.0 \
        -resolution 0.001

    bind $widgets(sclIsoVal) <Any-ButtonRelease>
    bind $widgets(sclIsoVal) <Any-ButtonRelease> "planes_window::change_intensity 0"
    
    bind $widgets(sclOpacity) <Any-ButtonRelease>
    bind $widgets(sclOpacity) <Any-ButtonRelease> "planes_window::change_opacity 0"

    if { [ u_surf::get_isoval ] != 0 } {

        planes_window::change_intensity 1 [ u_surf::get_isoval ]

    } else {

        planes_window::change_intensity 1 [ expr ( [ $widgets(sclIsoVal) cget -to ] + ( [ $widgets(sclIsoVal) cget -from ] * 3 ) ) / 4 ]

    }
    planes_window::change_opacity 1

    $widgets(btnPerpendicular) select
    $widgets(btnPerpendicular) invoke

    $widgets(btnOpaque)      deselect
    $widgets(btnTransparent) deselect
    $widgets(btnEdge)        deselect
    $widgets(btnTransparent) invoke

    $widgets(sclSlice) configure \
        -from 0 \
        -to   [ expr [ getNumberOfAxisPoints_dll ] - 1 ] \
        -resolution 1

    set first_point_quant 0
    set last_point_quant [ expr [ getNumberOfAxisPoints_dll ] - 1 ]

    bind $widgets(sclSlice) <Any-ButtonRelease>
    $widgets(sclSlice) set [ expr [ getNumberOfAxisPoints_dll ] / 2 ]
    planes_window::prepare_planes
    planes_window::set_plane
    bind $widgets(sclSlice) <Any-ButtonRelease> "planes_window::set_plane"
    
    $widgets(btnGreyScale) deselect
    $widgets(btnColor)     deselect
    $widgets(btnGreyScale) invoke

    $widgets(btnSHealthySlice) deselect
    $widgets(btnSHealthySlice) invoke
    
    $widgets(btnShowS) deselect
    $widgets(btnShowS) invoke

    $widgets(btnRings) select
    $widgets(btnRings) invoke

    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render

    planes_window::controls 0
    global_window::deselect_buttons
    global_window::invoke_buttons [ expr \
        $global_window::en_clear  | \
        $global_window::en_rotate | \
        $global_window::en_zoom     \
    ]

    renderer_$widgets(work3D) AddActor outlineActor_$widgets(work3D)
    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render

    $widgets(btnContour) configure \
        -command "planes_window::extract_contour -1 -1"

}

proc planes_window::set_IsoActor { typ } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::actual_actor     actual_actor

    catch { renderer_$widgets(work3D) RemoveActor isoActor_$widgets(work3D) }
    catch { renderer_$widgets(work3D) RemoveActor edgeActor_$widgets(work3D) }
    catch { renderer_$widgets(work3D) RemoveVolume opaqueVol_$widgets(work3D) }

    if { $typ != 4 } { set actual_actor $typ }

    if { $typ == 1 } {

        renderer_$widgets(work3D) AddVolume opaqueVol_$widgets(work3D)
        $widgets(btnShowS) select
    
    } elseif { $typ == 2 } {

        renderer_$widgets(work3D) AddActor isoActor_$widgets(work3D)
        $widgets(btnShowS) select

    } elseif { $typ == 3 } {

        renderer_$widgets(work3D) AddActor edgeActor_$widgets(work3D)
        $widgets(btnShowS) select

    }
    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render

}

proc planes_window::change_color { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::actual_actor     actual_actor

    set col [ $widgets(btnSColor) cget -background ]
    set col [ \
        tk_chooseColor \
            -initialcolor $col \
            -parent $widgets(btnColor) \
            -title "Choose a color..."
    ]
    if { $col != "" } { 
        
        $widgets(btnSColor) configure -background $col            
        set r [ expr "0x[ string index $col 1 ][ string index $col 2 ]" / 255.0 ]
        set g [ expr "0x[ string index $col 3 ][ string index $col 4 ]" / 255.0 ]
        set b [ expr "0x[ string index $col 5 ][ string index $col 6 ]" / 255.0 ]
        [ isoActor_$widgets(work3D) GetProperty ] SetColor $r $g $b
        [ edgeActor_$widgets(work3D) GetProperty ] SetColor $r $g $b
        
        [ $widgets(work3D) GetRenderWindow ] Render
        [ $widgets(image2D) GetRenderWindow ] Render

    }

}

proc planes_window::change_intensity { typ { isoval 0 } } {

    # For programming facilities
    upvar planes_window::widgets widgets

    if { $typ == 1 } {

        set slc $isoval
        $widgets(sclIsoVal) set $slc

    } else { set slc [ $widgets(sclIsoVal) get ] }

    cubes_$widgets(work3D) SetValue 0 $slc
    edgePoints_$widgets(work3D) SetValue $slc
    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render
    

}

proc planes_window::change_opacity { typ } {

    # For programming facilities
    upvar planes_window::widgets widgets

    if { $typ == 1 } {

        set slc [ expr ( [ $widgets(sclOpacity) cget -to ] + [ $widgets(sclOpacity) cget -from ] ) / 2 ]
        $widgets(sclOpacity) set $slc
    
    } else { set slc [ $widgets(sclOpacity) get ] }

    [ isoActor_$widgets(work3D) GetProperty ] SetOpacity $slc
    [ edgeActor_$widgets(work3D) GetProperty ] SetOpacity $slc
    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render
    

}

proc planes_window::prepare_planes { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index

    catch { renderer_$widgets(image2D) RemoveActor plane_actor_2D_$widgets(image2D) }
    catch { renderer_$widgets(work3D) RemoveActor plane_actor_3D_$widgets(work3D) }
    catch { plane_actor_2D_$widgets(image2D) Delete }
    catch { mapper_2D_$widgets(image2D) Delete }
    catch { collookup_$widgets(work3D) Delete }
    catch { bwlookup_$widgets(work3D) Delete }
    catch { plane_actor_3D_$widgets(work3D) Delete }
    catch { mapper_3D_$widgets(work3D) Delete }

    set range    [ getIntensityRange_dll ]

    vtkWindowLevelLookupTable bwlookup_$widgets(work3D)
        bwlookup_$widgets(work3D) SetHueRange 0.00 1.0 
        bwlookup_$widgets(work3D) SetNumberOfColors [ lindex [ split [ expr [ lindex $range 1 ] - [ lindex $range 0 ] + 1 ] . ] 0 ]
        bwlookup_$widgets(work3D) SetTableRange [ lindex $range 0 ] [ lindex $range 1 ]
        bwlookup_$widgets(work3D) SetSaturationRange 0 0
        bwlookup_$widgets(work3D) SetValueRange 0 1
        bwlookup_$widgets(work3D) SetAlphaRange 1 1
        bwlookup_$widgets(work3D) Build

    vtkLookupTable collookup_$widgets(work3D)
        collookup_$widgets(work3D) SetNumberOfColors 256
        collookup_$widgets(work3D) SetTableRange 0 255
        collookup_$widgets(work3D) Build
        collookup_$widgets(work3D) SetTableValue 0    1 0 0 1
        collookup_$widgets(work3D) SetTableValue 128  0 0 1 1
        collookup_$widgets(work3D) SetTableValue 255  0 1 0 1

    vtkDataSetMapper mapper_2D_$widgets(image2D)
        mapper_2D_$widgets(image2D) SetInput [ getVTKPoints_dll ]
        mapper_2D_$widgets(image2D) SetLookupTable bwlookup_$widgets(work3D)
        eval mapper_2D_$widgets(image2D) SetScalarRange [ lindex $range 0 ] [ lindex $range 1 ]
        mapper_2D_$widgets(image2D) ImmediateModeRenderingOn

    vtkActor plane_actor_2D_$widgets(image2D)
       plane_actor_2D_$widgets(image2D) SetMapper mapper_2D_$widgets(image2D)

    renderer_$widgets(image2D) AddActor plane_actor_2D_$widgets(image2D)

    [ renderer_$widgets(image2D) GetActiveCamera ] SetPosition   [ expr [ getCutSize_dll ] / 2 ] [ expr [ getCutSize_dll ] / 2 ] [ expr round( [ getCutSize_dll ] * 1.8 ) ]
    [ renderer_$widgets(image2D) GetActiveCamera ] SetFocalPoint [ expr [ getCutSize_dll ] / 2 ] [ expr [ getCutSize_dll ] / 2 ] 0

    # 3D actor
    vtkDataSetMapper mapper_3D_$widgets(work3D)
        mapper_3D_$widgets(work3D) SetInput [ [ getVTKProbe_dll ] GetOutput ]
        mapper_3D_$widgets(work3D) SetLookupTable bwlookup_$widgets(work3D)
        eval mapper_3D_$widgets(work3D) SetScalarRange $range
        mapper_3D_$widgets(work3D) ImmediateModeRenderingOn

    vtkActor plane_actor_3D_$widgets(work3D)
        plane_actor_3D_$widgets(work3D) SetMapper mapper_3D_$widgets(work3D)

    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render

}

proc planes_window::set_plane { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index
    upvar planes_window::actual_area  actual_area
    upvar planes_window::actual_peri  actual_peri
    upvar planes_window::actual_darea actual_darea
    upvar planes_window::actual_dperi actual_dperi
    upvar planes_window::actual_dmax  actual_dmax
    upvar planes_window::actual_dmin  actual_dmin
    upvar planes_window::actual_davg  actual_davg
    upvar planes_window::actual_sten  actual_sten
    upvar planes_window::actual_quant_x actual_quant_x
    upvar planes_window::actual_quant_sten actual_quant_sten
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant real_last_point_quant

    set slice [ $widgets(sclSlice) get ]

    planes_window::clean_contour
    changeSliceAxis_dll $slice
    set p [ getAxisPoint_dll $slice ]
    set resample [ getVTKSource_dll ]
    set bounds   [ $resample GetBounds ]
    catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_cell_int_$widgets(work3D) ] }
    DeleteSphere sphere_cell_int_$widgets(work3D)
    set act [ \
        DrawSphere \
            sphere_cell_int_$widgets(work3D) \
            [ expr [ getCellIntensitySize_dll ] / 2.0 ] \
            [ expr [ lindex $p 0 ] + [ lindex $bounds 0 ] ] \
            [ expr [ lindex $p 1 ] + [ lindex $bounds 2 ] ] \
            [ expr [ lindex $p 2 ] + [ lindex $bounds 4 ] ] \
            0.0 0.0 1.0 \
    ]
    [ $act GetProperty ] SetOpacity 0.2
    renderer_$widgets(work3D) AddActor $act

    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render

    catch { $widgets(graph) marker delete line_select }
    $widgets(graph) marker create line -coords { $slice -Inf $slice Inf } -dashes dash -linewidth 1 -outline red -name line_select

    set quant_data [ getValues_dll $slice ]
    set actual_area  [ change_float_precision [ lindex $quant_data 0 ] 2 ]
    set actual_peri  [ change_float_precision [ lindex $quant_data 1 ] 2 ]
    set actual_darea [ change_float_precision [ lindex $quant_data 2 ] 2 ]
    set actual_dperi [ change_float_precision [ lindex $quant_data 3 ] 2 ]
    set actual_dmax  [ change_float_precision [ lindex $quant_data 4 ] 2 ]
    set actual_dmin  [ change_float_precision [ lindex $quant_data 5 ] 2 ]
    set actual_davg  [ change_float_precision [ lindex $quant_data 6 ] 2 ]

    if { [ llength $actual_quant_sten ] > 0 } {

        set actual_sten [ change_float_precision [ lindex $actual_quant_sten [ expr $slice - [ lindex $actual_quant_x 0 ] ] ] 2 ]

    }

}

proc planes_window::extract_contour { x y { transformy 0 } } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index
    upvar planes_window::man_points man_points
    upvar planes_window::actual_area  actual_area
    upvar planes_window::actual_peri  actual_peri
    upvar planes_window::actual_darea actual_darea
    upvar planes_window::actual_dperi actual_dperi
    upvar planes_window::actual_dmax  actual_dmax
    upvar planes_window::actual_dmin  actual_dmin
    upvar planes_window::actual_davg  actual_davg
    upvar planes_window::actual_sten  actual_sten
    upvar planes_window::actual_quant_x     actual_quant_x
    upvar planes_window::actual_quant_area  actual_quant_area
    upvar planes_window::actual_quant_peri  actual_quant_peri
    upvar planes_window::actual_quant_darea actual_quant_darea
    upvar planes_window::actual_quant_dperi actual_quant_dperi
    upvar planes_window::actual_quant_dmax  actual_quant_dmax
    upvar planes_window::actual_quant_dmin  actual_quant_dmin
    upvar planes_window::actual_quant_davg  actual_quant_davg
    upvar planes_window::actual_quant_sten  actual_quant_sten
    upvar planes_window::quant_shown        quant_shown
    upvar planes_window::quantifing         quantifing
    upvar planes_window::first_quant        first_quant
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant real_last_point_quant

    set index [ $widgets(sclSlice) get ]
    planes_window::clean_contour

    if { [ llength $man_points ] > 0 } {
    
        setContour_dll $man_points
        for { set i 1 } { $i <= [ llength $man_points ] } { incr i } {
    
            catch { renderer_$widgets(image2D) RemoveActor [ GetSphereActorName man_point_$i ] }
            DeleteSphere man_point_$i
    
        }
        set man_points [ list ]

    } else {

        set params [ getContourParams_dll ]
        if { $transformy == 1 } { 

            set y [ expr [ lindex [ $widgets(image2D) configure -height ] 4 ] - $y - 1 ]
            catch { tmp_picker_$widgets(image2D) Delete }
            vtkWorldPointPicker tmp_picker_$widgets(image2D)
                set pickWP    [ tmp_picker_$widgets(image2D) Pick $x $y 0 renderer_$widgets(image2D) ]
                set pickWPPos [ tmp_picker_$widgets(image2D) GetPickPosition ]

            set x [ lindex $pickWPPos 0 ] 
            set y [ lindex $pickWPPos 1 ]

        }
        if { $x == -1 } { set rx [ expr [ getCutSize_dll ] / 2 ] } else { set rx $x }
        if { $y == -1 } { set ry [ expr [ getCutSize_dll ] / 2 ] } else { set ry $y }
        planes_window::generate_isocontour $rx $ry [ lindex $params 5 ] [ lindex $params 6 ]
        if { $x != -1 } { set x [ expr round( $x ) ] }
        if { $y != -1 } { set y [ expr round( [ getCutSize_dll ] - $y - 1 ) ] }
        extractContour_dll $x $y isoStrips_$widgets(work3D) 

    }

  catch { triangles_tmp Delete }
  catch { mesures_tmp Delete }

    # triangulate the polygons
#    vtkTriangleFilter triangles_tmp
#        triangles_tmp SetInput [ isoStrips_$widgets(work3D) GetOutput ]
#        triangles_tmp PassLinesOn
#        triangles_tmp PassVertsOn
#
#    vtkMassProperties mesures_tmp
#        mesures_tmp SetInput [triangles_tmp GetOutput]
#        mesures_tmp Update
#        set monarea [ mesures_tmp GetSurfaceArea ]
#    puts $monarea

    # Some contours had been calculated, so it's possible that
    # the user wants to keep them.
    set first_quant 0
    
    set points [ getContourPoints_dll ]
    set taille [ expr [ llength $points ] / 2 ]

    vtkPolygon aPolygon_$widgets(image2D)
    vtkPoints PointsContour_$widgets(image2D)

    vtkPolyLine aPolyLine_$widgets(image2D)
        set PointIds [ aPolyLine_$widgets(image2D) GetPointIds ]
        $PointIds SetNumberOfIds $taille
        set PointIdsPolygon [ aPolygon_$widgets(image2D) GetPointIds ]
        $PointIdsPolygon SetNumberOfIds $taille
    for { set i 0 } { $i< $taille } { incr i } {
      $PointIds SetId $i $i
      $PointIdsPolygon SetId $i $i
      PointsContour_$widgets(image2D) InsertNextPoint [ lindex $points [ expr ( $i * 2 ) + 0 ] ] [ lindex $points [ expr ( $i * 2 ) + 1 ] ] 0
    }

    vtkUnstructuredGrid aPolyLineGrid_$widgets(image2D)
        aPolyLineGrid_$widgets(image2D) Allocate 1 1
        set param1 [ aPolyLine_$widgets(image2D) GetCellType]
        set param2 [ aPolyLine_$widgets(image2D) GetPointIds]
        aPolyLineGrid_$widgets(image2D) InsertNextCell $param1 $param2
        aPolyLineGrid_$widgets(image2D) SetPoints PointsContour_$widgets(image2D)

    vtkDataSetMapper aPolyLineMapper_$widgets(image2D) 
        aPolyLineMapper_$widgets(image2D)    SetInput aPolyLineGrid_$widgets(image2D)

    vtkActor aPolyLineActor_$widgets(image2D)
        aPolyLineActor_$widgets(image2D) SetMapper aPolyLineMapper_$widgets(image2D)
        set Property1 [aPolyLineActor_$widgets(image2D) GetProperty]
        $Property1 SetColor 0 1 0
        $Property1 SetLineWidth 2
        $Property1 SetPointSize 2
        $Property1 BackfaceCullingOff

    renderer_$widgets(image2D) AddActor aPolyLineActor_$widgets(image2D)

    vtkUnstructuredGrid aPolygonGrid_$widgets(image2D)
        aPolygonGrid_$widgets(image2D) Allocate 1 1
        set param1 [ aPolygon_$widgets(image2D) GetCellType ]
        set param2 [ aPolygon_$widgets(image2D) GetPointIds ]
        aPolygonGrid_$widgets(image2D) InsertNextCell $param1 $param2
        aPolygonGrid_$widgets(image2D) SetPoints PointsContour_$widgets(image2D)

    vtkDataSetMapper aPolygonMapper_$widgets(image2D)
        aPolygonMapper_$widgets(image2D)  SetInput aPolygonGrid_$widgets(image2D)

    vtkActor aPolygonActor_$widgets(image2D)
        aPolygonActor_$widgets(image2D) SetMapper aPolygonMapper_$widgets(image2D)
        set Property1 [ aPolygonActor_$widgets(image2D) GetProperty ]
        $Property1 SetColor 0 1 0
        $Property1 SetLineWidth 2
        $Property1 SetPointSize 2
        $Property1 BackfaceCullingOff

    array set arr [ params_dll 0 ]
    if { $arr(e_debug_fill_area) == 1 } { renderer_$widgets(image2D) AddActor aPolygonActor_$widgets(image2D) }

    planes_window::show_max_min_diameters

    [ $widgets(image2D) GetRenderWindow ] Render

    planes_window::draw3D_contour $index

    set quant_data [ getValues_dll $index ]
    set actual_area  [ change_float_precision [ lindex $quant_data 0 ] 2 ]
    set actual_peri  [ change_float_precision [ lindex $quant_data 1 ] 2 ]
    set actual_darea [ change_float_precision [ lindex $quant_data 2 ] 2 ]
    set actual_dperi [ change_float_precision [ lindex $quant_data 3 ] 2 ]
    set actual_dmax  [ change_float_precision [ lindex $quant_data 4 ] 2 ]
    set actual_dmin  [ change_float_precision [ lindex $quant_data 5 ] 2 ]
    set actual_davg  [ change_float_precision [ lindex $quant_data 6 ] 2 ]
    set i [ lsearch -exact $actual_quant_x $index ]
    if { $i != -1 } {

        set actual_quant_area  [ lreplace $actual_quant_area  $i $i $actual_area ]
        set actual_quant_peri  [ lreplace $actual_quant_peri  $i $i $actual_peri ]
        set actual_quant_darea [ lreplace $actual_quant_darea $i $i $actual_darea ]
        set actual_quant_dperi [ lreplace $actual_quant_dperi $i $i $actual_dperi ]
        set actual_quant_dmax  [ lreplace $actual_quant_dmax  $i $i $actual_dmax ]
        set actual_quant_dmin  [ lreplace $actual_quant_dmin  $i $i $actual_dmin ]
        set actual_quant_davg  [ lreplace $actual_quant_davg  $i $i $actual_davg ]
        if { [ llength $actual_quant_sten ] > 0 } {
            
            set actual_quant_sten [ getStenosisQuant_dll ]
            set actual_sten [ change_float_precision [ lindex $actual_quant_sten [ expr $index - $real_first_point_quant ] ] 2 ]

        }

    }
    planes_window::update_blt_all_meassures

}

proc planes_window::clean_contour { } {

    # For programming facilities
    upvar planes_window::widgets widgets

    catch { renderer_$widgets(image2D) RemoveActor actor_debug2_work3D }
    catch { renderer_$widgets(image2D) RemoveActor actor_debug1_work3D }
    catch { actor_debug2_work3D Delete }
    catch { connMapper_$widgets(work3D) Delete }
    catch { isoStrips_$widgets(work3D) Delete }
    catch { cpd2_$widgets(work3D) Delete }
    catch { conn_$widgets(work3D) Delete }
    catch { cpd_$widgets(work3D) Delete }
    catch { actor_debug1_work3D Delete }
    catch { cntVTKMapper_$widgets(work3D) Delete }
    catch { cntVTK_$widgets(work3D) Delete }
    catch { renderer_$widgets(image2D) RemoveActor aPolyLineActor_$widgets(image2D) }
    catch { renderer_$widgets(image2D) RemoveActor aPolygonActor_$widgets(image2D) }
    catch { aPolyLineActor_$widgets(image2D) Delete }
    catch { aPolyLineMapper_$widgets(image2D) Delete }
    catch { aPolyLineGrid_$widgets(image2D) Delete }
    catch { aPolyLine_$widgets(image2D) Delete }
    catch { PointsContour_$widgets(image2D) Delete }
    catch { aPolygonActor_$widgets(image2D) Delete }
    catch { aPolygonMapper_$widgets(image2D) Delete }
    catch { aPolygonGrid_$widgets(image2D) Delete }
    catch { aPolygon_$widgets(image2D) Delete }
    catch { renderer_$widgets(image2D) RemoveActor dMax_actor_$widgets(image2D) }
    catch { renderer_$widgets(image2D) RemoveActor dMin_actor_$widgets(image2D) }
    catch { dMax_actor_$widgets(image2D)   Delete }
    catch { dMax_mapper_$widgets(image2D) Delete }
    catch { dMax_line_$widgets(image2D)   Delete }
    catch { dMin_actor_$widgets(image2D)   Delete }
    catch { dMin_mapper_$widgets(image2D) Delete }
    catch { dMin_line_$widgets(image2D)   Delete }

    [ $widgets(work3D) GetRenderWindow ] Render
    [ $widgets(image2D) GetRenderWindow ] Render

}

proc planes_window::show_hs_3D { var_healthy } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::actor_debug1 actor_debug1
    upvar planes_window::actor_debug2 actor_debug2
    upvar planes_window::show_hs_var show_hs_var
    
    set show_hs_var $var_healthy
    if { $var_healthy == 1 } {
    catch { renderer_$widgets(work3D) AddActor hs_actor_$widgets(work3D) }
    } else {
    catch { renderer_$widgets(work3D) RemoveActor hs_actor_$widgets(work3D) }
    }
    [ $widgets(work3D) GetRenderWindow ] Render

}

proc planes_window::put_plane_3D { var_perp } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::actor_debug1 actor_debug1
    upvar planes_window::actor_debug2 actor_debug2

    if { $var_perp == 1 } {
    catch { renderer_$widgets(work3D) AddActor plane_actor_3D_$widgets(work3D) }
    } else {
    catch { renderer_$widgets(work3D) RemoveActor plane_actor_3D_$widgets(work3D) }
    }
    [ $widgets(work3D) GetRenderWindow ] Render

}
        
proc planes_window::set_color_table { typ } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::actor_debug1 actor_debug1
    upvar planes_window::actor_debug2 actor_debug2

    if { $typ == 1 } {

        mapper_3D_$widgets(work3D) SetLookupTable bwlookup_$widgets(work3D)

    } else {

        mapper_3D_$widgets(work3D) SetLookupTable collookup_$widgets(work3D)

    }
    [ $widgets(work3D) GetRenderWindow ] Render

}

proc planes_window::generate_isocontour { x y vmin vmax } {

    # For programming facilities
    upvar planes_window::widgets widgets

    catch { renderer_$widgets(image2D) RemoveActor actor_debug2_work3D }
    catch { renderer_$widgets(image2D) RemoveActor actor_debug1_work3D }
    catch { actor_debug2_work3D Delete }
    catch { connMapper_$widgets(work3D) Delete }
    catch { isoStrips_$widgets(work3D) Delete }
    catch { cpd2_$widgets(work3D) Delete }
    catch { conn_$widgets(work3D) Delete }
    catch { cpd_$widgets(work3D) Delete }
    catch { actor_debug1_work3D Delete }
    catch { cntVTKMapper_$widgets(work3D) Delete }
    catch { cntVTK_$widgets(work3D) Delete }
    catch { renderer_$widgets(image2D) RemoveActor [ GetSphereActorName tmp_gc_point ] }
    DeleteSphere tmp_gc_point

    renderer_$widgets(image2D) AddActor [ \
        DrawSphere tmp_gc_point 0.1 \
        $x $y 0 \
        1.00 0.0 0.00
    ]

    set spoints [ getVTKPoints_dll ]
    vtkKitwareContourFilter cntVTK_$widgets(work3D)
        cntVTK_$widgets(work3D) SetInput $spoints
        cntVTK_$widgets(work3D) SetNumberOfContours 1
        cntVTK_$widgets(work3D) SetValue 0 $vmin
        #cntVTK_$widgets(work3D) SetValue 1 $vmax

    vtkPolyDataMapper cntVTKMapper_$widgets(work3D)
        cntVTKMapper_$widgets(work3D) SetInput [ cntVTK_$widgets(work3D) GetOutput ]
        cntVTKMapper_$widgets(work3D) ScalarVisibilityOff

    vtkActor actor_debug1_work3D
        actor_debug1_work3D SetMapper cntVTKMapper_$widgets(work3D)
        [ actor_debug1_work3D GetProperty ] SetColor 1 0 0
        
    vtkCleanPolyData cpd_$widgets(work3D)
        cpd_$widgets(work3D) SetInput [ cntVTK_$widgets(work3D) GetOutput ]

    vtkPolyDataConnectivityFilter conn_$widgets(work3D)
        conn_$widgets(work3D) SetInput [ cpd_$widgets(work3D) GetOutput ]
        conn_$widgets(work3D) SetExtractionModeToClosestPointRegion
        conn_$widgets(work3D) SetClosestPoint $x $y 0
        conn_$widgets(work3D) Update

    vtkCleanPolyData cpd2_$widgets(work3D)
        cpd2_$widgets(work3D) SetInput [ conn_$widgets(work3D) GetOutput ]

    vtkStripper isoStrips_$widgets(work3D)
        isoStrips_$widgets(work3D) SetInput [ cpd2_$widgets(work3D) GetOutput ]
        isoStrips_$widgets(work3D) Update

    vtkPolyDataMapper connMapper_$widgets(work3D)
        connMapper_$widgets(work3D) SetInput [ isoStrips_$widgets(work3D) GetOutput ]
        connMapper_$widgets(work3D) ScalarVisibilityOff

    vtkActor actor_debug2_work3D
        actor_debug2_work3D SetMapper connMapper_$widgets(work3D)
        [ actor_debug2_work3D GetProperty ] SetColor 0 0 1

    array set arr [ params_dll 0 ]

    if { $arr(e_debug_isocontour) == 1 } {
    
        renderer_$widgets(image2D) AddActor actor_debug1_work3D
        renderer_$widgets(image2D) AddActor actor_debug2_work3D

    }
    [ $widgets(image2D) GetRenderWindow ] Render

}

proc planes_window::select_axis_point { x y { real -1 } } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index
    upvar planes_window::nClicks nClicks
    upvar planes_window::first_point_quant first_point_quant
    upvar planes_window::last_point_quant last_point_quant
    upvar planes_window::actual_partial actual_partial
    upvar planes_window::given_points  given_points

    set nClicks [ expr ( $nClicks % 2 ) + 1 ]

    if { $real == -1 } {
    
        renderer_$widgets(work3D) IsInViewport 0 0
        catch { tmp_world_picker_$widgets(work3D) Delete }
        set y [ expr [ lindex [ $widgets(work3D) configure -height ] 4 ] - $y - 1 ]
                [ $widgets(work3D) GetRenderWindow ] Render
        set pickWPPos [ pick_point_local_actor $x $y renderer_$widgets(work3D) axisActor_$widgets(work3D) 0.001 ]
        set xc [ lindex $pickWPPos 0 ]
        set yc [ lindex $pickWPPos 1 ]
        set zc [ lindex $pickWPPos 2 ]
        
        #Chercher le point de l'axe le plus proche au point choisi
        set indP [axisGrid_$widgets(work3D) FindPoint $xc $yc $zc]
        set coordsP [axisGrid_$widgets(work3D) GetPoint $indP]
        set xc [lindex $coordsP 0]
        set yc [lindex $coordsP 1]
        set zc [lindex $coordsP 2]

    } else {

        set indP $real
        set coordsP [ axisGrid_$widgets(work3D) GetPoint $indP ]
        set xc [ lindex $coordsP 0 ]
        set yc [ lindex $coordsP 1 ]
        set zc [ lindex $coordsP 2 ]

    }

    if { $nClicks == 1 } {

        set first_point_quant $indP
        catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_quant1_$widgets(work3D) ] }
        DeleteSphere sphere_quant1_$widgets(work3D)

        renderer_$widgets(work3D) AddActor [ DrawSphere sphere_quant1_$widgets(work3D) 0.5 $xc $yc $zc 0.00 0.00 1.0 ]

    } else {
    
        set last_point_quant $indP
        catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_quant2_$widgets(work3D) ] }
        DeleteSphere sphere_quant2_$widgets(work3D)

        renderer_$widgets(work3D) AddActor [ DrawSphere sphere_quant2_$widgets(work3D) 0.5 $xc $yc $zc 0.00 1.0 0.00 ]
        planes_window::controls 1
        set given_points 1

    }

    [ $widgets(work3D) GetRenderWindow ] Render
    set f [ expr ( $first_point_quant < $last_point_quant )? $first_point_quant: $last_point_quant ]
    set l [ expr ( $first_point_quant > $last_point_quant )? $first_point_quant: $last_point_quant ]
    set actual_partial [ change_float_precision [ getPartialAxisLength_dll $f $l ] 2 ]

}


proc planes_window::set_plane_3D { x y } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index

    renderer_$widgets(work3D) IsInViewport 0 0

    busy hold .
    update

    catch { tmp_world_picker_$widgets(work3D) Delete }
    set y [ expr [ lindex [ $widgets(work3D) configure -height ] 4 ] - $y - 1 ]

    set pickWPPos [ pick_point_local_actor $x $y renderer_$widgets(work3D) isoActor_$widgets(work3D) 0.001 ]
    set xc [ lindex $pickWPPos 0 ]
    set yc [ lindex $pickWPPos 1 ]
    set zc [ lindex $pickWPPos 2 ]
    #Chercher le point de l'axe le plus proche au point choisi sur la surface
    set indP [axisGrid_$widgets(work3D) FindPoint $xc $yc $zc]
    set coordsP [axisGrid_$widgets(work3D) GetPoint $indP]
    set xc [lindex $coordsP 0]
    set yc [lindex $coordsP 1]
    set zc [lindex $coordsP 2]

    if { $indP >= 0 } {

        $widgets(sclSlice) set $indP
        planes_window::set_plane

    }

    busy release .
    update

    [ $widgets(work3D) GetRenderWindow ] Render

}

proc planes_window::do_quant { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index        axis_index
    upvar planes_window::nClicks           nClicks
    upvar planes_window::first_point_quant first_point_quant
    upvar planes_window::last_point_quant  last_point_quant
    upvar planes_window::quantifing        quantifing
    upvar planes_window::first_quant       first_quant
    upvar planes_window::actual_quant_x     actual_quant_x
    upvar planes_window::actual_quant_area  actual_quant_area
    upvar planes_window::actual_quant_peri  actual_quant_peri
    upvar planes_window::actual_quant_darea actual_quant_darea
    upvar planes_window::actual_quant_dperi actual_quant_dperi
    upvar planes_window::actual_quant_dmax  actual_quant_dmax
    upvar planes_window::actual_quant_dmin  actual_quant_dmin
    upvar planes_window::actual_quant_davg  actual_quant_davg
    upvar planes_window::actual_quant_sten  actual_quant_sten
    upvar planes_window::actual_area  actual_area
    upvar planes_window::actual_peri  actual_peri
    upvar planes_window::actual_darea actual_darea
    upvar planes_window::actual_dperi actual_dperi
    upvar planes_window::actual_dmax  actual_dmax
    upvar planes_window::actual_dmin  actual_dmin
    upvar planes_window::actual_davg  actual_davg
    upvar planes_window::quant_shown        quant_shown
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant real_last_point_quant
    upvar planes_window::actual_partial actual_partial

    if { $quantifing == 0 } {

        planes_window::clean_BLT
        planes_window::clean3D

        set quantifing 1

        set f [ expr ( $first_point_quant < $last_point_quant )? $first_point_quant: $last_point_quant ]
        set l [ expr ( $first_point_quant > $last_point_quant )? $first_point_quant: $last_point_quant ]
        planes_window::controls 2

        set actual_quant_x     [ list ]
        set actual_quant_area  [ list ]
        set actual_quant_peri  [ list ]
        set actual_quant_darea [ list ]
        set actual_quant_dperi [ list ]
        set actual_quant_dmax  [ list ]
        set actual_quant_dmin  [ list ]
        set actual_quant_davg  [ list ]
        for { set i $f } { $i <= $l } { incr i } { lappend actual_quant_x $i }
        update_blt_all_meassures

        startQuant_dll $f
        set cont $f
        changeSliceAxis_dll $f

        set ans [ \
            tk_messageBox \
                -icon question \
                -message "$string_table::str_recalculate_contours" \
                -type yesno \
                -title "Question" \
        ]
        set recal [ expr ( [ string compare $ans yes ] == 0 )? 1: 0 ]

        planes_window::clean_contour
        $widgets(sclSlice) set $cont
        planes_window::set_plane
        set quant_shown 1
        set params [ getContourParams_dll ]
        planes_window::generate_isocontour [ expr [ getCutSize_dll ] / 2 ] [ expr [ getCutSize_dll ] / 2 ] [ lindex $params 5 ] [ lindex $params 6 ]
        while { [ nextQuant_dll $recal isoStrips_$widgets(work3D) ] == 1 && $cont <= $l } {

            if { $quantifing == 1 } {

                catch { renderer_$widgets(image2D) RemoveActor aPolygonActor_$widgets(image2D) }
                catch { renderer_$widgets(image2D) RemoveActor aPolyLineActor_$widgets(image2D) }
                catch { aPolygonActor_$widgets(image2D)   Delete }
                catch { aPolygonMapper_$widgets(image2D)  Delete }
                catch { aPolygonGrid_$widgets(image2D)    Delete }
                catch { aPolyLineActor_$widgets(image2D)  Delete }
                catch { aPolyLineMapper_$widgets(image2D) Delete }
                catch { aPolyLineGrid_$widgets(image2D)   Delete }
                catch { aPolyLine_$widgets(image2D)       Delete }
                catch { PointsContour_$widgets(image2D)   Delete }
                catch { aPolygon_$widgets(image2D)        Delete }

                set points [ getContourPoints_dll ]
                set taille [ expr [ llength $points ] / 2 ]

                vtkPolygon aPolygon_$widgets(image2D)
                vtkPoints PointsContour_$widgets(image2D)

                vtkPolyLine aPolyLine_$widgets(image2D)
                    set PointIds [ aPolyLine_$widgets(image2D) GetPointIds ]
                    $PointIds SetNumberOfIds $taille
                    set PointIdsPolygon [ aPolygon_$widgets(image2D) GetPointIds ]
                    $PointIdsPolygon SetNumberOfIds $taille
                for { set i 0 } { $i< $taille } { incr i } {
                    $PointIds SetId $i $i
                    $PointIdsPolygon SetId $i $i
                    PointsContour_$widgets(image2D) InsertNextPoint [ lindex $points [ expr ( $i * 2 ) + 0 ] ] [ lindex $points [ expr ( $i * 2 ) + 1 ] ] 0
                }

                vtkUnstructuredGrid aPolyLineGrid_$widgets(image2D)
                    aPolyLineGrid_$widgets(image2D) Allocate 1 1
                    set param1 [ aPolyLine_$widgets(image2D) GetCellType]
                    set param2 [ aPolyLine_$widgets(image2D) GetPointIds]
                    aPolyLineGrid_$widgets(image2D) InsertNextCell $param1 $param2
                    aPolyLineGrid_$widgets(image2D) SetPoints PointsContour_$widgets(image2D)

                vtkDataSetMapper aPolyLineMapper_$widgets(image2D) 
                    aPolyLineMapper_$widgets(image2D)    SetInput aPolyLineGrid_$widgets(image2D)

                vtkActor aPolyLineActor_$widgets(image2D)
                    aPolyLineActor_$widgets(image2D) SetMapper aPolyLineMapper_$widgets(image2D)
                    set Property1 [aPolyLineActor_$widgets(image2D) GetProperty]
                    $Property1 SetColor 0 1 0
                    $Property1 SetLineWidth 2
                    $Property1 SetPointSize 2
                    $Property1 BackfaceCullingOff

                renderer_$widgets(image2D) AddActor aPolyLineActor_$widgets(image2D)

                vtkUnstructuredGrid aPolygonGrid_$widgets(image2D)
                    aPolygonGrid_$widgets(image2D) Allocate 1 1
                    set param1 [ aPolygon_$widgets(image2D) GetCellType ]
                    set param2 [ aPolygon_$widgets(image2D) GetPointIds ]
                    aPolygonGrid_$widgets(image2D) InsertNextCell $param1 $param2
                    aPolygonGrid_$widgets(image2D) SetPoints PointsContour_$widgets(image2D)

                vtkDataSetMapper aPolygonMapper_$widgets(image2D)
                    aPolygonMapper_$widgets(image2D)  SetInput aPolygonGrid_$widgets(image2D)

                vtkActor aPolygonActor_$widgets(image2D)
                    aPolygonActor_$widgets(image2D) SetMapper aPolygonMapper_$widgets(image2D)
                    set Property1 [ aPolygonActor_$widgets(image2D) GetProperty ]
                    $Property1 SetColor 0 1 0
                    $Property1 SetLineWidth 2
                    $Property1 SetPointSize 2
                    $Property1 BackfaceCullingOff

                array set arr [ params_dll 0 ]
                if { $arr(e_debug_fill_area) == 1 } { renderer_$widgets(image2D) AddActor aPolygonActor_$widgets(image2D) }
                planes_window::show_max_min_diameters

                [ $widgets(image2D) GetRenderWindow ] Render

                planes_window::draw3D_contour $cont

                set values [ getValues_dll $cont ]
                lappend actual_quant_area  [ lindex $values 0 ]
                lappend actual_quant_peri  [ lindex $values 1 ]
                lappend actual_quant_darea [ lindex $values 2 ]
                lappend actual_quant_dperi [ lindex $values 3 ]
                lappend actual_quant_dmax  [ lindex $values 4 ]
                lappend actual_quant_dmin  [ lindex $values 5 ]
                lappend actual_quant_davg  [ lindex $values 6 ]
                planes_window::update_blt_all_meassures

                set actual_area  [ change_float_precision [ lindex $values 0 ] 2 ]
                set actual_peri  [ change_float_precision [ lindex $values 1 ] 2 ]
                set actual_darea [ change_float_precision [ lindex $values 2 ] 2 ]
                set actual_dperi [ change_float_precision [ lindex $values 3 ] 2 ]
                set actual_dmax  [ change_float_precision [ lindex $values 4 ] 2 ]
                set actual_dmin  [ change_float_precision [ lindex $values 5 ] 2 ]
                set actual_davg  [ change_float_precision [ lindex $values 6 ] 2 ]
                incr cont
                planes_window::clean_contour
                $widgets(sclSlice) set $cont
                planes_window::set_plane
                set params [ getContourParams_dll ]
                planes_window::generate_isocontour [ expr [ getCutSize_dll ] / 2 ] [ expr [ getCutSize_dll ] / 2 ] [ lindex $params 5 ] [ lindex $params 6 ]
                update

            } elseif { $quantifing == 2 } { 
            
                while { $quantifing == 2 } { update }
                
            } elseif { $quantifing == 3 } {

                $widgets(btnPause) configure -text $string_table::str_pause
                break

            }

        }
        finishQuant_dll
        planes_window::clean_contour
        set quantifing 0

    } else {

        set quantifing 2
        set ans [ \
            tk_messageBox \
                -icon question \
                -message "$string_table::str_stop_quantification" \
                -type yesno \
                -title "Question" \
        ]
        set quantifing 1
        if { [ string compare $ans yes ] == 0 } { set quantifing 3 }

    }

}

proc planes_window::contour_calculated { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index

    set index [ $widgets(sclSlice) get ]

    planes_window::clean_contour
    set points [ getContourPoints_dll ]
    set taille [ expr [ llength $points ] / 2 ]

    if { $taille > 0 } {
    
        vtkPolygon aPolygon_$widgets(image2D)
        vtkPoints PointsContour_$widgets(image2D)

        vtkPolyLine aPolyLine_$widgets(image2D)
            set PointIds [ aPolyLine_$widgets(image2D) GetPointIds ]
            $PointIds SetNumberOfIds $taille
            set PointIdsPolygon [ aPolygon_$widgets(image2D) GetPointIds ]
            $PointIdsPolygon SetNumberOfIds $taille
        for { set i 0 } { $i< $taille } { incr i } {

            $PointIds SetId $i $i
            $PointIdsPolygon SetId $i $i
            PointsContour_$widgets(image2D) InsertNextPoint [ lindex $points [ expr ( $i * 2 ) + 0 ] ] [ lindex $points [ expr ( $i * 2 ) + 1 ] ] 0

        }

        vtkUnstructuredGrid aPolyLineGrid_$widgets(image2D)
            aPolyLineGrid_$widgets(image2D) Allocate 1 1
            set param1 [ aPolyLine_$widgets(image2D) GetCellType]
            set param2 [ aPolyLine_$widgets(image2D) GetPointIds]
            aPolyLineGrid_$widgets(image2D) InsertNextCell $param1 $param2
            aPolyLineGrid_$widgets(image2D) SetPoints PointsContour_$widgets(image2D)

        vtkDataSetMapper aPolyLineMapper_$widgets(image2D) 
            aPolyLineMapper_$widgets(image2D)    SetInput aPolyLineGrid_$widgets(image2D)

        vtkActor aPolyLineActor_$widgets(image2D)
            aPolyLineActor_$widgets(image2D) SetMapper aPolyLineMapper_$widgets(image2D)
            set Property1 [aPolyLineActor_$widgets(image2D) GetProperty]
            $Property1 SetColor 0 1 0
            $Property1 SetLineWidth 2
            $Property1 SetPointSize 2
            $Property1 BackfaceCullingOff

        renderer_$widgets(image2D) AddActor aPolyLineActor_$widgets(image2D)

        vtkUnstructuredGrid aPolygonGrid_$widgets(image2D)
            aPolygonGrid_$widgets(image2D) Allocate 1 1
            set param1 [ aPolygon_$widgets(image2D) GetCellType ]
            set param2 [ aPolygon_$widgets(image2D) GetPointIds ]
            aPolygonGrid_$widgets(image2D) InsertNextCell $param1 $param2
            aPolygonGrid_$widgets(image2D) SetPoints PointsContour_$widgets(image2D)

        vtkDataSetMapper aPolygonMapper_$widgets(image2D)
            aPolygonMapper_$widgets(image2D)  SetInput aPolygonGrid_$widgets(image2D)

        vtkActor aPolygonActor_$widgets(image2D)
            aPolygonActor_$widgets(image2D) SetMapper aPolygonMapper_$widgets(image2D)
            set Property1 [ aPolygonActor_$widgets(image2D) GetProperty ]
            $Property1 SetColor 0 1 0
            $Property1 SetLineWidth 2
            $Property1 SetPointSize 2
            $Property1 BackfaceCullingOff

        array set arr [ params_dll 0 ]
        if { $arr(e_debug_fill_area) == 1 } { renderer_$widgets(image2D) AddActor aPolygonActor_$widgets(image2D) }

        [ $widgets(work3D) GetRenderWindow ] Render
        [ $widgets(image2D) GetRenderWindow ] Render

    }

}

proc planes_window::clean_BLT { } {

    # For programming facilities
    upvar planes_window::widgets     widgets

    $widgets(graph) axis configure y -min 0.00
    $widgets(graph) grid configure  -hide no
    $widgets(graph) legend configure -position bottom -font {Helvetica -14 bold}
    Blt_Crosshairs $widgets(graph)
    $widgets(graph) crosshairs configure -hide no
    $widgets(graph) crosshairs configure -color red -dashes 2
    bind bltCrosshairs <ButtonPress-1> {}

    catch { $widgets(graph) marker delete line_select }
    catch { $widgets(graph) element delete $string_table::str_area }
    catch { $widgets(graph) element delete $string_table::str_peri }
    catch { $widgets(graph) element delete $string_table::str_diam_area }
    catch { $widgets(graph) element delete $string_table::str_diam_peri }
    catch { $widgets(graph) element delete $string_table::str_diam_max }
    catch { $widgets(graph) element delete $string_table::str_diam_min }
    catch { $widgets(graph) element delete $string_table::str_diam_avg }
    catch { $widgets(graph) element delete $string_table::str_stenosis }

}

proc planes_window::update_blt_all_meassures { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::actual_quant_x     actual_quant_x
    upvar planes_window::actual_quant_area  actual_quant_area
    upvar planes_window::actual_quant_peri  actual_quant_peri
    upvar planes_window::actual_quant_darea actual_quant_darea
    upvar planes_window::actual_quant_dperi actual_quant_dperi
    upvar planes_window::actual_quant_dmax  actual_quant_dmax
    upvar planes_window::actual_quant_dmin  actual_quant_dmin
    upvar planes_window::actual_quant_davg  actual_quant_davg
    upvar planes_window::actual_quant_sten  actual_quant_sten
    upvar planes_window::quant_shown        quant_shown

    if { [ llength $actual_quant_x ] > 0 } {
    
        planes_window::clean_BLT
        bind bltCrosshairs <ButtonPress-1> "planes_window::set_plane_BLT %x"

        array set arr [ params_dll 0 ]

        if { [ expr $arr(e_quantification_type) & 0x01 ] == 0x01 } { $widgets(graph) element create $string_table::str_area      -symbol "" -color #ff0000 -xdata $actual_quant_x -ydata $actual_quant_area }
        if { [ expr $arr(e_quantification_type) & 0x02 ] == 0x02 } { $widgets(graph) element create $string_table::str_peri      -symbol "" -color #ff8000 -xdata $actual_quant_x -ydata $actual_quant_peri }
        if { [ expr $arr(e_quantification_type) & 0x04 ] == 0x04 } { $widgets(graph) element create $string_table::str_diam_area -symbol "" -color #808040 -xdata $actual_quant_x -ydata $actual_quant_darea }
        if { [ expr $arr(e_quantification_type) & 0x08 ] == 0x08 } { $widgets(graph) element create $string_table::str_diam_peri -symbol "" -color #808080 -xdata $actual_quant_x -ydata $actual_quant_dperi }
        if { [ expr $arr(e_quantification_type) & 0x10 ] == 0x10 } { $widgets(graph) element create $string_table::str_diam_min  -symbol "" -color #0000ff -xdata $actual_quant_x -ydata $actual_quant_dmin }
        if { [ expr $arr(e_quantification_type) & 0x20 ] == 0x20 } { $widgets(graph) element create $string_table::str_diam_max  -symbol "" -color #800080 -xdata $actual_quant_x -ydata $actual_quant_dmax }
        if { [ expr $arr(e_quantification_type) & 0x40 ] == 0x40 } { $widgets(graph) element create $string_table::str_diam_avg  -symbol "" -color #000000 -xdata $actual_quant_x -ydata $actual_quant_davg }
        if { [ llength $actual_quant_sten ] > 0 } {
    
            set actual_quant_sten [ getStenosisQuant_dll ]
            $widgets(graph) element create $string_table::str_stenosis -symbol "" -color #00ff00 -xdata $actual_quant_x -ydata $actual_quant_sten
            $widgets(graph) element configure $string_table::str_stenosis -mapy y2
            $widgets(graph) axis configure y2 -hide no
            $widgets(graph) axis configure y2 -min -100.00 -max 100.00

        }

    }

}

proc planes_window::ev_start_window_level { x y } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::initX           initX
    upvar planes_window::initY           initY
    upvar planes_window::initWindow      initWindow
    upvar planes_window::initLevel       initLevel

    set initX $x
    set initY $y

    set initWindow [ bwlookup_$widgets(work3D) GetWindow ]
    set initLevel  [ bwlookup_$widgets(work3D) GetLevel  ]

}

proc planes_window::ev_window_level { x y } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::initX           initX
    upvar planes_window::initY           initY
    upvar planes_window::initWindow      initWindow
    upvar planes_window::initLevel       initLevel

    # get the widgets dimensions
    set width  [ lindex [ $widgets(image2D) configure -width ] 4 ]
    set height [ lindex [ $widgets(image2D) configure -height ] 4 ]

    # compute normalized delta
    set dx [ expr 4.0 * ( $x - $initX ) / $width  ]
    set dy [ expr 4.0 * ( $initY - $y ) / $height ]

    # scale by current values 
    set dx [ expr $dx * $initWindow ]
    set dy [ expr $dy * $initLevel  ]

    # abs so that direction does not flip
    if { $initWindow < 0.00 } { set dx [ expr 0 - $dx ] }
    if { $initLevel < 0.00  } { set dy [ expr 0 - $dy ] }
    
    # compute new window level
    set window [ expr $dx + $initWindow ]
    if {$window < 0.00} {
    set level [ expr $dy + $initLevel ]
    } else {
    set level [ expr $initLevel - $dy ]
    }
    
    if { $window < 0.00 } { set dy [ expr 0 - $dy ] }
    
    bwlookup_$widgets(work3D) SetWindow $window
    bwlookup_$widgets(work3D) SetLevel  $level

    [ $widgets(image2D) GetRenderWindow ] Render

}

proc planes_window::profil_linear { x y } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::initX   initX
    upvar planes_window::initY   initY

    set y1 [ expr [ lindex [ $widgets(image2D) configure -height ] 4 ] - $initY - 1 ]
    set y2 [ expr [ lindex [ $widgets(image2D) configure -height ] 4 ] - $y - 1 ]
    set x1 $initX
    set x2 $x
    
    catch { tmp_picker_$widgets(image2D) Delete }
    vtkWorldPointPicker tmp_picker_$widgets(image2D)
        set pickWP     [ tmp_picker_$widgets(image2D) Pick $x1 $y1 0 renderer_$widgets(image2D) ]
        set pickWPPos1 [ tmp_picker_$widgets(image2D) GetPickPosition ]
        set pickWP     [ tmp_picker_$widgets(image2D) Pick $x2 $y2 0 renderer_$widgets(image2D) ]
        set pickWPPos2 [ tmp_picker_$widgets(image2D) GetPickPosition ]

    set c1 [ list [ lindex $pickWPPos1 0 ] [ lindex $pickWPPos1 1 ] 0 ]
    set c2 [ list [ lindex $pickWPPos2 0 ] [ lindex $pickWPPos2 1 ] 0 ]

    planes_window::clear
    
    renderer_$widgets(image2D) AddActor [ \
        DrawSphere prb1_lfv 0.1 \
        [ lindex $c1 0 ] [ lindex $c1 1 ] [ lindex $c1 2 ] \
        1.0 0.00 0.00
    ]
    renderer_$widgets(image2D) AddActor [ \
        DrawSphere prb2_lfv 0.1 \
        [ lindex $c2 0 ] [ lindex $c2 1 ] [ lindex $c2 2 ] \
        0.00 0.00 1.0
    ]
    
    vtkLineSource line_2D_profil_$widgets(image2D)
        line_2D_profil_$widgets(image2D) SetPoint1 [ lindex $c1 0 ] [ lindex $c1 1 ] [ lindex $c1 2 ]
        line_2D_profil_$widgets(image2D) SetPoint2 [ lindex $c2 0 ] [ lindex $c2 1 ] [ lindex $c2 2 ]
    vtkPolyDataMapper mapper_2D_profil_$widgets(image2D)
        mapper_2D_profil_$widgets(image2D) SetInput [ line_2D_profil_$widgets(image2D) GetOutput ]
        mapper_2D_profil_$widgets(image2D) ImmediateModeRenderingOn
    vtkActor actor_2D_profil_$widgets(image2D)
        actor_2D_profil_$widgets(image2D) SetMapper mapper_2D_profil_$widgets(image2D)
        [ actor_2D_profil_$widgets(image2D) GetProperty ] SetColor  1.0 0.00 0.00
    renderer_$widgets(image2D) AddActor actor_2D_profil_$widgets(image2D)

    [ $widgets(image2D) GetRenderWindow ] Render

    busy hold .
    update
    set vals [ getProfilCut_dll $c1 $c2 ]
    catch { destroy $widgets(image2D).fnProfil }
    toplevel $widgets(image2D).fnProfil -width [ lindex $vals 2 ] -height [ lindex $vals 1 ] -background black
    canvas $widgets(image2D).fnProfil.c -width [ lindex $vals 2 ] -height [ lindex $vals 1 ] -background black -borderwidth 1
    pack $widgets(image2D).fnProfil.c -fill both -expand 1
    for { set i 5 } { $i < [ llength $vals ] } { incr i } {
            
        if { $i > 5 } {

        $widgets(image2D).fnProfil.c create line \
            [ expr $i - 6 ] [ expr [ lindex $vals 1 ] - [ lindex $vals [ expr $i - 1 ] ] ] \
            [ expr $i - 5 ] [ expr [ lindex $vals 1 ] - [ lindex $vals $i ] ] \
            -fill #0000ff -width 1

        } else {

            $widgets(image2D).fnProfil.c create line \
                0 0 \
                [ expr $i - 5 ] [ expr [ lindex $vals 1 ] - [ lindex $vals $i ] ] \
                -fill #0000ff -width 1

        }

    }
    array set arr [ params_dll 0 ]
    set dist [ DistPoints [ lindex $c1 0 ] [ lindex $c1 1 ] 0 [ lindex $c2 0 ] [ lindex $c2 1 ] 0 ]
    set len [ expr $dist * $arr(e_scale) * $arr(e_roi_dimension) / [ getCutSize_dll ] ]
    $widgets(image2D).fnProfil.c create text \
        0 0 \
        -text "$string_table::str_min = [ lindex $vals 0 ]\n$string_table::str_max = [ lindex $vals 1 ]\n$string_table::str_nro_pix = [ lindex $vals 2 ]\n$string_table::str_mm_length = $len\n$string_table::str_avg = [ lindex $vals 3 ]\n$string_table::str_std = [ lindex $vals 4 ]" \
        -fill yellow \
        -justify left \
        -anchor nw \
        -font { Helvetica -12 bold }
    busy release .
    update

}

proc planes_window::profil_area { x y } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::initX   initX
    upvar planes_window::initY   initY

    set y1 [ expr [ lindex [ $widgets(image2D) configure -height ] 4 ] - $initY - 1 ]
    set y2 [ expr [ lindex [ $widgets(image2D) configure -height ] 4 ] - $y - 1 ]
    set x1 $initX
    set x2 $x
    
    catch { tmp_picker_$widgets(image2D) Delete }
    vtkWorldPointPicker tmp_picker_$widgets(image2D)
        set pickWP     [ tmp_picker_$widgets(image2D) Pick $x1 $y1 0 renderer_$widgets(image2D) ]
        set pickWPPos1 [ tmp_picker_$widgets(image2D) GetPickPosition ]
        set pickWP     [ tmp_picker_$widgets(image2D) Pick $x2 $y2 0 renderer_$widgets(image2D) ]
        set pickWPPos2 [ tmp_picker_$widgets(image2D) GetPickPosition ]

    set c1 [ list [ lindex $pickWPPos1 0 ] [ lindex $pickWPPos1 1 ] 0 ]
    set c2 [ list [ lindex $pickWPPos2 0 ] [ lindex $pickWPPos2 1 ] 0 ]

    planes_window::clear

    renderer_$widgets(image2D) AddActor [ \
        DrawSphere prb1_lfv2 1.0 \
        [ lindex $c1 0 ] [ lindex $c1 1 ] [ lindex $c1 2 ] \
        1.0 0.00 0.00
    ]
    renderer_$widgets(image2D) AddActor [ \
        DrawSphere prb2_lfv2 1.0 \
        [ lindex $c2 0 ] [ lindex $c2 1 ] [ lindex $c2 2 ] \
        0.00 0.00 1.0
    ]
    
    [ $widgets(image2D) GetRenderWindow ] Render

    busy hold .
    update
    set vals [ getProfilAreaCut_dll $c1 $c2 ]
    catch { destroy .fnProfil }
    toplevel $widgets(image2D).fnProfil -width 100 -height 100 -background black
    canvas $widgets(image2D).fnProfil.c -width 100 -height 100 -background black -borderwidth 1
    pack $widgets(image2D).fnProfil.c -fill both -expand 1
    $widgets(image2D).fnProfil.c create text \
        0 0 \
        -text "$string_table::str_min = [ lindex $vals 0 ]\n$string_table::str_max = [ lindex $vals 1 ]\n$string_table::str_nro_pix = [ lindex $vals 2 ]\n$string_table::str_avg = [ lindex $vals 3 ]\n$string_table::str_std = [ lindex $vals 4 ]" \
        -fill yellow \
        -justify left \
        -anchor nw \
        -font { Helvetica -12 bold }
    busy release .
    update

}

proc planes_window::clear { } {

    # For programming facilities
    upvar planes_window::widgets widgets

    catch { renderer_$widgets(image2D) RemoveActor [ GetSphereActorName prb1_lfv2 ] }
    catch { renderer_$widgets(image2D) RemoveActor [ GetSphereActorName prb2_lfv2 ] }
    DeleteSphere prb1_lfv2
    DeleteSphere prb2_lfv2
    catch { renderer_$widgets(image2D) RemoveActor [ GetSphereActorName prb1_lfv ] }
    catch { renderer_$widgets(image2D) RemoveActor [ GetSphereActorName prb2_lfv ] }
    catch { renderer_$widgets(image2D) RemoveActor actor_2D_profil_$widgets(image2D) }
    catch { actor_2D_profil_$widgets(image2D) Delete }
    catch { mapper_2D_profil_$widgets(image2D) Delete }
    catch { line_2D_profil_$widgets(image2D) Delete }
    DeleteSphere prb1_lfv
    DeleteSphere prb2_lfv

    catch { [ $widgets(image2D) GetRenderWindow ] Render }

}

proc planes_window::set_healthy_slice { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index        axis_index
    upvar planes_window::first_point_quant first_point_quant
    upvar planes_window::last_point_quant  last_point_quant
    upvar planes_window::show_hs_var show_hs_var
    upvar planes_window::actual_sten actual_sten
    upvar planes_window::actual_quant_sten actual_quant_sten
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant real_last_point_quant

    set f $real_first_point_quant
    set l $real_last_point_quant

    set x [ list ]
    for { set i $f } { $i <= $l } { incr i } { lappend x $i }

    set slice [ $widgets(sclSlice) get ]

    # Get new data
    setHealthySlice_dll $slice
    set actual_quant_sten [ getStenosisQuant_dll ]

    # Show it
    catch { $widgets(graph) marker delete line_healthy_slice }
    $widgets(graph) marker create line -coords { $slice -Inf $slice Inf } -dashes dash -linewidth 1.5 -outline green -name line_healthy_slice
    planes_window::update_blt_all_meassures
    set actual_sten 0.00

    # Show plane
    set plane [ getVTKPlane_dll ]
    set o [ $plane GetOrigin ]
    set c [ $plane GetCenter ]
    set n [ $plane GetNormal ]
    set p1 [ $plane GetPoint1 ]
    set p2 [ $plane GetPoint2 ]

    catch { renderer_$widgets(work3D) RemoveActor hs_actor_$widgets(work3D) }
    catch { hs_actor_$widgets(work3D) Delete }
    catch { hs_mapper_$widgets(work3D) Delete }
    catch { hs_grid_$widgets(work3D) Delete }
    catch { hs_points_$widgets(work3D) Delete }
    catch { hs_poly_line_$widgets(work3D) Delete }

    vtkPolyLine hs_poly_line_$widgets(work3D)
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetNumberOfIds 8
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetId 0 0
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetId 1 1
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetId 2 2
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetId 3 3
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetId 4 4
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetId 5 5
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetId 6 6
        [ hs_poly_line_$widgets(work3D) GetPointIds ] SetId 7 7

    vtkPoints hs_points_$widgets(work3D)
        hs_points_$widgets(work3D) InsertNextPoint [ lindex $o 0 ] [ lindex $o 1 ] [ lindex $o 2 ]
        hs_points_$widgets(work3D) InsertNextPoint [ lindex $p1 0 ] [ lindex $p1 1 ] [ lindex $p1 2 ]
        hs_points_$widgets(work3D) InsertNextPoint \
            [ expr [ lindex $p2 0 ] + [ lindex $p1 0 ] - [ lindex $o 0 ] ] \
            [ expr [ lindex $p2 1 ] + [ lindex $p1 1 ] - [ lindex $o 1 ] ] \
            [ expr [ lindex $p2 2 ] + [ lindex $p1 2 ] - [ lindex $o 2 ] ]
        hs_points_$widgets(work3D) InsertNextPoint [ lindex $p2 0 ] [ lindex $p2 1 ] [ lindex $p2 2 ]
        hs_points_$widgets(work3D) InsertNextPoint [ lindex $o 0 ] [ lindex $o 1 ] [ lindex $o 2 ]
        hs_points_$widgets(work3D) InsertNextPoint \
            [ expr [ lindex $p2 0 ] + [ lindex $p1 0 ] - [ lindex $o 0 ] ] \
            [ expr [ lindex $p2 1 ] + [ lindex $p1 1 ] - [ lindex $o 1 ] ] \
            [ expr [ lindex $p2 2 ] + [ lindex $p1 2 ] - [ lindex $o 2 ] ]
        hs_points_$widgets(work3D) InsertNextPoint [ lindex $p1 0 ] [ lindex $p1 1 ] [ lindex $p1 2 ]
        hs_points_$widgets(work3D) InsertNextPoint [ lindex $p2 0 ] [ lindex $p2 1 ] [ lindex $p2 2 ]

    vtkUnstructuredGrid hs_grid_$widgets(work3D)
        hs_grid_$widgets(work3D) Allocate 1 1
        hs_grid_$widgets(work3D) InsertNextCell \
            [ hs_poly_line_$widgets(work3D) GetCellType ] [ hs_poly_line_$widgets(work3D) GetPointIds ]
            hs_grid_$widgets(work3D) SetPoints hs_points_$widgets(work3D)

    vtkDataSetMapper hs_mapper_$widgets(work3D)
        hs_mapper_$widgets(work3D) SetInput hs_grid_$widgets(work3D)
        hs_mapper_$widgets(work3D) ImmediateModeRenderingOn

    vtkActor hs_actor_$widgets(work3D)
        hs_actor_$widgets(work3D) SetMapper hs_mapper_$widgets(work3D)
        [ hs_actor_$widgets(work3D) GetProperty] BackfaceCullingOn
        [ hs_actor_$widgets(work3D) GetProperty] SetDiffuseColor 0 1 0

    if { $show_hs_var == 1 } { catch { renderer_$widgets(work3D) AddActor hs_actor_$widgets(work3D) } }

    [ $widgets(work3D) GetRenderWindow ] Render

}

proc planes_window::set_plane_BLT { x } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index

    busy hold .
    update

    set slice [ expr round( [ $widgets(graph) axis invtransform x $x ] ) ]
    $widgets(sclSlice) set $slice
    planes_window::set_plane
    catch { $widgets(graph) marker delete line_select }
    $widgets(graph) marker create line -coords { $slice -Inf $slice Inf } -dashes dash -linewidth 1 -outline red -name line_select

    busy release .
    update

    [ $widgets(work3D) GetRenderWindow ] Render

}

proc planes_window::add_point_contour_manual { x y } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::man_points man_points

    set y [ expr [ lindex [ $widgets(image2D) configure -height ] 4 ] - $y - 1 ]

    catch { tmp_picker_$widgets(image2D) Delete }
    vtkWorldPointPicker tmp_picker_$widgets(image2D)
        set pickWP    [ tmp_picker_$widgets(image2D) Pick $x $y 0 renderer_$widgets(image2D) ]
        set pickWPPos [ tmp_picker_$widgets(image2D) GetPickPosition ]

    set point [ list [ lindex $pickWPPos 0 ] [ lindex $pickWPPos 1 ] 0 ]
    lappend man_points [ lindex $point 0 ]
    lappend man_points [ lindex $point 1 ]
    set i [ llength $man_points ]

    renderer_$widgets(image2D) AddActor [ \
        DrawSphere man_point_$i 0.5 \
        [ lindex $point 0 ] [ lindex $point 1 ] [ lindex $point 2 ] \
        0.00 1.0 0.00
    ]
    
    [ $widgets(image2D) GetRenderWindow ] Render

}

proc planes_window::set_mouse_left_events { mask } {

    # For programming facilities
    upvar planes_window::widgets widgets

    # TODO : change
    catch { bind $widgets(work3D) <Any-ButtonPress>   { ev_startMotion %W %x %y } }
    catch { bind $widgets(work3D) <Any-ButtonRelease> { ev_endMotion %W %x %y } }
    catch { bind $widgets(image2D) <Any-ButtonPress>   { ev_startMotion %W %x %y } }
    catch { bind $widgets(image2D) <Any-ButtonRelease> { ev_endMotion %W %x %y } }

    if { [ expr $mask & 0x4 ] == 0x4 } { 

        catch { bind $widgets(work3D) <B1-Motion> { evz_rotate %W %x %y } }
        catch { bind $widgets(image2D) <B1-Motion> { evz_pan %W %x %y } }

    }
    if { [ expr $mask & 0x2 ] == 0x2 } {
    
        catch { bind $widgets(work3D) <B1-Motion> { evz_pan %W %x %y } }
        catch { bind $widgets(image2D) <B1-Motion> { evz_pan %W %x %y } }
        
    }
    if { [ expr $mask & 0x1 ] == 0x1 } {

        catch { bind $widgets(image2D) <B1-Motion> { planes_window::point_intensity %x %y } }

    }

}

proc planes_window::set_mouse_right_events { mask } {

    # For programming facilities
    upvar planes_window::widgets widgets

    catch { bind $widgets(work3D) <Any-ButtonPress>   { ev_startMotion %W %x %y } }
    catch { bind $widgets(work3D) <Any-ButtonRelease> { ev_endMotion %W %x %y } }

    if { [ expr $mask & 0x4 ] == 0x4 } {

        catch { bind $widgets(work3D) <B3-Motion> { evz_zoom %W %x %y } }

        catch { bind $widgets(image2D) <ButtonPress-3>   { ev_startMotion %W %x %y } }
        catch { bind $widgets(image2D) <ButtonRelease-3> { ev_endMotion %W %x %y } }
        catch { bind $widgets(image2D) <B3-Motion>       { evz_zoom %W %x %y } }

    }
    if { [ expr $mask & 0x8 ] == 0x8 } {

        catch { bind $widgets(work3D) <B3-Motion> { evz_zoom %W %x %y } }

        catch { bind $widgets(image2D) <ButtonPress-3>   { planes_window::ev_start_window_level %x %y } }
        catch { bind $widgets(image2D) <ButtonRelease-3> { ev_endMotion %W %x %y } }
        catch { bind $widgets(image2D) <B3-Motion>       { planes_window::ev_window_level %x %y } }

    }
    if { [ expr $mask & 0x2 ] == 0x2 } {

        catch { bind $widgets(work3D) <B3-Motion> { evz_zoom %W %x %y } }

        catch { bind $widgets(image2D) <ButtonPress-3>   { planes_window::ev_start_window_level %x %y } }
        catch { bind $widgets(image2D) <B3-Motion>       { } }
        catch { bind $widgets(image2D) <ButtonRelease-3> { planes_window::profil_linear %x %y } }

    }
    if { [ expr $mask & 0x1 ] == 0x1 } {

        catch { bind $widgets(work3D) <B3-Motion> { evz_zoom %W %x %y } }

        catch { bind $widgets(image2D) <ButtonPress-3>   { planes_window::ev_start_window_level %x %y } }
        catch { bind $widgets(image2D) <B3-Motion>       { } }
        catch { bind $widgets(image2D) <ButtonRelease-3> { planes_window::profil_area %x %y } }

    }

}

proc planes_window::draw3D_contour { slice } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index
    upvar planes_window::show_rings show_rings
    upvar planes_window::rings_index  rings_index

    if { [ lsearch -exact $rings_index $slice ] == -1 } { lappend rings_index $slice }

    catch { renderer_$widgets(work3D) RemoveActor cont3DActor_{$widgets(work3D)}_{$slice} }
    catch { cont3DActor_{$widgets(work3D)}_{$slice}    Delete }
    catch { cont3DMapper_{$widgets(work3D)}_{$slice}   Delete }
    catch { cont3DGrid_{$widgets(work3D)}_{$slice}     Delete }
    catch { cont3DPolyLine_{$widgets(work3D)}_{$slice} Delete }
    catch { cont3DPoints_{$widgets(work3D)}_{$slice}   Delete }

    set points3D [ get3DContour_dll $slice ]
    set nP [ expr [ llength $points3D ] / 3 ]

    vtkPoints cont3DPoints_{$widgets(work3D)}_{$slice}
    vtkPolyLine cont3DPolyLine_{$widgets(work3D)}_{$slice}
    [ cont3DPolyLine_{$widgets(work3D)}_{$slice} GetPointIds ] SetNumberOfIds $nP
    for { set i 0 } { $i < $nP } { incr i } {

        [ cont3DPolyLine_{$widgets(work3D)}_{$slice} GetPointIds ] SetId $i $i
        cont3DPoints_{$widgets(work3D)}_{$slice} InsertNextPoint \
            [ lindex $points3D [ expr $i * 3 + 0 ] ] \
            [ lindex $points3D [ expr $i * 3 + 1 ] ] \
            [ lindex $points3D [ expr $i * 3 + 2 ] ]

    }

    vtkUnstructuredGrid cont3DGrid_{$widgets(work3D)}_{$slice}
        cont3DGrid_{$widgets(work3D)}_{$slice} Allocate 1 1
        cont3DGrid_{$widgets(work3D)}_{$slice} InsertNextCell \
            [ cont3DPolyLine_{$widgets(work3D)}_{$slice} GetCellType ] \
            [ cont3DPolyLine_{$widgets(work3D)}_{$slice} GetPointIds ]
        cont3DGrid_{$widgets(work3D)}_{$slice} SetPoints cont3DPoints_{$widgets(work3D)}_{$slice}

    vtkDataSetMapper cont3DMapper_{$widgets(work3D)}_{$slice}
        cont3DMapper_{$widgets(work3D)}_{$slice} SetInput cont3DGrid_{$widgets(work3D)}_{$slice}
     cont3DMapper_{$widgets(work3D)}_{$slice} ImmediateModeRenderingOn

    vtkActor cont3DActor_{$widgets(work3D)}_{$slice}
        cont3DActor_{$widgets(work3D)}_{$slice} SetMapper cont3DMapper_{$widgets(work3D)}_{$slice}
        [ cont3DActor_{$widgets(work3D)}_{$slice} GetProperty] BackfaceCullingOn
        [ cont3DActor_{$widgets(work3D)}_{$slice} GetProperty] SetDiffuseColor 0 1 0

    if { $show_rings == 1 } { renderer_$widgets(work3D) AddActor cont3DActor_{$widgets(work3D)}_{$slice} }
    [ $widgets(work3D) GetRenderWindow ] Render

}

proc planes_window::show3D_rings_contour { var_rings } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::axis_index axis_index
    upvar planes_window::show_rings show_rings

    set show_rings $var_rings

    set noap [ getNumberOfAxisPoints_dll ]

    for { set i 0 } { $i < $noap } { incr i } {
    
        if { $show_rings == 0 } {
        catch { renderer_$widgets(work3D) RemoveActor cont3DActor_{$widgets(work3D)}_{$i} }
        } else {
        catch { renderer_$widgets(work3D) AddActor cont3DActor_{$widgets(work3D)}_{$i} }
        }
    
    }

    [ $widgets(work3D) GetRenderWindow ] Render

}

proc planes_window::controls { { id -1 } } {

    if { $id == -1 } {

        global_window::active_controls 0

    } else {

        if { $id == 0 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_params    | \
                $global_window::en_save      | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                $global_window::en_rotate    | \
                $global_window::en_bright    | \
                $global_window::en_pan       | \
                $global_window::en_zoom      | \
                $global_window::en_clear     | \
                $global_window::en_intensity | \
                $global_window::en_linear    | \
                $global_window::en_area      | \
                $global_window::en_back      | \
                $global_window::en_wizard    | \
                0
            ]

        } elseif { $id == 1 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_quant     | \
                $global_window::en_params    | \
                $global_window::en_save      | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                $global_window::en_rotate    | \
                $global_window::en_bright    | \
                $global_window::en_pan       | \
                $global_window::en_zoom      | \
                $global_window::en_clear     | \
                $global_window::en_intensity | \
                $global_window::en_linear    | \
                $global_window::en_area      | \
                $global_window::en_back      | \
                $global_window::en_wizard    | \
                0
            ]

        } elseif { $id == 2 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_quant     | \
                $global_window::en_params    | \
                $global_window::en_save      | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                $global_window::en_rotate    | \
                $global_window::en_bright    | \
                $global_window::en_pan       | \
                $global_window::en_zoom      | \
                $global_window::en_clear     | \
                $global_window::en_intensity | \
                $global_window::en_linear    | \
                $global_window::en_area      | \
                $global_window::en_back      | \
                $global_window::en_excel     | \
                $global_window::en_wizard    | \
                0
            ]

        }

    }

}

proc planes_window::point_intensity { x y } {

    # For programming facilities
    upvar planes_window::widgets widgets

    set y [ expr [ lindex [ $widgets(work3D) configure -height ] 4 ] - $y - 1 ]
    catch { tmp_picker_$widgets(image2D) Delete }
    vtkWorldPointPicker tmp_picker_$widgets(image2D)
        set pickWP    [ tmp_picker_$widgets(image2D) Pick $x $y 0 renderer_$widgets(image2D) ]
        set pickWPPos [ tmp_picker_$widgets(image2D) GetPickPosition ]
    set x [ lindex [ split [ lindex $pickWPPos 0 ] . ] 0 ]
    set y [ lindex [ split [ lindex $pickWPPos 1 ] . ] 0 ]
    set y [ expr [ getCutSize_dll ] - $y - 1 ]
    set intensity [ getIntensityCut_dll  $x $y ]

}
    

proc planes_window::refresh_quant { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::actual_quant_sten actual_quant_sten
    upvar planes_window::axis_index axis_index
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant real_last_point_quant

    if { $real_first_point_quant != -1 && $real_last_point_quant != -1 && [ llength $actual_quant_sten ] > 0 } {
            
        set actual_quant_sten [ getStenosisQuant_dll ]
        set actual_sten [ change_float_precision [ lindex $actual_quant_sten [ expr [ $widgets(sclSlice) get ] - $real_first_point_quant ] ] 2 ]

    }
    planes_window::update_blt_all_meassures

}

proc planes_window::pause { } {

    # For programming facilities
    upvar planes_window::widgets    widgets
    upvar planes_window::quantifing quantifing

    if { $quantifing == 1 } {

        set quantifing 2
        $widgets(btnPause) configure -text $string_table::str_play
        backQuant_dll

    } elseif { $quantifing == 2 } {

        set quantifing 1
        $widgets(btnPause) configure -text $string_table::str_pause

    }

}


proc planes_window::clean3D { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant real_last_point_quant
    upvar planes_window::rings_index rings_index
    upvar planes_window::actual_area  actual_area
    upvar planes_window::actual_peri  actual_peri
    upvar planes_window::actual_darea actual_darea
    upvar planes_window::actual_dperi actual_dperi
    upvar planes_window::actual_dmax  actual_dmax
    upvar planes_window::actual_dmin  actual_dmin
    upvar planes_window::actual_davg  actual_davg
    upvar planes_window::actual_sten  actual_sten
    upvar planes_window::quant_shown  quant_shown
    upvar planes_window::actual_quant_x     actual_quant_x
    upvar planes_window::actual_quant_area  actual_quant_area
    upvar planes_window::actual_quant_peri  actual_quant_peri
    upvar planes_window::actual_quant_darea actual_quant_darea
    upvar planes_window::actual_quant_dperi actual_quant_dperi
    upvar planes_window::actual_quant_dmax  actual_quant_dmax
    upvar planes_window::actual_quant_dmin  actual_quant_dmin
    upvar planes_window::actual_quant_davg  actual_quant_davg
    upvar planes_window::actual_quant_sten  actual_quant_sten
    upvar planes_window::first_quant first_quant

    set first_quant 1
    set real_first_point_quant -1
    set real_last_point_quant -1
    planes_window::controls 1
    set quant_shown 0

    catch { renderer_$widgets(work3D) RemoveActor hs_actor_$widgets(work3D) }
    catch { hs_actor_$widgets(work3D) Delete }
    catch { hs_mapper_$widgets(work3D) Delete }
    catch { hs_grid_$widgets(work3D) Delete }
    catch { hs_points_$widgets(work3D) Delete }
    catch { hs_poly_line_$widgets(work3D) Delete }
    foreach i $rings_index {

        catch { renderer_$widgets(work3D) RemoveActor cont3DActor_{$widgets(work3D)}_{$i} }
        catch { cont3DActor_{$widgets(work3D)}_{$i}    Delete }
        catch { cont3DMapper_{$widgets(work3D)}_{$i}   Delete }
        catch { cont3DGrid_{$widgets(work3D)}_{$i}     Delete }
        catch { cont3DPolyLine_{$widgets(work3D)}_{$i} Delete }
        catch { cont3DPoints_{$widgets(work3D)}_{$i}   Delete }

    }
    set rings_index [ list ]

}

proc planes_window::erase_all_data { } {

    # For programming facilities
    upvar planes_window::widgets widgets
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant real_last_point_quant
    upvar planes_window::rings_index rings_index
    upvar planes_window::actual_area  actual_area
    upvar planes_window::actual_peri  actual_peri
    upvar planes_window::actual_darea actual_darea
    upvar planes_window::actual_dperi actual_dperi
    upvar planes_window::actual_dmax  actual_dmax
    upvar planes_window::actual_dmin  actual_dmin
    upvar planes_window::actual_davg  actual_davg
    upvar planes_window::actual_sten  actual_sten
    upvar planes_window::quant_shown  quant_shown
    upvar planes_window::actual_quant_x     actual_quant_x
    upvar planes_window::actual_quant_area  actual_quant_area
    upvar planes_window::actual_quant_peri  actual_quant_peri
    upvar planes_window::actual_quant_darea actual_quant_darea
    upvar planes_window::actual_quant_dperi actual_quant_dperi
    upvar planes_window::actual_quant_dmax  actual_quant_dmax
    upvar planes_window::actual_quant_dmin  actual_quant_dmin
    upvar planes_window::actual_quant_davg  actual_quant_davg
    upvar planes_window::actual_quant_sten  actual_quant_sten
    upvar planes_window::first_quant first_quant

    set ans [ \
        tk_messageBox \
            -icon question \
            -message "$string_table::str_erase_quant_q" \
            -type yesno \
            -title "Question" \
    ]

    if { [ string compare $ans yes ] == 0 } {

        set first_quant 1
        set real_first_point_quant -1
        set real_last_point_quant -1
        planes_window::controls 1
        set quant_shown 0
        planes_window::clean_BLT

        catch { renderer_$widgets(work3D) RemoveActor hs_actor_$widgets(work3D) }
        catch { hs_actor_$widgets(work3D) Delete }
        catch { hs_mapper_$widgets(work3D) Delete }
        catch { hs_grid_$widgets(work3D) Delete }
        catch { hs_points_$widgets(work3D) Delete }
        catch { hs_poly_line_$widgets(work3D) Delete }
        foreach i $rings_index {

            catch { renderer_$widgets(work3D) RemoveActor cont3DActor_{$widgets(work3D)}_{$i} }
            catch { cont3DActor_{$widgets(work3D)}_{$i}    Delete }
            catch { cont3DMapper_{$widgets(work3D)}_{$i}   Delete }
            catch { cont3DGrid_{$widgets(work3D)}_{$i}     Delete }
            catch { cont3DPolyLine_{$widgets(work3D)}_{$i} Delete }
            catch { cont3DPoints_{$widgets(work3D)}_{$i}   Delete }

        }
        set rings_index [ list ]

        set actual_quant_x     [ list ]
        set actual_quant_area  [ list ]
        set actual_quant_peri  [ list ]
        set actual_quant_darea [ list ]
        set actual_quant_dperi [ list ]
        set actual_quant_dmax  [ list ]
        set actual_quant_dmin  [ list ]
        set actual_quant_davg  [ list ]
        set actual_quant_sten  [ list ]

        set actual_area  0.00
        set actual_peri  0.00
        set actual_darea 0.00
        set actual_dperi 0.00
        set actual_dmax  0.00
        set actual_dmin  0.00
        set actual_davg  0.00
        set actual_sten  0.00
        set quant_shown  0
        [ $widgets(work3D) GetRenderWindow ] Render

        planes_window::clean_contour

        set ans [ \
            tk_messageBox \
                -icon question \
                -message "$string_table::str_erase_extracted_contours" \
                -type yesno \
                -title "Question" \
        ]
        if { [ string compare $ans yes ] == 0 } { cleanData_dll }

    }

}

proc planes_window::reload_axis { mask step } {

    # For programming facilities
    upvar planes_window::widgets      widgets
    upvar planes_window::axis_index   axis_index
    upvar planes_window::given_points given_points
    upvar planes_window::quant_shown  quant_shown
    upvar planes_window::shown        shown
    upvar planes_window::rings_index  rings_index

    if { $step == 1 } {
        
        redoAxisSpline_dll
        catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_quant1_$widgets(work3D) ] }
        catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_quant2_$widgets(work3D) ] }
        DeleteSphere sphere_quant1_$widgets(work3D)
        DeleteSphere sphere_quant2_$widgets(work3D)
        set given_points 0

    } elseif { $mask == 1 } { recalculeAxisSignal_dll }

    if { ( $mask == 1 || $step == 1 ) && $shown == 1 } {
        
        tk_messageBox \
            -icon info \
            -message "$string_table::str_quant_will_be_erased" \
            -type ok

        catch { renderer_$widgets(work3D) RemoveActor hs_actor_$widgets(work3D) }
        catch { hs_actor_$widgets(work3D) Delete }
        catch { hs_mapper_$widgets(work3D) Delete }
        catch { hs_grid_$widgets(work3D) Delete }
        catch { hs_points_$widgets(work3D) Delete }
        catch { hs_poly_line_$widgets(work3D) Delete }
        foreach i $rings_index {

            catch { renderer_$widgets(work3D) RemoveActor cont3DActor_{$widgets(work3D)}_{$i} }
            catch { cont3DActor_{$widgets(work3D)}_{$i}    Delete }
            catch { cont3DMapper_{$widgets(work3D)}_{$i}   Delete }
            catch { cont3DGrid_{$widgets(work3D)}_{$i}     Delete }
            catch { cont3DPolyLine_{$widgets(work3D)}_{$i} Delete }
            catch { cont3DPoints_{$widgets(work3D)}_{$i}   Delete }
                
        }
        set rings_index [ list ]

        set actual_area  0.00
        set actual_peri  0.00
        set actual_darea 0.00
        set actual_dperi 0.00
        set actual_dmax  0.00
        set actual_dmin  0.00
        set actual_davg  0.00
        set actual_sten  0.00
        set quant_shown  0

        planes_window::clean_BLT
    
        set first_quant 1
        set range    [ getIntensityRange_dll ]
        set resample [ getVTKSource_dll ]
        set bounds   [ $resample GetBounds ]

        # Axis
        set points [ getAxis_dll ]
        set nP [ expr [ llength $points ] / 3 ]
        $widgets(sclSlice) configure \
            -from 0 \
            -to   [ expr [ getNumberOfAxisPoints_dll ] - 1 ] \
            -resolution 1

        # Poly-line actor construction...
        catch { renderer_$widgets(work3D) RemoveActor axisActor_$widgets(work3D) }
        catch { axisActor_$widgets(work3D)    Delete }
        catch { axisMapper_$widgets(work3D)   Delete }
        catch { axisGrid_$widgets(work3D)     Delete }
        catch { axisPolyLine_$widgets(work3D) Delete }
        catch { axisPoints_$widgets(work3D)   Delete }

        vtkPoints axisPoints_$widgets(work3D)
        vtkPolyLine axisPolyLine_$widgets(work3D)
        [ axisPolyLine_$widgets(work3D) GetPointIds ] SetNumberOfIds $nP
        set vox_size [ getActualVoxelSize_dll ]
        for { set i 0 } { $i < $nP } { incr i } {

            [ axisPolyLine_$widgets(work3D) GetPointIds ] SetId $i $i
            set p [ \
                PointCoord \
                [ lindex $points [ expr $i * 3 + 0 ] ] \
                [ lindex $points [ expr $i * 3 + 1 ] ] \
                [ lindex $points [ expr $i * 3 + 2 ] ] \
                [ lindex $bounds 0 ] \
                [ lindex $bounds 2 ] \
                [ lindex $bounds 4 ] \
                $vox_size $vox_size $vox_size \
            ]
            axisPoints_$widgets(work3D) InsertNextPoint [ lindex $p 0 ] [ lindex $p 1 ] [ lindex $p 2 ]

        }

        vtkUnstructuredGrid axisGrid_$widgets(work3D)
            axisGrid_$widgets(work3D) Allocate 1 1
            axisGrid_$widgets(work3D) InsertNextCell \
                [ axisPolyLine_$widgets(work3D) GetCellType ] \
                [ axisPolyLine_$widgets(work3D) GetPointIds ]
                axisGrid_$widgets(work3D) SetPoints axisPoints_$widgets(work3D)

        vtkDataSetMapper axisMapper_$widgets(work3D)
            axisMapper_$widgets(work3D) SetInput axisGrid_$widgets(work3D)
            axisMapper_$widgets(work3D) ImmediateModeRenderingOn

        vtkActor axisActor_$widgets(work3D)
            axisActor_$widgets(work3D) SetMapper axisMapper_$widgets(work3D)
            [ axisActor_$widgets(work3D) GetProperty] BackfaceCullingOn
            [ axisActor_$widgets(work3D) GetProperty] SetDiffuseColor 1 0 0

        renderer_$widgets(work3D) AddActor axisActor_$widgets(work3D)

        [ $widgets(work3D) GetRenderWindow ] Render
        [ $widgets(image2D) GetRenderWindow ] Render

        renderer_$widgets(work3D) AddActor outlineActor_$widgets(work3D)
        planes_window::controls 0

    }
    if { $given_points == 1 } {
            
        planes_window::controls 1

    }
    if { $quant_shown == 1 } {

        planes_window::update_blt_all_meassures

    }

}

proc planes_window::load_reconstructed_surface { typ } {

    # For programming facilities
    upvar planes_window::widgets                widgets
    upvar planes_window::axis_index             axis_index
    upvar planes_window::real_first_point_quant real_first_point_quant
    upvar planes_window::real_last_point_quant  real_last_point_quant

    catch { renderer_$widgets(work3D) RemoveActor surfaceActor_rec_$widgets(work3D) }
    catch { surfaceActor_rec_$widgets(work3D) Delete }
    catch { map_rec_$widgets(work3D)          Delete }
    catch { reverse_rec_$widgets(work3D)      Delete }
    catch { cf_rec_$widgets(work3D)           Delete }
    catch { surf_rec_$widgets(work3D)         Delete }
    catch { source_rec_$widgets(work3D)       Delete }
    catch { cells_rec_$widgets(work3D)        Delete }
    catch { points_rec_$widgets(work3D)       Delete }

    if { $typ == 1 } {

        vtkPoints    points_rec_$widgets(work3D)
        vtkCellArray cells_rec_$widgets(work3D)
        set f [ getFirstSlice_dll ]
        set l [ getLastSlice_dll ]

        set k 0
        for { set i $f } { $i < $l } { incr i } {

            set points3D [ get3DContour_dll $i ]
            set nP [ expr [ llength $points3D ] / 3 ]
            for { set j 0 } { $j < $nP } { incr j } {

                points_rec_$widgets(work3D) InsertNextPoint \
                    [ lindex $points3D [ expr $j * 3 + 0 ] ] \
                    [ lindex $points3D [ expr $j * 3 + 1 ] ] \
                    [ lindex $points3D [ expr $j * 3 + 2 ] ]
                cells_rec_$widgets(work3D) InsertNextCell 0
                cells_rec_$widgets(work3D) InsertCellPoint $k
                incr k

            }

        }

        vtkPolyData source_rec_$widgets(work3D)
            source_rec_$widgets(work3D) SetPoints points_rec_$widgets(work3D)
            source_rec_$widgets(work3D) SetPolys cells_rec_$widgets(work3D)

        vtkSurfaceReconstructionFilter surf_rec_$widgets(work3D)
            surf_rec_$widgets(work3D) SetInput source_rec_$widgets(work3D)
            surf_rec_$widgets(work3D) SetSampleSpacing 0.05

        vtkMarchingCubes cf_rec_$widgets(work3D)
#        vtkContourFilter cf_rec_$widgets(work3D)
            cf_rec_$widgets(work3D) SetInput [ surf_rec_$widgets(work3D) GetOutput ]
            cf_rec_$widgets(work3D) SetValue 0 0.0

        vtkReverseSense reverse_rec_$widgets(work3D)
            reverse_rec_$widgets(work3D) SetInput [ cf_rec_$widgets(work3D) GetOutput ]
            reverse_rec_$widgets(work3D) ReverseCellsOn
            reverse_rec_$widgets(work3D) ReverseNormalsOn

        vtkPolyDataMapper map_rec_$widgets(work3D)
            map_rec_$widgets(work3D) SetInput [ reverse_rec_$widgets(work3D) GetOutput ]
            map_rec_$widgets(work3D) ScalarVisibilityOff

        vtkActor surfaceActor_rec_$widgets(work3D)
            surfaceActor_rec_$widgets(work3D) SetMapper map_rec_$widgets(work3D)
            [ surfaceActor_rec_$widgets(work3D) GetProperty ] SetDiffuseColor 0.5 0.3882 0.2784
            [ surfaceActor_rec_$widgets(work3D) GetProperty ] SetSpecularColor 1 1 1
            [ surfaceActor_rec_$widgets(work3D) GetProperty ] SetSpecular .4
            [ surfaceActor_rec_$widgets(work3D) GetProperty ] SetSpecularPower 50

        renderer_$widgets(work3D) AddActor surfaceActor_rec_$widgets(work3D)

    }
    [ $widgets(work3D) GetRenderWindow ] Render

}

proc planes_window::show_max_min_diameters { } {

    # For programming facilities
    upvar planes_window::widgets widgets

    set slice [ $widgets(sclSlice) get ]
    set lmax [ getMaximumLine_dll ]
    set lmin [ getMinimumLine_dll ]

    catch { renderer_$widgets(image2D) RemoveActor dMax_actor_$widgets(image2D) }
    catch { renderer_$widgets(image2D) RemoveActor dMin_actor_$widgets(image2D) }
    catch { dMax_actor_$widgets(image2D)   Delete }
    catch { dMax_mapper_$widgets(image2D) Delete }
    catch { dMax_line_$widgets(image2D)   Delete }
    catch { dMin_actor_$widgets(image2D)   Delete }
    catch { dMin_mapper_$widgets(image2D) Delete }
    catch { dMin_line_$widgets(image2D)   Delete }

    vtkLineSource dMax_line_$widgets(image2D)
        dMax_line_$widgets(image2D) SetPoint1 [ lindex $lmax 0 ] [ lindex $lmax 1 ] 0.0
        dMax_line_$widgets(image2D) SetPoint2 [ lindex $lmax 2 ] [ lindex $lmax 3 ] 0.0
    vtkPolyDataMapper dMax_mapper_$widgets(image2D)
        dMax_mapper_$widgets(image2D) SetInput [ dMax_line_$widgets(image2D) GetOutput ]
        dMax_mapper_$widgets(image2D) ImmediateModeRenderingOn
    vtkActor dMax_actor_$widgets(image2D)
        dMax_actor_$widgets(image2D) SetMapper dMax_mapper_$widgets(image2D)
        [ dMax_actor_$widgets(image2D) GetProperty ] SetColor  1.00 0.00 0.00

    vtkLineSource dMin_line_$widgets(image2D)
        dMin_line_$widgets(image2D) SetPoint1 [ lindex $lmin 0 ] [ lindex $lmin 1 ] 0.0
        dMin_line_$widgets(image2D) SetPoint2 [ lindex $lmin 2 ] [ lindex $lmin 3 ] 0.0
    vtkPolyDataMapper dMin_mapper_$widgets(image2D)
        dMin_mapper_$widgets(image2D) SetInput [ dMin_line_$widgets(image2D) GetOutput ]
        dMin_mapper_$widgets(image2D) ImmediateModeRenderingOn
    vtkActor dMin_actor_$widgets(image2D)
        dMin_actor_$widgets(image2D) SetMapper dMin_mapper_$widgets(image2D)
        [ dMin_actor_$widgets(image2D) GetProperty ] SetColor  0.00 0.00 1.00

    array set arr [ params_dll 0 ]
    if { $arr(e_debug_diameters) == 1 } {

        renderer_$widgets(image2D) AddActor dMax_actor_$widgets(image2D)
        renderer_$widgets(image2D) AddActor dMin_actor_$widgets(image2D)

    }
    [ $widgets(image2D) GetRenderWindow ] Render

}

proc planes_window::back { } {

    # For programming facilities
    upvar planes_window::shown shown

    set ret $shown
    set shown 0

    return $ret

}

proc planes_window::set_quant_point_from_scale { } {

    # For programming facilities
    upvar planes_window::widgets widgets

    set slice [ $widgets(sclSlice) get ]
    planes_window::select_axis_point 0 0 $slice

}

# EOF - planes_window.tcl
