
namespace eval subtract {

    namespace export \
        show

    # variables
    variable base ""

    variable frSerieName    .frSerieName
    variable frDescription  .frDescription
    variable frSeries       .frSeries

    variable edtSerieName   .frSerieName.02
    variable edtDescription .frDescription.02

    variable btnLeft1  .frSeries.btnLeft1
    variable btnLeft2  .frSeries.btnLeft2
    variable btnRight1 .frSeries.btnRight1
    variable btnRight2 .frSeries.btnRight2

    variable btnOk     .btnOk
    variable btnCancel .btnCancel

    variable lbl001 .frSerieName.01
    variable lblSub .frSeries.lblSub
    variable lbl002 .frDescription.01
    variable lblt   .lblt

    variable sense 12
    variable description
    variable seriename

}

proc subtract::reset_values { } {

    # For programming facilities
    upvar subtract::base           base
    upvar subtract::frSerieName    frSerieName
    upvar subtract::frDescription  frDescription
    upvar subtract::frSeries       frSeries
    upvar subtract::edtSerieName   edtSerieName
    upvar subtract::edtDescription edtDescription
    upvar subtract::btnLeft1       btnLeft1
    upvar subtract::btnLeft2       btnLeft2
    upvar subtract::btnRight1      btnRight1
    upvar subtract::btnRight2      btnRight2
    upvar subtract::btnOk          btnOk
    upvar subtract::btnCancel      btnCancel
    upvar subtract::lbl001         lbl001
    upvar subtract::lblSub         lblSub
    upvar subtract::lbl002         lbl002
    upvar subtract::lblt           lblt
    upvar subtract::sense          sense

    set base           ""
    set frSerieName    ".frSerieName"
    set frDescription  ".frDescription"
    set frSeries       ".frSeries"
    set edtSerieName   ".frSerieName.02"
    set edtDescription ".frDescription.02"
    set btnLeft1       ".frSeries.btnLeft1"
    set btnLeft2       ".frSeries.btnLeft2"
    set btnRight1      ".frSeries.btnRight1"
    set btnRight2      ".frSeries.btnRight2"
    set btnOk          ".btnOk"
    set btnCancel      ".btnCancel"
    set lbl001         ".frSerieName.01"
    set lblSub         ".frSeries.lblSub"
    set lbl002         ".frDescription.01"
    set lblt           ".lblt"
    set sense 12

}


proc subtract::show { parent serie1 serie2 } {

    # For programming facilities
    upvar subtract::base           base
    upvar subtract::frSerieName    frSerieName
    upvar subtract::frDescription  frDescription
    upvar subtract::frSeries       frSeries
    upvar subtract::edtSerieName   edtSerieName
    upvar subtract::edtDescription edtDescription
    upvar subtract::btnLeft1       btnLeft1
    upvar subtract::btnLeft2       btnLeft2
    upvar subtract::btnRight1      btnRight1
    upvar subtract::btnRight2      btnRight2
    upvar subtract::btnOk          btnOk
    upvar subtract::btnCancel      btnCancel
    upvar subtract::lbl001         lbl001
    upvar subtract::lblSub         lblSub
    upvar subtract::lbl002         lbl002
    upvar subtract::lblt           lblt
    upvar subtract::sense          sense
    upvar subtract::description    description
    upvar subtract::seriename      seriename

    subtract::reset_values
    set base           "$parent.subtract"
    set frSerieName    "$base$frSerieName"
    set frDescription  "$base$frDescription"
    set frSeries       "$base$frSeries"
    set edtSerieName   "$base$edtSerieName"
    set edtDescription "$base$edtDescription"
    set btnLeft1       "$base$btnLeft1"
    set btnLeft2       "$base$btnLeft2"
    set btnRight1      "$base$btnRight1"
    set btnRight2      "$base$btnRight2"
    set btnOk          "$base$btnOk"
    set btnCancel      "$base$btnCancel"
    set lbl001         "$base$lbl001"
    set lblSub         "$base$lblSub"
    set lbl002         "$base$lbl002"
    set lblt           "$base$lblt"

    toplevel $base -class Toplevel
    wm focusmodel       $base passive
    wm geometry         $base 365x213+215+163
    wm maxsize          $base 1028 753
    wm minsize          $base 104 1
    wm overrideredirect $base 0
    wm resizable        $base 0 0
    wm deiconify        $base
    wm title            $base "$string_table::str_subtract_series"

    frame $frSerieName   -height 30 -width 30 
    frame $frDescription -height 30 -width 30 
    frame $frSeries      -borderwidth 2 -height 75 -relief groove -width 125 

    entry $edtSerieName   -textvariable subtract::seriename
    entry $edtDescription -textvariable subtract::description

    $edtSerieName   delete 0 end
    $edtDescription delete 0 end
    $edtSerieName   insert 0 "subtraction_$serie1\_$serie2"
    $edtDescription insert 0 "subtraction_$serie1\_$serie2"

    radiobutton $btnLeft1  -text $serie1 -variable ser1_var -value 1 -command "set subtract::sense 12; $btnRight1 deselect; $btnRight2 select"
    radiobutton $btnLeft2  -text $serie2 -variable ser1_var -value 2 -command "set subtract::sense 21; $btnRight1 select; $btnRight2 deselect"
    radiobutton $btnRight1 -text $serie1 -variable ser2_var -value 1 -command "set subtract::sense 21; $btnLeft1 deselect; $btnLeft2 select"
    radiobutton $btnRight2 -text $serie2 -variable ser2_var -value 2 -command "set subtract::sense 12; $btnLeft2 deselect; $btnLeft1 select"

    button $btnOk          -text $string_table::str_ok     -command "destroy $base"
    button $base.btnCancel -text $string_table::str_cancel -command "set subtract::sense 0; destroy $base"

    label $lbl001 -anchor w -borderwidth 0 -text $string_table::str_serie_name 
    label $lbl002 -anchor w -borderwidth 0 -text $string_table::str_description 
    label $lblSub -borderwidth 0 -text "----"
    label $lblt   -borderwidth 0 -text $string_table::str_choose_order 

    place $frSerieName    -x 15 -y 25 -width 335 -height 25 -anchor nw -bordermode ignore 
    pack  $lbl001         -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $edtSerieName   -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $frDescription  -x 15 -y 55 -width 335 -height 25 -anchor nw -bordermode ignore 
    pack  $lbl002         -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $edtDescription -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    place $frSeries       -x 10 -y 100 -width 345 -height 65 -anchor nw -bordermode ignore 
    place $btnLeft1       -x 15 -y 10 -anchor nw -bordermode ignore 
    place $btnLeft2       -x 15 -y 30 -anchor nw -bordermode ignore 
    place $btnRight1      -x 210 -y 10 -anchor nw -bordermode ignore 
    place $btnRight2      -x 210 -y 30 -anchor nw -bordermode ignore 
    place $lblSub         -x 135 -y 25 -anchor nw -bordermode ignore 
    place $base.lblt      -x 15 -y 90 -anchor nw -bordermode ignore 
    place $base.btnOk     -x 115 -y 175 -anchor nw -bordermode ignore 
    place $base.btnCancel -x 180 -y 175 -anchor nw -bordermode ignore 

    $btnLeft1 invoke

    # set global focus input to dialog
    grab set $base

    # waits for dialog destruction, i.e. waits for user interaction with dialog
    tkwait window $base

    return [ list $sense $seriename $description ]

}

# EOF - subtract.tcl
