namespace eval u_3D {

    # public interface
    namespace export        \
        create              \
        positionate         \
        forget
    
    # variables
    variable base ""

    variable tools .tools
    variable work  .work3D

    variable btnMPR  .tools.btnMPR
    variable btnMIP  .tools.btnMIP
    variable btnSurf .tools.btnSurf
    variable local_id

    variable axis_shown
    variable shown

}

proc u_3D::create { parent id } {

    # For programming facilities
    upvar u_3D::base    base
    upvar u_3D::tools   tools
    upvar u_3D::work    work
    upvar u_3D::btnMPR  btnMPR
    upvar u_3D::btnMIP  btnMIP
    upvar u_3D::btnSurf btnSurf
    upvar u_3D::local_id  local_id
    upvar u_3D::shown     shown

    set shown 0

    set local_id $id

    set base    "$parent"
    set tools   "$parent$tools"
    set work    "$parent$work"
    set btnMPR  "$parent$btnMPR"
    set btnMIP  "$parent$btnMIP"
    set btnSurf "$parent$btnSurf"

    # frames
    frame $tools -borderwidth 0 -height 75 -relief flat -width 125
    frame $work  -borderwidth 0 -height 75 -relief flat -width 125

    # buttons
    radiobutton $btnMPR  -indicatoron 0 -text mpr  -variable u3dtype -value 1 -command { u_3D::set_vis $u3dtype }
    radiobutton $btnMIP  -indicatoron 0 -text mip  -variable u3dtype -value 2 -command { u_3D::set_vis $u3dtype }
    radiobutton $btnSurf -indicatoron 0 -text surf -variable u3dtype -value 3 -command { u_3D::set_vis $u3dtype }
    
    # sub-windows
    u_mpr::create  $work
    u_mip::create  $work
    u_surf::create $work

}

proc u_3D::positionate { } {

    # For programming facilities
    upvar u_3D::base    base
    upvar u_3D::tools   tools
    upvar u_3D::work    work
    upvar u_3D::btnMPR  btnMPR
    upvar u_3D::btnMIP  btnMIP
    upvar u_3D::btnSurf btnSurf
    upvar u_3D::local_id  local_id
    upvar u_3D::shown     shown

    set shown 1

    set global_window::window_shown $local_id

    pack $tools   -anchor center -expand 0 -fill x    -side top
    pack $btnMPR  -anchor nw     -expand 0 -fill none -side left
    pack $btnMIP  -anchor nw     -expand 0 -fill none -side left
    pack $btnSurf -anchor nw     -expand 0 -fill none -side left
    pack $work    -anchor center -expand 1 -fill both -side top

    $btnMPR  deselect
    $btnMIP  deselect
    $btnSurf deselect
    $btnSurf  invoke

}

proc u_3D::forget { } {

    # For programming facilities
    upvar u_3D::base    base
    upvar u_3D::tools   tools
    upvar u_3D::work    work
    upvar u_3D::btnMPR  btnMPR
    upvar u_3D::btnMIP  btnMIP
    upvar u_3D::btnSurf btnSurf
    upvar u_3D::shown     shown

    set shown 0

    pack forget $work
    pack forget $btnSurf
    pack forget $btnMIP
    pack forget $btnMPR
    pack forget $tools

}

proc u_3D::set_data { } {

    # For programming facilities
    upvar u_3D::base    base
    upvar u_3D::tools   tools
    upvar u_3D::work    work
    upvar u_3D::btnMPR  btnMPR
    upvar u_3D::btnMIP  btnMIP
    upvar u_3D::btnSurf btnSurf
    upvar u_3D::local_id  local_id
    upvar u_3D::axis_shown axis_shown

    set global_window::data_loaded [ expr $global_window::data_loaded | $local_id ]

    set axis_shown 0
    set data [ image_browser::get_data ]
    if { $data != "" } {

		InitExperiment_dll $data
        u_mpr::set_data
        u_mip::set_data
        u_surf::set_data

    } else {
    
        set axis_shown 1
        u_mpr::set_data
        u_mip::set_data
        u_surf::set_data
        u_surf::load_axes
    
    }

    $btnMPR  deselect
    $btnMIP  deselect
    $btnSurf deselect
    $btnSurf  invoke

}

proc u_3D::set_vis { typ } {

    # For programming facilities
    upvar u_3D::base    base
    upvar u_3D::tools   tools
    upvar u_3D::work    work
    upvar u_3D::btnMPR  btnMPR
    upvar u_3D::btnMIP  btnMIP
    upvar u_3D::btnSurf btnSurf
    upvar u_3D::axis_shown axis_shown

    u_mpr::forget
    u_mip::forget
    u_surf::forget

    if { $typ == 1 } {

        u_mpr::positionate
        u_3D::controls 1
        global_window::deselect_buttons
        global_window::invoke_buttons [ expr \
            $global_window::en_clear  | \
            $global_window::en_rotate | \
            $global_window::en_zoom     \
        ]

    } elseif { $typ == 2 } {

        u_mip::positionate
        u_3D::controls 0
        global_window::deselect_buttons
        global_window::invoke_buttons [ expr \
            $global_window::en_clear  | \
            $global_window::en_rotate | \
            $global_window::en_zoom     \
        ]

    } elseif { $typ == 3 } {

        u_surf::positionate
        
        if { $axis_shown == 0 } {

            u_3D::controls 0

        } else {

            u_3D::controls 2

        }
        global_window::deselect_buttons
        global_window::invoke_buttons [ expr \
            $global_window::en_clear  | \
            $global_window::en_rotate | \
            $global_window::en_zoom     \
        ]

    }

}

proc u_3D::back { } {

    # For programming facilities
    upvar u_3D::shown     shown

    set ret $shown
    set shown 0

    return $ret

}

proc u_3D::controls { { id -1 } } {

    if { $id == -1 } {

        global_window::active_controls 0

    } else {

        if { $id == 0 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_params    | \
                $global_window::en_save      | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                $global_window::en_rotate    | \
                $global_window::en_pan       | \
                $global_window::en_zoom      | \
                $global_window::en_back      | \
                0
            ]

        } elseif { $id == 1 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_params    | \
                $global_window::en_save      | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                $global_window::en_rotate    | \
                $global_window::en_bright    | \
                $global_window::en_pan       | \
                $global_window::en_zoom      | \
                $global_window::en_back      | \
                0
            ]

        } elseif { $id == 2 } {

            global_window::active_controls [   \
                expr                           \
                $global_window::en_planes    | \
                $global_window::en_params    | \
                $global_window::en_save      | \
                $global_window::en_load      | \
                $global_window::en_open      | \
                $global_window::en_help      | \
                $global_window::en_rotate    | \
                $global_window::en_bright    | \
                $global_window::en_pan       | \
                $global_window::en_zoom      | \
                $global_window::en_back      | \
                $global_window::en_wizard    | \
                0
            ]

        }

    }

}

# EOF - u_3D.tcl
