namespace eval u_mip {

    # public interface
    namespace export        \
        create              \
        positionate         \
        forget
    
    # variables
    variable widgets
    variable reference_actor
    variable mip_volume

}

proc u_mip::reset { parent } {

    # For programming facilities
    upvar u_mip::widgets widgets

    set widgets(base)         "$parent"
    set widgets(work3D)       "$parent\.mip"
    set widgets(controls)     "$parent\.mipControls"
    set widgets(frType)       "$parent\.mipControls.type"
    set widgets(frColor)      "$parent\.mipControls.colors"
    set widgets(btnNeighbor)  "$parent\.mipControls.type.btnNeighbor"
    set widgets(btnTrilinear) "$parent\.mipControls.type.btnTrilinear"
    set widgets(btnGrey)      "$parent\.mipControls.colors.btnGrey"
    set widgets(btnColor)     "$parent\.mipControls.colors.btnColor"
    set widgets(lbl001)       "$parent\.mipControls.lbl001"
    set widgets(lbl002)       "$parent\.mipControls.lbl002"
    set widgets(lbl003)       "$parent\.mipControls.lbl003"

}

proc u_mip::create { parent } {

    # For programming facilities
    upvar u_mip::widgets widgets

    u_mip::reset $parent

    # frames
    frame $widgets(controls) -borderwidth 1 -height 75 -relief groove -width 191 
    frame $widgets(frType)   -borderwidth 2 -height 75 -relief groove -width 125 
    frame $widgets(frColor)  -borderwidth 2 -height 75 -relief groove -width 125 

    # labels
    label $widgets(lbl001) -borderwidth 0 -text $string_table::str_mip_controls 
    label $widgets(lbl002) -borderwidth 0 -text $string_table::str_interpolation_type 
    label $widgets(lbl003) -borderwidth 0 -text $string_table::str_colormap 

}

proc u_mip::positionate { } {

    # For programming facilities
    upvar u_mip::widgets widgets
    upvar u_mip::mip_volume mip_volume

    pack  $widgets(work3D)       -anchor nw -expand 1 -fill both -side left
    pack  $widgets(controls)     -anchor nw -expand 0 -fill both -side left
    place $widgets(lbl001)       -x 55 -y 15 -anchor nw -bordermode ignore 
    place $widgets(frType)       -x 10 -y 60 -width 170 -height 95 -anchor nw -bordermode ignore 
    place $widgets(btnNeighbor)  -x 25 -y 20 -anchor nw -bordermode ignore 
    place $widgets(btnTrilinear) -x 25 -y 50 -anchor nw -bordermode ignore 
    place $widgets(frColor)      -x 10 -y 175 -width 170 -height 95 -anchor nw -bordermode ignore 
    place $widgets(btnGrey)      -x 30 -y 20 -anchor nw -bordermode ignore 
    place $widgets(btnColor)     -x 30 -y 50 -anchor nw -bordermode ignore 
    place $widgets(lbl002)       -x 15 -y 50 -anchor nw -bordermode ignore 
    place $widgets(lbl003)       -x 15 -y 165 -anchor nw -bordermode ignore 

    $widgets(btnGrey)      deselect
    $widgets(btnColor)     deselect
    $widgets(btnNeighbor)  deselect
    $widgets(btnTrilinear) deselect

    $widgets(btnGrey)     invoke
    $widgets(btnNeighbor) invoke
    
    [ $widgets(work3D) GetRenderWindow ] Render

}

proc u_mip::forget { } {

    # For programming facilities
    upvar u_mip::widgets widgets
    upvar u_mip::mip_volume mip_volume

    catch { place forget $widgets(lbl003) }
    catch { place forget $widgets(lbl002) }
    catch { place forget $widgets(btnColor) }
    catch { place forget $widgets(btnGrey) }
    catch { place forget $widgets(frColor) }
    catch { place forget $widgets(btnTrilinear) }
    catch { place forget $widgets(btnNeighbor) }
    catch { place forget $widgets(frType) }
    catch { place forget $widgets(lbl001) }
    catch { pack  forget $widgets(controls) }
    catch { pack  forget $widgets(work3D) }

}

proc u_mip::set_data { } {

    # For programming facilities
    upvar u_mip::widgets widgets
    upvar u_mip::mip_volume mip_volume

    # render widget
    destroy $widgets(work3D)
    vtkTkRenderWidget $widgets(work3D) -width 30 -height 30

    # TODO: change
    bindBasicEvents $widgets(work3D)

    catch { renderer_$widgets(work3D) Delete }
    vtkRenderer renderer_$widgets(work3D)
    set render [ $widgets(work3D) GetRenderWindow ]
    $render AddRenderer renderer_$widgets(work3D)
    $render SetSize 1 1

    # radiobuttons
    destroy $widgets(btnNeighbor)
    destroy $widgets(btnTrilinear)
    destroy $widgets(btnGrey)
    destroy $widgets(btnColor)

    radiobutton $widgets(btnNeighbor)  -text $string_table::str_near_neighbor -variable var_type  -value 1 -command "catch { mip_prop_$widgets(work3D) SetInterpolationTypeToNearest; [ $widgets(work3D) GetRenderWindow ] Render }"
    radiobutton $widgets(btnTrilinear) -text $string_table::str_trilinear     -variable var_type  -value 2 -command "catch { mip_prop_$widgets(work3D) SetInterpolationTypeToLinear; [ $widgets(work3D) GetRenderWindow ] Render }"
    radiobutton $widgets(btnGrey)      -text $string_table::str_greyscale     -variable var_color -value 1 -command "catch { mip_prop_$widgets(work3D) SetColor gtfun_$widgets(work3D); [ $widgets(work3D) GetRenderWindow ] Render }"
    radiobutton $widgets(btnColor)     -text $string_table::str_color         -variable var_color -value 2 -command "catch { mip_prop_$widgets(work3D) SetColor ctfun_$widgets(work3D); [ $widgets(work3D) GetRenderWindow ] Render }"

    set resample [ GetVTKVolume_dll ]
    set bounds   [ $resample GetBounds ]
    set range    [ GetImageRange_dll ]

    # 3D outline
    catch { renderer_$widgets(work3D) RemoveActor outlineActor_$widgets(work3D) }
    catch { outlineActor_$widgets(work3D)  Delete }
    catch { outlineMapper_$widgets(work3D) Delete }
    catch { outlineSource_$widgets(work3D) Delete }
    catch { renderer_$widgets(work3D) RemoveVolume mip_volume_$widgets(work3D) }
    catch { mip_volume_$widgets(work3D) Delete }
    catch { mip_volmap_$widgets(work3D) Delete }
    catch { mip_func_$widgets(work3D) Delete }
    catch { mip_prop_$widgets(work3D) Delete }
    catch { ctfun_$widgets(work3D) Delete }
    catch { gtfun_$widgets(work3D) Delete }
    catch { mip_tfun_$widgets(work3D) Delete }

    vtkCubeSource outlineSource_$widgets(work3D)
        outlineSource_$widgets(work3D) SetXLength [ expr [ lindex $bounds 1 ] - [ lindex $bounds 0 ] ]
        outlineSource_$widgets(work3D) SetYLength [ expr [ lindex $bounds 3 ] - [ lindex $bounds 2 ] ]
        outlineSource_$widgets(work3D) SetZLength [ expr [ lindex $bounds 5 ] - [ lindex $bounds 4 ] ]
        outlineSource_$widgets(work3D) SetCenter  \
            [ expr ( [ lindex $bounds 0 ] + [ lindex $bounds 1 ] ) / 2 ] \
            [ expr ( [ lindex $bounds 2 ] + [ lindex $bounds 3 ] ) / 2 ] \
            [ expr ( [ lindex $bounds 4 ] + [ lindex $bounds 5 ] ) / 2 ]

    vtkPolyDataMapper outlineMapper_$widgets(work3D)
        outlineMapper_$widgets(work3D) SetInput [ outlineSource_$widgets(work3D) GetOutput ]
        outlineMapper_$widgets(work3D) ImmediateModeRenderingOn

    vtkActor outlineActor_$widgets(work3D)
        outlineActor_$widgets(work3D) SetMapper outlineMapper_$widgets(work3D)
        [ outlineActor_$widgets(work3D) GetProperty ] SetRepresentationToWireframe
        [ outlineActor_$widgets(work3D) GetProperty ] SetColor    0.7 0.0 0.9
        [ outlineActor_$widgets(work3D) GetProperty ] SetAmbient  1
        [ outlineActor_$widgets(work3D) GetProperty ] SetDiffuse  0
        [ outlineActor_$widgets(work3D) GetProperty ] SetSpecular 0

    renderer_$widgets(work3D) AddActor outlineActor_$widgets(work3D)

    vtkPiecewiseFunction mip_tfun_$widgets(work3D)
        mip_tfun_$widgets(work3D) AddPoint 0   0.0
        mip_tfun_$widgets(work3D) AddPoint [ expr ( [ lindex $range 1 ] / 2 ) ] 1.0

    vtkPiecewiseFunction gtfun_$widgets(work3D)
       gtfun_$widgets(work3D) AddPoint 0 0.0
       gtfun_$widgets(work3D) AddPoint [ expr ( [ lindex $range 1 ] / 4 ) ] 1.0


    vtkColorTransferFunction ctfun_$widgets(work3D)
        ctfun_$widgets(work3D) AddRGBPoint 0.0 0.0 0.0 0.0
#;      ctfun_$widgets(work3D) AddRGBPoint [ expr [ lindex $range 1 ] / 8 ] 0.0 0.0 0.0
        ctfun_$widgets(work3D) AddRGBPoint [ expr [ lindex $range 1 ] / 4 ] 1.0 0.0 0.0
        ctfun_$widgets(work3D) AddRGBPoint [ expr [ lindex $range 1 ] / 2 ] 0.0 0.0 1.0
	    ctfun_$widgets(work3D) AddRGBPoint [ lindex $range 1 ] 0.0 1.0 0.0

    vtkVolumeProperty mip_prop_$widgets(work3D)
        mip_prop_$widgets(work3D) SetColor gtfun_$widgets(work3D)
        mip_prop_$widgets(work3D) SetScalarOpacity mip_tfun_$widgets(work3D)

    vtkVolumeRayCastMIPFunction  mip_func_$widgets(work3D)
        mip_func_$widgets(work3D) SetMaximizeMethodToScalarValue

    vtkVolumeRayCastMapper mip_volmap_$widgets(work3D)
        mip_volmap_$widgets(work3D) SetInput $resample
        mip_volmap_$widgets(work3D) SetVolumeRayCastFunction mip_func_$widgets(work3D)

    vtkVolume mip_volume_$widgets(work3D)
        mip_volume_$widgets(work3D) SetMapper mip_volmap_$widgets(work3D)
        mip_volume_$widgets(work3D) SetProperty mip_prop_$widgets(work3D)

    renderer_$widgets(work3D) AddVolume mip_volume_$widgets(work3D)

}

proc u_mip::set_mouse_left_events { mask } {

    # For programming facilities
    upvar u_mip::widgets widgets

    # TODO : change
    catch { bind $widgets(work3D) <Any-ButtonPress>   { ev_startMotion %W %x %y } }
    catch { bind $widgets(work3D) <Any-ButtonRelease> { ev_endMotion %W %x %y } }

    if { [ expr $mask & 0x4 ] == 0x4 } { catch { bind $widgets(work3D) <B1-Motion> { evz_rotate %W %x %y } } }
    if { [ expr $mask & 0x2 ] == 0x2 } { catch { bind $widgets(work3D) <B1-Motion> { evz_pan %W %x %y } } }

}

proc u_mip::set_mouse_right_events { mask } {

    # For programming facilities
    upvar u_mip::widgets widgets

    catch { bind $widgets(work3D) <Any-ButtonPress>   { ev_startMotion %W %x %y } }
    catch { bind $widgets(work3D) <Any-ButtonRelease> { ev_endMotion %W %x %y } }

    if { [ expr $mask & 0x4 ] == 0x4 } { catch { bind $widgets(work3D) <B3-Motion> { evz_zoom %W %x %y } } }
    
}

# EOF - u_mip.tcl
