namespace eval u_mpr {

    # public interface
    namespace export        \
        create              \
        positionate         \
        forget
    
    # variables
    variable widgets

    variable reference_actor
    variable mpr_data
    variable actual_plane -1
    variable bounds
    variable intRange
    variable stPoint

    variable initX
    variable initY
    variable initWindow
    variable initLevel
    variable select_first

}

proc u_mpr::reset { parent } {

    # For programming facilities
    upvar u_mpr::widgets widgets

    set widgets(base)       "$parent"
    set widgets(work3D)     "$parent\.mpr"
    set widgets(controls)   "$parent\.mprControls"
    set widgets(type)       "$parent\.mprControls.type"
    set widgets(btnSagital) "$parent\.mprControls.type.btnSagital"
    set widgets(btnAxial)   "$parent\.mprControls.type.btnAxial"
    set widgets(btnCoronal) "$parent\.mprControls.type.btnCoronal"
    set widgets(lbl001)     "$parent\.mprControls.lbl001"
    set widgets(lbl002)     "$parent\.mprControls.lbl002"
    set widgets(sclMPR)     "$parent\.mprControls.sclMPR"
    set widgets(frMeasure)  "$parent\.mprControls.frMeasure"
    set widgets(lblMeasure) "$parent\.mprControls.frMeasure.01"
    set widgets(edtMeasure) "$parent\.mprControls.frMeasure.02"

}

proc u_mpr::create { parent } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::select_first select_first

    u_mpr::reset $parent

    # frames
    frame $widgets(controls)  -borderwidth 1 -height 75 -relief groove -width 191
    frame $widgets(type)      -borderwidth 2 -height 75 -relief groove -width 125
    frame $widgets(frMeasure) -height 30 -width 30 

    # entries
    entry $widgets(edtMeasure) -cursor {}

    # buttons
    radiobutton $widgets(btnSagital) -text $string_table::str_sagital -variable show_type -value 1 -command { u_mpr::set_probe $show_type #ff0000 }
    radiobutton $widgets(btnAxial)   -text $string_table::str_axial   -variable show_type -value 2 -command { u_mpr::set_probe $show_type #00ff00 }
    radiobutton $widgets(btnCoronal) -text $string_table::str_coronal -variable show_type -value 3 -command { u_mpr::set_probe $show_type #0000ff }

    # labels
    label $widgets(lbl001)     -borderwidth 0 -text $string_table::str_mpr_controls
    label $widgets(lbl002)     -borderwidth 0 -text $string_table::str_mpr_type
    label $widgets(lblMeasure) -anchor w -borderwidth 0 -text $string_table::str_distance

    scale $widgets(sclMPR) -label $string_table::str_slices -orient horizontal

}

proc u_mpr::positionate { } {

    # For programming facilities
    upvar u_mpr::widgets widgets

    pack  $widgets(work3D)     -anchor nw -expand 1 -fill both -side left
    pack  $widgets(controls)   -anchor nw -expand 0 -fill both -side left
    place $widgets(type)       -x 10 -y 80 -width 175 -height 100 -anchor nw -bordermode ignore
    place $widgets(btnSagital) -x 5 -y 5 -anchor nw -bordermode ignore
    place $widgets(btnAxial)   -x 5 -y 35 -anchor nw -bordermode ignore
    place $widgets(btnCoronal) -x 5 -y 65 -anchor nw -bordermode ignore
    place $widgets(lbl001)     -x 55 -y 25 -anchor nw -bordermode ignore
    place $widgets(lbl002)     -x 15 -y 70 -anchor nw -bordermode ignore 
    place $widgets(sclMPR)     -x 5 -y 245 -width 178 -height 59 -anchor nw -bordermode ignore 
    place $widgets(frMeasure)  -x 5 -y 430 -width 180 -height 25 -anchor nw -bordermode ignore 
    pack  $widgets(lblMeasure) -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack  $widgets(edtMeasure) -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 

}

proc u_mpr::forget { } {

    # For programming facilities
    upvar u_mpr::widgets widgets

    pack  forget $widgets(edtMeasure)
    pack  forget $widgets(lblMeasure)
    place forget $widgets(frMeasure)
    place forget $widgets(sclMPR)
    place forget $widgets(lbl002)
    place forget $widgets(lbl001)
    place forget $widgets(btnCoronal)
    place forget $widgets(btnAxial)
    place forget $widgets(btnSagital)
    place forget $widgets(type)
    pack  forget $widgets(controls)
    pack  forget $widgets(work3D)

}

proc u_mpr::set_data { } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::reference_actor reference_actor
    upvar u_mpr::mpr_data        mpr_data
    upvar u_mpr::actual_plane    actual_plane
    upvar u_mpr::bounds          bounds
    upvar u_mpr::intRange        intRange
    upvar u_mpr::select_first    select_first

    set resample [ GetVTKVolume_dll ]
    set bounds   [ $resample GetBounds ]

    # 3D outline
    catch { renderer_$widgets(work3D) RemoveActor outlineActor_$widgets(work3D) }
    catch { outlineActor_$widgets(work3D)  Delete }
    catch { outlineMapper_$widgets(work3D) Delete }
    catch { outlineSource_$widgets(work3D) Delete }
    catch { lookup_$widgets(work3D)        Delete }

    # render widget
    destroy $widgets(work3D)
    vtkTkRenderWidget $widgets(work3D) -width 30 -height 30

    # TODO: change
    bindBasicEvents $widgets(work3D)

    set select_first 1
    bind $widgets(work3D) <Double-Button-1> "u_mpr::ev_dbl_select_st_point %x %y"
    bind $widgets(work3D) <Double-Button-3> "u_mpr::ev_dbl_select_point %x %y"
    $widgets(edtMeasure) delete 0 end
    
    catch { renderer_$widgets(work3D) Delete }
    vtkRenderer renderer_$widgets(work3D)
    renderer_$widgets(work3D) SetBackground 0 0 0
    #renderer_$widgets(work3D) SetBackground 1 1 1
    set render [ $widgets(work3D) GetRenderWindow ]
    $render AddRenderer renderer_$widgets(work3D)
    $render SetSize 1 1

    set u_mpr::stPoint {}

    for { set i 0 } { $i < 3 } { incr i } {    

        catch { renderer_$widgets(work3D) RemoveActor outline_actor_{$widgets(work3D)}_{$i} }
        catch { renderer_$widgets(work3D) RemoveActor plane_{$widgets(work3D)}_{$i} }
        catch { plane_{$widgets(work3D)}_{$i}          Delete }
        catch { mapper_{$widgets(work3D)}_{$i}         Delete }
        catch { strip_{$widgets(work3D)}_{$i}          Delete }
        catch { triangle_{$widgets(work3D)}_{$i}       Delete }
        catch { cast_{$widgets(work3D)}_{$i}           Delete }
        catch { probe_filter_{$widgets(work3D)}_{$i}   Delete }
        catch { outline_actor_{$widgets(work3D)}_{$i}  Delete }
        catch { outline_mapper_{$widgets(work3D)}_{$i} Delete }
        catch { outline_filter_{$widgets(work3D)}_{$i} Delete }
        catch { trans_filter_{$widgets(work3D)}_{$i}   Delete }
        catch { transform_{$widgets(work3D)}_{$i}      Delete }
        catch { source_{$widgets(work3D)}_{$i}         Delete }

    }

    vtkCubeSource outlineSource_$widgets(work3D)
        outlineSource_$widgets(work3D) SetXLength [ expr [ lindex $bounds 1 ] - [ lindex $bounds 0 ] ]
        outlineSource_$widgets(work3D) SetYLength [ expr [ lindex $bounds 3 ] - [ lindex $bounds 2 ] ]
        outlineSource_$widgets(work3D) SetZLength [ expr [ lindex $bounds 5 ] - [ lindex $bounds 4 ] ]
        outlineSource_$widgets(work3D) SetCenter  \
            [ expr ( [ lindex $bounds 0 ] + [ lindex $bounds 1 ] ) / 2 ] \
            [ expr ( [ lindex $bounds 2 ] + [ lindex $bounds 3 ] ) / 2 ] \
            [ expr ( [ lindex $bounds 4 ] + [ lindex $bounds 5 ] ) / 2 ]

    vtkPolyDataMapper outlineMapper_$widgets(work3D)
        outlineMapper_$widgets(work3D) SetInput [ outlineSource_$widgets(work3D) GetOutput ]
        outlineMapper_$widgets(work3D) ImmediateModeRenderingOn

    vtkActor outlineActor_$widgets(work3D)
        outlineActor_$widgets(work3D) SetMapper outlineMapper_$widgets(work3D)
        [ outlineActor_$widgets(work3D) GetProperty ] SetRepresentationToWireframe
        [ outlineActor_$widgets(work3D) GetProperty ] SetColor    0.7 0.0 0.9
        [ outlineActor_$widgets(work3D) GetProperty ] SetAmbient  1
        [ outlineActor_$widgets(work3D) GetProperty ] SetDiffuse  0
        [ outlineActor_$widgets(work3D) GetProperty ] SetSpecular 0

    renderer_$widgets(work3D) AddActor outlineActor_$widgets(work3D)

    # Probe planes
    set range    [ GetImageRange_dll ]
    set xdiff    [ lindex [ split [ expr [ lindex $bounds 1 ] - [ lindex $bounds 0 ] ] . ] 0 ]
    set ydiff    [ lindex [ split [ expr [ lindex $bounds 3 ] - [ lindex $bounds 2 ] ] . ] 0 ]
    set zdiff    [ lindex [ split [ expr [ lindex $bounds 5 ] - [ lindex $bounds 4 ] ] . ] 0 ]

    vtkWindowLevelLookupTable lookup_$widgets(work3D)
        lookup_$widgets(work3D) SetHueRange 0.0 1.0
        lookup_$widgets(work3D) SetNumberOfColors [ lindex [ split [ expr [ lindex $range 1 ] - [ lindex $range 0 ] + 1 ] . ] 0 ]
        lookup_$widgets(work3D) SetTableRange [ lindex $range 0 ] [ lindex $range 1 ]
        lookup_$widgets(work3D) SetSaturationRange 0 0
        lookup_$widgets(work3D) SetValueRange 0 1
        lookup_$widgets(work3D) SetAlphaRange 1 1
        lookup_$widgets(work3D) Build

    for { set i 0 } { $i < 3 } { incr i } {

        vtkPlaneSource source_{$widgets(work3D)}_{$i}
            source_{$widgets(work3D)}_{$i} SetResolution [ expr ( $i == 0 )? $zdiff: $xdiff ] [ expr ( $i == 1 )? $zdiff: $ydiff ]

        vtkTransform transform_{$widgets(work3D)}_{$i}
            transform_{$widgets(work3D)}_{$i} Identity
            transform_{$widgets(work3D)}_{$i} Translate \
                [ expr ( $xdiff / 2 ) + [ lindex $bounds 0 ] ] \
                [ expr ( $ydiff / 2 ) + [ lindex $bounds 2 ] ] \
                [ expr ( $zdiff / 2 ) + [ lindex $bounds 4 ] ]
            transform_{$widgets(work3D)}_{$i} Scale $xdiff $ydiff $zdiff
            if { $i == 0 } { transform_{$widgets(work3D)}_{$i} RotateY 90 }
            if { $i == 1 } { transform_{$widgets(work3D)}_{$i} RotateX 90 }

        vtkTransformPolyDataFilter trans_filter_{$widgets(work3D)}_{$i}
            trans_filter_{$widgets(work3D)}_{$i} SetInput [ source_{$widgets(work3D)}_{$i} GetOutput ]
            trans_filter_{$widgets(work3D)}_{$i} SetTransform transform_{$widgets(work3D)}_{$i}

        vtkOutlineFilter outline_filter_{$widgets(work3D)}_{$i}
            outline_filter_{$widgets(work3D)}_{$i} SetInput [ trans_filter_{$widgets(work3D)}_{$i} GetOutput ]

        vtkPolyDataMapper outline_mapper_{$widgets(work3D)}_{$i}
            outline_mapper_{$widgets(work3D)}_{$i} SetInput [ outline_filter_{$widgets(work3D)}_{$i} GetOutput ]

        vtkActor outline_actor_{$widgets(work3D)}_{$i}
            outline_actor_{$widgets(work3D)}_{$i} SetMapper outline_mapper_{$widgets(work3D)}_{$i}
            [ outline_actor_{$widgets(work3D)}_{$i} GetProperty ] SetRepresentationToWireframe
            [ outline_actor_{$widgets(work3D)}_{$i} GetProperty ] SetColor    0.7 0.0 0.9
            [ outline_actor_{$widgets(work3D)}_{$i} GetProperty ] SetAmbient  1
            [ outline_actor_{$widgets(work3D)}_{$i} GetProperty ] SetDiffuse  0
            [ outline_actor_{$widgets(work3D)}_{$i} GetProperty ] SetSpecular 0

        vtkProbeFilter probe_filter_{$widgets(work3D)}_{$i}
            probe_filter_{$widgets(work3D)}_{$i} SetInput [ trans_filter_{$widgets(work3D)}_{$i} GetOutput ]
            probe_filter_{$widgets(work3D)}_{$i} SetSource $resample

        vtkCastToConcrete cast_{$widgets(work3D)}_{$i}
            cast_{$widgets(work3D)}_{$i} SetInput [ probe_filter_{$widgets(work3D)}_{$i} GetOutput ]

        vtkTriangleFilter triangle_{$widgets(work3D)}_{$i}
            triangle_{$widgets(work3D)}_{$i} SetInput [ cast_{$widgets(work3D)}_{$i} GetPolyDataOutput ]

        vtkStripper strip_{$widgets(work3D)}_{$i}
            strip_{$widgets(work3D)}_{$i} SetInput [ triangle_{$widgets(work3D)}_{$i} GetOutput ]

        vtkPolyDataMapper mapper_{$widgets(work3D)}_{$i}
        mapper_{$widgets(work3D)}_{$i} SetInput [ strip_{$widgets(work3D)}_{$i} GetOutput ]
        mapper_{$widgets(work3D)}_{$i} SetLookupTable lookup_$widgets(work3D)
        mapper_{$widgets(work3D)}_{$i} SetScalarRange [ lindex $range 0 ] [ lindex $range 1 ]
        mapper_{$widgets(work3D)}_{$i} ImmediateModeRenderingOn

        vtkActor plane_{$widgets(work3D)}_{$i}
            plane_{$widgets(work3D)}_{$i} SetMapper mapper_{$widgets(work3D)}_{$i}
            [ plane_{$widgets(work3D)}_{$i} GetProperty ] SetOpacity 1.0

    }

    [ $widgets(work3D) GetRenderWindow ] Render

    $widgets(btnSagital) deselect
    $widgets(btnAxial)   deselect
    $widgets(btnCoronal) deselect

    $widgets(btnCoronal) invoke

    global_window::active_controls [ expr \
        $global_window::en_open   | \
        $global_window::en_load   | \
        $global_window::en_params | \
        $global_window::en_rotate |  \
        $global_window::en_pan    |  \
        $global_window::en_bright |  \
        $global_window::en_zoom      \
    ]

}

proc u_mpr::set_probe { typ col } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::reference_actor reference_actor
    upvar u_mpr::mpr_data        mpr_data
    upvar u_mpr::actual_plane    actual_plane
    upvar u_mpr::bounds          bounds
    upvar u_mpr::intRange        intRange

    catch { renderer_$widgets(work3D) RemoveActor outline_actor_{$widgets(work3D)}_{$actual_plane} }
    catch { renderer_$widgets(work3D) RemoveActor plane_{$widgets(work3D)}_{$actual_plane} }
    catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_1_$widgets(work3D) ] }
    DeleteSphere sphere_1_$widgets(work3D)
    catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_2_$widgets(work3D) ] }
    DeleteSphere sphere_2_$widgets(work3D)
    catch { renderer_$widgets(work3D) RemoveActor textActor_$widgets(work3D) }
    catch { textActor_$widgets(work3D) Delete }
    catch { textMapper_$widgets(work3D) Delete }
    catch { textSource_$widgets(work3D) Delete }
    catch { tmp_picker_$widgets(work3D) Delete }

    if { $actual_plane == 1 } {

        [ renderer_$widgets(work3D) GetActiveCamera ] Elevation -90.0
        [ renderer_$widgets(work3D) GetActiveCamera ] OrthogonalizeViewUp

    }
    if { $actual_plane == 0 } {

            [ renderer_$widgets(work3D) GetActiveCamera ] Azimuth -90.0
            [ renderer_$widgets(work3D) GetActiveCamera ] OrthogonalizeViewUp

    }
    [ $widgets(work3D) GetRenderWindow ] Render
    set actual_plane [ expr $typ - 1 ]
    if { $actual_plane == 0 || $actual_plane == 1 || $actual_plane == 2 } {
    
        set r [ expr "0x[ string index $col 1 ][ string index $col 2 ]" / 255.0 ]
        set g [ expr "0x[ string index $col 3 ][ string index $col 4 ]" / 255.0 ]
        set b [ expr "0x[ string index $col 5 ][ string index $col 6 ]" / 255.0 ]
        [ outline_actor_{$widgets(work3D)}_{$actual_plane} GetProperty ] SetColor $r $g $b
        renderer_$widgets(work3D) AddActor outline_actor_{$widgets(work3D)}_{$actual_plane}
        renderer_$widgets(work3D) AddActor plane_{$widgets(work3D)}_{$actual_plane}

        [ $widgets(work3D) GetRenderWindow ] Render

        set resample [ GetVTKVolume_dll ]
        set bounds   [ $resample GetBounds ]
        $widgets(sclMPR) configure \
            -from [ lindex $bounds [ expr ( $actual_plane == 0 )? 0: ( $actual_plane == 1 )? 2: 4 ] ] \
            -to   [ lindex $bounds [ expr ( $actual_plane == 0 )? 1: ( $actual_plane == 1 )? 3: 5 ] ] \
            -fg $col \
            -resolution 0.5

        bind $widgets(sclMPR) <Any-ButtonRelease>
        bind $widgets(sclMPR) <Any-ButtonRelease> "u_mpr::ev_change_slice 0"
        u_mpr::ev_change_slice 1

        [ $widgets(work3D) GetRenderWindow ] Render

        set xc [ expr ( [ lindex $bounds 1 ] + [ lindex $bounds 0 ] ) / 2 ]
        set yc [ expr ( [ lindex $bounds 3 ] + [ lindex $bounds 2 ] ) / 2 ]
        set zc [ expr ( [ lindex $bounds 5 ] + [ lindex $bounds 4 ] ) / 2 ]
        set xf $xc
        set yf $yc
        set zf $zc
        set zc [ expr $zc + 15 * [ expr [ lindex $bounds 5 ] - [ lindex $bounds 4 ] ] ]
        #[ renderer_$widgets(work3D) GetActiveCamera ] SetFocalPoint $xf $yf $zf
        #[ renderer_$widgets(work3D) GetActiveCamera ] SetPosition   $xc $yc $zc

        if { $actual_plane == 0 } {

            [ renderer_$widgets(work3D) GetActiveCamera ] Azimuth   90.0
            [ renderer_$widgets(work3D) GetActiveCamera ] OrthogonalizeViewUp

        } elseif { $actual_plane == 1 } {

            [ renderer_$widgets(work3D) GetActiveCamera ] Elevation 90.0
            [ renderer_$widgets(work3D) GetActiveCamera ] OrthogonalizeViewUp

        }

        [ $widgets(work3D) GetRenderWindow ] Render

    }

}

proc u_mpr::ev_change_slice { typ } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::reference_actor reference_actor
    upvar u_mpr::mpr_data        mpr_data
    upvar u_mpr::actual_plane    actual_plane
    upvar u_mpr::bounds          bounds
    upvar u_mpr::intRange        intRange

    catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_1_$widgets(work3D) ] }
    DeleteSphere sphere_1_$widgets(work3D)
    catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_2_$widgets(work3D) ] }
    DeleteSphere sphere_2_$widgets(work3D)
    catch { renderer_$widgets(work3D) RemoveActor textActor_$widgets(work3D) }
    catch { textActor_$widgets(work3D) Delete }
    catch { textMapper_$widgets(work3D) Delete }
    catch { textSource_$widgets(work3D) Delete }
    catch { tmp_picker_$widgets(work3D) Delete }
    if { $actual_plane == 0 || $actual_plane == 1 || $actual_plane == 2 } {
    
        if { $typ == 1 } {

            set slc [ expr ( [ $widgets(sclMPR) cget -to ] + [ $widgets(sclMPR) cget -from ] ) / 2 ]
            $widgets(sclMPR) set $slc

        } else { set slc [ $widgets(sclMPR) get ] }

        set resample [ GetVTKVolume_dll ]
        set bounds   [ $resample GetBounds ]
        set xdiff [ expr [ lindex $bounds 1 ] - [ lindex $bounds 0 ] ];
        set ydiff [ expr [ lindex $bounds 3 ] - [ lindex $bounds 2 ] ];
        set zdiff [ expr [ lindex $bounds 5 ] - [ lindex $bounds 4 ] ];

        transform_{$widgets(work3D)}_{$actual_plane} Identity
        transform_{$widgets(work3D)}_{$actual_plane} Translate \
            [ expr ( $actual_plane == 0 )? $slc: ( $xdiff / 2 ) + [ lindex $bounds 0 ] ] \
            [ expr ( $actual_plane == 1 )? $slc: ( $ydiff / 2 ) + [ lindex $bounds 2 ] ] \
            [ expr ( $actual_plane == 2 )? $slc: ( $zdiff / 2 ) + [ lindex $bounds 4 ] ]
        transform_{$widgets(work3D)}_{$actual_plane} Scale $xdiff $ydiff $zdiff
        if { $actual_plane == 0 } { transform_{$widgets(work3D)}_{$actual_plane} RotateY 90 }
        if { $actual_plane == 1 } { transform_{$widgets(work3D)}_{$actual_plane} RotateX 90 }
        [ $widgets(work3D) GetRenderWindow ] Render
    
    }

}

proc u_mpr::set_mouse_events { bright_type } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::reference_actor reference_actor
    upvar u_mpr::mpr_data        mpr_data
    upvar u_mpr::actual_plane    actual_plane
    upvar u_mpr::bounds          bounds
    upvar u_mpr::intRange        intRange

    if { $bright_type == 0 } {

        bind $widgets(work3D) <Any-ButtonPress>
        bind $widgets(work3D) <B1-Motion>

        # TODO: change
        bindBasicEvents $widgets(work3D)
        bindZoomEvents $widgets(work3D) 0

    } else {

        bind $widgets(work3D) <Any-ButtonPress>
        bind $widgets(work3D) <B1-Motion>

    }

}

proc u_mpr::ev_start_window_level { x y } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::reference_actor reference_actor
    upvar u_mpr::mpr_data        mpr_data
    upvar u_mpr::actual_plane    actual_plane
    upvar u_mpr::bounds          bounds
    upvar u_mpr::intRange        intRange
    upvar u_mpr::initX           initX
    upvar u_mpr::initY           initY
    upvar u_mpr::initWindow      initWindow
    upvar u_mpr::initLevel       initLevel

    set initX $x
    set initY $y

    set initWindow [ lookup_$widgets(work3D) GetWindow ]
    set initLevel  [ lookup_$widgets(work3D) GetLevel  ]

}

proc u_mpr::ev_window_level { x y } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::reference_actor reference_actor
    upvar u_mpr::mpr_data        mpr_data
    upvar u_mpr::actual_plane    actual_plane
    upvar u_mpr::bounds          bounds
    upvar u_mpr::intRange        intRange
    upvar u_mpr::initX           initX
    upvar u_mpr::initY           initY
    upvar u_mpr::initWindow      initWindow
    upvar u_mpr::initLevel       initLevel

    # get the widgets dimensions
    set width  [ lindex [ $widgets(work3D) configure -width ] 4 ]
    set height [ lindex [ $widgets(work3D) configure -height ] 4 ]

    # compute normalized delta
    set dx [ expr 4.0 * ( $x - $initX ) / $width  ]
    set dy [ expr 4.0 * ( $initY - $y ) / $height ]

    # scale by current values 
    set dx [ expr $dx * $initWindow ]
    set dy [ expr $dy * $initLevel  ]

    # abs so that direction does not flip
    if { $initWindow < 0.0 } { set dx [ expr 0 - $dx ] }
    if { $initLevel < 0.0  } { set dy [ expr 0 - $dy ] }
    
    # compute new window level
    set window [ expr $dx + $initWindow ]
    if {$window < 0.0} {
    set level [ expr $dy + $initLevel ]
    } else {
    set level [ expr $initLevel - $dy ]
    }
    
    if { $window < 0.0 } { set dy [ expr 0 - $dy ] }
    
    lookup_$widgets(work3D) SetWindow $window
    lookup_$widgets(work3D) SetLevel  $level

    [ $widgets(work3D) GetRenderWindow ] Render

}

proc u_mpr::ev_dbl_select_point { x y } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::actual_plane actual_plane
    upvar u_mpr::select_first select_first

    set y [ expr [ lindex [ $widgets(work3D) configure -height ] 4 ] - $y - 1 ]

    if { $select_first == 1 } {

        catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_1_$widgets(work3D) ] }
        DeleteSphere sphere_1_$widgets(work3D)
        catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_2_$widgets(work3D) ] }
        DeleteSphere sphere_2_$widgets(work3D)
        catch { tmp_picker_$widgets(work3D) Delete }

        vtkWorldPointPicker tmp_picker_$widgets(work3D)
        set pickWP    [ tmp_picker_$widgets(work3D) Pick $x $y 0 renderer_$widgets(work3D) ]
        set pickWPPos [ tmp_picker_$widgets(work3D) GetPickPosition ]
  
        set xc [ lindex $pickWPPos 0 ]
        set yc [ lindex $pickWPPos 1 ]
        set zc [ lindex $pickWPPos 2 ]
        set resample [ GetVTKVolume_dll ]
    
        set indP [ [ probe_filter_{$widgets(work3D)}_{$actual_plane} GetOutput ] FindPoint $xc $yc $zc ]
        set coordsP [ [ probe_filter_{$widgets(work3D)}_{$actual_plane} GetOutput ] GetPoint $indP ]

        renderer_$widgets(work3D) AddActor [ \
            DrawSphere \
                sphere_1_$widgets(work3D) \
                0.5 \
                [ lindex $coordsP 0 ] [ lindex $coordsP 1 ] [ lindex $coordsP 2 ] \
                1.0 0.5 0.5
        ]

        set select_first 0
    
    } else {

        catch { tmp_picker_$widgets(work3D) Delete }

        vtkWorldPointPicker tmp_picker_$widgets(work3D)
        set pickWP    [ tmp_picker_$widgets(work3D) Pick $x $y 0 renderer_$widgets(work3D) ]
        set pickWPPos [ tmp_picker_$widgets(work3D) GetPickPosition ]
  
        set xc [ lindex $pickWPPos 0 ]
        set yc [ lindex $pickWPPos 1 ]
        set zc [ lindex $pickWPPos 2 ]
        set resample [ GetVTKVolume_dll ]
    
        set indP [ [ probe_filter_{$widgets(work3D)}_{$actual_plane} GetOutput ] FindPoint $xc $yc $zc ]
        set coordsP [ [ probe_filter_{$widgets(work3D)}_{$actual_plane} GetOutput ] GetPoint $indP ]

        renderer_$widgets(work3D) AddActor [ \
            DrawSphere \
                sphere_2_$widgets(work3D) \
                0.5 \
                [ lindex $coordsP 0 ] [ lindex $coordsP 1 ] [ lindex $coordsP 2 ] \
                1.0 0.5 0.5
        ]

        set select_first 1

        set c1 [ sphere_1_$widgets(work3D) GetCenter ]
        set c2 [ sphere_2_$widgets(work3D) GetCenter ]
        set dist [ DistPoints \
            [ lindex $c1 0 ] \
            [ lindex $c1 1 ] \
            [ lindex $c1 2 ] \
            [ lindex $c2 0 ] \
            [ lindex $c2 1 ] \
            [ lindex $c2 2 ] \
        ]

        $widgets(edtMeasure) delete 0 end
        $widgets(edtMeasure) insert 0 "$dist"

    }    
    [ $widgets(work3D) GetRenderWindow ] Render

}

proc u_mpr::ev_dbl_select_st_point { x y } {

    # For programming facilities
    upvar u_mpr::widgets widgets
    upvar u_mpr::actual_plane actual_plane
    upvar u_mpr::select_first select_first

    set y [ expr [ lindex [ $widgets(work3D) configure -height ] 4 ] - $y - 1 ]

    catch { renderer_$widgets(work3D) RemoveActor [ GetSphereActorName sphere_st_$widgets(work3D) ] }
    DeleteSphere sphere_st_$widgets(work3D)
    catch { tmp_picker_$widgets(work3D) Delete }

    vtkWorldPointPicker tmp_picker_$widgets(work3D)
    set pickWP    [ tmp_picker_$widgets(work3D) Pick $x $y 0 renderer_$widgets(work3D) ]
    set pickWPPos [ tmp_picker_$widgets(work3D) GetPickPosition ]

    set xc [ lindex $pickWPPos 0 ]
    set yc [ lindex $pickWPPos 1 ]
    set zc [ lindex $pickWPPos 2 ]
    set resample [ GetVTKVolume_dll ]

    set indP [ [ probe_filter_{$widgets(work3D)}_{$actual_plane} GetOutput ] FindPoint $xc $yc $zc ]
    set coordsP [ [ probe_filter_{$widgets(work3D)}_{$actual_plane} GetOutput ] GetPoint $indP ]

    renderer_$widgets(work3D) AddActor [ \
        DrawSphere \
            sphere_st_$widgets(work3D) \
            1.0 \
            [ lindex $coordsP 0 ] [ lindex $coordsP 1 ] [ lindex $coordsP 2 ] \
            0.0 0.0 1.0
    ]
    set u_mpr::stPoint "[ lindex $coordsP 0 ] [ lindex $coordsP 1 ] [ lindex $coordsP 2 ]"

    [ $widgets(work3D) GetRenderWindow ] Render

}

proc u_mpr::set_mouse_left_events { mask } {

    # For programming facilities
    upvar u_mpr::widgets widgets

    # TODO : change
    catch { bind $widgets(work3D) <Any-ButtonPress>   { ev_startMotion %W %x %y } }
    catch { bind $widgets(work3D) <Any-ButtonRelease> { ev_endMotion %W %x %y } }

    catch { bind $widgets(work3D) <B1-Motion> { evz_pan %W %x %y } }

}

proc u_mpr::set_mouse_right_events { mask } {

    # For programming facilities
    upvar u_mpr::widgets widgets

    if { [ expr $mask & 0x4 ] == 0x4 } {

        catch { bind $widgets(work3D) <ButtonPress-3>   { ev_startMotion %W %x %y } }
        catch { bind $widgets(work3D) <ButtonRelease-3> { ev_endMotion %W %x %y } }
        catch { bind $widgets(work3D) <B3-Motion>       { evz_zoom %W %x %y } }

    }
    if { [ expr $mask & 0x8 ] == 0x8 } { 

        catch { bind $widgets(work3D) <ButtonPress-3>   { u_mpr::ev_start_window_level %x %y } }
        catch { bind $widgets(work3D) <ButtonRelease-3> { } }
        catch { bind $widgets(work3D) <B3-Motion>       { u_mpr::ev_window_level %x %y } }

    }
    
}

# EOF - u_mpr.tcl
