%module maracas

%{
#include <wx/list.h>
#include <wx/string.h>
#include <vtkCellLocator.h>
#include <vtkImageData.h>
#include <vtkPolyData.h>
#include <vtkTclUtil.h>
#include "marTclInterface.h"
%}

%include typemaps.i

%typemap(tcl8,in) std::string& {

    int l;
    $target = new std::string( Tcl_GetStringFromObj( $source, &l ) );

}

%typemap(tcl8,freearg) std::string& {

    delete $source;

}

%typemap(tcl8,out) std::string {


    Tcl_AppendElement( interp, $source->c_str( ) );

}

%typemap(tcl8,in) wxStringList& {

    int l, i, s;
    Tcl_Obj *tmp;

    $target = new wxStringList;
    Tcl_ListObjLength( interp, $source, &l );
    for( i = 0; i < l; i++ ) {

        Tcl_ListObjIndex( interp, $source, i, &tmp );
        $target->Add( Tcl_GetStringFromObj( tmp, &s ) );

    } // rof

}

%typemap(tcl8,freearg) wxStringList& {

    delete $source;

}

%typemap(tcl8,out) wxStringList& {

    unsigned int i = 0;

    for( i = 0; i < $source->GetCount( ); i++ ) {

        Tcl_AppendElement( interp, ( *$source )[ i ] );

    } // rof

}

%typemap(tcl8,in) int * {

    int* c = NULL;
    int l, i;
    Tcl_Obj *tmp;

    Tcl_ListObjLength( interp, $source, &l );
    c = new int [ l ];
    for( i = 0; i < l; i++ ) {

        Tcl_ListObjIndex( interp, $source, i, &tmp );
        Tcl_GetIntFromObj( interp, tmp, &c[ i ] );

    } // rof

    $target = c;

}

%typemap(tcl8,out) ushort * {

    int i;
    int tam;
    char cad[ 100 ];

    if( $source != NULL ) {

        tam = ( int )$source[ 0 ];
        for( i = 1; i <= tam; i++ ) {

            sprintf( cad, "%d", $source[ i ] );
            Tcl_AppendElement( interp, cad );

        } // rof

    } // fi

}

%typemap(tcl8,out) double * {

    int i;
    int tam;
    char cad[ 100 ];

    if( $source != NULL ) {

        tam = ( int )$source[ 0 ];
        for( i = 1; i <= tam; i++ ) {

            sprintf( cad, "%f", $source[ i ] );
            Tcl_AppendElement( interp, cad );

        } // rof

    } // fi

}

%typemap(tcl8,in) vtkCellLocator * {

    int err, s;
    Tcl_Obj* tmp;

    Tcl_ListObjIndex( interp, $source, 0, &tmp );
    $target = ( vtkCellLocator* ) vtkTclGetPointerFromObject( Tcl_GetStringFromObj( tmp, &s ), "vtkCellLocator", interp, err );

}

%typemap(tcl8,out) vtkImageData * {

    int ( *command )( ClientData, Tcl_Interp*, int, char* [] ) = NULL;

    // this function already sets the return    
    vtkTclGetObjectFromPointer( interp, $source, command );

}

%typemap(tcl8,out) vtkPolyData * {

    int ( *command )( ClientData, Tcl_Interp*, int, char* [] ) = NULL;

    // this function already sets the return    
    vtkTclGetObjectFromPointer( interp, $source, command );

}

// INTERFACE

void freeAllMaracasInterfaces_dll( );

// Parameters functions
wxStringList params_dll          ( );
void         setParams_dll          ( wxStringList& raParams );
bool         saveParams_dll         ( std::string& fName );
bool         loadParams_dll         ( std::string& fName );
void         SetROIStep_dll         ( double vWidth );
double       GetActualVoxelSize_dll ( );

// DB functions
wxStringList studies_dll   ( );
wxStringList studyData_dll ( std::string& study );
wxStringList series_dll    ( std::string& study );
wxStringList serieData_dll ( std::string& study, std::string& serie );
void SubtractSeries_dll( std::string& sl, std::string& sr, std::string& ss, std::string& description );

// Image functions
bool         LoadImages_dll        ( );
void         LoadTkImages_dll      ( wxStringList& tkNames, Tcl_Interp* interp );
int          GetNumberOfImages_dll ( );
wxStringList GetImagesNumbers_dll  ( );

double GetImageIntensity_dll ( int x, int y, int z );

ushort* GetProfilFromTotalVolume_dll( int xO, int yO, int zO, int xF, int yF, int zF );

%apply int *OUTPUT { int* min, int* max, int* avg, int* sd, int* size };
void GetAreaValuesFromTotalVolume_dll( int xO, int yO, int zO, int xF, int yF, int zF, int* min, int* max, int* avg, int* sd, int* size );

// Experiment functions
bool SaveExperiment_dll ( std::string& fName );
bool LoadExperiment_dll ( std::string& fName );
void InitExperiment_dll ( int* voi );
void SetStartPoint_dll  ( int x, int y, int z );
void ExtractAxes_dll    ( );

int          GetNumberOfAxes_dll     ( );
vtkPolyData* GetAllAxes_dll          ( );
vtkPolyData* GetActualAxis_dll       ( );
int GetActualAxisNumberOfPoints_dll  ( );
double* GetActualAxisPoint_dll       ( int i );
vtkImageData* GetActualAxisSlice_dll ( int i );

void PrepareQuantification_dll( int i );
double GetAxisLength_dll( );

// VTK data retrieving functions
%apply int *OUTPUT { int* min, int* max };
void          GetImageRange_dll ( int* min, int* max );
vtkImageData* GetVTKVolume_dll  ( );

// Functions to replace
%apply double *OUTPUT { double* xI, double* yI, double* zI };
extern int IntersectWithLine_dll ( vtkCellLocator* iCellLocator, double x1, double y1, double z1, double x2, double y2, double z2, double tol, double *xI, double *yI, double *zI );
%apply double *OUTPUT { double* xP1, double* yP1, double* zP1, double* xP2, double* yP2, double* zP2 };
extern void TclPerpendiculars_dll( double xN, double yN, double zN, double angle, double *xP1, double *yP1, double *zP1, double *xP2, double *yP2, double *zP2 );

// EOF - local_typemaps.i
