/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __AutoControlPoints_h_INCLUDED__
#define __AutoControlPoints_h_INCLUDED__

#include "manualContourModel.h"
#include "Propagation.h"
#include "vectorFunctions.h"

class AutoControlPoints : Vector
{
	public:
			AutoControlPoints();
			~AutoControlPoints();		
			int GetSizeVector	( std::vector<double>*Vector );

			void PointLeft		( std::vector<double>*IndX, std::vector<double>*InY, std::vector<double>*InZ, 
								  double* lex, double* ley, double* lez );
			void PointRight		( std::vector<double>*IndX, std::vector<double>*InY, std::vector<double>*InZ, 
								  double* rix, double* riy, double* riz );
			void PointHigh		( std::vector<double>*IndX, std::vector<double>*InY, std::vector<double>*InZ, 
								  double* hix, double* hiy, double* hiz );
			void PointLow		( std::vector<double>*IndX, std::vector<double>*InY, std::vector<double>*InZ, 
								  double* lox, double* loy, double* loz );
			void TwoPoints		( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			
			void Intersection	( double x01, double y01, double x02, double y02, double mn, double m2, double* x, double* y );
			void InterBetweenContours			( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void GetInterBetweenContours		( std::vector<Vector>*interVX, std::vector<Vector>*interVY );
			void IntersectionPoints				( );
			void GetIntersectionPoints			( std::vector<Vector>*interVX, std::vector<Vector>*interVY );
			void GetErrorBetweenContours		( std::vector<double>*vec );
			void CalculeControlPoints			( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void GetControlPoints				( std::vector<double>*OutX, std::vector<double>*OutY, std::vector<double>*OutZ );
			void CalculeInitialControlPoints	( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void GetInitialControlPoints		( std::vector<double>*OutX, std::vector<double>*OutY, std::vector<double>*OutZ );
			void SetNumSplineInterpolation		( int num ); 
	
	private:
			void ChargeSpline					( );
			double	Slope						( double x0, double y0, double x1, double y1 );
			double	Normal						( double x0, double y0, double* m, double xi );
			void	CircleCenter				( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ, double *cx, double *cy, double *r );
			void	CirclePoints				( double cx, double cy, double r, double grad, double *x, double *y );	
			void	InterCircle					( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void	maxminLocal					( );
			void	fixBetweenPoints			( double val );
			void	ErrorBetweenContours		( );
			void	AddControlPoint				( bool activate );
			void	InterBetweenControl			( );
			void	fixBetweenControl			( );
			void	PossibleIntersections		( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void	ControlInContour			( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void	NearMaxError2Control		( );
			void	MoveControlPointInContour	( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			double	MoveAndAverage				( int dir, std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void	MoveControlPoints			( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void	GetNewPoints				( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			void	GetInitialNewPoints			( std::vector<double>*InX, std::vector<double>*InY, std::vector<double>*InZ );
			
			int						_SizeVectorIn;
			std::vector<double>		_controlpointsX;
			std::vector<double>		_controlpointsY;
			std::vector<double>		_controlpointsZ;

			manualContourModel		*_mContourModel;
			int						_numspline;
			double					_pathsize;

			std::vector<double>		_chargecontrolpointsX;
			std::vector<double>		_chargecontrolpointsY;
			std::vector<double>		_chargecontrolpointsZ;

			std::vector<double>		_circleX;
			std::vector<double>		_circleY;
			std::vector<double>		_intercircleX;
			std::vector<double>		_intercircleY;
			std::vector<double>		_intercircleDist;
			std::vector<double>		_interbewteencircleX;
			std::vector<double>		_interbewteencircleY;
			std::vector<double>		_interbewteencircleDist;
			std::vector<int>		_interbewteencirclePos;

			std::vector<int>		_posmaxlocal;
			std::vector<int>		_posminlocal;
			std::vector<double>		_maxlocalX;
			std::vector<double>		_maxlocalY;
			std::vector<double>		_minlocalX;
			std::vector<double>		_minlocalY;
			std::vector<double>		_minmaxlocalX;
			std::vector<double>		_minmaxlocalY;
			std::vector<int>		_posminmaxlocal;

			std::vector<Vector>		_intervectorX;
			std::vector<Vector>		_intervectorY;
			std::vector<double>		_interpointsX;
			std::vector<double>		_interpointsY;
			int						_posA;
			int						_posB;

			double					_errorpos;
			std::vector<double>		_errorvector;
			
			std::vector<Vector>		_intervecXX;
			std::vector<Vector>		_intervecYY;
			std::vector<Vector>		_interitselfX;
			std::vector<Vector>		_interitselfY;

			int						_posn;
			std::vector<int>		_contIncontpos;	

};

#endif //  __AutoControlPoints_h_INCLUDED__
 
 
