/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "ContourCrownWidget.h"

#include <vtkImageMapToColors.h>
#include <vtkImageActor.h>

#include "wxVtk2DBaseView.h"
#include "vtkLookupTable.h"

//----------------------------------------------------------------------
  wxMaracasCoutourTool::wxMaracasCoutourTool(wxWindow *parent)
    : wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
  {
	wxPanel	*panel			= this;
    wxSizer *sizer			= NULL;
	
	// Widget interface
	wxButton *btnContourA   = new wxButton( panel, -1, _T("Crown Extern"));
	wxButton *btnContourB   = new wxButton( panel, -1, _T("Crown Intern"));
	wxButton *btnContourAB  = new wxButton( panel, -1, _T("Crown Extern and Intern"));

//JSTG 21-03-08 --------------------------------------------------------------------
	wxButton *btnSaveContour		= new wxButton( panel, -1, _T("Save Contour"));
	wxButton *btnSaveControlPoints  = new wxButton( panel, -1, _T("Save Control Points"));
//JSTG 11-04-08
	wxButton *btnEreaseLastContour  = new wxButton( panel, -1, _T("Erease Last Contour"));
	wxButton *btnEreaseLastCP		= new wxButton( panel, -1, _T("Erease Last Control Points"));
//----------------------------------------------------------------------------------

	wxFlexGridSizer *sizer1 = new wxFlexGridSizer(10); //Original Value = 10
    sizer1->Add(new wxStaticText(panel,-1,_T("  ")));
    sizer1->Add(new wxStaticText(panel,-1,_T("  ")));

    Connect(btnContourA->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxMaracasCoutourTool::OnContourA  );
    Connect(btnContourB->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxMaracasCoutourTool::OnContourB  );
    Connect(btnContourAB->GetId()	, wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxMaracasCoutourTool::OnContourAB );

//JSTG 21-03-08 ---------------------------------------------------------------------
	Connect(btnSaveContour->GetId(), wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxMaracasCoutourTool::OnSaveContour );
	Connect(btnSaveControlPoints->GetId(), wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxMaracasCoutourTool::OnSaveControlPoints );
//JSTG 11-04-08
	Connect(btnEreaseLastContour->GetId(), wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxMaracasCoutourTool::EreaseLastContour );
	Connect(btnEreaseLastCP->GetId(), wxEVT_COMMAND_BUTTON_CLICKED  , (wxObjectEventFunction) &wxMaracasCoutourTool::EreaseLastCP );	
//-----------------------------------------------------------------------------------

    sizer1->Add(btnContourA);
    sizer1->Add(btnContourB);
    sizer1->Add(btnContourAB);

//JSTG 21-03-08 --------------------
	sizer1->Add(btnSaveContour);
	sizer1->Add(btnSaveControlPoints);
//JSTG 11-04-08
	sizer1->Add(btnEreaseLastContour);
	sizer1->Add(btnEreaseLastCP);
//----------------------------------	
	sizer = sizer1;
	panel	->	SetSizer(sizer);
    panel	->	SetAutoLayout(true);
    panel	->	Layout();  
	
}

  // ------------------------------------------------------------------------

  wxMaracasCoutourTool::~wxMaracasCoutourTool()
  {
  }

  // ------------------------------------------------------------------------
  wxVtkBaseView *wxMaracasCoutourTool::GetWxVtkBaseView()
	{
		return this->wxvtkbaseview;
	}


	// ------------------------------------------------------------------------
void wxMaracasCoutourTool::Init(wxVtkBaseView *wxvtkbaseview, vtkImageData* imagedata)
{
    this->imagedata			= imagedata;
	this->wxvtkbaseview		= wxvtkbaseview;
	
	InitVtkImagesResult();
	
	vtkLookupTable *table = vtkLookupTable::New();
	//	 table->SetAlphaRange(128,255);
	table->SetRange(0, 255); // image intensity range
	//   table->SetValueRange(0.0, 1.0); // from black to white
	table->SetValueRange(0.0, 255.0); // from black to white
	
	table->SetTableValue (0, 1.0 , 1.0 , 1.0 , 0.1 );
	table->SetTableValue (255, 1.0 , 1.0 , 0.0 , 0.1);
	
	//	 table->SetTableValue (0, 0.0 , 0.0 , 1.0 , 0.35 );
	//	 table->SetTableValue (255, 1.0 , 0.0 , 0.0 , 0.10);
	
	table->SetSaturationRange(0.0, 0.0); // no color saturation
	table->SetRampToLinear();
	table->Build();
	
	vtkImageMapToColors  *mapperImage 	= vtkImageMapToColors::New();
	vtkImageActor *actorImage			= vtkImageActor::New();

	mapperImage->SetLookupTable(table);


//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	mapperImage->SetInput( imagedataMaskResult );
	actorImage->SetInput( mapperImage->GetOutput() );
#else
	mapperImage->SetInputData( imagedataMaskResult );
	actorImage->SetInputData( mapperImage->GetOutput() );
#endif


	actorImage->SetOpacity(1);
	
	wxvtkbaseview->GetRenderer()->AddActor(actorImage);	
}


  // ------------------------------------------------------------------------
  void wxMaracasCoutourTool::ConfigureVTK()
  {
	  double spc[3];
	  this->imagedata->GetSpacing(spc);

 	// Contorno 1
	_manContourControl_1	= new manualContourControler();
	_mContourModel_1		= new manualContourModel();
	_mViewContour_1			= new manualViewContour();
	_mViewContour_1->SetModel( _mContourModel_1 );
	_mViewContour_1->SetWxVtkBaseView( this->wxvtkbaseview );
	_mViewContour_1->SetRange( 2 );
	_mViewContour_1->SetZ( 1000 );

//JSTG 18-06-07
	_mContourModel_1->SetNumberOfPointsSpline(100);


//EED 3 oct 2006
	_mViewContour_1->SetSpacing(spc);


//EED 3 oct 2006
	_mViewContour_1->SetColorNormalContour(0, 0, 1);
	_mViewContour_1->SetColorEditContour(0.5, 0.5, 0.5);


	_manContourControl_1->SetModelView( _mContourModel_1 , _mViewContour_1 );
	((vtkInteractorStyleBaseView*)this->wxvtkbaseview->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _manContourControl_1 );
	_manContourControl_1->CreateNewManualContour();
	_manContourControl_1->SetActive(false);
	_mViewContour_1->RefreshContour();


	// Contorno 2
	_manContourControl_2	= new manualContourControler();
	_mContourModel_2		= new manualContourModel();
	_mViewContour_2			= new manualViewContour();
	_mViewContour_2->SetModel( _mContourModel_2 );
	_mViewContour_2->SetWxVtkBaseView( this->wxvtkbaseview );
	_mViewContour_2->SetRange( 2 );
	_mViewContour_2->SetZ( 1000 );

//EED 3 oct 2006
	_mViewContour_2->SetSpacing(spc);

//EED 3 oct 2006
	_mViewContour_2->SetColorNormalContour(1, 0, 0);
	_mViewContour_2->SetColorEditContour(0.5, 0.5, 0.5);


	_manContourControl_2->SetModelView( _mContourModel_2 , _mViewContour_2 );
	((vtkInteractorStyleBaseView*)this->wxvtkbaseview->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _manContourControl_2 );
	_manContourControl_2->CreateNewManualContour();
	_manContourControl_2->SetActive(false);
	_mViewContour_2->RefreshContour();

//	Refresh();	

//JSTG 16-06-08
	_contprop = new ContourPropagation();
 }

//JSTG 26-02-08 -------------------------------------------------------------------------------------------------------------
  void wxMaracasCoutourTool::SetControlPoints(  std::vector<double> *InVectorX, 
												std::vector<double> *InVectorY, 
												std::vector<double> *InVectorZ )
  {
	int lstSize;
	if (InVectorX!=NULL)
	{
		int i,size=InVectorX->size();
		if (size!=0)
		{
			_mContourModel_1->DeleteAllPoints();
			_mViewContour_1->DeleteContour();

			for (i=0;i<size;i++)
			{
				lstSize = _mContourModel_1->AddPoint( (*InVectorX)[i] , (*InVectorY)[i] , (*InVectorZ)[i] );
				_mViewContour_1->AddPoint();
			}
			//_manContourControl_1->CreateNewManualContour();
			//_manContourControl_1->SetActive(true);
			_mViewContour_1->CreateNewContour();
			_mContourModel_1->UpdateSpline();
			_mViewContour_1->RefreshContour();
			//_mViewContour_1->Refresh ();
		} 
	 } 
  }

// JSTG 26-02-08 ------------------------------------------------------------------------------
  void wxMaracasCoutourTool::GetSplinePoints(   std::vector<double> *pLstContourX,
												std::vector<double> *pLstContourY,
												std::vector<double> *pLstContourZ  )
  {
	  int i;
	  double x,y,z;
	  _mContourModel_1->UpdateSpline();
	  
	  for(i=0; i<_mContourModel_1->GetNumberOfPointsSpline(); i++)
	  {
		_mContourModel_1->GetSpline_i_Point( i, &x, &y, &z );
		pLstContourX->push_back(x);
		pLstContourY->push_back(y);
		//pLstContourY->push_back(z);			//Fake Z -> For Visualization
		pLstContourZ->push_back(_zz);			//True Z -> For processing
	  }
  }
//---------------------------------------------------------------------------------------------

//------------------------------------------------------------------------
void wxMaracasCoutourTool::OnContourA(wxCommandEvent& event)
{
	_manContourControl_1 -> SetActive(true);
	_manContourControl_2 -> SetActive(false);
}
//------------------------------------------------------------------------
void wxMaracasCoutourTool::OnContourB(wxCommandEvent& event)
{
	_manContourControl_1 -> SetActive(false);
	_manContourControl_2 -> SetActive(true);
}
//------------------------------------------------------------------------
void wxMaracasCoutourTool::OnContourAB(wxCommandEvent& event)
{
	_manContourControl_1 -> SetActive(true);
	_manContourControl_2 -> SetActive(true);
}

//------------------------------------------------------------------------
void wxMaracasCoutourTool::GetMinMaxPoint(int *minPoint, 
										  int *maxPoint, 
										  manualViewBaseContour *manualviewbaseecontour,
										  manualContourModel *manualcontourmodel
										  )
{
	int i;
	//int	np  = manualviewbaseecontour->GetNumberOfPoints( );  // number of control points // JPRx

// JSTG 26-02-08 ---------------------------------------------------------------------------------------
	//int nps = manualviewbaseecontour->GetNumberOfPointsSpline(); // number of points in the spline
	int nps = manualcontourmodel->GetNumberOfPointsSpline(); // number of points in the spline
//------------------------------------------------------------------------------------------------------
	
// JSTG 26-02-08 ---------------------------------------------------------------------------------------
	//double x,y,z,t;
	double x,y,z;
	//double delta=( double ) ( np  ) / ( double ) ( nps  );
	manualcontourmodel->UpdateSpline();
	for (i=0; i<nps; i++)
	{
		//t= delta * (double)i;
		//manualcontourmodel->GetSplinePoint(t,x,y,z);
		manualcontourmodel->GetSpline_i_Point(i,&x,&y,&z);
		if (x<minPoint[0]){ minPoint[0]=(int)x; }
		if (y<minPoint[1]){ minPoint[1]=(int)y; }
		if (x>maxPoint[0]){ maxPoint[0]=(int)x; }
		if (y>maxPoint[1]){ maxPoint[1]=(int)y; }
	}
//------------------------------------------------------------------------------------------------------
}

//------------------------------------------------------------------------

int wxMaracasCoutourTool::AnalisisContourInside(int x, 
												int y, 
												manualViewBaseContour *manualviewbaseecontour,
												manualContourModel *manualcontourmodel
												)
{
	int result = 0;
	int i;
	int	np  = manualviewbaseecontour->GetNumberOfPoints( );  // number of control points

// JSTG 26-02-08 ---------------------------------------------------------------------------------------
	//int nps = manualviewbaseecontour->GetNumberOfPointsSpline(); // number of points in the spline
	int nps = manualcontourmodel->GetNumberOfPointsSpline(); // number of points in the spline
	//double x1,y1,z1,x2,y2,z2,t;
	double x1,y1,z1,x2,y2,z2;
	double xx1, yy1,xx2, yy2;
	//double delta=( double ) ( np  ) / ( double ) ( nps  );
	manualcontourmodel->UpdateSpline();
//------------------------------------------------------------------------------------------------------
	double d;
	bool ok;
	if (np>=2)
	{
// JSTG 26-02-08 ---------------------------------------------------------------------------------------
		nps--;
		//manualcontourmodel->GetSplinePoint(0,x1,y1,z1);
		manualcontourmodel->GetSpline_i_Point(0,&x1,&y1,&z1);
		for (i=1; i<=nps; i++)
		{
			ok=false;
			//t= delta * (double)(i%nps);
			//manualcontourmodel->GetSplinePoint(t,x2,y2,z2);
			manualcontourmodel->GetSpline_i_Point(i,&x2,&y2,&z2);
//------------------------------------------------------------------------------------------------------
			//by triangle similarity
			if ( ((y1<y2)&&(y>=y1)&&(y<y2)) || ((y1>y2)&&(y<=y1)&&(y>y2)) )
			{
				if (y1<y2) { xx1=x1; yy1=y1; xx2=x2; yy2=y2;} else { xx1=x2; yy1=y2; xx2=x1; yy2=y1; } 
				d = ( fabs(xx2-xx1)*(y-yy1) ) / (yy2-yy1) ;
				if (  ((xx1<xx2)&&(x<(xx1+d)))  ||  ((xx1>xx2)&&(x<(xx1-d)))  ) { result++; }
			}
			x1=x2; y1=y2; z1=z2;
		}
	}
	return result;
}

//------------------------------------------------------------------------


bool wxMaracasCoutourTool::isInside(int x, int y)
{
	bool result=false;

	int ext[6];
	imagedataValueResult->GetExtent(ext);

	if ((x>=0) && (x<=ext[1]) && (y>=0) && (y<=ext[3]))
	{
		int numberLeftA=AnalisisContourInside(x,y,_mViewContour_1, _mContourModel_1); 
		int numberLeftB=AnalisisContourInside(x,y,_mViewContour_2, _mContourModel_2);
		if ( (numberLeftA+numberLeftB) % 2 ==1){ 	result = true;  } 
	}

	return result;
}

//------------------------------------------------------------------------

double wxMaracasCoutourTool::GetDataValue(int x, int y)
{
	unsigned short *p;
	wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)wxvtkbaseview;
	int z = (int)wxvtk2dbaseview->GetVtkBaseData()->GetZ();
	//JSTG 13-03-08-----
	_zz = z;
	//------------------
	p = (unsigned short *)imagedata->GetScalarPointer(x,y,z);
	return (double)(*p);
}

//------------------------------------------------------------------------

void wxMaracasCoutourTool::PutVtkImageDataResultValue( int x, int y, double value )
{
	unsigned short *pValue;
	unsigned short *pMask;
	pValue	= (unsigned short *)imagedataValueResult->GetScalarPointer(x,y,0);
	pMask	= (unsigned short *)imagedataMaskResult->GetScalarPointer(x,y,0);
	*pMask	= 255;
	*pValue = (unsigned short)value;
}

//------------------------------------------------------------------------
void wxMaracasCoutourTool::ResetImageResult()
{
	unsigned short *pValue;
	unsigned short *pMask;
	pValue	= (unsigned short *)imagedataValueResult->GetScalarPointer(0,0,0);
	pMask	= (unsigned short *)imagedataMaskResult->GetScalarPointer(0,0,0);
	
	int ext[6];
	imagedataValueResult->GetExtent(ext);

	int i,size = (ext[1]-ext[0]+1) * (ext[3]-ext[2]+1); 
	for(i=0; i<size; i++)
	{
		*pMask	= 0;
		*pValue = 0;
		pMask++;
		pValue++;
	}
}
//------------------------------------------------------------------------

void wxMaracasCoutourTool::GetValuesInsideCrown(std::vector<double> *pLstValue,
												std::vector<double> *pLstValuePosX,
												std::vector<double> *pLstValuePosY,
												std::vector<double> *pLstValuePosZ)
{
  pLstValue->clear();
  pLstValuePosX->clear();
  pLstValuePosY->clear();
  pLstValuePosZ->clear();
  ResetImageResult();
  
	int minPoint[2];
	int maxPoint[2];
	int i,j;
	double value;


	minPoint[0]=999999;
	minPoint[1]=999999;
	maxPoint[0]=-999999;
	maxPoint[1]=-999999;

	GetMinMaxPoint(minPoint,maxPoint, _mViewContour_1, _mContourModel_1);
	GetMinMaxPoint(minPoint,maxPoint, _mViewContour_2, _mContourModel_2);

	for (j=minPoint[1]; j<maxPoint[1]; j++)
	{
		for (i=minPoint[0]; i<maxPoint[0]; i++)
		{
			if (isInside(i,j)==true)
			{
				value = GetDataValue(i,j);
				PutVtkImageDataResultValue(i,j,  value );
				pLstValue		-> push_back( value );
				pLstValuePosX	-> push_back( i );
				pLstValuePosY	-> push_back( j );
				pLstValuePosZ	-> push_back( -1 );
			} // if
		} // for
	} // for

	imagedataValueResult->Modified();
	imagedataMaskResult->Modified();
}

//------------------------------------------------------------------------

vtkImageData *wxMaracasCoutourTool::GetVtkImageValueResult()
{
	return imagedataValueResult;
}
//------------------------------------------------------------------------
vtkImageData *wxMaracasCoutourTool::GetVtkImageMaskResult()
{
	return imagedataMaskResult;
}
// ------------------------------------------------------------------------
void wxMaracasCoutourTool::InitVtkImagesResult()
  {
	  int ext[6];
	  int newDim[3];
	  double spc[3];
	  int scalartype;

	  imagedata->GetSpacing(spc);
	  imagedata->GetExtent(ext);
	  newDim[0]=ext[1]-ext[0]+1;
	  newDim[1]=ext[3]-ext[2]+1;
	  newDim[2]=1;
	  scalartype = imagedata->GetScalarType();

	  imagedataValueResult = vtkImageData::New();
//	  imagedataValueResult->SetScalarType(scalartype);
	  imagedataValueResult->SetSpacing(spc);
	  imagedataValueResult->SetDimensions( newDim );

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	  imagedataValueResult->SetScalarTypeToUnsignedShort();
	  imagedataValueResult->AllocateScalars();
#else
	  imagedataValueResult->AllocateScalars(VTK_UNSIGNED_SHORT,1);
#endif


	  imagedataMaskResult  = vtkImageData::New();
//	  imagedataMaskResult->SetScalarType(scalartype);
	  imagedataMaskResult->SetSpacing(spc);
	  imagedataMaskResult->SetDimensions( newDim );

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	  imagedataMaskResult->SetScalarTypeToUnsignedShort();
	  imagedataMaskResult->AllocateScalars();
#else
	  imagedataMaskResult->AllocateScalars(VTK_UNSIGNED_SHORT,1);
#endif


  }

//JSTG 21-03-08 -------------------------------------------------------------------
void wxMaracasCoutourTool::OnSaveContour(wxCommandEvent& event)
{
	//For write the actual time and date
	/*
	time_t timer;
	struct tm *tblock;
	timer = time(NULL);
	tblock = localtime(&timer);
	*/

	FILE *fd;
	
	//WHERE CAN I MAKE THEM DELETE!!!
	_mpoint = new manualPoint();

	std::vector<double> tempX;
	std::vector<double> tempY;
	std::vector<double> tempZ;
	tempX.clear();
	tempY.clear();
	tempZ.clear();

	int size = _mContourModel_1->GetNumberOfPointsSpline();
	wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)wxvtkbaseview;
	int z = (int)wxvtk2dbaseview->GetVtkBaseData()->GetZ();
	double xx, yy, zz;

	fd = fopen("C:/bbtk_JS/data/SavedContours.txt","a");
	//fprintf(fd,"Date %s", asctime(tblock) );
	fprintf(fd,"\nPointsContour %d", size );
	for(int i=0; i<size; i++)
	{
		_mContourModel_1->GetSpline_i_Point(i,&xx,&yy,&zz);
		fprintf(fd,"\n%f %f %d",xx,yy,z);	//z -> Contain the true value || zz -> Contain the cheating value for visualitation 
		tempX.push_back(xx);
		tempY.push_back(yy);
		tempZ.push_back(z);
	}
	fclose(fd);

//JSTG 16-06-08
	_contprop->appendContour(&tempX,&tempY,&tempZ);
}

//JSTG 21-03-08 --------------------------------------------------------------------
void wxMaracasCoutourTool::OnSaveControlPoints(wxCommandEvent& event)
{
	//For write the actual time and date
	/*
	time_t timer;
	struct tm *tblock;
	timer = time(NULL);
	tblock = localtime(&timer);
	*/
	FILE *fd;
	_mpoint = new manualPoint();
	int size = _mContourModel_1->GetSizeLstPoints();
	wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)wxvtkbaseview;
	int z = (int)wxvtk2dbaseview->GetVtkBaseData()->GetZ();

	fd = fopen("C:/bbtk_JS/data/SavedManualPoints.txt","a");
	//fprintf(fd,"Date %s", asctime(tblock) );
	fprintf(fd,"\nNumberOfControlPoints %d", size );
	for(int i=0; i<size; i++)
	{
		_mpoint = _mContourModel_1->GetManualPoint(i);
		fprintf(fd,"\n%f %f %d",_mpoint->GetX(),_mpoint->GetY(),z);
	}
	fclose(fd);
}
//----------------------------------------------------------------------------------
void wxMaracasCoutourTool::EreaseLastContour(wxCommandEvent& event)
{
	char firstline[30];
	int	size = 0,i,j;
	double x,y;
	int z;		
	
	_tempCX.clear();
	_tempCY.clear();
	_tempCZ.clear();
	_tempCPX.clear();
	_tempCPY.clear();
	_tempCPZ.clear();
	_SizesC.clear();
	_SizesCP.clear();

	FILE* fd;
	fd = fopen("C:/bbtk_JS/data/SavedContours.txt","r");
	if(fd!=NULL)
	{
		while(!feof(fd))	
		{
//		//fscanf(fd," %s %d",&firstline,&size); // JPRx
			fscanf(fd," %s %d",firstline,&size);

			_SizesC.push_back(size);
			for(j=0; j<size; j++)
			{
				fscanf(fd,"%lf %lf %d",&x,&y,&z);
				_tempCX.push_back(x);
				_tempCY.push_back(y);
				_tempCZ.push_back(z);
			}
		}
	}
	else
	{
		printf("\nJSTG - wxMaracasCoutourTool::EreaseLastContour - FILE NOT FOUND");
	}
	fclose(fd);

	for(i=0; i<size; i++)
	{
		_tempCX.pop_back();
		_tempCY.pop_back();
		_tempCZ.pop_back();
	}
	_SizesC.pop_back();
	
	fd = fopen("C:/bbtk_JS/data/SavedContours.txt","w");
	if(fd!=NULL)
	{
		int cont = 0;
		for(i=0; i<(int)(_SizesC.size()); i++)
		{
			fprintf(fd,"\nNumberOfPoints %d", _SizesC[i] );
			for(j=0; j<_SizesC[i]; j++)
			{
				fprintf(fd,"\n%f %f %d",_tempCX[j+cont],_tempCY[j+cont],_tempCZ[j+cont]);
			}
			cont = _SizesC[i];
		}
	}
	else
	{
		printf("\nJSTG - wxMaracasCoutourTool::EreaseLastContour - FILE NOT FOUND");
	}
	fclose(fd);

}
//----------------------------------------------------------------------------------
void wxMaracasCoutourTool::EreaseLastCP(wxCommandEvent& event)
{
	char firstline[30];
	int	size = 0,i,j;
	double x,y;
	int z;		
	
	_tempCX.clear();
	_tempCY.clear();
	_tempCZ.clear();
	_tempCPX.clear();
	_tempCPY.clear();
	_tempCPZ.clear();
	_SizesC.clear();
	_SizesCP.clear();

	FILE* fd;
	fd = fopen("C:/bbtk_JS/data/SavedManualPoints.txt","r");
	if(fd!=NULL)
	{
		while(!feof(fd))	
		{
			//fscanf(fd,"");  // ?? JPRx
			//fscanf(fd," %s %d",&firstline,&size);// JPRx
			fscanf(fd," %s %d",firstline,&size); 
			_SizesC.push_back(size);
			for(j=0; j<size; j++)
			{
				fscanf(fd,"%lf %lf %d",&x,&y,&z);
				_tempCX.push_back(x);
				_tempCY.push_back(y);
				_tempCZ.push_back(z);
			}
		}
	}
	else
	{
		printf("\nJSTG - wxMaracasCoutourTool::EreaseLastContour - FILE NOT FOUND");
	}
	fclose(fd);

	for(i=0; i<size; i++)
	{
		_tempCX.pop_back();
		_tempCY.pop_back();
		_tempCZ.pop_back();
	}
	_SizesC.pop_back();
	
	fd = fopen("C:/bbtk_JS/data/SavedManualPoints.txt","w");
	if(fd!=NULL)
	{
		int cont = 0;
		for(i=0; i<(int)(_SizesC.size()); i++)
		{
			fprintf(fd,"\nNumberOfControlPoints %d", _SizesC[i] );
			for(j=0; j<_SizesC[i]; j++)
			{
				fprintf(fd,"\n%f %f %d",_tempCX[j+cont],_tempCY[j+cont],_tempCZ[j+cont]);
			}
			cont = _SizesC[i];
		}
	}
	else
	{
		printf("\nJSTG - wxMaracasCoutourTool::EreaseLastContour - FILE NOT FOUND");
	}
	fclose(fd);
}
//----------------------------------------------------------------------------------
