/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "ContourPropagation.h"

//Construction
ContourPropagation::ContourPropagation()
{
	_propc = new PropContour();
	_autoc = new AutoControlPoints();
	_ext2D = new ExtractControlPoints2D();
	_InX.clear();
	_InY.clear();
	_InZ.clear();
	_sliceKeyContourVec.clear();
}
//Destruction
ContourPropagation::~ContourPropagation()
{
}
//-------------------------------------------------------------------------------------
void ContourPropagation::resetAppend()
{
	_InX.clear();
	_InY.clear();
	_InZ.clear();
	_InS.clear();
	_propc->ResetKeyContours();
	_sliceKeyContourVec.clear();
}

//-------------------------------------------------------------------------------------
bool ContourPropagation::ifSliceKeyContourExist(int slice)
{
	bool result=false;
	int i,size=_sliceKeyContourVec.size();
	for (i=0; ((i<size) && (result==false)); i++)
	{
		//int temp=_sliceKeyContourVec[i]; // JPRx
		if (_sliceKeyContourVec[i]==slice)
		{
			result=true;
		}
		if (_sliceKeyContourVec[i]>slice)
		{
			i=size;
		}
	}
	return result;
}

//-------------------------------------------------------------------------------------
void ContourPropagation::OrdenarSliceKeyContourVec()
{
	int i,j,tmp,size=_sliceKeyContourVec.size();
	for (i=0;i<size;i++)
	{
		for (j=0;j<size;j++)
		{
			if (_sliceKeyContourVec[i]<_sliceKeyContourVec[j])
			{
				tmp=_sliceKeyContourVec[i];
				_sliceKeyContourVec[i]=_sliceKeyContourVec[j];
				_sliceKeyContourVec[j]=tmp;
			}
		}
	}
}

//-------------------------------------------------------------------------------------
void ContourPropagation::appendContour(std::vector<double>*InX,std::vector<double>*InY,std::vector<double>*InZ)
{
/*
	vectorFunctions *vf = new vectorFunctions();
	vf->copyVector(InX,&_InX);
	vf->copyVector(InY,&_InY);
	vf->copyVector(InZ,&_InZ);
	delete vf;
*/


	int i,size = InX->size();
	if(size != 0)
	{
		_sliceKeyContourVec.push_back( (*InZ)[0] );
		OrdenarSliceKeyContourVec();
		for(i=0; i<size; i++)
		{
			_InX.push_back( (*InX)[i] );
			_InY.push_back( (*InY)[i] );
			_InZ.push_back( (*InZ)[i] );
		}
	}

	_InS.push_back(InX->size());
	_propc->SetKeyContours(InX,InY,InZ);
}
//-------------------------------------------------------------------------------------
//TEST CLASS FOR BBTK
void ContourPropagation::appendContour()
{
	_InX.clear();
	_InY.clear();
	_InZ.clear();
	_InS.clear();
	_propc->ResetKeyContours();
	FILE* fd;
	fd = fopen("C:/bbtk_JS/data/SavedContours.txt","r");
	_propc->ReadKeyContour( fd );
	fclose(fd);
	_propc->GetKeyContours(&_InX,&_InY,&_InZ,&_InS);
}
//-------------------------------------------------------------------------------------
bool ContourPropagation::mustOrderAppend()
{
	bool orderA = true;
	bool orderD = true;
	bool mustOrder = false;
	int i,j;

	if(_InS.size()>2)
	{
		//ASCENDING
		j=0;
		for(i=0; i<(int)(_InS.size())-1; i++)
		{
			if(_InZ[j]>_InZ[j+_InS[i]])
			{
				orderA = false;
			}
			j = j+_InS[i];
		}
		//DESCENDING
		if(orderA == false)
		{
			j=0;
			for(i=0; i<(int)(_InS.size())-1; i++)
			{
				if(_InZ[j]<_InZ[j+_InS[i]])
				{
					orderD = false;
				}
				j =	j+_InS[i];
			}
		}
		//IS ORGANIZED
		if((orderD == false) || (orderA == false))
		{
			mustOrder = true;
		}
		else
		{
			mustOrder = false;
		}
		return mustOrder;
	}
	return mustOrder;
}
//-------------------------------------------------------------------------------------
void ContourPropagation::orderAppend()
{
	int i,j,cont,cont2;
	std::vector<double> tempX;
	std::vector<double> tempY;
	std::vector<double> tempZ;
	std::vector<int> tempS;
	tempX.clear();
	tempY.clear();
	tempZ.clear();
	tempS.clear();
	
	bool mustOrder = mustOrderAppend();

	while( mustOrder == true )
	{
		tempX.clear();
		tempY.clear();
		tempZ.clear();
		tempS.clear();
		cont = 0;
		for(i=0; i<(int)(_InS.size())-1; i++)
		{
			if(_InZ[cont]<_InZ[cont+_InS[i]])
			{
				cont2 = cont;
				for(j=0; j<_InS[i]; j++)
				{
					tempX.push_back( _InX[cont2] );
					tempY.push_back( _InY[cont2] );
					tempZ.push_back( _InZ[cont2] );
					cont2++;
				}
				tempS.push_back( _InS[1] );
			}
			if(_InZ[cont]>_InZ[cont+_InS[i]])
			{
				cont2 = cont+_InS[i];
				for(j=0; j<_InS[i+1]; j++)
				{
					tempX.push_back( _InX[cont2] );
					tempY.push_back( _InY[cont2] );
					tempZ.push_back( _InZ[cont2] );
					cont2++;
				}
				tempS.push_back( _InS[i+1] );
				cont2 = cont;
				for(j=0; j<_InS[i]; j++)
				{
					tempX.push_back( _InX[cont2] );
					tempY.push_back( _InY[cont2] );
					tempZ.push_back( _InZ[cont2] );
					cont2++;
				}
				tempS.push_back( _InS[i] );
			}
			cont = cont + _InS[i];
		}
		_InX.clear();
		_InY.clear();
		_InZ.clear();	
		_InS.clear();
		vectorFunctions *vf = new vectorFunctions();
		vf->copyVector(&tempX,&_InX);
		vf->copyVector(&tempY,&_InY);
		vf->copyVector(&tempZ,&_InZ);
		delete vf;
		for(i=0; i<(int)(tempS.size()); i++)
		{
			_InS.push_back(tempS[i]);
		}
		mustOrder = mustOrderAppend();
	}

}
//-------------------------------------------------------------------------------------
void ContourPropagation::CalculeSplinePropagation()
{
	//_propc->SetKeyContours(&_InX,&_InY,&_InZ);
	_propc->GetKeyContours(&_InX,&_InY,&_InZ,&_InS);
	_propc->CalculeSplinePropagation();
}

//-------------------------------------------------------------------------------------
int ContourPropagation::FindIdWithZ(double z)
{
	return _propc->FindIdWithZ(z);
}



//-------------------------------------------------------------------------------------
//INITIAL AUTOMATIC METHOD
void ContourPropagation::GetInitialControlPoints(int id, std::vector<double>*vecX, std::vector<double>*vecY, std::vector<double>*vecZ)
{
	_propc->GetIdContour(id,vecX,vecY,vecZ);
	_ext2D->SetContour(vecX,vecY,vecZ);
	_ext2D->GetInitialControlPoints(vecX,vecY,vecZ);
}

//-------------------------------------------------------------------------------------
//AUTOMATIC METHOD
void ContourPropagation::GetControlPoints(int id, std::vector<double>*vecX, std::vector<double>*vecY, std::vector<double>*vecZ)
{
	//_propc->SetKeyContours(&_InX,&_InY,&_InZ);
//	_propc->CalculeSplinePropagation();
	_propc->GetIdContour(id,vecX,vecY,vecZ);
	_ext2D->SetContour(vecX,vecY,vecZ);
	_ext2D->GetControlPoints(vecX,vecY,vecZ);
}

//-------------------------------------------------------------------------------------
//SAMPLING METHOD
void ContourPropagation::GetControlPoints(int id, double samp, std::vector<double>*vecX, std::vector<double>*vecY, std::vector<double>*vecZ)
{
//	//_propc->SetKeyContours(&_InX,&_InY,&_InZ);
//	_propc->GetKeyContours(&_InX,&_InY,&_InZ,&_InS);
//	_propc->CalculeSplinePropagation();
//	int size = _InX.size();
	_propc->GetIdContour(id,vecX,vecY,vecZ);
//	int size2 = vecX->size();
	_ext2D->SetContour(vecX,vecY,vecZ);
	_ext2D->SetSamplingControlPoints(samp);
	_ext2D->GetSamplingControlPoints(vecX,vecY,vecZ);
}
//-------------------------------------------------------------------------------------
void ContourPropagation::GetContour(int id, std::vector<double>*vecX, std::vector<double>*vecY, std::vector<double>*vecZ)
{
	//orderAppend();
	_propc->SetKeyContours(&_InX,&_InY,&_InZ);
	_propc->CalculeSplinePropagation();
	_propc->GetIdContour(id,vecX,vecY,vecZ);
}
//-------------------------------------------------------------------------------------
//TEST CLASS FOR BBTK
vtkImageData* ContourPropagation::GetKeyContours(std::vector<double>*vecX, std::vector<double>*vecY, std::vector<double>*vecZ,std::vector<int>*vecS)
{
	//orderAppend();
	_propc->GetKeyContours(vecX,vecY,vecZ,vecS);	
	return _propc->CalculeSplinePropagation();
}
//-------------------------------------------------------------------------------------
void ContourPropagation ::getMaxMinZ(double *minz, double *maxz)
{
	vectorFunctions *vf = new vectorFunctions();
	vf->minVector(&_InZ,minz);
	vf->maxVector(&_InZ,maxz);
	delete vf;
}
//-------------------------------------------------------------------------------------
void ContourPropagation::setInterpolationNumber(int num)
{
	_propc->SetInterpNumber(num);
}
//-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------

