/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __ContourPropagation_h_INCLUDED__
#define __ContourPropagation_h_INCLUDED__

#include "Propagation.h"
#include "ExtractControlPoints2D.h"
#include "vtkImageData.h"
#include "vectorFunctions.h"
#include "marTypes.h"

class creaMaracasVisu_EXPORT ContourPropagation 
{
	public:
		ContourPropagation();
		~ContourPropagation();
		void resetAppend				( );
		void appendContour				( std::vector<double>*InX, 
										  std::vector<double>*InY, 
										  std::vector<double>*InZ );
		void GetContour					( int id, std::vector<double>*vecX, 
												  std::vector<double>*vecY, 
												  std::vector<double>*vecZ );
		//AUTOMATIC METHOD
		void GetInitialControlPoints	( int id, std::vector<double>*vecX, 
												  std::vector<double>*vecY, 
												  std::vector<double>*vecZ);
		void GetControlPoints			( int id, std::vector<double>*vecX, 
												  std::vector<double>*vecY, 
												  std::vector<double>*vecZ );

		//SAMPLING METHOD
		void CalculeSplinePropagation();
		void GetControlPoints			( int id, double samp,
										  std::vector<double>*vecX, 
										  std::vector<double>*vecY, 
										  std::vector<double>*vecZ );

		int  FindIdWithZ				( double z);


		void getMaxMinZ					( double *minz, double *maxz);
		void setInterpolationNumber		( int num );


	//TEST CLASSES FOR BBTK
		void appendContour				( );
		vtkImageData* GetKeyContours	( std::vector<double>*vecX, 
										  std::vector<double>*vecY, 
										  std::vector<double>*vecZ, 
										  std::vector<int>*vecS );

		bool ifSliceKeyContourExist(int slice);


	private:
		bool mustOrderAppend( );
		void orderAppend( );
		void OrdenarSliceKeyContourVec();
		

		PropContour					*_propc;
		AutoControlPoints			*_autoc;
		ExtractControlPoints2D		*_ext2D;

		std::vector<double>			_InX;
		std::vector<double>			_InY;
		std::vector<double>			_InZ;
		std::vector<int>			_InS;
		std::vector<int>			_sliceKeyContourVec;

		std::vector<Vector>			_planevector;
};

#endif //__ContourPropagation_h_INCLUDED__
 
 
