/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "ContourVOIWidget.h"

//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

  wxWidgetSliderMinMaxVOI :: wxWidgetSliderMinMaxVOI(ContourVOIWidget *contourtool,
													 mBarRange *modelBarRange )
		:wxEvtHandler()
		{			
			modBarRange = modelBarRange;
			mcontourtool = contourtool;
			modBarRange->PushEventHandler(this);
			Connect(modBarRange->GetId(),wxEVT_TSBAR,(wxObjectEventFunction) (wxCommandEventFunction) &wxWidgetSliderMinMaxVOI::onBarrange );
			Connect(modBarRange->GetId(),wxEVT_TSBAR_ACTUAL,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMaxVOI::onActualChange_Bar );
			Connect(modBarRange->GetId(),wxEVT_TSBAR_START,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMaxVOI::onStartChange_Bar );
			Connect(modBarRange->GetId(),wxEVT_TSBAR_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMaxVOI::onEndChange_Bar );
			Connect(modBarRange->GetId(),wxEVT_SELECTION_END,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMaxVOI::onSelectionEnd );
			Connect(modBarRange->GetId(),wxEVT_TSBAR_MOVED,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMaxVOI::onMovedBar );		
		}

		wxWidgetSliderMinMaxVOI ::  ~wxWidgetSliderMinMaxVOI()
		{
			
		}
		

	  //--------------------------------------------------------------------------------------------------------------------------------
	  // Min-Max Barrange received events
	  //--------------------------------------------------------------------------------------------------------------------------------
		void wxWidgetSliderMinMaxVOI :: onBarrange(wxCommandEvent& event)
		{

		}
		void wxWidgetSliderMinMaxVOI :: onActualChange_Bar(wxCommandEvent& event)
		{
std::cout << "wxWidgetSliderMinMaxVOI ::onActualChange_Bar" << std::endl;
			wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)mcontourtool->GetWxVtkBaseView();
			wxvtk2dbaseview->GetVtkBaseData()->SetZ(modBarRange->GetActual());
			wxvtk2dbaseview->Refresh();
		}
		void wxWidgetSliderMinMaxVOI :: onStartChange_Bar(wxCommandEvent& event)
		{
std::cout << "wxWidgetSliderMinMaxVOI ::onStartChange_Bar" << std::endl;
			wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)mcontourtool->GetWxVtkBaseView();
			wxvtk2dbaseview->GetVtkBaseData()->SetZ(modBarRange->GetStart());
			wxvtk2dbaseview->Refresh();
//EED			mcontourtool->ProcessOutputs();
		}
		void wxWidgetSliderMinMaxVOI :: onEndChange_Bar(wxCommandEvent& event)
		{
std::cout << "wxWidgetSliderMinMaxVOI ::onEndChange_Bar" << std::endl;
			wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)mcontourtool->GetWxVtkBaseView();
			wxvtk2dbaseview->GetVtkBaseData()->SetZ(modBarRange->GetEnd());
			wxvtk2dbaseview->Refresh();
//EED			mcontourtool->ProcessOutputs();
		}
		void wxWidgetSliderMinMaxVOI :: onSelectionEnd(wxCommandEvent& event)
		{
		}
		void wxWidgetSliderMinMaxVOI :: onMovedBar(wxCommandEvent& event)
		{
//EED			mcontourtool->ProcessOutputs();
		}
//----------------------------------------------------------------------
//----------------------------------------------------------------------
//----------------------------------------------------------------------


  ContourVOIWidget::ContourVOIWidget(wxWindow *parent, wxVtkBaseView *wxvtkbaseview, vtkImageData* imagedata)
    : wxPanel( parent, -1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
  {
//EED    this->mbbtkContourCrown	= contourcrown;
    this->imagedata					= imagedata;
	this->wxvtkbaseview				= wxvtkbaseview;
	wxPanel	*panel					= this;
    wxSizer *sizer					= NULL;
	
	mbarrange = new mBarRange(panel,200, 65); 
 	mbarrange -> SetOrientation( true );
	mbarrange -> setActiveStateTo(true);
	mbarrange -> setVisibleLabels( true );
	mbarrange -> setDeviceEndMargin(10);
   	mbarrange -> setRepresentedValues( 0 , 100 );
	mbarrange -> setDeviceBlitStart(10,10); 
	mbarrange -> setIfWithActualDrawed( true );
	mbarrange -> SetStart( 10 );
	mbarrange -> SetEnd( 90 );  

	//wxWidgetSliderMinMaxVOI * eventHandler = new wxWidgetSliderMinMaxVOI(this, mbarrange); // JPRx

	wxFlexGridSizer *sizer1 = new wxFlexGridSizer(10);
	sizer1->AddGrowableCol(0);
        sizer1->Add(mbarrange,1,wxGROW);
	sizer = sizer1;
	panel -> SetSizer(sizer);

    panel	->	SetAutoLayout(true);
    panel	->	Layout();  
  }

  // ------------------------------------------------------------------------

  ContourVOIWidget::~ContourVOIWidget()
  {
  }

  // ------------------------------------------------------------------------
  wxVtkBaseView *ContourVOIWidget::GetWxVtkBaseView()
	{
		return this->wxvtkbaseview;
	}


  // ------------------------------------------------------------------------


  void ContourVOIWidget::ConfigureVTK()
  {
	  double spc[3];
	  this->imagedata->GetSpacing(spc);

	  // LG 14 dec 2007
	  int dim[3];
	  this->imagedata->GetDimensions(dim);
	  mbarrange -> setRepresentedValues( 0 , dim[2] );
	
	// Rectangulo
	_manRoiControl  = new manualRoiControler();
	_mContourModel  = new manualContourModelRoi();
	_mViewRoi		= new manualViewRoi();
	_mViewRoi->SetModel( _mContourModel );
	_mViewRoi->SetWxVtkBaseView( this->wxvtkbaseview );
	_mViewRoi->SetRange( 2 );
	_mViewRoi->SetZ( 1000 );

//EED 3 oct 2006
	_mViewRoi->SetSpacing(spc);

	_manRoiControl->SetModelView( _mContourModel , _mViewRoi );
	((vtkInteractorStyleBaseView*)this->wxvtkbaseview->GetInteractorStyleBaseView())->AddInteractorStyleMaracas( _manRoiControl );
	_manRoiControl->CreateNewManualContour();
	_manRoiControl->SetActive(true);
	_mViewRoi->RefreshContour();


  }

//--------------------------------------------------------------------------------------------------------------------------------
void ContourVOIWidget::GetVOI( int voi[6] )
{
	double minX,minY,maxX,maxY;
	_mViewRoi->GetMinMax(minX,minY,maxX,maxY);
	voi[0]=(int)minX;
	voi[1]=(int)maxX;
	voi[2]=(int)minY;
	voi[3]=(int)maxY;

	voi[4] =  mbarrange->GetStart();
	voi[5] =  mbarrange->GetEnd();

	int border[6];
	wxVtk2DBaseView *wxvtk2dbaseview = (wxVtk2DBaseView*)wxvtkbaseview;
	wxvtk2dbaseview->GetVtkBaseData()->GetImageData()->GetExtent( border );

	if ( (voi[0]==voi[1]) || (voi[2]==voi[3]) || (voi[4]==voi[5]) )
	{
			voi[0] = border[0];
			voi[1] = border[1];
			voi[2] = border[2];
			voi[3] = border[3];
			voi[4] = border[4];
			voi[5] = border[5];
	}

	// border min
	if (voi[0]<border[0]) { voi[0]=border[0]; }
	if (voi[2]<border[2]) { voi[2]=border[2]; }
	if (voi[4]<border[4]) { voi[4]=border[4]; }

	// border max
	if (voi[1]>border[1]) { voi[1]=border[1]; }
	if (voi[3]>border[3]) { voi[3]=border[3]; }
	if (voi[5]>border[5]) { voi[5]=border[5]; }
}

//--------------------------------------------------------------------------------------------------------------------------------
/*EED
void wxMaracasCoutourTool::ProcessOutputs()
{
	int voi[6];
	GetVOI(voi);
	char buffer[40];
	sprintf(buffer,"%d %d %d ", voi[0], voi[2], voi[4] );
	std::string Index(buffer);
	sprintf(buffer,"%d %d %d ", voi[1]-voi[0]+1, voi[3]-voi[2]+1, voi[5]-voi[4]+1 );
	std::string Size(buffer);
	mbbtkContourCrown->bbSetOutputIndex( Index );
	mbbtkContourCrown->bbSetOutputSize( Size );
	std::vector<std::string> mod;
	mod.push_back("Index");
	mod.push_back("Size");
	mbbtkContourCrown->bbSignalOutputModification(mod);
}
*/



