/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "ExtractControlPoints2D.h"

//Construction
ExtractControlPoints2D::ExtractControlPoints2D()
{
	_numinterspline = 100;
	_numsampling = 25;
}
//Destruction
ExtractControlPoints2D::~ExtractControlPoints2D()
{
}
//-----------------------------------------------------------------------------------------
void ExtractControlPoints2D::ResetControlPoints()
{

}
//-----------------------------------------------------------------------------------------
void ExtractControlPoints2D::SetContour(std::vector<double>*InX, std::vector<double>*InY,std::vector<double>*InZ)
{
	int i;
	_InX.clear();
	_InY.clear();
	_InZ.clear();
	int sizeX = InX->size();
	int sizeY = InY->size();
	int sizeZ = InZ->size();
	if( (sizeX == sizeY) && (sizeY==sizeZ) )
	{
		for(i=0; i<sizeX; i++)
		{
			_InX.push_back( (*InX)[i] );
			_InY.push_back( (*InY)[i] );
			_InZ.push_back( (*InZ)[i] );
		} // for i
	} else {
		printf("\n The lists Of vectors have diferents sizes");
	}
}
//-----------------------------------------------------------------------------------------
//AUTOMATIC METHOD (INITIAL AND ADDING)
void ExtractControlPoints2D::GetInitialControlPoints(std::vector<double>*pOutX, std::vector<double>*pOutY, std::vector<double>*pOutZ)
{
	AutoControlPoints *autoc = new AutoControlPoints();
	pOutX->clear();
	pOutY->clear();
	pOutZ->clear();

	if(_InX.size() != 0)
	{
		autoc->SetNumSplineInterpolation((int)_numinterspline);
		autoc->CalculeInitialControlPoints(&_InX,&_InY,&_InZ);
		autoc->GetInitialControlPoints(pOutX,pOutY,pOutZ);
	}
	delete autoc;
}
//-----------------------------------------------------------------------------------------
//AUTOMATIC METHOD (INITIAL, ADDING AND SAMPLING)
void ExtractControlPoints2D::GetControlPoints(std::vector<double>*pOutX, std::vector<double>*pOutY, std::vector<double>*pOutZ)
{
	AutoControlPoints *autoc = new AutoControlPoints();
	pOutX->clear();
	pOutY->clear();
	pOutZ->clear();

	if(_InX.size() != 0)
	{
		autoc->SetNumSplineInterpolation((int)_numinterspline);
		autoc->CalculeControlPoints(&_InX,&_InY,&_InZ);
		autoc->GetControlPoints(pOutX,pOutY,pOutZ);
	}
	delete autoc;
}
//-----------------------------------------------------------------------------------------
//SET THE SAMPLING (PERCENT) FOR THE REGULAR SAMPLING METHOD
void ExtractControlPoints2D::SetSamplingControlPoints(double val)
{
	if(_InX.size() != 0)
	{
		_numsampling = _InX.size()* (val/100);
	}
}
//-----------------------------------------------------------------------------------------
//REGULAR SAMPLING METHOD
void ExtractControlPoints2D::GetSamplingControlPoints(std::vector<double>*pOutX, std::vector<double>*pOutY, std::vector<double>*pOutZ)
{
	pOutX->clear();
	pOutY->clear();
	pOutZ->clear();
	if(_InX.size() != 0)
	{
		int h = 1;
		//int j=0;  // JPRx
		int points = (int)(_InX.size()/_numsampling);
		for (int i=0; i<(int)(_InX.size()); i++, h++)
		{
			if( h == points )
			{
				pOutX->push_back( _InX[i] );
				pOutY->push_back( _InY[i] );
				pOutZ->push_back( _InZ[i] );
				h = 0;
			}
		}
	}
}
//-----------------------------------------------------------------------------------------
void ExtractControlPoints2D::SetNumberOfSplineInterpolation(double val)
{
	_numinterspline = val;
}
//------------------------------------------------------------------------------
 
 
