/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "contoursIntersection.h"

//Construction
contoursIntersection::contoursIntersection()
{
}
//Destruction
contoursIntersection::~contoursIntersection()
{
} 
//-----------------------------------------------------------
double contoursIntersection::Slope(double x0, double y0, double x1, double y1)
{
	double m = (y1-y0)/(x1-x0);
	return m;
}
//-----------------------------------------------------------
double contoursIntersection::Normal(double x0, double y0, double* m, double xi)
{
	double y;
	*m = -(1/(*m));
	y = ((*m)*(xi - x0)) + y0;
	return y;
}
//-----------------------------------------------------------
void contoursIntersection::Intersection(double x01, double y01, double x02, double y02, double mn, double m2, double* x, double* y)
{
	*x = ( y02-y01-(m2*x02)+(mn*x01) )/(mn-m2);
	*y = m2*(*x-x02)+y02;
}
//-----------------------------------------------------------
//-----------------------------------------------------------
//-----------------------------------------------------------
//-----------------------------------------------------------
//-----------------------------------------------------------
//-----------------------------------------------------------
//-----------------------------------------------------------
//-----------------------------------------------------------
 
 
