/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __contoursIntersection_h_INCLUDED__
#define __contoursIntersection_h_INCLUDED__

#include "vectorFunctions.h"

class contoursIntersection
{
  public:
		contoursIntersection  ( );
		~contoursIntersection ( );
        double Slope                ( double x0, double y0,
                                      double x1, double y1 );
        double Normal               ( double x0, double y0,
                                      double *m, double xi );
        void Intersection           ( double x01, double y01,
                                      double x02, double y02,
                                      double mn, double m2,
                                      double *x, double *y );
        void SetContour1            ( std::vector<double>*InX1,
                                      std::vector<double>*InY1,
                                      std::vector<double>*InZ1 );
        void SetContour2            ( std::vector<double>*InX2,
                                      std::vector<double>*InY2,
                                      std::vector<double>*InZ2 );
        //All the intersections between the two set contour
        void InterBetweenContours   ( std::vector<double>*OutX,
                                      std::vector<double>*OutY,
                                      std::vector<double>*OutZ );
        //All the possible intersections between the contours
        void PossibleIntersections  ( std::vector<double>*OutX,
                                      std::vector<double>*OutY,
                                      std::vector<double>*OutZ );
        //Logical intersections between the two set contours
        void IntersectionPoints     ( std::vector<double>*OutX,
                                      std::vector<double>*OutY,
                                      std::vector<double>*OutZ );
        //Set the parameter data for stimate the error between the contours
        void SetErrorParameter      ( double val );
        //The error between the contours
        int GetErrorBetweenContours ( double error );
   private:
         std::vector<double> _InX1;
         std::vector<double> _InY1;
         std::vector<double> _InZ1;
          std::vector<double> _InX2;
         std::vector<double> _InY2;
         std::vector<double> _InZ2;
};
#endif
 
 
