/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vectorFunctions.h"
#include <stdio.h>

//Constructor
vectorFunctions::vectorFunctions()
{
}
//Destructor
vectorFunctions::~vectorFunctions()
{
}

//---------------------------------------------------------------
//Copy Vector1 in Vector2 (double)
void vectorFunctions::copyVector(std::vector<double>*Vector1,std::vector<double>*Vector2)
{
	int size = Vector1->size();
	Vector2->clear();
	int i;
	if(size != 0)
	{
		for(i=0; i<size; i++)
		{
			Vector2->push_back( (*Vector1)[i] );
		}
	}
}
//---------------------------------------------------------------
//Copy Vector1 in Vector2 (int)
void vectorFunctions::copyintVector(std::vector<int>*Vector1,std::vector<int>*Vector2)
{
	int size = Vector1->size();
	Vector2->clear();
	int i;
	if( size != 0)
	{
		for(i=0; i<size; i++)
		{
			Vector2->push_back( (*Vector1)[i] );
		}
	}
}
//------------------------------------------------------------------------------------------------------------------------------------------
//Print 2 vectors of the same size
void vectorFunctions::printVector(std::vector<double>*Vector1,std::vector<double>*Vector2)
{
	int i;
	if( Vector1->size() == Vector2->size() )
	{
		for(i=0; i<Vector1->size(); i++)
		{
			printf("\n v1(%d) = %f, v2(%d) = %f",i,(*Vector1)[i],i,(*Vector2)[i]);
		}
	}
}
//------------------------------------------------------------------------------------------------------------------------------------------
//Returns the average value of the vector
double vectorFunctions::promVector(std::vector<double>*Vector1, bool OnNormal)
{
	int i;
	double suma = 0,prom;
	std::vector<double> tempv;
	int size = Vector1->size();
	if(size != 0)
	{
		if(OnNormal == false)
		{
			for(i=0; i<size; i++)
			{
				suma = suma + (*Vector1)[i];
			}
			return prom = suma/Vector1->size();
		}
		int pos;
		double maxval;
		copyVector(Vector1,&tempv);
		if(OnNormal == true)
		{
			pos = maxVector(Vector1,&maxval);
			for(i=0; i<size; i++)
			{
				tempv.push_back((*Vector1)[i]/maxval);
			}
			suma = 0;
			for(i=0; i<tempv.size(); i++)
			{
				suma = suma + tempv[i];
			}
			return prom = suma/tempv.size();
		}
	}
	return -1;
}
//------------------------------------------------------------------------------------------------------------------------------------------
//Returns the maximum value of the vector
int vectorFunctions::maxVector(std::vector<double>*Vector1,double *val)
{
	int i, pos;
	double max = -1;
	if(Vector1->size() != 0)
	{
		for(i=0; i<Vector1->size(); i++)
		{
			if( (*Vector1)[i]>max )
			{
				max = (*Vector1)[i];
				pos = i;
			}
		}
		*val = max;
		return pos;
	}
	return -1;
}
//------------------------------------------------------------------------------------------------------------------------------------------
//Returns the minimum value of the vector
int vectorFunctions::minVector(std::vector<double>*Vector1,double *val)
{
	int i, pos;
	double min = 99999;
	if(Vector1->size() != 0)
	{
		for(i=0; i<Vector1->size(); i++)
		{
			if( (*Vector1)[i]<min )
			{
				min = (*Vector1)[i];
				pos = i;
			}
		}
		*val = min;
		return pos;
	}
	return -1;
}
//------------------------------------------------------------------------------------------------------------------------------------------
//Find the minimal distance between an input point and an input lists of points
int vectorFunctions::nearPoint(std::vector<double>*VectorX, std::vector<double>*VectorY, double px, double py)
{
	int i, pos = -1;
	double min = 10000, dist;
	if(VectorX->size() != 0)
	{
		for(i=0; i<VectorX->size(); i++)
		{
			dist = sqrt(pow(px-(*VectorX)[i],2) + pow(py-(*VectorY)[i],2));
			if(dist<min)
			{
				min = dist;
				pos = i;
			}
		}
		return pos;
	}
	return -1;
}
//------------------------------------------------------------------------------------------------------------------------------------------
//Returns the position of the point in the lsts. (Aprox. + or - 1).
int vectorFunctions::findPointInLst(std::vector<double>*vecX, std::vector<double>*vecY, std::vector<double>*vecZ, 
									double x, double y, double z)
{
	int i,flag = -1;
	double apr = 1.5;
	if(vecX->size() != 0)
	{
		for(i=0; i<vecX->size(); i++)
		{
			if( ((*vecX)[i]-apr <= x)&&(x <=(*vecX)[i]+apr)&&((*vecY)[i]-apr <= y)&&(y <=(*vecY)[i]+apr)&&((*vecZ)[i]-apr <= z)&&(z <=(*vecZ)[i]+apr) )
			{
				flag = i;
				return i; 
			}
		}
		return flag;
	}
	return -1;
}
