/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

// MaracasDll.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "wxMaracasApp.h"
#include "MaracasDll.h"
#include <wx/log.h>

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			break;
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}
// This is the constructor of a class that has been exported.
// see MaracasDll.h for the class definition
CMaracasController::CMaracasController()
:m_pSlicesPixels(NULL)
{
//EEDxx	wxWindows 2.4
//	wxEntry(GetModuleHandle(NULL),NULL,NULL,0,FALSE);
	m_pMarApp = (wxMaracasApp*)wxTheApp;
	_rpPixels = NULL;
}

CMaracasController::~CMaracasController()
{
	// TODO : verifier le vidage de la m�moire
	if (m_pSlicesPixels!=NULL) delete m_pSlicesPixels;
	m_pMarApp->OnExit();
//EEDxx	wxWindows 2.4
//	wxApp::CleanUp();
	m_pMarApp->CleanUp();
}

int CMaracasController::RunMaracas(void)
{ 
	m_pMarApp->SetVolumeData(
		m_nX,
		m_nY,
		m_nSlices,
		m_PixelSpacingColumn,
		m_PixelSpacingRow, 
		m_PixelSpacingSlice,
		m_RescaleSlope,
		m_RescaleIntercept,
		m_pSlicesPixels);
	m_pMarApp->Run();
	return 0;
}

int CMaracasController::ShowApp(int nCmdShow) 
{
   if ( SW_HIDE == nCmdShow )
   {
	  m_pMarApp->ShowFrame(SHOW_WINDOW_MINIMIZED);
   } 
   else if ( SW_SHOW == nCmdShow )
   {
	  m_pMarApp->ShowFrame(SHOW_WINDOW_RESTORE);
   }
   else if ( SW_NORMAL == nCmdShow )
   {
	  m_pMarApp->ShowFrame(SHOW_WINDOW_NORMAL);
   }
   else if ( SW_MINIMIZE == nCmdShow )
   {
	  m_pMarApp->ShowFrame(SHOW_WINDOW_MINIMIZED);
   }
   else if ( SW_MAXIMIZE == nCmdShow )
   {
	  m_pMarApp->ShowFrame(SHOW_WINDOW_MAXIMIZED);
   }
   else
   {
	  m_pMarApp->ShowFrame(SHOW_WINDOW_NORMAL);
   }
   return 0;
}

int CMaracasController::Reset(void)
{
	// TODO : verifier le vidage de la m�moire
	if (m_pSlicesPixels!=NULL) delete m_pSlicesPixels;
	m_pSlicesPixels=NULL;
	m_pMarApp->Reset();
	return 0;
}

void CMaracasController::SetVolumeParams(int nX, int nY, int nSlices)
{
	m_nX=nX;
	m_nY=nY;
	m_nSlices=nSlices;
	if(m_pSlicesPixels==NULL) 
	{
		m_pSlicesPixels=new unsigned short [m_nX*m_nY*m_nSlices];
	}
	wxString msg=wxString();

//EEDxx2.4 DEBuG
//	wxLogDebug(msg.Format("Volume dimensions received : %d, %d ,%d",m_nX,m_nY,m_nSlices));

}

void CMaracasController::SetSliceParams(float pixelSpacingColumn,
										float pixelSpacingRow,
										float pixelSpacingSlice, 
										float RescaleSlope, 
										float RescaleIntercept)
{
	m_PixelSpacingColumn	= pixelSpacingColumn;
	m_PixelSpacingRow		= pixelSpacingRow;
	m_PixelSpacingSlice		= pixelSpacingSlice;
	m_RescaleSlope			= RescaleSlope;
	m_RescaleIntercept		= RescaleIntercept;

	wxString msg=wxString();
//EEDxx2.4 DEBuG
//	wxLogDebug(msg.Format("Spacings received: %d, %d, %d",m_PixelSpacingColumn,m_PixelSpacingRow,m_PixelSpacingSlice));

}

void CMaracasController::SetSlicePixels(int numSlice,unsigned short * pixels)
{

	wxString msg=wxString();

//EEDxx2.4 DEBuG
//	wxLogDebug(msg.Format("Data for slice %d received",numSlice));
	
	int nbPixels=m_nX*m_nY;
	int startIndex=numSlice*nbPixels;

	for (int i=0; i<nbPixels;i++)
	{
		m_pSlicesPixels[i+startIndex]=pixels[i];
	}
}

void CMaracasController::GetSnapshot(	unsigned int&	rWidth,
						                unsigned int&	rHeight,
										unsigned char*& rpPixels )  /*const*/ {

	wxColour	*colour		= new wxColour();
	wxBitmap	*wxbitmap	= m_pMarApp->GetSnapshot();
	wxMemoryDC	*wxmemorydc = new wxMemoryDC();
	wxmemorydc->SelectObject(*wxbitmap);

	int i,j;
	unsigned char r,g,b;
	int w = wxbitmap->GetWidth();
	int h = wxbitmap->GetHeight();

	_rpPixels=(unsigned char*)malloc( sizeof(unsigned char)*3*w*h );
	for (i=0;i<w;i++){
		for (j=0;j<h;j++){
			wxmemorydc->GetPixel(i,j,colour);
			r=colour->Red();
			g=colour->Green();
			b=colour->Blue();
			rpPixels[j*3*w+i*3+0]=r;
			rpPixels[j*3*w+i*3+1]=g;
			rpPixels[j*3*w+i*3+2]=b;
		}
	}

	delete wxbitmap;
	delete wxmemorydc;
	wxbitmap->SaveFile("c:/tmp/MaracasPlamavic.bmp", wxBITMAP_TYPE_BMP  );

	rWidth	 = w;
	rHeight	 = h;
	rpPixels = _rpPixels;
}


int CMaracasController::ReleaseSnapshot(){
	if (_rpPixels!=NULL) {
		free(_rpPixels);
		_rpPixels=NULL;
	}
	return 0;
}

