/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __CMARACASCONTROLLER_H_
#define __CMARACASCONTROLLER_H_

// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the MaracasWin32Lib_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// MARACASDLL_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef MaracasWin32Lib_EXPORTS
#define MARACASDLL_API __declspec(dllexport)
#else
#define MARACASDLL_API __declspec(dllimport)
#endif
class wxMaracasApp;
// This class is exported from the MaracasWin32Lib.dll
class MARACASDLL_API CMaracasController {
public:
	CMaracasController(void);
	
	~CMaracasController();
	
	int RunMaracas(void);
	
	int ShowApp(int nCmdShow);
	
	int Reset();
	
	void GetSnapshot( unsigned int& rWidth,
                     unsigned int& rHeight,
                     unsigned char*& rpPixels ) /*const*/ ;

	/*! \brief Notify the snapshot bitmap has been retrieved
	*/
	int ReleaseSnapshot();
	
	/*! \brief Notify the resampled image has been retrieved
	*/
	int OutputVolumeRetrieved();

	void SetVolumeParams(int nX, int nY, int nSlices);

	void SetSliceParams(float pixelSpacingColumn,
						float pixelSpacingRow,
						float pixelSpacingSlice,
						float RescaleSlope, 
						float RescaleIntercept);

	void SetSlicePixels(int numSlice,unsigned short * pixels);

private :
	wxMaracasApp	*m_pMarApp;
	unsigned char	*_rpPixels; //Snapshot

	unsigned short	*m_pSlicesPixels;
	int				m_nX;
	int				m_nY;
	int				m_nSlices;
	float			m_PixelSpacingColumn;
	float			m_PixelSpacingRow;
	float			m_PixelSpacingSlice;
	float			m_RescaleSlope;
	float			m_RescaleIntercept;
};


#endif // __CMARACASCONTROLLER_H_

